/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ResultHolderTest
extends JdbcTestBase {
    boolean callbackInvoked = false;
    private QueryInfo qInfo;

    public ResultHolderTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ResultHolderTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerializability() throws SQLException, IOException, ClassNotFoundException, StandardException {
        Connection conn = ResultHolderTest.getConnection();
        this.createTable(conn);
        PreparedStatement psInsert = conn.prepareStatement("insert into orders values (?, ?,?,?,?,?)");
        psInsert.setInt(1, 1);
        psInsert.setString(2, "asif");
        psInsert.setInt(3, 1);
        psInsert.setString(4, "asif");
        psInsert.setInt(5, 1);
        psInsert.setString(6, "asif");
        psInsert.executeUpdate();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qinfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    ResultHolderTest.this.callbackInvoked = true;
                    TestCase.assertTrue((boolean)(qinfo instanceof SelectQueryInfo));
                    ResultHolderTest.this.qInfo = qinfo;
                }
            });
            conn.setAutoCommit(false);
            EmbedPreparedStatement pqry = (EmbedPreparedStatement)conn.prepareStatement("Select num,cust_name from orders where id = ?");
            pqry.setInt(1, 1);
            assert (this.qInfo instanceof SelectQueryInfo) : "queryinfo is not an instance of SelectQueryInfo";
            ColumnQueryInfo[] cqi = ((SelectQueryInfo)this.qInfo).getProjectionColumnQueryInfo();
            ColumnDescriptorList pqryRowTemplate = new ColumnDescriptorList();
            for (int i = 0; i < cqi.length; ++i) {
                pqryRowTemplate.add((Object)cqi[i].getColumnDescriptor());
            }
            PreparedStatement pqry1 = conn.prepareStatement("Select num,cust_name from orders where id = ?");
            pqry1.setInt(1, 1);
            cqi = ((SelectQueryInfo)this.qInfo).getProjectionColumnQueryInfo();
            ColumnDescriptorList pqry1RowTemplate = new ColumnDescriptorList();
            for (int i = 0; i < cqi.length; ++i) {
                pqry1RowTemplate.add((Object)cqi[i].getColumnDescriptor());
            }
            EmbedResultSet ers = (EmbedResultSet)pqry.executeQuery();
            EmbedResultSet ers1 = (EmbedResultSet)pqry1.executeQuery();
            ers.setupContextStack(true);
            LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
            lcc.pushStatementContext(true, true, pqry.getSQLText(), pqry.getParameterValueSet(), false, 1000000L);
            long origMaxChunkSize = GemFireXDUtils.DML_MAX_CHUNK_SIZE;
            GemFireXDUtils.DML_MAX_CHUNK_SIZE = 1000000L;
            ResultHolder rhSender = new ResultHolder(ers, (EmbedStatement)pqry, null, 0, null, false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dop = new DataOutputStream(baos);
            rhSender.prepareSend(null);
            rhSender.toData((DataOutput)dop);
            ResultHolder rhReciever = new ResultHolder();
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            DataInputStream di = new DataInputStream(bis);
            RowFormatter rf = new RowFormatter(pqryRowTemplate, "APP", "ORDERS", 1, null);
            rhReciever.setRowFormatter(rf, false);
            rhReciever.fromData((DataInput)di);
            ers1.next();
            ExecRow row = ers1.getCurrentRow();
            row = rhReciever.getNext(row, null);
            ResultHolderTest.assertEquals((int)row.getRowArray().length, (int)2);
            DataValueDescriptor[] dvd = row.getRowArray();
            ResultHolderTest.assertEquals((int)1, (int)dvd[0].getInt());
            ResultHolderTest.assertEquals((String)"asif", (String)dvd[1].getString());
            GemFireXDUtils.DML_MAX_CHUNK_SIZE = origMaxChunkSize;
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void testSerializabilityOfEmptyResultSetWithProjection() throws SQLException, IOException, ClassNotFoundException, StandardException {
        this.executeQueryForEmptyResult(true);
    }

    public void testSerializabilityOfEmptyResultSetWithoutProjection() throws SQLException, IOException, ClassNotFoundException, StandardException {
        this.executeQueryForEmptyResult(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryForEmptyResult(boolean doProjection) throws SQLException, IOException, ClassNotFoundException, StandardException {
        Connection conn = ResultHolderTest.getConnection();
        this.createTable(conn);
        PreparedStatement psInsert = conn.prepareStatement("insert into orders values (?, ?,?,?,?,?)");
        psInsert.setInt(1, 1);
        psInsert.setString(2, "asif");
        psInsert.setInt(3, 1);
        psInsert.setString(4, "asif");
        psInsert.setInt(5, 1);
        psInsert.setString(6, "asif");
        psInsert.executeUpdate();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qinfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    ResultHolderTest.this.callbackInvoked = true;
                    TestCase.assertTrue((boolean)(qinfo instanceof SelectQueryInfo));
                    ResultHolderTest.this.qInfo = qinfo;
                }
            });
            EmbedPreparedStatement pqry = null;
            pqry = doProjection ? (EmbedPreparedStatement)conn.prepareStatement("Select num,cust_name from orders where id = ?") : (EmbedPreparedStatement)conn.prepareStatement("Select * from orders where id = ?");
            pqry.setInt(1, 5);
            assert (this.qInfo instanceof SelectQueryInfo) : "queryinfo is not an instance of SelectQueryInfo";
            ColumnQueryInfo[] cqi = ((SelectQueryInfo)this.qInfo).getProjectionColumnQueryInfo();
            ColumnDescriptorList pqryRowTemplate = new ColumnDescriptorList();
            for (int i = 0; i < cqi.length; ++i) {
                pqryRowTemplate.add((Object)cqi[i].getColumnDescriptor());
            }
            cqi = ((SelectQueryInfo)this.qInfo).getProjectionColumnQueryInfo();
            ColumnDescriptorList pqry1RowTemplate = new ColumnDescriptorList();
            for (int i = 0; i < cqi.length; ++i) {
                pqry1RowTemplate.add((Object)cqi[i].getColumnDescriptor());
            }
            EmbedResultSet ers = (EmbedResultSet)pqry.executeQuery();
            ers.setupContextStack(true);
            LanguageConnectionContext lcc = ((EmbedConnection)conn).getLanguageConnection();
            lcc.pushStatementContext(true, true, pqry.getSQLText(), pqry.getParameterValueSet(), false, 1000000L);
            ResultHolder rhSender = new ResultHolder(ers, (EmbedStatement)pqry, null, 0, null, false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dop = new DataOutputStream(baos);
            rhSender.toData((DataOutput)dop);
            ResultHolder rhReciever = new ResultHolder();
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            DataInputStream di = new DataInputStream(bis);
            RowFormatter rf = new RowFormatter(pqryRowTemplate, "APP", "ORDERS", 1, null);
            rhReciever.setRowFormatter(rf, false);
            rhReciever.fromData((DataInput)di);
            ResultHolderTest.assertFalse((boolean)rhReciever.hasNext(null));
        }
        finally {
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void createTableWithPrimaryKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTable(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int not null , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTableWithCompositeKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100), Primary Key (id, cust_name))");
        s.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.callbackInvoked = false;
        super.tearDown();
    }
}

