/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.gemstone.gnu.trove.TLongObjectHashMap;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedDatabaseMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameter;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CyclicBarrier;
import junit.framework.TestCase;

public class PreparedStatementDUnit
extends DistributedSQLTestBase {
    private static volatile long connID = -1L;
    private static volatile long stmtID = -1L;
    private static volatile String sql;
    private static volatile boolean executionUsingGemFireXDActivation;
    private static volatile boolean connectionCloseExecuted;
    public static String currentUserName;
    public static String currentUserPassword;

    public PreparedStatementDUnit(String name) {
        super(name);
    }

    private void checkOneResult(ResultSet rs) throws SQLException {
        PreparedStatementDUnit.assertTrue((String)"Expected one result", (boolean)rs.next());
        if (rs.next()) {
            PreparedStatementDUnit.fail((String)("unexpected next element with ID: " + rs.getObject(1)));
        }
    }

    private GemFireXDQueryObserver getQueryObserver(final boolean setConnectionCloseFlag) {
        return new GemFireXDQueryObserverAdapter(){

            public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                PreparedStatementDUnit.this.getLogWriter().info((Object)("setting the connectionId : " + wrapper.getIncomingConnectionId() + " and statementId : " + pstmt.getID()));
                connID = wrapper.getIncomingConnectionId();
                stmtID = pstmt.getID();
                sql = query;
            }

            public void beforeConnectionCloseByExecutorFunction(long[] connectionIDs) {
                if (setConnectionCloseFlag) {
                    connectionCloseExecuted = true;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41222() throws Exception {
        try {
            int n;
            final int numThreads = n = Integer.getInteger("DistributionManager.MAX_FE_THREADS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16)).intValue();
            this.startVMs(1, 1);
            this.clientSQLExecute(1, "create schema EMP");
            this.createDiskStore(true, 1);
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) " + this.getSuffix());
            this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
            VM dataStore1 = (VM)this.serverVMs.get(0);
            SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

                public void run() throws CacheException {
                    try {
                        String maxCid = "create function maxCidBug41222() RETURNS INTEGER PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA EXTERNAL NAME 'sql.TestFunctions.getMaxCidBug41222'";
                        TestUtil.setupConnection();
                        Connection conn = TestUtil.jdbcConn;
                        Statement stmt = conn.createStatement();
                        stmt.executeUpdate(maxCid);
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                            final CyclicBarrier barrier;
                            {
                                this.barrier = new CyclicBarrier(numThreads, new Runnable(){

                                    @Override
                                    public void run() {
                                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                                    }
                                });
                            }

                            public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                                try {
                                    this.barrier.await();
                                }
                                catch (Exception e) {
                                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            dataStore1.invoke((Runnable)setObserver);
            TestUtil.setupConnection();
            PreparedStatement[] eps = new PreparedStatement[numThreads];
            for (int i = 0; i < eps.length; ++i) {
                EmbedConnection mcon = (EmbedConnection)TestUtil.getConnection();
                eps[i] = mcon.prepareStatement("select * from EMP.TESTTABLE where ID = maxCidBug41222()");
            }
            final boolean[] failed = new boolean[]{false};
            Thread[] threads = new Thread[numThreads];
            int i = 0;
            Object[] arr$ = eps;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PreparedStatement var;
                final PreparedStatement ps = var = arr$[i$];
                threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ResultSet rs = ps.executeQuery();
                            rs.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            failed[0] = true;
                        }
                    }
                });
                threads[i].start();
                ++i;
            }
            for (Thread th : threads) {
                th.join();
            }
            PreparedStatementDUnit.assertFalse((boolean)failed[0]);
        }
        finally {
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerializationData() throws Exception {
        this.startVMs(1, 2);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) " + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'Second', 'J 604')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)PreparedStatementDUnit.this.getQueryObserver(false));
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        TestUtil.setupConnection();
        EmbedConnection mcon = (EmbedConnection)TestUtil.jdbcConn;
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id >= ? and DESCRIPTION = ?");
        eps.setInt(1, 1);
        eps.setString(2, "First");
        ResultSet rs = eps.executeQuery();
        this.checkOneResult(rs);
        final long clientConnID = mcon.getConnectionID();
        final long clientStmntID = eps.getID();
        SerializableRunnable validate = new SerializableRunnable("validate"){

            public void run() throws CacheException {
                try {
                    TestCase.assertEquals((long)clientConnID, (long)connID);
                    TestCase.assertEquals((long)clientStmntID, (long)stmtID);
                    connID = -1L;
                    stmtID = -1L;
                    sql = null;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
        this.clientSQLExecute(1, "Drop schema EMP restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryStringNotPassedEveryTime() throws Exception {
        try {
            this.startServerVMs(2, 0, "SG2");
            this.startClientVMs(1, 0, null);
            this.createDiskStore(true, 1);
            this.clientSQLExecute(1, "create schema EMP default server groups (SG2)");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID) )" + this.getSuffix());
            this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
            this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'Second', 'J 604')");
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                            public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                                connID = wrapper.getIncomingConnectionId();
                                stmtID = pstmt.getID();
                                sql = query;
                                TestCase.assertNull((String)("got query " + query), (Object)query);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            TestUtil.setupConnection();
            EmbedConnection mcon = (EmbedConnection)TestUtil.jdbcConn;
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  >= ? and DESCRIPTION = ? ");
            eps.setInt(1, 1);
            eps.setString(2, "First");
            ResultSet rs = eps.executeQuery();
            this.checkOneResult(rs);
            eps.setInt(1, 1);
            eps.setString(2, "First");
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            rs = eps.executeQuery();
            this.checkOneResult(rs);
            final long clientConnID = mcon.getConnectionID();
            final long clientStmntID = eps.getID();
            SerializableRunnable validate = new SerializableRunnable("validate"){

                public void run() throws CacheException {
                    try {
                        TestCase.assertEquals((long)clientConnID, (long)connID);
                        TestCase.assertEquals((long)clientStmntID, (long)stmtID);
                        TestCase.assertNull((Object)sql);
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                    finally {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    }
                }
            };
            dataStore1.invoke((Runnable)validate);
            dataStore2.invoke((Runnable)validate);
        }
        finally {
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPopluationOfPrepStmntIDToNodes() throws Exception {
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where id  >= ? and DESCRIPTION = ? ";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID) ) " + this.getSuffix());
        try {
            this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
            TestUtil.setupConnection();
            EmbedConnection mcon = (EmbedConnection)TestUtil.jdbcConn;
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  >= ? and DESCRIPTION = ? ");
            eps.setInt(1, 1);
            eps.setString(2, "First");
            ResultSet rs = eps.executeQuery();
            this.checkOneResult(rs);
            this.startServerVMs(1, 0, null);
            this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'Second', 'J 604')");
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            dataStore2.invoke((Runnable)new SerializableRunnable("Rebalance"){

                public void run() {
                    RebalanceFactory rf = GemFireCacheImpl.getInstance().getResourceManager().createRebalanceFactory();
                    try {
                        rf.start().getResults();
                    }
                    catch (Exception e) {
                        DistributedSQLTestBase.fail("Caught exception", e);
                    }
                }
            });
            SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)PreparedStatementDUnit.this.getQueryObserver(false));
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            eps.setInt(1, 1);
            eps.setString(2, "First");
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            rs = eps.executeQuery();
            this.checkOneResult(rs);
            final long clientConnID = mcon.getConnectionID();
            final long clientStmntID = eps.getID();
            SerializableRunnable validateNoQuerySend = new SerializableRunnable("validate"){

                public void run() throws CacheException {
                    try {
                        TestCase.assertEquals((long)clientConnID, (long)connID);
                        TestCase.assertEquals((long)clientStmntID, (long)stmtID);
                        TestCase.assertNull((Object)sql);
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                    finally {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    }
                }
            };
            SerializableRunnable validateQuerySend = new SerializableRunnable("validate"){

                public void run() throws CacheException {
                    try {
                        TestCase.assertEquals((long)clientConnID, (long)connID);
                        TestCase.assertEquals((long)clientStmntID, (long)stmtID);
                        TestCase.assertEquals((String)sql, (String)"select ID, DESCRIPTION from EMP.TESTTABLE where id  >= ? and DESCRIPTION = ? ");
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                    finally {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    }
                }
            };
            dataStore1.invoke((Runnable)validateNoQuerySend);
            dataStore2.invoke((Runnable)validateQuerySend);
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            eps.setInt(1, 1);
            eps.setString(2, "First");
            rs = eps.executeQuery();
            this.checkOneResult(rs);
            dataStore1.invoke((Runnable)validateNoQuerySend);
            dataStore2.invoke((Runnable)validateNoQuerySend);
        }
        finally {
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39364_1() throws Exception {
        this.startServerVMs(1, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.createDiskStore(true, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where id  IN (?,?,?) order by ID asc ";
        this.clientSQLExecute(1, "create schema EMP default server groups (SG2)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID))" + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'First', 'J 604')");
        TestUtil.setupConnection();
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  IN (?,?,?) order by ID asc ");
        eps.setInt(1, 1);
        eps.setInt(2, 2);
        eps.setInt(3, 3);
        ResultSet rs = eps.executeQuery();
        HashSet<Integer> found = new HashSet<Integer>();
        HashSet<Integer> expected = new HashSet<Integer>();
        for (int i = 0; i < 3; ++i) {
            PreparedStatementDUnit.assertTrue((boolean)rs.next());
            found.add(rs.getInt(1));
            expected.add(i + 1);
        }
        PreparedStatementDUnit.assertEquals(expected, found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39364_2() throws Exception {
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where id  IN (?,2,?) order by ID asc ";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID))" + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'First', 'J 604')");
        TestUtil.setupConnection();
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  IN (?,2,?) order by ID asc ");
        eps.setInt(1, 1);
        eps.setInt(2, 3);
        ResultSet rs = eps.executeQuery();
        HashSet<Integer> found = new HashSet<Integer>();
        HashSet<Integer> expected = new HashSet<Integer>();
        for (int i = 0; i < 3; ++i) {
            PreparedStatementDUnit.assertTrue((boolean)rs.next());
            found.add(rs.getInt(1));
            expected.add(i + 1);
        }
        PreparedStatementDUnit.assertEquals(expected, found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39369_1() throws Exception {
        this.startServerVMs(2, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.createDiskStore(true, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where ( ID  >= 1 ) ";
        this.clientSQLExecute(1, "create schema EMP default server groups (SG2)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024))" + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'First', 'J 604')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                            String query = activation.getStatementText();
                            if (query == null || !query.contains("SYS.MEMORYANALYTICS") && !query.contains("SYS.MEMBERS")) {
                                executionUsingGemFireXDActivation = true;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        SerializableRunnable validate = new SerializableRunnable("validate no gfxd fabric activation used"){

            public void run() throws CacheException {
                try {
                    TestCase.assertFalse((boolean)executionUsingGemFireXDActivation);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        this.sqlExecuteVerify(new int[]{1}, null, "select ID, DESCRIPTION from EMP.TESTTABLE where ( ID  >= 1 ) ", null, null);
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        PreparedStatementDUnit.invokeInEveryVM(((Object)((Object)this)).getClass(), (String)"reset");
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                String query = activation.getStatementText();
                if (query == null || !query.contains("SYS.MEMORYANALYTICS") && !query.contains("SYS.MEMBERS")) {
                    executionUsingGemFireXDActivation = true;
                }
            }
        });
        SerializableRunnable validateGemFireXDActivation = new SerializableRunnable("validate  gfxd fabric activation used"){

            public void run() throws CacheException {
                try {
                    TestCase.assertTrue((boolean)executionUsingGemFireXDActivation);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        this.sqlExecuteVerify(null, new int[]{1}, "select ID, DESCRIPTION from EMP.TESTTABLE where ( ID  >= 1 ) ", null, null);
        dataStore2.invoke((Runnable)validate);
        dataStore1.invoke((Runnable)validateGemFireXDActivation);
        PreparedStatementDUnit.assertFalse((boolean)executionUsingGemFireXDActivation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39369_2() throws Exception {
        int i;
        this.startVMs(1, 2);
        this.createDiskStore(true, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where (ID  >= ?)";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024),primary key (ID))" + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'First', 'J 604')");
        TestUtil.setupConnection();
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where (ID  >= ?)");
        eps.setInt(1, 1);
        ResultSet rs = eps.executeQuery();
        HashSet<Integer> rslts = new HashSet<Integer>();
        for (i = 1; i < 4; ++i) {
            rslts.add(i);
        }
        for (i = 0; i < 3; ++i) {
            PreparedStatementDUnit.assertTrue((boolean)rs.next());
            PreparedStatementDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
        }
        PreparedStatementDUnit.assertTrue((boolean)rslts.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39321() throws Exception {
        int i;
        this.startServerVMs(2, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.createDiskStore(true, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where (ID  >= ?)";
        this.clientSQLExecute(1, "create schema EMP default server groups (SG2)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024))" + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        TestUtil.setupConnection();
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where (ID  >= ?)");
        eps.setInt(1, 1);
        ResultSet rs = eps.executeQuery();
        HashSet<Integer> rslts = new HashSet<Integer>();
        for (i = 1; i < 3; ++i) {
            rslts.add(i);
        }
        for (i = 0; i < 2; ++i) {
            PreparedStatementDUnit.assertTrue((boolean)rs.next());
            PreparedStatementDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
        }
        PreparedStatementDUnit.assertTrue((boolean)rslts.isEmpty());
        VM dataStore1 = (VM)this.serverVMs.get(0);
        SerializableRunnable queryExecutor = new SerializableRunnable("Query Executor"){

            public void run() throws CacheException {
                try {
                    int i;
                    TestUtil.setupConnection();
                    EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where (ID  >= ?)");
                    eps.setInt(1, 1);
                    ResultSet rs = eps.executeQuery();
                    HashSet<Integer> rslts = new HashSet<Integer>();
                    for (i = 1; i < 3; ++i) {
                        rslts.add(i);
                    }
                    for (i = 0; i < 2; ++i) {
                        TestCase.assertTrue((boolean)rs.next());
                        TestCase.assertTrue((boolean)rslts.remove(rs.getInt(1)));
                    }
                    TestCase.assertTrue((boolean)rslts.isEmpty());
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)queryExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedConnectionCloseForPRTable_Bug40135_1() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) " + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'Second', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'Third', 'J 604')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)PreparedStatementDUnit.this.getQueryObserver(true));
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        dataStore3.invoke((Runnable)setObserver);
        TestUtil.setupConnection();
        EmbedConnection mcon = (EmbedConnection)TestUtil.jdbcConn;
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  >= ? and DESCRIPTION = ?");
        eps.setInt(1, 1);
        eps.setString(2, "First");
        ResultSet rs = eps.executeQuery();
        this.checkOneResult(rs);
        final long clientConnID = mcon.getConnectionID();
        final long clientStmntID = eps.getID();
        SerializableRunnable validate = new SerializableRunnable("validate"){

            public void run() throws CacheException {
                try {
                    int tries;
                    TestCase.assertEquals((long)clientConnID, (long)connID);
                    TestCase.assertEquals((long)clientStmntID, (long)stmtID);
                    boolean ok = false;
                    for (tries = 0; tries < 100; ++tries) {
                        boolean bl = ok = GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connID)) == null;
                        if (ok) break;
                        Thread.sleep(500L);
                    }
                    TestCase.assertTrue((boolean)ok);
                    ok = false;
                    for (tries = 0; tries < 100 && !(ok = connectionCloseExecuted); ++tries) {
                        Thread.sleep(500L);
                    }
                    TestCase.assertTrue((boolean)ok);
                    connID = -1L;
                    stmtID = -1L;
                    sql = null;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        mcon.close();
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        dataStore3.invoke((Runnable)validate);
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
        this.clientSQLExecute(1, "Drop schema EMP restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedConnectionCloseForReplicatedTable_Bug40135_2() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate " + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)PreparedStatementDUnit.this.getQueryObserver(true));
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        dataStore3.invoke((Runnable)setObserver);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeConnectionCloseByExecutorFunction(long[] connectionIDs) {
                connectionCloseExecuted = true;
            }
        });
        TestUtil.setupConnection();
        EmbedConnection mcon = (EmbedConnection)TestUtil.jdbcConn;
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  >= ? and DESCRIPTION = ?");
        eps.setInt(1, 1);
        eps.setString(2, "First");
        ResultSet rs = eps.executeQuery();
        PreparedStatementDUnit.assertTrue((boolean)rs.next());
        PreparedStatementDUnit.assertTrue((boolean)rs.next());
        PreparedStatementDUnit.assertFalse((boolean)rs.next());
        SerializableRunnable validate = new SerializableRunnable("validate"){

            public void run() throws CacheException {
                try {
                    int tries;
                    boolean ok = false;
                    for (tries = 0; tries < 100; ++tries) {
                        boolean bl = ok = connID == -1L || GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connID)) == null;
                        if (ok) break;
                        Thread.sleep(500L);
                    }
                    TestCase.assertTrue((boolean)ok);
                    ok = false;
                    for (tries = 0; tries < 100 && !(ok = connectionCloseExecuted); ++tries) {
                        Thread.sleep(500L);
                    }
                    TestCase.assertTrue((boolean)ok);
                    connID = -1L;
                    stmtID = -1L;
                    sql = null;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        mcon.close();
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        dataStore3.invoke((Runnable)validate);
        PreparedStatementDUnit.assertTrue((boolean)connectionCloseExecuted);
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
        this.clientSQLExecute(1, "Drop schema EMP restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedPrepStatementCloseForPRTable_Bug40136_1() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) " + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'Second', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'Third', 'J 604')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)PreparedStatementDUnit.this.getQueryObserver(false));
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        dataStore3.invoke((Runnable)setObserver);
        TestUtil.setupConnection();
        EmbedConnection mcon = (EmbedConnection)TestUtil.jdbcConn;
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  >= ? and DESCRIPTION = ?");
        eps.setInt(1, 1);
        eps.setString(2, "First");
        ResultSet rs = eps.executeQuery();
        this.checkOneResult(rs);
        final long clientConnID = mcon.getConnectionID();
        final long clientStmntID = eps.getID();
        eps.close();
        SerializableRunnable validate = new SerializableRunnable("validate"){

            public void run() throws CacheException {
                try {
                    boolean ok;
                    TestCase.assertEquals((long)clientConnID, (long)connID);
                    TestCase.assertEquals((long)clientStmntID, (long)stmtID);
                    GfxdConnectionWrapper scw = GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connID));
                    boolean bl = ok = scw == null;
                    if (!ok) {
                        for (int tries = 0; tries < 100; ++tries) {
                            boolean bl2 = ok = scw.getStatementForTEST(Long.valueOf(stmtID).longValue()) == null;
                            if (ok) break;
                            Thread.sleep(500L);
                        }
                    }
                    TestCase.assertTrue((boolean)ok);
                    connID = -1L;
                    stmtID = -1L;
                    sql = null;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        dataStore3.invoke((Runnable)validate);
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
        this.clientSQLExecute(1, "Drop schema EMP restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedPrepStatementCloseForPRTable_Bug40136_2() throws Exception {
        this.startServerVMs(4, 0, null);
        this.createDiskStore(false, 1);
        this.serverSQLExecute(1, "create schema EMP");
        this.serverSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) " + this.getSuffix());
        this.serverSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.serverSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'Second', 'J 604')");
        this.serverSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'Third', 'J 604')");
        this.serverSQLExecute(1, "insert into EMP.TESTTABLE values (4, 'Fourth', 'J 604')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        VM dataStore4 = (VM)this.serverVMs.get(3);
        final GemFireXDQueryObserver soo = this.getQueryObserver(false);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)soo);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        dataStore3.invoke((Runnable)setObserver);
        dataStore4.invoke((Runnable)setObserver);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)soo);
        SerializableRunnable queryExecutor = new SerializableRunnable("queryExecutor"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    EmbedPreparedStatement eps = (EmbedPreparedStatement)conn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  >= 3 and DESCRIPTION = 'abc'");
                    eps.executeQuery();
                    eps.close();
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)queryExecutor);
        SerializableRunnable validate = new SerializableRunnable("validate"){

            public void run() throws CacheException {
                try {
                    boolean ok;
                    TestCase.assertTrue((connID != -1L ? 1 : 0) != 0);
                    TestCase.assertTrue((stmtID != -1L ? 1 : 0) != 0);
                    GfxdConnectionWrapper scw = GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connID));
                    boolean bl = ok = scw == null;
                    if (!ok) {
                        PreparedStatementDUnit.this.getLogWriter().info((Object)("Got wrapper for statementId=" + stmtID + " connectionId=" + connID + " : " + scw));
                        for (int tries = 0; tries < 100; ++tries) {
                            boolean bl2 = ok = scw.getStatementForTEST(Long.valueOf(stmtID).longValue()) == null;
                            if (ok) break;
                            Thread.sleep(500L);
                        }
                        TestCase.assertTrue((boolean)ok);
                        connID = -1L;
                        stmtID = -1L;
                        sql = null;
                    }
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        dataStore3.invoke((Runnable)validate);
        dataStore4.invoke((Runnable)validate);
        PreparedStatementDUnit.assertEquals((long)connID, (long)-1L);
        PreparedStatementDUnit.assertEquals((long)stmtID, (long)-1L);
        GfxdConnectionWrapper scw = connID != -1L ? GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connID)) : null;
        PreparedStatementDUnit.assertNull((Object)scw);
        connID = -1L;
        stmtID = -1L;
        sql = null;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        this.serverSQLExecute(1, "Drop table EMP.TESTTABLE ");
        this.serverSQLExecute(1, "Drop schema EMP restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedPrepStatementCloseForReplicatedTable_Bug40136_1() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate " + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        final GemFireXDQueryObserver soo = this.getQueryObserver(false);
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)soo);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        dataStore1.invoke((Runnable)setObserver);
        dataStore2.invoke((Runnable)setObserver);
        dataStore3.invoke((Runnable)setObserver);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)soo);
        SerializableRunnable queryExecutor = new SerializableRunnable("queryExecutor"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    EmbedPreparedStatement eps = (EmbedPreparedStatement)conn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  >= 3 and DESCRIPTION = 'abc'");
                    eps.executeQuery();
                    eps.close();
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        queryExecutor.run();
        SerializableRunnable validate = new SerializableRunnable("validate"){

            public void run() throws CacheException {
                try {
                    GfxdConnectionWrapper scw;
                    GfxdConnectionWrapper gfxdConnectionWrapper = scw = connID != -1L ? GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connID)) : null;
                    if (scw != null) {
                        boolean ok = false;
                        for (int tries = 0; tries < 100; ++tries) {
                            boolean bl = ok = scw.getStatementForTEST(Long.valueOf(stmtID).longValue()) == null;
                            if (ok) break;
                            Thread.sleep(500L);
                        }
                        TestCase.assertTrue((boolean)ok);
                    }
                    connID = -1L;
                    stmtID = -1L;
                    sql = null;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                }
            }
        };
        dataStore1.invoke((Runnable)validate);
        dataStore2.invoke((Runnable)validate);
        dataStore3.invoke((Runnable)validate);
        PreparedStatementDUnit.assertEquals((long)connID, (long)-1L);
        PreparedStatementDUnit.assertEquals((long)stmtID, (long)-1L);
        GfxdConnectionWrapper scw = connID != -1L ? GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connID)) : null;
        PreparedStatementDUnit.assertNull((Object)scw);
        connID = -1L;
        stmtID = -1L;
        sql = null;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
        this.clientSQLExecute(1, "Drop schema EMP restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommon() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        String queryStr = "select ID, DESCRIPTION from EMP.TESTTABLE where id  > ?";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID))" + this.getSuffix());
        for (int i2 = 0; i2 < 100; ++i2) {
            this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i2 + 1) + ", 'First', 'J 604')");
        }
        TestUtil.setupConnection();
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id  > ?");
        eps.setInt(1, 50);
        HashSet<Integer> results = new HashSet<Integer>();
        ResultSet rs = eps.executeQuery();
        for (i = 0; i < 50; ++i) {
            PreparedStatementDUnit.assertTrue((boolean)rs.next());
            results.add(rs.getInt(1));
        }
        PreparedStatementDUnit.assertFalse((boolean)rs.next());
        for (i = 51; i < 101; ++i) {
            results.remove(i);
        }
        PreparedStatementDUnit.assertTrue((boolean)results.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForBug40209And40220NoDistributionOccurs() throws Exception {
        this.startServerVMs(2, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.createDiskStore(true, 1);
        final boolean[] usedGemFireXDActication = new boolean[]{false};
        final boolean[] queryInfoCreated = new boolean[]{false};
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                usedGemFireXDActication[0] = true;
            }

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                queryInfoCreated[0] = true;
            }
        });
        TestUtil.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        conn.getMetaData().getIndexInfo(null, null, "SYS", true, true);
        PreparedStatementDUnit.assertFalse((String)"The query should have been executed using Derby's activation locally", (boolean)usedGemFireXDActication[0]);
        PreparedStatementDUnit.assertFalse((String)"The QueryInfo object should not have been created", (boolean)queryInfoCreated[0]);
        queryInfoCreated[0] = false;
        usedGemFireXDActication[0] = false;
        ((EmbedDatabaseMetaData)conn.getMetaData()).getClientInfoProperties();
        PreparedStatementDUnit.assertFalse((String)"The query should have been executed using Derby's activation locally", (boolean)usedGemFireXDActication[0]);
        PreparedStatementDUnit.assertFalse((String)"The QueryInfo object should not have been created", (boolean)queryInfoCreated[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40997() throws Exception {
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  replicate " + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   partition by range (cid) ( VALUES BETWEEN 0 AND 599, VALUES BETWEEN 599 AND 902, VALUES BETWEEN 902 AND 1255, VALUES BETWEEN 1255 AND 1678, VALUES BETWEEN 1678 AND 10000) " + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))   partition by range (cid) ( VALUES BETWEEN 0 AND 599, VALUES BETWEEN 599 AND 902, VALUES BETWEEN 902 AND 1255, VALUES BETWEEN 1255 AND 1678, VALUES BETWEEN 1678 AND 10000) colocate with (trade.customers) " + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references trade.securities (sec_id), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by column (cid, sid) " + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10) default 'open', tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, constraint status_ch check (status in ('cancelled', 'open', 'filled')))" + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id), constraint bo_qty_ck check (qty>=0))" + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.txhistory(cid int, oid int, sid int, qty int, price decimal (30, 20), ordertime timestamp, type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))" + this.getSuffix());
        this.clientSQLExecute(1, "create table emp.employees (eid int not null constraint employees_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9))" + this.getSuffix());
        this.clientSQLExecute(1, " create table trade.trades (tid int, cid int, eid int, tradedate date, primary Key (tid), foreign key (cid) references trade.customers (cid), constraint emp_fk foreign key (eid) references emp.employees (eid))" + this.getSuffix());
        this.clientSQLExecute(1, "create function maxCid(DP1 Integer) RETURNS INTEGER PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA EXTERNAL NAME 'sql.TestFunctions.getMaxCid'");
        String subquery = "select * from trade.customers c where c.cid = maxCid( 3  )";
        TestUtil.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        CallableStatement psGFE = conn.prepareCall(subquery);
        psGFE.execute();
        ResultSet gfeRS = psGFE.getResultSet();
        PreparedStatementDUnit.assertFalse((boolean)gfeRS.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41005_1() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid))   partition by range (cid) ( VALUES BETWEEN 0 AND 599, VALUES BETWEEN 599 AND 902, VALUES BETWEEN 902 AND 1255, VALUES BETWEEN 1255 AND 1678, VALUES BETWEEN 1678 AND 10000)" + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, loanlimit int, tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict)   partition by range (cid) ( VALUES BETWEEN 0 AND 599, VALUES BETWEEN 599 AND 902, VALUES BETWEEN 902 AND 1255, VALUES BETWEEN 1255 AND 1678, VALUES BETWEEN 1678 AND 10000) colocate with (trade.customers)" + this.getSuffix());
        this.clientSQLExecute(1, "create function maxCid(DP1 Integer) RETURNS INTEGER PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA EXTERNAL NAME 'sql.TestFunctions.getMaxCidForBug41005' ");
        this.clientSQLExecute(1, "insert into trade.customers values (1,'test' ,1)");
        this.clientSQLExecute(1, "insert into trade.networth values (1,1 ,1)");
        this.clientSQLExecute(1, "insert into trade.customers values (2,'test' ,2)");
        this.clientSQLExecute(1, "insert into trade.networth values (2,2 ,2)");
        this.clientSQLExecute(1, "insert into trade.customers values (3,'test' ,3)");
        this.clientSQLExecute(1, "insert into trade.networth values (3,3 ,3)");
        TestUtil.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        String subquery = "select * from trade.customers c where c.cid = maxCid( 1  )";
        CallableStatement psGFE = conn.prepareCall(subquery);
        psGFE.execute();
        ResultSet gfeRS = psGFE.getResultSet();
        PreparedStatementDUnit.assertTrue((boolean)gfeRS.next());
    }

    public void testCallbackArgBehaviour() throws Exception {
        ResultSet rs;
        int i;
        this.startVMs(1, 4);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null, ID2 int not null , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID2 )");
        PreparedStatement ps = TestUtil.getPreparedStatement("Insert into TESTTABLE1 values (?,?,?,?)");
        for (i = 1; i < 9; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.setString(3, "DESC" + i);
            ps.setString(4, "ADD" + i);
            ps.executeUpdate();
        }
        ps = TestUtil.getPreparedStatement("select ID2 from TESTTABLE1 where ID1 = ?");
        for (i = 1; i < 9; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            PreparedStatementDUnit.assertTrue((boolean)rs.next());
            PreparedStatementDUnit.assertEquals((int)rs.getInt(1), (int)(i + 1));
        }
        ps = TestUtil.getPreparedStatement("Update TESTTABLE1 set ADDRESS = ? where ID1 = ?");
        for (i = 1; i < 9; ++i) {
            ps.setString(1, "ADD" + (i + 1));
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        ps = TestUtil.getPreparedStatement("select ADDRESS from TESTTABLE1 where ID1 = ?");
        for (i = 1; i < 9; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            PreparedStatementDUnit.assertTrue((boolean)rs.next());
            PreparedStatementDUnit.assertEquals((String)("ADD" + (i + 1)), (String)rs.getString(1));
        }
    }

    public void testBugFixTicket5921_UseCase8() throws Exception {
        this.startServerVMs(2, 0, null);
        this.createDiskStore(false, 1);
        this.serverSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) PARTITION BY COLUMN ( ID )");
        for (int i = 0; i <= 3; ++i) {
            this.serverSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
        }
        SerializableRunnable queryExecutor = new SerializableRunnable("BugVerifier"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() throws CacheException {
                GemFireXDQueryObserverAdapter sqo = null;
                try {
                    Connection conn = TestUtil.getConnection();
                    final long connID = ((EmbedConnection)conn).getConnectionID();
                    final Object lock = new Object();
                    final Object testEndLock = new Object();
                    EmbedPreparedStatement eps2 = (EmbedPreparedStatement)conn.prepareStatement("select * from TESTTABLE  where ADDRESS = ?");
                    final long stmtID = eps2.getID();
                    eps2.setString(1, "J1 604");
                    eps2.executeQuery();
                    final boolean[] proceed = new boolean[]{false};
                    final Throwable[] failure = new Throwable[1];
                    final boolean[] connClosed = new boolean[]{false};
                    final boolean[] executedOnce = new boolean[]{false};
                    final Thread stmtCloseCheck = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = lock;
                            synchronized (object) {
                                try {
                                    proceed[0] = true;
                                    lock.notify();
                                    lock.wait();
                                }
                                catch (Throwable t) {
                                    failure[0] = t;
                                }
                            }
                        }
                    });
                    sqo = new GemFireXDQueryObserverAdapter(){

                        public void afterClosingWrapperPreparedStatement(long wrapperPrepStatementID, long wrapperConnectionID) {
                            if (wrapperPrepStatementID == stmtID && !executedOnce[0]) {
                                executedOnce[0] = true;
                                stmtCloseCheck.start();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void afterConnectionCloseByExecutorFunction(long[] connIDs) {
                            boolean notify = false;
                            for (long id : connIDs) {
                                if (id != connID) continue;
                                notify = true;
                                break;
                            }
                            if (notify) {
                                Object object = lock;
                                synchronized (object) {
                                    lock.notify();
                                }
                                object = testEndLock;
                                synchronized (object) {
                                    connClosed[0] = true;
                                    testEndLock.notify();
                                }
                            }
                        }
                    };
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)sqo);
                    eps2.close();
                    Object object = lock;
                    synchronized (object) {
                        if (!proceed[0]) {
                            lock.wait();
                        }
                    }
                    conn.close();
                    object = testEndLock;
                    synchronized (object) {
                        if (!connClosed[0]) {
                            testEndLock.wait();
                        }
                    }
                    stmtCloseCheck.join();
                    TestCase.assertTrue((boolean)executedOnce[0]);
                    TestCase.assertTrue((boolean)connClosed[0]);
                    if (failure[0] != null) {
                        throw failure[0];
                    }
                    if (sqo == null) return;
                }
                catch (Throwable t) {
                    try {
                        throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)t);
                    }
                    catch (Throwable throwable) {
                        if (sqo == null) throw throwable;
                        GemFireXDQueryObserverHolder.removeObserver(sqo);
                        throw throwable;
                    }
                }
                GemFireXDQueryObserverHolder.removeObserver((QueryObserver)sqo);
                return;
            }
        };
        VM dataStore1 = (VM)this.serverVMs.get(0);
        dataStore1.invoke((Runnable)queryExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMainQueryOnPRAndNonCorrelatedSubqueryOnReplicatedRegion_WhereClause() throws Exception {
        this.nestedQuerySetupForPR_Main_RR_Sub();
        String[] queries = new String[]{"select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2 where description2 = 'First26')"};
        String[] prepQueries = new String[]{"select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2 where description2 = ?)"};
        Object[] prepQueryArgs = new Object[]{"First24"};
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        if (currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        try {
            String queryString;
            int i;
            for (i = 0; i < queries.length; ++i) {
                queryString = queries[i];
                TestUtil.validateResults(derbyStmt, stmt, queryString, false);
            }
            for (i = 0; i < prepQueries.length; ++i) {
                queryString = prepQueries[i];
                PreparedStatement pstmt = conn.prepareStatement(queryString);
                pstmt.setObject(1, prepQueryArgs[i]);
                PreparedStatement derbyPstmt = derbyConn.prepareStatement(queryString);
                derbyPstmt.setObject(1, prepQueryArgs[i]);
                TestUtil.validateResults(derbyPstmt, pstmt, queryString, false);
            }
        }
        finally {
            block19: {
                this.cleanDerbyArtifacts(derbyStmt, derbyConn);
                try {
                    this.clientSQLExecute(1, "drop table TESTTABLE1");
                }
                catch (SQLException i) {}
                try {
                    this.clientSQLExecute(1, "drop table TESTTABLE2");
                }
                catch (SQLException i) {}
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block19;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41607() throws Exception {
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        String queryStr = "Delete  from EMP.TESTTABLE where DESCRIPTION  IN ('third','second','First') ";
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate " + this.getSuffix());
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'First', 'J 604')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (3, 'First', 'J 604')");
        TestUtil.setupConnection();
        EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("Delete  from EMP.TESTTABLE where DESCRIPTION  IN ('third','second','First') ");
        PreparedStatementDUnit.assertEquals((int)eps.executeUpdate(), (int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void __testMainQueryOnPRAndCorrelatedSubQueryOnRR_Unsupported_for_now() throws Exception {
        Connection derbyConn = null;
        Statement derbyStmt = null;
        this.nestedQuerySetupForPR_Main_RR_Sub();
        TestUtil.setupConnection();
        String query23333332 = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2 where ID2 > ID1)";
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        if (currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
        }
        derbyConn = DriverManager.getConnection(derbyDbUrl);
        derbyStmt = derbyConn.createStatement();
        TestUtil.setupConnection();
        this.clientSQLExecute(1, query23333332, false, true, false);
        PreparedStatementDUnit.fail((String)"should have thrown Exception");
        this.cleanDerbyArtifacts(derbyStmt, derbyConn);
        try {
            this.clientSQLExecute(1, "drop table TESTTABLE1");
        }
        catch (SQLException query23333332) {
            // empty catch block
        }
        try {
            this.clientSQLExecute(1, "drop table TESTTABLE2");
        }
        catch (SQLException query23333332) {
            // empty catch block
        }
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle22222222) {
            if (sqle22222222.getMessage().indexOf("shutdown") != -1) return;
            sqle22222222.printStackTrace();
            throw sqle22222222;
        }
        catch (SQLException sqle22222222) {
            this.cleanDerbyArtifacts(derbyStmt, derbyConn);
            try {
                this.clientSQLExecute(1, "drop table TESTTABLE1");
            }
            catch (SQLException sqle22222222) {
                // empty catch block
            }
            try {
                this.clientSQLExecute(1, "drop table TESTTABLE2");
            }
            catch (SQLException sqle22222222) {
                // empty catch block
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                return;
            }
            catch (SQLException sqle3) {
                if (sqle3.getMessage().indexOf("shutdown") != -1) return;
                sqle3.printStackTrace();
                throw sqle3;
            }
            catch (Throwable throwable) {
                this.cleanDerbyArtifacts(derbyStmt, derbyConn);
                try {
                    this.clientSQLExecute(1, "drop table TESTTABLE1");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    this.clientSQLExecute(1, "drop table TESTTABLE2");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    throw throwable;
                }
                catch (SQLException sqle4) {
                    if (sqle4.getMessage().indexOf("shutdown") != -1) throw throwable;
                    sqle4.printStackTrace();
                    throw sqle4;
                }
            }
        }
    }

    private void nestedQuerySetupForPR_Main_RR_Sub() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        String table1DDL = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))";
        String table2DDL = "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))";
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        if (currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        derbyStmt.execute(table1DDL);
        derbyStmt.execute(table2DDL);
        this.clientSQLExecute(1, table1DDL + "PARTITION BY COLUMN ( ID1 )" + this.getSuffix());
        this.clientSQLExecute(1, table2DDL + "replicate " + this.getSuffix());
        for (int i = 0; i <= 8; ++i) {
            String insertT1 = "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')";
            String insertT2 = "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')";
            this.clientSQLExecute(1, insertT1);
            this.clientSQLExecute(1, insertT2);
            derbyStmt.execute(insertT1);
            derbyStmt.execute(insertT2);
        }
    }

    private void cleanDerbyArtifacts(Statement derbyStmt, Connection conn) throws Exception {
        if (derbyStmt != null) {
            String[] tables2;
            for (String table : tables2 = new String[]{"testtable", "testtable1", "testtable2", "testtable3"}) {
                try {
                    derbyStmt.execute("drop table " + table);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void testBug47299() throws Exception {
        this.startVMs(2, 1);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create table oorder (cid       integer      not null  ,sid       integer  ,did       integer  ,price       integer  ,type       integer  ,qty integer ) replicate " + this.getSuffix());
        int type = 5;
        int price = 2;
        for (int i = 1; i <= 2; ++i) {
            for (int j = 1; j <= 5; ++j) {
                for (int k = 1; k <= 10; ++k) {
                    this.clientSQLExecute(1, "Insert into  oorder values(" + i + "," + j + "," + k + "," + 2 + "," + 5 + "," + i + ")");
                }
            }
        }
        this.clientExecute(2, (Callable<?>)new SerializableCallable("Client 2"){

            public Object call() throws CacheException {
                String query = "select sid, count(*) from oorder  where cid>? and sid<? and did =? GROUP BY sid HAVING count(*) >=1";
                try {
                    EmbedPreparedStatement ps1 = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(query);
                    ps1.setInt(1, 1);
                    ps1.setInt(2, 2);
                    ps1.setInt(3, 3);
                    ResultSet rs = ps1.executeQuery();
                    int count = 0;
                    while (rs.next()) {
                        TestCase.assertEquals((int)1, (int)rs.getInt(1));
                        TestCase.assertEquals((int)1, (int)rs.getInt(2));
                        ++count;
                    }
                    TestCase.assertEquals((int)1, (int)count);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        TestUtil.setupConnection();
        String query = "select sid, did from oorder  where cid>? and sid<? GROUP BY sid, did  order by (sid+did)";
        EmbedPreparedStatement ps1 = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(query);
        ps1.setInt(1, 1);
        ps1.setInt(2, 2);
        ResultSet rs = ps1.executeQuery();
        int count = 0;
        while (rs.next()) {
            PreparedStatementDUnit.assertEquals((int)1, (int)rs.getInt(1));
            ++count;
        }
        PreparedStatementDUnit.assertEquals((int)10, (int)count);
        query = "select sid, count(*) from oorder  where cid>? and sid<? and did =? GROUP BY sid HAVING count(*) >=1";
        ps1 = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(query);
        ps1.setInt(1, 1);
        ps1.setInt(2, 3);
        ps1.setInt(3, 3);
        rs = ps1.executeQuery();
        count = 1;
        while (rs.next()) {
            PreparedStatementDUnit.assertEquals((int)count, (int)rs.getInt(1));
            PreparedStatementDUnit.assertEquals((int)1, (int)rs.getInt(2));
            ++count;
        }
        PreparedStatementDUnit.assertEquals((int)3, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMainQueryOnPRAndNonCorrelatedSubqueryOnReplicatedRegion_WhereClause_Unsupported_For_Now_ServerGrp_Mismatch() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, -1, "SG1");
        this.startServerVMs(1, -1, "SG1,SG2");
        this.createDiskStore(true, 1);
        String table1DDL = "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))";
        String table2DDL = "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))";
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        if (currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        derbyStmt.execute(table1DDL);
        derbyStmt.execute(table2DDL);
        this.clientSQLExecute(1, table1DDL + "PARTITION BY COLUMN ( ID1 )" + "server groups (SG1, SG2)" + this.getSuffix());
        this.clientSQLExecute(1, table2DDL + "replicate " + "server groups ( SG2)" + this.getSuffix());
        for (int i = 0; i <= 8; ++i) {
            String insertT1 = "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')";
            String insertT2 = "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')";
            this.clientSQLExecute(1, insertT1);
            this.clientSQLExecute(1, insertT2);
            derbyStmt.execute(insertT1);
            derbyStmt.execute(insertT2);
        }
        String[] queries = new String[]{"select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2 where description2 = 'First26')  "};
        TestUtil.setupConnection();
        Statement stmt = TestUtil.getConnection().createStatement();
        try {
            for (int i = 0; i < queries.length; ++i) {
                String queryString = queries[i];
                try {
                    stmt.executeQuery(queryString);
                    PreparedStatementDUnit.fail((String)"the query should not have executed successfully");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        finally {
            block21: {
                this.cleanDerbyArtifacts(derbyStmt, derbyConn);
                try {
                    this.clientSQLExecute(1, "drop table TESTTABLE1");
                }
                catch (SQLException i) {}
                try {
                    this.clientSQLExecute(1, "drop table TESTTABLE2");
                }
                catch (SQLException i) {}
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block21;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42840_45715() throws Exception {
        int i;
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table trade.buyordersRep(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), status varchar(10), tid int) replicate");
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), status varchar(100),tid int) partition by column (sid)");
        String query1 = "select * from buyorders  where status =? and tid  >= ? ";
        for (i = 0; i < 15; ++i) {
            s.executeUpdate("insert into buyorders values (" + i + "," + i + "," + i + "," + 10 * i + "," + 101.75 * (double)i + ",'filled'," + i + ")");
        }
        for (i = 0; i < 15; ++i) {
            s.executeUpdate("insert into trade.buyordersRep values (" + i + "," + i + "," + i + "," + 10 * i + "," + 101.75 * (double)i + ",'filled'," + i + ")");
        }
        try {
            PreparedStatement ps = conn.prepareStatement(query1);
            ps.setString(1, "filled");
            ps.setInt(2, 0);
            ResultSet rs = ps.executeQuery();
            long connectionID = ((EmbedConnection)conn).getConnectionID();
            long prepStatementID = ((EmbedPreparedStatement)ps).getID();
            SerializableRunnable sr = PreparedStatementDUnit.getExecutorToManipulatePVS(connectionID, prepStatementID);
            this.serverExecute(1, (Runnable)sr);
            ps.setString(1, "filled");
            ps.setInt(2, 0);
            this.addExpectedException(null, new int[]{1}, CacheClosedException.class);
            rs = ps.executeQuery();
            int numRes = 0;
            while (rs.next()) {
                ++numRes;
            }
            PreparedStatementDUnit.assertEquals((int)15, (int)numRes);
            this.removeExpectedException(null, new int[]{1}, CacheClosedException.class);
            rs = s.executeQuery("select cid, max(qty*bid) as largest_order from trade.buyordersRep where status = 'filled' GROUP BY cid HAVING max(qty*bid) > 4000 ORDER BY max(qty*bid) DESC");
            numRes = 14;
            while (rs.next()) {
                PreparedStatementDUnit.assertEquals((int)numRes, (int)rs.getInt(1));
                PreparedStatementDUnit.assertEquals((Object)new BigDecimal(numRes * numRes * 10).multiply(new BigDecimal("101.75")).setScale(20), (Object)rs.getBigDecimal(2));
                --numRes;
            }
            PreparedStatementDUnit.assertEquals((int)1, (int)numRes);
            rs = s.executeQuery("select cid, max(qty*bid) as largest_order from buyorders where status = 'filled' GROUP BY cid HAVING max(qty*bid) > 4000 ORDER BY max(qty*bid) DESC");
            numRes = 14;
            while (rs.next()) {
                PreparedStatementDUnit.assertEquals((int)numRes, (int)rs.getInt(1));
                PreparedStatementDUnit.assertEquals((Object)new BigDecimal(numRes * numRes * 10).multiply(new BigDecimal("101.75")).setScale(20), (Object)rs.getBigDecimal(2));
                --numRes;
            }
            PreparedStatementDUnit.assertEquals((int)1, (int)numRes);
            rs = s.executeQuery("select cid, max(qty*bid) as largest_order from buyorders where status = 'filled' and tid=5 GROUP BY cid HAVING max(qty*bid) > 4000 ORDER BY max(qty*bid) DESC");
            numRes = 5;
            while (rs.next()) {
                PreparedStatementDUnit.assertEquals((int)numRes, (int)rs.getInt(1));
                PreparedStatementDUnit.assertEquals((Object)new BigDecimal(numRes * numRes * 10).multiply(new BigDecimal("101.75")).setScale(20), (Object)rs.getBigDecimal(2));
                --numRes;
            }
            PreparedStatementDUnit.assertEquals((int)4, (int)numRes);
            rs = s.executeQuery("select cid, max(qty*bid) as largest_order from trade.buyordersRep where status = 'filled' and tid=5 GROUP BY cid HAVING max(qty*bid) > 4000 ORDER BY max(qty*bid) DESC");
            numRes = 5;
            while (rs.next()) {
                PreparedStatementDUnit.assertEquals((int)numRes, (int)rs.getInt(1));
                PreparedStatementDUnit.assertEquals((Object)new BigDecimal(numRes * numRes * 10).multiply(new BigDecimal("101.75")).setScale(20), (Object)rs.getBigDecimal(2));
                --numRes;
            }
            PreparedStatementDUnit.assertEquals((int)4, (int)numRes);
            numRes = 5;
            query1 = "select cid, max(qty*bid) as largest_order from buyorders where status=? and tid=? GROUP BY cid HAVING max(qty*bid) > 4000 ORDER BY max(qty*bid) DESC";
            ps = conn.prepareStatement(query1);
            ps.setString(1, "filled");
            ps.setInt(2, numRes);
            rs = ps.executeQuery();
            while (rs.next()) {
                PreparedStatementDUnit.assertEquals((int)numRes, (int)rs.getInt(1));
                PreparedStatementDUnit.assertEquals((Object)new BigDecimal(numRes * numRes * 10).multiply(new BigDecimal("101.75")).setScale(20), (Object)rs.getBigDecimal(2));
                --numRes;
            }
            PreparedStatementDUnit.assertEquals((int)4, (int)numRes);
            numRes = 5;
            query1 = "select cid, max(qty*bid) as largest_order from trade.buyordersRep where status=? and tid=? GROUP BY cid HAVING max(qty*bid) > 4000 ORDER BY max(qty*bid) DESC";
            ps = conn.prepareStatement(query1);
            ps.setString(1, "filled");
            ps.setInt(2, numRes);
            rs = ps.executeQuery();
            while (rs.next()) {
                PreparedStatementDUnit.assertEquals((int)numRes, (int)rs.getInt(1));
                PreparedStatementDUnit.assertEquals((Object)new BigDecimal(numRes * numRes * 10).multiply(new BigDecimal("101.75")).setScale(20), (Object)rs.getBigDecimal(2));
                --numRes;
            }
            PreparedStatementDUnit.assertEquals((int)4, (int)numRes);
            conn.close();
            numRes = 5;
            conn = TestUtil.getConnection();
            ps = conn.prepareStatement(query1);
            ps.setString(1, "filled");
            ps.setInt(2, numRes);
            rs = ps.executeQuery();
            while (rs.next()) {
                PreparedStatementDUnit.assertEquals((int)numRes, (int)rs.getInt(1));
                PreparedStatementDUnit.assertEquals((Object)new BigDecimal(numRes * numRes * 10).multiply(new BigDecimal("101.75")).setScale(20), (Object)rs.getBigDecimal(2));
                --numRes;
            }
            PreparedStatementDUnit.assertEquals((int)4, (int)numRes);
            conn.close();
        }
        finally {
            s = TestUtil.getConnection().createStatement();
            s.execute("drop table buyorders");
            s.execute("drop table trade.buyordersRep");
        }
    }

    protected static SerializableRunnable getExecutorToManipulatePVS(final long connectionID, final long statementID) {
        SerializableRunnable pvsManip = new SerializableRunnable("PVS manipulator"){

            public void run() throws CacheException {
                GfxdConnectionHolder holder = GfxdConnectionHolder.getHolder();
                EmbedPreparedStatement ps = (EmbedPreparedStatement)holder.getExistingWrapper(Long.valueOf(connectionID)).getStatementForTEST(statementID);
                GenericParameterValueSet pvs = (GenericParameterValueSet)ps.getParameterValueSet();
                final GenericParameter gp = pvs.getGenericParameter(0);
                final SQLVarchar sqlchar = new SQLVarchar("filled");
                DataType myDVD = new DataType(){

                    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
                        gp.initialize((DataValueDescriptor)new SQLVarchar());
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new GemFireXDRuntimeException((Throwable)e);
                        }
                        throw new CacheClosedException();
                    }

                    public int compare(DataValueDescriptor other) throws StandardException {
                        return sqlchar.compare(other);
                    }

                    public int estimateMemoryUsage() {
                        return 0;
                    }

                    public DataValueDescriptor getClone() {
                        return this;
                    }

                    public int getLength() throws StandardException {
                        return sqlchar.getLength();
                    }

                    public DataValueDescriptor getNewNull() {
                        return null;
                    }

                    public String getString() throws StandardException {
                        return "filled";
                    }

                    public String getTypeName() {
                        return sqlchar.getTypeName();
                    }

                    public void readExternalFromArray(ArrayInputStream ais) throws IOException, ClassNotFoundException {
                        throw new CacheClosedException();
                    }

                    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
                    }

                    public boolean isNull() {
                        return false;
                    }

                    public void restoreToNull() {
                    }

                    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                    }

                    public void writeExternal(ObjectOutput out) throws IOException {
                    }

                    public int getTypeFormatId() {
                        return sqlchar.getTypeFormatId();
                    }

                    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
                        throw new UnsupportedOperationException("unexpected invocation");
                    }

                    public int computeHashCode(int maxWidth, int hash) {
                        throw new UnsupportedOperationException("unexpected invocation");
                    }

                    public void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
                        throw new UnsupportedOperationException("unexpected invocation");
                    }

                    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
                        throw new UnsupportedOperationException("Not expected to be invoked for " + ((Object)((Object)this)).getClass());
                    }

                    public int readBytes(UnsafeWrapper unsafe, long memOffset, int columnWidth, ByteSource bs) {
                        throw new UnsupportedOperationException("Not expected to be invoked for " + ((Object)((Object)this)).getClass());
                    }
                };
                gp.initialize((DataValueDescriptor)myDVD);
            }
        };
        return pvsManip;
    }

    public void testStmntMapCleanupInGfxdConnWrapper() throws Exception {
        this.startVMs(1, 1);
        Connection qConn = TestUtil.getConnection();
        Statement s = qConn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) PARTITION BY COLUMN ( ID )");
        for (int i = 0; i <= 8; ++i) {
            s.execute("insert into TESTTABLE values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
        }
        String[] queries = new String[]{"select * from testtable where id > ?", "select DESCRIPTION, ADDRESS from testtable where id < ?"};
        PreparedStatement ps1 = qConn.prepareStatement(queries[0]);
        PreparedStatement ps2 = qConn.prepareStatement(queries[1]);
        ps1.setInt(1, 6);
        ps2.setInt(1, 6);
        ResultSet rs = ps1.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        PreparedStatementDUnit.assertEquals((int)3, (int)cnt);
        cnt = 0;
        rs = ps2.executeQuery();
        while (rs.next()) {
            ++cnt;
        }
        PreparedStatementDUnit.assertEquals((int)5, (int)cnt);
        DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){
            Integer size;

            public boolean done() {
                VM serverVM = (VM)PreparedStatementDUnit.this.serverVMs.get(0);
                this.size = (Integer)serverVM.invoke(PreparedStatementDUnit.class, "verifyWrapperSize", new Object[]{1});
                return this.size != null && this.size < 2;
            }

            public String description() {
                return "expected size of statement map to be < 2 but got " + this.size;
            }
        };
        PreparedStatementDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)500L, (boolean)false);
    }

    public static void invokeGC() {
        System.gc();
        System.runFinalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int verifyWrapperSize(int expectedSize) throws SQLException {
        int mapSize = 0;
        for (int i = 1; i <= 5; ++i) {
            if (i > 1) {
                long dummy = 0L;
                for (int j = 1; j <= 100000; ++j) {
                    Object[] obj = new Object[50];
                    dummy += (long)obj.hashCode();
                }
                PreparedStatementDUnit.getGlobalLogger().info((Object)("statement not GCed, dummy=" + dummy));
            }
            PreparedStatementDUnit.invokeGC();
            GfxdConnectionHolder holder = GfxdConnectionHolder.getHolder();
            ConcurrentMap idToConnMap = holder.getWrapperMap();
            PreparedStatementDUnit.assertNotNull((Object)idToConnMap);
            GfxdConnectionWrapper wrapper = null;
            InternalManagementService ims = InternalManagementService.getAnyInstance();
            for (GfxdConnectionWrapper o : idToConnMap.values()) {
                if (ims != null && o == ims.getConnectionWrapperForTEST()) continue;
                if (wrapper == null) {
                    wrapper = o;
                    continue;
                }
                PreparedStatementDUnit.fail((String)"found more than one user connection wrappers");
            }
            if (wrapper == null) {
                return 0;
            }
            TLongObjectHashMap stmntMap = wrapper.getStatementMapForTEST();
            long[] allKeys = stmntMap.keys();
            if (allKeys.length > 0) {
                EmbedConnection conn = wrapper.getConnectionForSynchronization();
                Object object = conn.getConnectionSynchronization();
                synchronized (object) {
                    wrapper.getStatement(null, allKeys[0], true, false, false, false, null, false, 0L, 0);
                }
            }
            if ((mapSize = stmntMap.size()) > expectedSize) continue;
            return mapSize;
        }
        return mapSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testNonCorrelatedSubqueryOnPartitionedRegion() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )" + this.getSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))  " + this.getSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        String[] queries = new String[]{"select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2 where description2 = 'First26')  "};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                String queryString = queries[i];
                try {
                    this.clientSQLExecute(1, queryString, false, true, false);
                    PreparedStatementDUnit.fail((String)"Test should fail");
                    continue;
                }
                catch (SQLException sqle) {
                    PreparedStatementDUnit.assertTrue((sqle.getMessage().indexOf("PR based subquery not supported") != -1 ? 1 : 0) != 0);
                }
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testCorrelatedSubQueryOnPRUnsupported() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )" + this.getSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) " + this.getSuffix());
        try {
            for (int i = 0; i <= 8; ++i) {
                this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
                this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
            }
            String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN ( Select ID2 from Testtable2 where description2 = description1)";
            TestUtil.setupConnection();
            try {
                this.clientSQLExecute(1, query, false, true, false);
                PreparedStatementDUnit.fail((String)"should have thrown Exception");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        }
    }

    public static final void reset() {
        connID = -1L;
        stmtID = -1L;
        sql = "";
        executionUsingGemFireXDActivation = false;
        connectionCloseExecuted = false;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        PreparedStatementDUnit.reset();
    }

    public String getSuffix() throws Exception {
        return " ";
    }

    public void createDiskStore(boolean useClient, int vmNum) throws Exception {
    }

    static {
        executionUsingGemFireXDActivation = false;
        connectionCloseExecuted = false;
        currentUserName = null;
        currentUserPassword = null;
    }
}

