/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.query.QueryEvaluationHelper;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class PrepStatementNodesPruningDUnit
extends DistributedSQLTestBase {
    protected static volatile boolean isQueryExecutedOnNode = false;
    private static final int byrange = 1;
    private static final int bylist = 2;
    private static final int bycolumn = 4;
    private static final int ANDing = 8;
    private static final int ORing = 16;
    private static final int Contains = 32;
    private static final int OrderBy = 64;
    private static final int noCheck = 1;
    private static final int fixLater = 3;
    private static final int fixImmediate = 5;
    private static final int wontFix = 9;
    private static final int fixDepend = 17;
    private static final int fixInvestigate = 33;

    public PrepStatementNodesPruningDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINClauseOnRangePartitioning() throws Exception {
        this.startVMs(2, 3);
        this.clientSQLExecute(2, "create table Account ( id varchar(10) primary key, name varchar(100), type int ) partition by range(id)   ( values between 'A'  and 'B'    ,values between 'C'  and 'D'    ,values between 'E'  and 'F'    ,values between 'G'  and 'Z'    ,values between '01' and '05'    ,values between '05' and '15'    ,values between '15' and '20'   )");
        TestUtil.jdbcConn.commit();
        for (int i = 1; i < 21; ++i) {
            this.clientSQLExecute(2, "insert into Account values ('" + (i < 10 ? "0" : "") + "" + i + "', 'Account " + i + "'," + i % 2 + " )");
        }
        Object[][][] queries = new Object[][][]{{{"select id,name from Account where id in (?,?) and type >= 0"}, {new Integer(12), new SQLVarchar("01")}, {new Integer(12), new SQLVarchar("03")}, {new Integer(2), new Integer(1), new Integer(2)}}, {{"select id,name from Account where id in (?,?,?) and type >= 0"}, {new Integer(12), new SQLVarchar("01")}, {new Integer(12), new SQLVarchar("05")}, {new Integer(12), new SQLVarchar("17")}, {new Integer(3), new Integer(3), new Integer(0)}}};
        try {
            VM[] vms = new VM[]{(VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1), (VM)this.serverVMs.get(2)};
            for (Object[][] querie : queries) {
                QueryEvaluationHelper.evaluateQueriesForListPartitionResolver(querie, vms, this);
                PrepStatementNodesPruningDUnit.invokeInEveryVM(QueryEvaluationHelper.class, (String)"reset");
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop Table Account");
            this.getLogWriter().info((Object)"Cleared all artifacts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINClauseOnListPartitioning() throws Exception {
        this.startVMs(2, 3);
        this.clientSQLExecute(2, "create table Account_list ( id varchar(10) primary key, name varchar(100), type int ) partition by list(id) (   values ('00','01')   ,values ('02','03')   ,values ('04','05')   ,values ('06','07','08','09')   ,values ('10','11','12','13')   ,values ('14','15')   ,values ('16','17')    )");
        TestUtil.jdbcConn.commit();
        for (int i = 0; i < 21; ++i) {
            this.clientSQLExecute(2, "insert into Account_list values ('" + (i < 10 ? "0" + i : Integer.valueOf(i)) + "', 'Account " + i + "'," + i % 2 + " )");
        }
        Object[][][] queries = new Object[][][]{{{"select id,name from Account_list where id in (?,?,?) and type >= 0"}, {new Integer(12), new SQLVarchar("00")}, {new Integer(12), new SQLVarchar("01")}, {new Integer(12), new SQLVarchar("04")}, {new Integer(3), new Integer(2), new Integer(1)}}};
        VM[] vms = new VM[]{(VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1), (VM)this.serverVMs.get(2)};
        try {
            for (Object[][] querie : queries) {
                QueryEvaluationHelper.evaluateQueriesForListPartitionResolver(querie, vms, this);
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop Table Account_list");
            this.getLogWriter().info((Object)"Cleared all artifacts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleConditionWhereClauseWithRangePartitioning_1() throws Exception {
        this.startVMs(2, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 )");
        try {
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(2, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
            }
            SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr, "");
            TestUtil.setupConnection();
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from TESTTABLE where ID  >= ? And ID <= ? ");
            eps.setInt(1, 1);
            eps.setInt(2, 3);
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 1; i < 4; ++i) {
                rslts.add(i);
            }
            ResultSet rs = eps.executeQuery();
            for (int i = 1; i < 4; ++i) {
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rs.next());
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            PrepStatementNodesPruningDUnit.assertFalse((boolean)rs.next());
            PartitionedRegion pr = (PartitionedRegion)sqiArr[0].getRegion();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            Object[] routingObjects = spr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(1), true, (DataValueDescriptor)new SQLInteger(3), true);
            this.getLogWriter().info((Object)("Number of routing keys retrieved =" + routingObjects.length + " value1 = " + routingObjects[0]));
            this.verifyQueryExecution(sqiArr[0], routingObjects, 1, 2, eps.getSQLText());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiConditionWhereClauseWithRangePartitioning() throws Exception {
        this.startVMs(2, 3);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 )");
        for (int i = 1; i <= 10; ++i) {
            this.clientSQLExecute(2, "insert into TESTTABLE values (" + i + ", 'First" + i + "', 'J 604')");
        }
        Object[][][][] queries = new Object[][][][]{{{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? And ID <= ?  AND ID <= ? AND ID >= ?"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(3)}, {new Integer(4), new Integer(7)}, {new Integer(4), new Integer(4)}}, {{new Integer(0), new Integer(0), new Integer(3)}}, {{new Integer(1), new Integer(1), true, new Integer(3), true, 1}, {new Integer(8), new Integer(4), true, new Integer(7), true, 1}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? And ID <= ?  AND ID <= ? AND ID >= ?"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(5)}, {new Integer(4), new Integer(7)}, {new Integer(4), new Integer(4)}}, {{new Integer(2), new Integer(1), new Integer(2)}}, {{new Integer(1), new Integer(1), true, new Integer(5), true, 2}, {new Integer(8), new Integer(4), true, new Integer(7), true, 1}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? And ID <= ?  AND ID <= 7 AND ID >= 4"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(3)}}, {{new Integer(0), new Integer(0), new Integer(3)}}, {{new Integer(1), new Integer(1), true, new Integer(3), true, 1}, {new Integer(8), new Integer(4), true, new Integer(7), true, 1}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? And ID <= ?  AND ID <= 7 AND ID >= 4"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(5)}}, {{new Integer(2), new Integer(1), new Integer(2)}}, {{new Integer(1), new Integer(1), true, new Integer(5), true, 2}, {new Integer(8), new Integer(4), true, new Integer(7), true, 1}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? AND ID <= 7 And ID <= ? AND ID >= 4"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(3)}}, {{new Integer(0), new Integer(0), new Integer(3)}}, {{new Integer(1), new Integer(1), true, new Integer(3), true, 1}, {new Integer(8), new Integer(4), true, new Integer(7), true, 1}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? And ID <= ?  AND ID <= ? AND ID >= ?"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(5)}, {new Integer(4), new Integer(7)}, {new Integer(4), new Integer(5)}}, {{new Integer(1), new Integer(1), new Integer(2)}}, {{new Integer(1), new Integer(1), true, new Integer(5), true, 2}, {new Integer(8), new Integer(5), true, new Integer(7), true, 1}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? AND ID <= ? And ID <= ? AND ID >= ?"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(7)}, {new Integer(4), new Integer(3)}, {new Integer(4), new Integer(4)}}, {{new Integer(0), new Integer(0), new Integer(3)}}, {{new Integer(1), new Integer(1), true, new Integer(3), true, 1}, {new Integer(8), new Integer(4), true, null, false, 1}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? AND ID <= ? And ID <= ? AND ID >= ?"}}, {{new Integer(4), new Integer(7)}, {new Integer(4), new Integer(1)}, {new Integer(4), new Integer(2)}, {new Integer(4), new Integer(6)}}, {{new Integer(0), new Integer(2), new Integer(1)}}, {{new Integer(1), new Integer(7), true, null, true, 2}, {new Integer(1), null, true, new Integer(1), true, 2}}}, {{{"select ID, DESCRIPTION from TESTTABLE where ID  >= ? AND ID <= ? And ID >= ? AND ID <= ? AND ID != 1"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(4)}, {new Integer(4), new Integer(4)}, {new Integer(4), new Integer(4)}}, {{new Integer(1), new Integer(3), new Integer(0)}}, {{new Integer(1), new Integer(4), true, new Integer(4), true, 2}, {new Integer(16), new Integer(1), true, new Integer(10), true, 3}}}, {{{"select ID , ADDRESS as alias3 from TESTTABLE where ID  >= ? and ID <= ?"}}, {{new Integer(4), new Integer(1)}, {new Integer(4), new Integer(10)}}, {{new Integer(10), new Integer(3), new Integer(0)}, {new Integer(32), new Integer(1), new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}}}, {{new Integer(1), new Integer(1), true, new Integer(10), true, new Integer(3)}}}};
        try {
            VM[] vms = new VM[]{(VM)this.serverVMs.get(0), (VM)this.serverVMs.get(1), (VM)this.serverVMs.get(2)};
            QueryEvaluationHelper.evaluate4DQueryArray(queries, vms, this);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixedParametersAndConstantRangeCondition() throws Exception {
        this.startVMs(2, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 8 )");
        try {
            VM nodeVM;
            int i;
            for (int i2 = 0; i2 < 9; ++i2) {
                this.clientSQLExecute(2, "insert into TESTTABLE values (" + (i2 + 1) + ", 'First" + (i2 + 1) + "', 'J 604')");
            }
            final SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qi, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    sqi[0] = (SelectQueryInfo)qi;
                }
            });
            SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver on DataStore Node"){

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                            public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                                isQueryExecutedOnNode = true;
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            TestUtil.setupConnection();
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from TESTTABLE where ID  >= ? And ID <= ?  AND ID <= 7 AND ID >= 4");
            SerializableRunnable validateQueryExecution = new SerializableRunnable("validate node has executed the query"){

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                        TestCase.assertTrue((boolean)isQueryExecutedOnNode);
                        isQueryExecutedOnNode = false;
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            SerializableRunnable validateNoQueryExecution = new SerializableRunnable("validate node has NOT executed the query"){

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                        TestCase.assertFalse((boolean)isQueryExecutedOnNode);
                        isQueryExecutedOnNode = false;
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            };
            eps.setInt(1, 1);
            eps.setInt(2, 3);
            ResultSet rs = eps.executeQuery();
            PrepStatementNodesPruningDUnit.assertFalse((boolean)rs.next());
            PartitionedRegion pr = (PartitionedRegion)sqi[0].getRegion();
            Set nodesOfPr = pr.getRegionAdvisor().adviseDataStore();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            Object[] routingObjects1 = spr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(1), true, (DataValueDescriptor)new SQLInteger(3), true);
            PrepStatementNodesPruningDUnit.assertEquals((int)routingObjects1.length, (int)1);
            Object[] routingObjects2 = spr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(4), true, (DataValueDescriptor)new SQLInteger(7), true);
            PrepStatementNodesPruningDUnit.assertEquals((int)routingObjects2.length, (int)1);
            PrepStatementNodesPruningDUnit.assertFalse((routingObjects1[0] == routingObjects2[0] ? 1 : 0) != 0);
            for (i = 0; i < routingObjects1.length; ++i) {
                this.getLogWriter().info((Object)("Gfxd:: Range1: Routing key=" + routingObjects1[i]));
            }
            int j = 0;
            while (i < routingObjects2.length) {
                this.getLogWriter().info((Object)("Gfxd:: Range2: Routing key=" + routingObjects2[j]));
                ++j;
            }
            Set prunedNodes1 = pr.getMembersFromRoutingObjects(routingObjects1);
            Set prunedNodes2 = pr.getMembersFromRoutingObjects(routingObjects2);
            HashSet prunedNodes = new HashSet();
            prunedNodes.addAll(prunedNodes1);
            prunedNodes.retainAll(prunedNodes2);
            PrepStatementNodesPruningDUnit.assertTrue((boolean)prunedNodes.isEmpty());
            nodesOfPr.removeAll(prunedNodes);
            PrepStatementNodesPruningDUnit.assertTrue((nodesOfPr.size() > 0 ? 1 : 0) != 0);
            for (DistributedMember member : nodesOfPr) {
                nodeVM = this.getHostVMForMember(member);
                nodeVM.invoke((Runnable)validateNoQueryExecution);
                PrepStatementNodesPruningDUnit.assertNotNull((Object)nodeVM);
            }
            for (DistributedMember member : prunedNodes) {
                nodeVM = this.getHostVMForMember(member);
                PrepStatementNodesPruningDUnit.assertNotNull((Object)nodeVM);
                nodeVM.invoke((Runnable)validateQueryExecution);
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrJunctionWithListResolver_1() throws Exception {
        this.startVMs(2, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) PARTITION BY LIST ( ID ) ( VALUES (1, 2,3,4,5), VALUES (6,7,8) ) ");
        for (int i = 0; i < 9; ++i) {
            this.clientSQLExecute(2, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr, "");
            TestUtil.setupConnection();
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from TESTTABLE where (ID  = ? OR ID = ?) AND ADDRESS = 'J 604'");
            eps.setInt(1, 1);
            eps.setInt(2, 2);
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 1; i < 3; ++i) {
                rslts.add(i);
            }
            ResultSet rs = eps.executeQuery();
            for (int i = 1; i < 3; ++i) {
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rs.next());
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            PrepStatementNodesPruningDUnit.assertFalse((boolean)rs.next());
            PartitionedRegion pr = (PartitionedRegion)sqiArr[0].getRegion();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            ArrayList<SQLInteger> temp = new ArrayList<SQLInteger>();
            temp.add(new SQLInteger(1));
            temp.add(new SQLInteger(2));
            DataValueDescriptor[] dvdarr = new DataValueDescriptor[]{new SQLInteger(1), new SQLInteger(2)};
            Object[] routingObjects = spr.getRoutingObjectsForList(dvdarr);
            PrepStatementNodesPruningDUnit.assertEquals((int)routingObjects.length, (int)2);
            for (int i = 0; i < routingObjects.length; ++i) {
                this.getLogWriter().info((Object)("Gfxd::testOrJunctionWithListResolver : Routing key=" + routingObjects[i]));
            }
            this.verifyQueryExecution(sqiArr[0], routingObjects, 1, 2, eps.getSQLText());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrJunctionWithListResolver_2() throws Exception {
        this.startVMs(2, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) PARTITION BY LIST ( ID ) ( VALUES (1, 2,3,4,5), VALUES (6,7,8) ) ");
        for (int i = 0; i < 9; ++i) {
            this.clientSQLExecute(2, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
        String query = "select ID, DESCRIPTION from TESTTABLE where (ID  = 1 OR ID = 2) AND ADDRESS = 'J 604'";
        try {
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr, "select ID, DESCRIPTION from TESTTABLE where (ID  = 1 OR ID = 2) AND ADDRESS = 'J 604'");
            TestUtil.setupConnection();
            EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 1; i < 3; ++i) {
                rslts.add(i);
            }
            ResultSet rs = es.executeQuery("select ID, DESCRIPTION from TESTTABLE where (ID  = 1 OR ID = 2) AND ADDRESS = 'J 604'");
            for (int i = 1; i < 3; ++i) {
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rs.next());
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            PrepStatementNodesPruningDUnit.assertFalse((boolean)rs.next());
            PartitionedRegion pr = (PartitionedRegion)sqiArr[0].getRegion();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            ArrayList<SQLInteger> temp = new ArrayList<SQLInteger>();
            temp.add(new SQLInteger(1));
            temp.add(new SQLInteger(2));
            DataValueDescriptor[] dvdarr = new DataValueDescriptor[]{new SQLInteger(1), new SQLInteger(2)};
            Object[] routingObjects = spr.getRoutingObjectsForList(dvdarr);
            PrepStatementNodesPruningDUnit.assertEquals((int)routingObjects.length, (int)2);
            for (int i = 0; i < routingObjects.length; ++i) {
                this.getLogWriter().info((Object)("Gfxd::testOrJunctionWithListResolver : Routing key=" + routingObjects[i]));
            }
            this.verifyQueryExecution(sqiArr[0], routingObjects, 1, 2, es.getSQLText());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInClauseWithAnANDCondition_1_Bug39553() throws Exception {
        this.startVMs(2, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) PARTITION BY LIST ( ID ) ( VALUES (1, 2), VALUES (3,4,5), VALUES (6,7,8) ) ");
        for (int i = 0; i < 9; ++i) {
            this.clientSQLExecute(2, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr, "");
            TestUtil.setupConnection();
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select ID, DESCRIPTION from TESTTABLE where  (ID  IN   (?,?) OR ID = ?) AND DESCRIPTION = 'First1'");
            eps.setInt(1, 1);
            eps.setInt(2, 2);
            eps.setInt(3, 3);
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 1; i < 2; ++i) {
                rslts.add(i);
            }
            ResultSet rs = eps.executeQuery();
            for (int i = 1; i < 2; ++i) {
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rs.next());
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            PrepStatementNodesPruningDUnit.assertFalse((boolean)rs.next());
            PartitionedRegion pr = (PartitionedRegion)sqiArr[0].getRegion();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            ArrayList<SQLInteger> temp = new ArrayList<SQLInteger>();
            temp.add(new SQLInteger(1));
            temp.add(new SQLInteger(2));
            temp.add(new SQLInteger(3));
            DataValueDescriptor[] dvdarr = new DataValueDescriptor[]{new SQLInteger(1), new SQLInteger(2), new SQLInteger(3)};
            Object[] routingObjects = spr.getRoutingObjectsForList(dvdarr);
            PrepStatementNodesPruningDUnit.assertEquals((int)routingObjects.length, (int)3);
            for (int i = 0; i < routingObjects.length; ++i) {
                this.getLogWriter().info((Object)("Gfxd::testOrJunctionWithListResolver : Routing key=" + routingObjects[i]));
            }
            this.verifyQueryExecution(sqiArr[0], routingObjects, -1, -1, eps.getSQLText());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInClauseWithAnANDCondition_2_Bug39555() throws Exception {
        this.startVMs(2, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 10 )");
        for (int i = 0; i < 9; ++i) {
            this.clientSQLExecute(2, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr, "");
            TestUtil.setupConnection();
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select id,description from TESTTABLE where ID in (?,?) and ID < ? AND ID >= ?");
            eps.setInt(1, 1);
            eps.setInt(2, 7);
            eps.setInt(3, 3);
            eps.setInt(4, 1);
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 1; i < 2; ++i) {
                rslts.add(i);
            }
            ResultSet rs = eps.executeQuery();
            for (int i = 1; i < 2; ++i) {
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rs.next());
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            PrepStatementNodesPruningDUnit.assertFalse((boolean)rs.next());
            PartitionedRegion pr = (PartitionedRegion)sqiArr[0].getRegion();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            Object[] routingObjects = spr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(1), true, (DataValueDescriptor)new SQLInteger(3), true);
            PrepStatementNodesPruningDUnit.assertTrue((routingObjects.length == 1 ? 1 : 0) != 0);
            for (int i = 0; i < routingObjects.length; ++i) {
                this.getLogWriter().info((Object)("Gfxd::testOrJunctionWithListResolver : Routing key=" + routingObjects[i]));
            }
            this.verifyQueryExecution(sqiArr[0], routingObjects, 1, 2, eps.getSQLText());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInClauseWithAnANDCondition_3_Bug39555() throws Exception {
        this.startVMs(2, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(2, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 10 )");
        for (int i = 0; i < 9; ++i) {
            this.clientSQLExecute(2, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604')");
        }
        try {
            SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr, "");
            TestUtil.setupConnection();
            EmbedPreparedStatement eps = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement("select id,description from TESTTABLE where ID = ? and description = 'First1'");
            eps.setInt(1, 1);
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 1; i < 2; ++i) {
                rslts.add(i);
            }
            ResultSet rs = eps.executeQuery();
            for (int i = 1; i < 2; ++i) {
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rs.next());
                PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            PrepStatementNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            PrepStatementNodesPruningDUnit.assertFalse((boolean)rs.next());
            PartitionedRegion pr = (PartitionedRegion)sqiArr[0].getRegion();
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            Object[] routingObjects = spr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(1), true, (DataValueDescriptor)new SQLInteger(3), true);
            PrepStatementNodesPruningDUnit.assertTrue((routingObjects.length == 1 ? 1 : 0) != 0);
            for (int i = 0; i < routingObjects.length; ++i) {
                this.getLogWriter().info((Object)("Gfxd::testOrJunctionWithListResolver : Routing key=" + routingObjects[i]));
            }
            this.verifyQueryExecution(sqiArr[0], routingObjects, 1, 2, eps.getSQLText());
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(2, "Drop table TESTTABLE ");
        }
    }

    private void setupObservers(VM[] dataStores, final SelectQueryInfo[] sqi, String queryStr) {
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qi, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                sqi[0] = (SelectQueryInfo)qi;
            }
        });
        SerializableRunnable setObserver = new SerializableRunnable("Set GemFireXDObserver on DataStore Node for query " + queryStr){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                            PrepStatementNodesPruningDUnit.this.getLogWriter().info((Object)"Observer::beforeQueryExecutionByPrepStatementQueryExecutor invoked");
                            isQueryExecutedOnNode = true;
                        }

                        public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                            isQueryExecutedOnNode = true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        for (VM dataStore : dataStores) {
            dataStore.invoke((Runnable)setObserver);
        }
    }

    private void verifyQueryExecution(SelectQueryInfo sqi, Object[] routingObjects, int noOfPrunedNodes, int noOfNoExecQueryNodes, String query) {
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        Set<DistributedMember> prunedNodes = routingObjects.length != 0 ? pr.getMembersFromRoutingObjects(routingObjects) : new HashSet();
        this.getLogWriter().info((Object)("Number of members found after prunning =" + prunedNodes.size()));
        this.verifyExecutionOnDMs(sqi, prunedNodes, noOfPrunedNodes, noOfNoExecQueryNodes, query);
    }

    private void verifyExecutionOnDMs(SelectQueryInfo sqi, Set<DistributedMember> prunedNodes, int noOfPrunedNodes, int noOfNoExecQueryNodes, String query) {
        VM nodeVM;
        SerializableRunnable validateQueryExecution = new SerializableRunnable("validate node has executed the query " + query){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertTrue((boolean)isQueryExecutedOnNode);
                    isQueryExecutedOnNode = false;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        SerializableRunnable validateNoQueryExecution = new SerializableRunnable("validate node has NOT executed the query " + query){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertFalse((boolean)isQueryExecutedOnNode);
                    isQueryExecutedOnNode = false;
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        Set nodesOfPr = pr.getRegionAdvisor().adviseDataStore();
        this.getLogWriter().info((Object)(" Total members = " + nodesOfPr.size()));
        String logPrunedMembers = new String();
        logPrunedMembers = " Prunned member(s) " + prunedNodes.size() + "\n";
        for (DistributedMember dm : prunedNodes) {
            if (dm == null) continue;
            logPrunedMembers = logPrunedMembers + dm.toString() + " ";
        }
        this.getLogWriter().info((Object)logPrunedMembers);
        if (noOfPrunedNodes > -1) {
            PrepStatementNodesPruningDUnit.assertEquals((int)noOfPrunedNodes, (int)prunedNodes.size());
        }
        nodesOfPr.removeAll(prunedNodes);
        String logNonPrunedMembers = new String();
        logNonPrunedMembers = " Non-prunned member(s) " + nodesOfPr.size() + "\n";
        for (DistributedMember dm : nodesOfPr) {
            if (dm == null) continue;
            logNonPrunedMembers = logNonPrunedMembers + dm.toString() + " ";
        }
        this.getLogWriter().info((Object)logNonPrunedMembers);
        if (noOfNoExecQueryNodes > -1) {
            PrepStatementNodesPruningDUnit.assertEquals((int)noOfNoExecQueryNodes, (int)nodesOfPr.size());
        }
        for (DistributedMember memberNoExec : nodesOfPr) {
            nodeVM = this.getHostVMForMember(memberNoExec);
            PrepStatementNodesPruningDUnit.assertNotNull((Object)nodeVM);
            this.getLogWriter().info((Object)("Checking non-execution on VM(pid) : " + nodeVM.getPid()));
            nodeVM.invoke((Runnable)validateNoQueryExecution);
        }
        for (DistributedMember memberExec : prunedNodes) {
            nodeVM = this.getHostVMForMember(memberExec);
            PrepStatementNodesPruningDUnit.assertNotNull((Object)nodeVM);
            this.getLogWriter().info((Object)("Checking execution on VM(pid) : " + nodeVM.getPid()));
            nodeVM.invoke((Runnable)validateQueryExecution);
        }
    }

    public static final void reset() {
        isQueryExecutedOnNode = false;
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        QueryEvaluationHelper.reset();
        PrepStatementNodesPruningDUnit.reset();
    }
}

