/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PersistentReplicateTableDUnit
extends DistributedSQLTestBase {
    private static final String DISKSTORE = "TestPersistenceDiskStore";

    public PersistentReplicateTableDUnit(String name) {
        super(name);
    }

    public String getSuffix() throws Exception {
        String suffix = " PERSISTENT 'TestPersistenceDiskStore'";
        return suffix;
    }

    public void createDiskStore(boolean useClient, int vmNum) throws Exception {
        SerializableRunnable csr = PersistentReplicateTableDUnit.getDiskStoreCreator(DISKSTORE);
        if (useClient) {
            if (vmNum == 1) {
                csr.run();
            } else {
                this.clientExecute(vmNum, (Runnable)csr);
            }
        } else {
            this.serverExecute(vmNum, (Runnable)csr);
        }
    }

    @Override
    protected String[] testSpecificDirectoriesForDeletion() {
        return new String[]{"test_dir"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsufficientDatastoreBehaviourBug42447() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) replicate " + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (int i = 1; i < 31; ++i) {
            psInsert.setInt(1, i);
            psInsert.setString(2, "name" + i);
            psInsert.setInt(3, i);
            psInsert.executeUpdate();
        }
        this.stopVMNums(-3, -2, -1);
        this.stopVMNum(1);
        this.restartVMNums(1);
        try {
            PreparedStatement ps;
            conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            try {
                stmt.executeQuery("select * from trade.customers");
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                ps = conn.prepareStatement("select * from trade.customers where tid > ?");
                ps.setInt(1, 0);
                ps.executeQuery();
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                stmt.executeUpdate("update trade.customers set tid = 5 where tid > 3");
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                ps = conn.prepareStatement("update trade.customers set tid = ? where tid > ?");
                ps.setInt(1, 5);
                ps.setInt(2, 3);
                ps.executeUpdate();
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                stmt.executeUpdate(" delete from trade.customers  where tid > 3");
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                ps = conn.prepareStatement(" delete from trade.customers  where tid > ?");
                ps.setInt(1, 3);
                ps.executeUpdate();
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                ResultSet rs = stmt.executeQuery("select * from trade.customers where cid  = 1");
                rs.next();
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
            }
            try {
                ps = conn.prepareStatement("select * from trade.customers where cid = ?");
                ps.setInt(1, 1);
                ResultSet rs = ps.executeQuery();
                rs.next();
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                stmt.executeUpdate("update trade.customers set tid = 5 where cid = 3");
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                psInsert = conn.prepareStatement("insert into trade.customers values (?,?,?)");
                psInsert.setInt(1, 40);
                psInsert.setString(2, "name40");
                psInsert.setInt(3, 40);
                psInsert.executeUpdate();
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                ps = conn.prepareStatement("update trade.customers set tid = ? where cid = ?");
                ps.setInt(1, 5);
                ps.setInt(2, 3);
                ps.executeUpdate();
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                stmt.executeUpdate(" delete from trade.customers  where  cid = 3");
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
            try {
                ps = conn.prepareStatement(" delete from trade.customers  where cid = ?");
                ps.setInt(1, 3);
                ps.executeUpdate();
                PersistentReplicateTableDUnit.fail((String)"Test should fail due to insufficient data stores");
            }
            catch (SQLException sqle) {
                PersistentReplicateTableDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
            }
        }
        catch (Throwable throwable) {
            this.restartVMNums(-1);
            throw throwable;
        }
        this.restartVMNums(-1);
    }
}

