/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.distributed.PreparedStatementDUnit;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;

public class PersistentPartitionPreparedStatementDUnit
extends PreparedStatementDUnit {
    private static final String DISKSTORE = "TestPersistenceDiskStore";

    public PersistentPartitionPreparedStatementDUnit(String name) {
        super(name);
    }

    @Override
    public String getSuffix() throws Exception {
        String suffix = " PERSISTENT 'TestPersistenceDiskStore'";
        return suffix;
    }

    @Override
    public void createDiskStore(boolean useClient, int vmNum) throws Exception {
        SerializableRunnable csr = PersistentPartitionPreparedStatementDUnit.getDiskStoreCreator(DISKSTORE);
        if (useClient) {
            if (vmNum == 1) {
                csr.run();
            } else {
                this.clientExecute(vmNum, (Runnable)csr);
            }
        } else {
            this.serverExecute(vmNum, (Runnable)csr);
        }
    }

    @Override
    protected String[] testSpecificDirectoriesForDeletion() {
        return new String[]{"test_dir"};
    }

    public void testDataPersistenceOfPRWithRangePartitioning() throws Exception {
        String prClause = " partition by range (cid) ( VALUES BETWEEN 0 AND 10, VALUES BETWEEN 10 AND 20, VALUES BETWEEN 20 AND 30 )  ";
        this.dataPersistenceOfPR(prClause);
    }

    public void testDataPersistenceOfPRWithDefaultPartitioning() throws Exception {
        String prClause = " ";
        this.dataPersistenceOfPR(prClause);
    }

    public void testDataPersistenceOfPRWithColumnPartitioning() throws Exception {
        String prClause = " partition by column (cid) ";
        this.dataPersistenceOfPR(prClause);
    }

    public void testDataPersistenceOfPRWithPrimaryKeyPartitioning() throws Exception {
        String prClause = " partition by primary key ";
        this.dataPersistenceOfPR(prClause);
    }

    public void testDataPersistenceOfPRWithListPartitioning() throws Exception {
        String prClause = " PARTITION BY LIST ( cid ) ( VALUES (0, 10 ),  VALUES (11, 20), VALUES (21, 45) ) ";
        this.dataPersistenceOfPR(prClause);
    }

    public void testDiskTableNodeRecycle() throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, uniq int unique not null, primary key (cid))   " + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        HashSet<Integer> cids = new HashSet<Integer>();
        PreparedStatement ps = conn.prepareStatement("insert into trade.customers values (?,?,?,?)");
        for (int i = 1; i < 11; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "name" + i);
            ps.setInt(3, i);
            ps.setInt(4, i);
            ps.executeUpdate();
            cids.add(i);
        }
        this.stopVMNum(-3);
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("select cid from trade.customers");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should have failed due to lack of data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        this.restartServerVMNums(new int[]{3}, 0, null, null);
        conn = TestUtil.getConnection();
        Iterator itr = cids.iterator();
        int i = 11;
        while (itr.hasNext()) {
            ps.setInt(1, i);
            ps.setString(2, "name" + i);
            ps.setInt(3, i);
            ps.setInt(4, (Integer)itr.next());
            try {
                ps.executeUpdate();
                PersistentPartitionPreparedStatementDUnit.fail((String)"Constraint violation expected");
            }
            catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
                // empty catch block
            }
            ++i;
        }
        for (i = 11; i < 21; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "name" + i);
            ps.setInt(3, i);
            ps.setInt(4, i);
            PersistentPartitionPreparedStatementDUnit.assertEquals((int)1, (int)ps.executeUpdate());
        }
        this.stopVMNums(1);
        this.stopVMNums(-3, -2, -1);
        this.restartVMNums(-1, -2, -3);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        stmt = conn.createStatement();
        rs = stmt.executeQuery("select cid from trade.customers");
        HashSet<Integer> result = new HashSet<Integer>();
        for (int j = 1; j < 21; ++j) {
            result.add(j);
        }
        while (rs.next()) {
            result.remove(rs.getInt(1));
        }
        PersistentPartitionPreparedStatementDUnit.assertTrue((boolean)result.isEmpty());
        itr = cids.iterator();
        i = 21;
        ps = conn.prepareStatement("insert into trade.customers values (?,?,?,?)");
        while (itr.hasNext()) {
            ps.setInt(1, i);
            ps.setString(2, "name" + i);
            ps.setInt(3, i);
            ps.setInt(4, (Integer)itr.next());
            try {
                ps.executeUpdate();
                PersistentPartitionPreparedStatementDUnit.fail((String)"Constraint violation expected");
            }
            catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
                // empty catch block
            }
            ++i;
        }
    }

    private void dataPersistenceOfPR(String partitionClause) throws Exception {
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) " + partitionClause + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (int i = 1; i < 31; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "name" + i);
            ps.setInt(3, i);
            ps.executeUpdate();
        }
        this.stopVMNum(1);
        this.stopVMNums(-3, -2, -1);
        this.restartVMNums(-3, -2, -1);
        this.restartVMNums(1);
        this.stopVMNums(-3, -2, -1);
        conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        this.addExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("select * from trade.customers");
            rs.next();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should have failed due to lack of data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        this.removeExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        this.restartVMNums(-1, -2, -3);
        stmt = conn.createStatement();
        rs = stmt.executeQuery("select * from trade.customers");
        int expected = 465;
        int actual = 0;
        while (rs.next()) {
            int val = rs.getInt(1);
            actual += val;
        }
        PersistentPartitionPreparedStatementDUnit.assertEquals((int)expected, (int)actual);
    }

    public void xxtestPartitionOfflineBehaviourBug42447_1() throws Exception {
        PreparedStatement ps;
        this.startVMs(1, 3);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) partition by column(cid)" + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (int i = 1; i < 31; ++i) {
            psInsert.setInt(1, i);
            psInsert.setString(2, "name" + i);
            psInsert.setInt(3, i);
            psInsert.executeUpdate();
        }
        this.stopVMNum(1);
        this.stopVMNums(-3, -2, -1);
        this.restartVMNums(-3, -2, -1);
        this.restartVMNums(1);
        this.stopVMNums(-3, -2, -1);
        conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        this.addExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        try {
            stmt.executeQuery("select * from trade.customers");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            ps = conn.prepareStatement("select * from trade.customers where tid > ?");
            ps.setInt(1, 0);
            ps.executeQuery();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            stmt.executeUpdate("update trade.customers set tid = 5 where tid > 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            ps = conn.prepareStatement("update trade.customers set tid = ? where tid > ?");
            ps.setInt(1, 5);
            ps.setInt(2, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            stmt.executeUpdate(" delete from trade.customers  where tid > 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            ps = conn.prepareStatement(" delete from trade.customers  where tid > ?");
            ps.setInt(1, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            ResultSet rs = stmt.executeQuery("select * from trade.customers where cid  = 3");
            rs.next();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)"X0Z08", (String)sqle.getSQLState());
        }
        try {
            ps = conn.prepareStatement("select * from trade.customers where cid = ?");
            ps.setInt(1, 3);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            stmt.executeUpdate("update trade.customers set tid = 5 where cid = 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            ps = conn.prepareStatement("update trade.customers set tid = ? where cid = ?");
            ps.setInt(1, 5);
            ps.setInt(2, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            stmt.executeUpdate(" delete from trade.customers  where  cid = 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            ps = conn.prepareStatement(" delete from trade.customers  where cid = ?");
            ps.setInt(1, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        this.restartVMNums(-1, -2, -3);
        this.removeExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
    }

    public void testPartitionOfflineBehaviourBug42447_2() throws Exception {
        PreparedStatement ps;
        int i;
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) partition by column(cid)" + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (i = 1; i < 31; ++i) {
            psInsert.setInt(1, i);
            psInsert.setString(2, "name" + i);
            psInsert.setInt(3, i);
            psInsert.executeUpdate();
        }
        this.startServerVMs(1, 0, null);
        for (i = 31; i < 41; ++i) {
            psInsert.setInt(1, i);
            psInsert.setString(2, "name" + i);
            psInsert.setInt(3, i);
            psInsert.executeUpdate();
        }
        this.stopVMNum(-2);
        conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        this.addExpectedException(new int[]{1}, null, PartitionOfflineException.class);
        try {
            stmt.executeQuery("select * from trade.customers");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement("select * from trade.customers where tid > ?");
            ps.setInt(1, 0);
            ps.executeQuery();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            stmt.executeUpdate("update trade.customers set tid = 5 where tid > 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement("update trade.customers set tid = ? where tid > ?");
            ps.setInt(1, 5);
            ps.setInt(2, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            stmt.executeUpdate(" delete from trade.customers  where tid > 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement(" delete from trade.customers  where tid > ?");
            ps.setInt(1, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        ResultSet rs = stmt.executeQuery("select * from trade.customers where cid  = 1");
        PersistentPartitionPreparedStatementDUnit.assertTrue((boolean)rs.next());
        PreparedStatement ps2 = conn.prepareStatement("select * from trade.customers where cid = ?");
        ps2.setInt(1, 1);
        rs = ps2.executeQuery();
        PersistentPartitionPreparedStatementDUnit.assertTrue((boolean)rs.next());
        int num = stmt.executeUpdate("update trade.customers set tid = 5 where cid = 3");
        PersistentPartitionPreparedStatementDUnit.assertEquals((int)1, (int)num);
        ps2 = conn.prepareStatement("update trade.customers set tid = ? where cid = ?");
        ps2.setInt(1, 5);
        ps2.setInt(2, 3);
        ps2.executeUpdate();
        PersistentPartitionPreparedStatementDUnit.assertEquals((int)1, (int)num);
        num = stmt.executeUpdate(" delete from trade.customers  where  cid = 3");
        PersistentPartitionPreparedStatementDUnit.assertEquals((int)1, (int)num);
        ps2 = conn.prepareStatement(" delete from trade.customers  where cid = ?");
        ps2.setInt(1, 4);
        num = ps2.executeUpdate();
        PersistentPartitionPreparedStatementDUnit.assertEquals((int)1, (int)num);
        this.removeExpectedException(new int[]{1}, null, PartitionOfflineException.class);
    }

    public void __testPartitionOfflineBehaviourBug42447_3() throws Exception {
        PreparedStatement ps;
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) partition by column(cid)" + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (int i = 1; i < 11; ++i) {
            psInsert.setInt(1, i);
            psInsert.setString(2, "name" + i);
            psInsert.setInt(3, i);
            psInsert.executeUpdate();
        }
        this.startServerVMs(1, 0, null, null);
        this.stopVMNum(-1);
        conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        this.addExpectedException(new int[]{1}, null, PartitionOfflineException.class);
        try {
            stmt.executeQuery("select * from trade.customers");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement("select * from trade.customers where tid > ?");
            ps.setInt(1, 0);
            ps.executeQuery();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            stmt.executeUpdate("update trade.customers set tid = 5 where tid > 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement("update trade.customers set tid = ? where tid > ?");
            ps.setInt(1, 5);
            ps.setInt(2, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            stmt.executeUpdate(" delete from trade.customers  where tid > 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement(" delete from trade.customers  where tid > ?");
            ps.setInt(1, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ResultSet rs = stmt.executeQuery("select * from trade.customers where cid  = 1");
            rs.next();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)"X0Z09", (String)sqle.getSQLState());
        }
        try {
            ps = conn.prepareStatement("select * from trade.customers where cid = ?");
            ps.setInt(1, 1);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            stmt.executeUpdate("update trade.customers set tid = 5 where cid = 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement("update trade.customers set tid = ? where cid = ?");
            ps.setInt(1, 5);
            ps.setInt(2, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            stmt.executeUpdate(" delete from trade.customers  where  cid = 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        try {
            ps = conn.prepareStatement(" delete from trade.customers  where cid = ?");
            ps.setInt(1, 3);
            ps.executeUpdate();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
        }
        this.removeExpectedException(new int[]{1}, null, PartitionOfflineException.class);
    }

    public void testPartitionOfflineBehaviourBug42443_1() throws Exception {
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int unique, primary key (cid)) partition by column(cid)" + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        this.stopVMNum(-1);
        Statement stmt = conn.createStatement();
        this.addExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        try {
            stmt.executeQuery("select * from trade.customers where tid = 3");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        this.removeExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        this.restartVMNums(-1);
    }

    public void testPartitionOfflineBehaviourBug42443_2() throws Exception {
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int unique, primary key (cid)) partition by column(cid)" + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        this.stopVMNum(-1);
        Statement stmt = conn.createStatement();
        this.addExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        try {
            stmt.executeUpdate("insert into trade.customers values(1,'cust_1',1)");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        this.removeExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        this.restartVMNums(-1);
    }

    public void testPartitionOfflineBehaviourBug49563() throws Exception {
        this.stopAllVMs();
        this.startVMs(0, 1);
        this.startVMs(1, 0);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int)  partition by range   (sid) ( VALUES BETWEEN 0 AND 409, VALUES BETWEEN 409 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1477, VALUES BETWEEN 1477 AND 1700, VALUES BETWEEN 1700 AND 100000)  REDUNDANCY 1 RECOVERYDELAY -1 STARTUPRECOVERYDELAY -1 " + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into trade.buyorders values (?, ?, ?)");
        ps.setInt(1, 1);
        ps.setInt(2, 1);
        ps.setInt(3, 1);
        ps.execute();
        this.startVMs(0, 1);
        this.stopVMNum(-1);
        ps.setInt(1, 2);
        ps.setInt(2, 2);
        ps.setInt(3, 500);
        ps.addBatch();
        ps.setInt(1, 3);
        ps.setInt(2, 3);
        ps.setInt(3, 400);
        ps.addBatch();
        ps.setInt(1, 4);
        ps.setInt(2, 4);
        ps.setInt(3, 600);
        ps.addBatch();
        this.addExpectedException(new int[]{1}, null, PartitionOfflineException.class);
        try {
            ps.executeBatch();
            PersistentPartitionPreparedStatementDUnit.fail((String)"Should have failed with a partition offline exception.");
        }
        catch (SQLException sql) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)"X0Z09", (String)sql.getSQLState());
        }
        this.removeExpectedException(new int[]{1}, null, PartitionOfflineException.class);
        this.restartVMNums(-1);
    }

    public void testPartitionOfflineBehaviourBug42443_3() throws Exception {
        this.startVMs(1, 1);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int unique, primary key (cid)) partition by column(cid)" + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.portfolio ( pid int not null, cid int not null, pf_name varchar(100), tid int unique, primary key (pid),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict ) partition by column(cid)" + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        this.stopVMNum(-1);
        Statement stmt = conn.createStatement();
        this.addExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        try {
            stmt.executeUpdate("delete from trade.customers where tid > 0");
            PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to insufficient data stores");
        }
        catch (SQLException sqle) {
            PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        this.removeExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        this.restartVMNums(-1);
    }

    public void testBug49193_1() throws Exception {
        this.startVMs(1, 2);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create table customers (cid int not null, cust_name varchar(100), col1 int , col2 int not null unique ,tid int, primary key (cid))  partition by range(tid)   ( values between 0  and 10    ,values between 10  and 100)" + this.getSuffix());
        this.basicTest49193();
    }

    public void testBug49193_2() throws Exception {
        this.startVMs(1, 2);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create table customers (cid int not null, cust_name varchar(100), col1 int , col2 int not null unique ,tid int, primary key (cid))  partition by range(tid)   ( values between 0  and 10    ,values between 10  and 100)" + this.getSuffix());
        this.clientSQLExecute(1, "create index i1 on customers(col1)");
        this.basicTest49193();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTest49193() throws Exception {
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into customers values (?,?,?,?,?)");
        try {
            int i;
            for (i = 1; i < 20; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
            this.startServerVMs(1, -1, "");
            for (i = 20; i < 90; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
            this.stopVMNums(-3);
            conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            this.addExpectedException(new int[]{1}, new int[]{1, 2}, PartitionOfflineException.class);
            this.addExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
            SerializableRunnable optimizerOverride = new SerializableRunnable(){

                public void run() {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                            return Double.MAX_VALUE;
                        }

                        public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                            return Double.MIN_VALUE;
                        }
                    });
                }
            };
            this.serverExecute(1, (Runnable)optimizerOverride);
            this.serverExecute(2, (Runnable)optimizerOverride);
            try {
                stmt.executeUpdate("delete from customers where cid > 50");
                PersistentPartitionPreparedStatementDUnit.fail((String)"Test should fail due to problem in global index maintenance");
            }
            catch (Exception sqle) {
                this.removeExpectedException(new int[]{1}, new int[]{1, 2}, PartitionOfflineException.class);
                this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
            }
            this.restartVMNums(-3);
            stmt.executeUpdate("delete from customers where cid > 50");
        }
        catch (Throwable throwable) {
            SerializableRunnable reset = new SerializableRunnable(){

                public void run() {
                    GemFireXDQueryObserverHolder.clearInstance();
                }
            };
            this.serverExecute(1, (Runnable)reset);
            this.serverExecute(2, (Runnable)reset);
            throw throwable;
        }
        SerializableRunnable reset = new /* invalid duplicate definition of identical inner class */;
        this.serverExecute(1, (Runnable)reset);
        this.serverExecute(2, (Runnable)reset);
    }

    public void testBug43104_1() throws Exception {
        int i;
        this.startVMs(1, 2);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int unique, primary key (cid)) partition by column(cid)" + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.portfolio ( cid int not null, sid int not null,  tid int unique, constraint pk primary key (cid,sid),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict )  replicate " + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.sellorders (oid int not null constraint orders_pk primary key,cid int, sid int, tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict)  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) " + this.getSuffix());
        PreparedStatement psCust = TestUtil.getPreparedStatement("insert into trade.customers values(?,?,?)");
        PreparedStatement psPortf = TestUtil.getPreparedStatement("insert into trade.portfolio values(?,?,?)");
        PreparedStatement psSellOrders = TestUtil.getPreparedStatement("insert into trade.sellorders values(?,?,?,?)");
        for (i = 0; i < 10; ++i) {
            psCust.setInt(1, i);
            psCust.setString(2, "name" + i);
            psCust.setInt(3, i);
            psCust.executeUpdate();
        }
        for (i = 0; i < 10; ++i) {
            psPortf.setInt(1, i);
            psPortf.setInt(2, 121);
            psPortf.setInt(3, i);
            psPortf.executeUpdate();
        }
        for (i = 0; i < 10; ++i) {
            psSellOrders.setInt(1, i);
            psSellOrders.setInt(2, i);
            psSellOrders.setInt(3, 121);
            psSellOrders.setInt(4, i);
            psSellOrders.executeUpdate();
        }
        this.stopVMNum(-1);
        PreparedStatement psPFDelete = TestUtil.getPreparedStatement("delete from trade.portfolio where cid = ? and sid = ? and tid =?");
        for (int i2 = 0; i2 < 10; ++i2) {
            psPFDelete.setInt(1, i2);
            psPFDelete.setInt(2, 121);
            psPFDelete.setInt(3, i2);
            try {
                psPFDelete.executeUpdate();
                PersistentPartitionPreparedStatementDUnit.fail((String)"The delete should have thrown exception");
                continue;
            }
            catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
                continue;
            }
            catch (SQLException sqle) {
                PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
            }
        }
    }

    public void testBug43104_2() throws Exception {
        int i;
        this.startVMs(1, 2);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int unique, primary key (cid)) partition by column(cid)" + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.portfolio ( cid int not null, sid int not null,  tid int unique, constraint pk primary key (cid,sid),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict )  replicate " + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.sellorders (oid int not null constraint orders_pk primary key,cid int, sid int, tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict)  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) " + this.getSuffix());
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null,  exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) " + this.getSuffix());
        PreparedStatement psSec = TestUtil.getPreparedStatement("insert into trade.securities values(?,?,?,?)");
        for (i = 0; i < 10; ++i) {
            psSec.setInt(1, i);
            psSec.setString(2, "symb" + i);
            psSec.setString(3, "nasdaq");
            psSec.setInt(4, i);
            psSec.executeUpdate();
        }
        this.stopVMNum(-1);
        for (i = 0; i < 10; ++i) {
            psSec.setInt(1, i + 10);
            psSec.setString(2, "symb" + i);
            psSec.setString(3, "nasdaq");
            psSec.setInt(4, i);
            try {
                psSec.executeUpdate();
                PersistentPartitionPreparedStatementDUnit.fail((String)"The insert should have thrown exception");
                continue;
            }
            catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
                continue;
            }
            catch (SQLException sqle) {
                PersistentPartitionPreparedStatementDUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z09");
            }
        }
    }
}

