/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class OuterJoinQueriesDUnit
extends DistributedSQLTestBase {
    private final String table1ddl_one = "create table emp.EMPLOYEE(lastname varchar(30), depId int) partition by (depId)";
    private final String table2ddl_one = "create table emp.DEPT(deptname varchar(30), depId int) partition by (depId) colocate with (emp.EMPLOYEE)";
    private final String table1ddl_one_REP = "create table emp.EMPLOYEE(lastname varchar(30), depId int) replicate";
    private final String table2ddl_one_PR = "create table emp.DEPT(deptname varchar(30), depId int) partition by (depId)";
    private final String table2ddl_one_REP = "create table emp.DEPT(deptname varchar(30), depId int) replicate";
    private final String empDepIdIndex = "create index edx on emp.EMPLOYEE(depId)";
    private final String deptDepIdIndex = "create index ddx on emp.DEPT(depId)";
    private final String bdgBidIndex = "create index bdx on bdg(bId)";
    private final String resBidIndex = "create index rdx on res(bid)";
    private final String domBidIndex = "create index dodx on dom(bid)";
    private final String[] ojQueries_one = new String[]{"SELECT emp.Employee.LastName as lname, emp.Employee.DepID as did1, emp.Dept.DeptName as depname, emp.Dept.DepID as did2  FROM emp.employee  LEFT OUTER JOIN emp.dept ON emp.employee.depID = emp.dept.DepID", "SELECT emp.Employee.LastName as lname, emp.Employee.DepID as did1, emp.Dept.DeptName as depname, emp.Dept.DepID as did2  FROM emp.employee  RIGHT OUTER JOIN emp.dept ON emp.employee.depID = emp.dept.DepID"};
    private final String[] xmlOutPutTags_one = new String[]{"leftouterJoin_one", "rightouterJoin_one"};
    private final String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";

    private void createFirstSetOfIndex() throws Exception {
        this.clientSQLExecute(1, "create index edx on emp.EMPLOYEE(depId)");
        this.clientSQLExecute(1, "create index ddx on emp.DEPT(depId)");
    }

    private void createSecondSetOfIndex() throws Exception {
        this.clientSQLExecute(1, "create index bdx on bdg(bId)");
        this.clientSQLExecute(1, "create index rdx on res(bid)");
        this.clientSQLExecute(1, "create index dodx on dom(bid)");
    }

    private void dropFirstSetOfTables() throws Exception {
        this.clientSQLExecute(1, "drop table Emp.depT");
        this.clientSQLExecute(1, "drop table emp.emploYee");
    }

    private void dropSecondSetOfTables() throws Exception {
        this.clientSQLExecute(1, "drop table dom");
        this.clientSQLExecute(1, "drop table res");
        this.clientSQLExecute(1, "drop table bdg");
    }

    public OuterJoinQueriesDUnit(String name) {
        super(name);
    }

    public void insertRows() throws Exception {
        this.clientSQLExecute(1, "insert into emp.employee values ('Jones', 33), ('Rafferty', 31), ('Robinson', 34), ('Steinberg', 33), ('Smith', 34), ('John', null)");
        this.clientSQLExecute(1, "insert into emp.dept values ('sales', 31), ('engineering', 33), ('clerical', 34), ('marketing', 35)");
    }

    public void testOuterJoin_NonColocated() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema emp");
        this.clientSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int)");
        this.clientSQLExecute(1, "create table emp.DEPT(deptname varchar(30), depId int)");
        this.insertRows();
        for (int i = 0; i < this.ojQueries_one.length; ++i) {
            String ojQuery1 = this.ojQueries_one[i];
            String opTag = this.xmlOutPutTags_one[i];
            try {
                this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
                continue;
            }
            catch (Exception ex) {
                this.getLogWriter().info((Object)"trace", (Throwable)ex);
            }
        }
    }

    public void testOuterJoin_1_PR_PR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema emp");
        for (int j = 0; j < 2; ++j) {
            this.clientSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) partition by (depId)");
            this.clientSQLExecute(1, "create table emp.DEPT(deptname varchar(30), depId int) partition by (depId) colocate with (emp.EMPLOYEE)");
            this.insertRows();
            if (j == 1) {
                this.createFirstSetOfIndex();
            }
            for (int i = 0; i < this.ojQueries_one.length; ++i) {
                String ojQuery1 = this.ojQueries_one[i];
                String opTag = this.xmlOutPutTags_one[i];
                this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            }
            this.dropFirstSetOfTables();
        }
    }

    public void testOuterJoin_1_RR_RR() throws Exception {
        this.startVMs(1, 3);
        for (int j = 0; j < 2; ++j) {
            this.clientSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) replicate");
            this.clientSQLExecute(1, "create table emp.DEPT(deptname varchar(30), depId int) replicate");
            this.insertRows();
            if (j == 1) {
                this.createFirstSetOfIndex();
            }
            for (int i = 0; i < this.ojQueries_one.length; ++i) {
                String ojQuery1 = this.ojQueries_one[i];
                String opTag = this.xmlOutPutTags_one[i];
                this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            }
            this.dropFirstSetOfTables();
        }
    }

    public void testOuterJoin_1_PR_RR() throws Exception {
        this.startVMs(1, 3);
        for (int j = 0; j < 2; ++j) {
            this.clientSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) partition by (depId)");
            this.clientSQLExecute(1, "create table emp.DEPT(deptname varchar(30), depId int) replicate");
            this.insertRows();
            if (j == 1) {
                this.createFirstSetOfIndex();
            }
            for (int i = 0; i < this.ojQueries_one.length; ++i) {
                String ojQuery1 = this.ojQueries_one[i];
                String opTag = this.xmlOutPutTags_one[i];
                this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            }
            this.dropFirstSetOfTables();
        }
    }

    public void testOuterJoin_1_RR_PR() throws Exception {
        this.startVMs(1, 3);
        for (int j = 0; j < 2; ++j) {
            this.clientSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) replicate");
            this.clientSQLExecute(1, "create table emp.DEPT(deptname varchar(30), depId int) partition by (depId)");
            this.insertRows();
            if (j == 1) {
                this.createFirstSetOfIndex();
            }
            for (int i = 0; i < this.ojQueries_one.length; ++i) {
                String ojQuery1 = this.ojQueries_one[i];
                String opTag = this.xmlOutPutTags_one[i];
                this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            }
            this.dropFirstSetOfTables();
        }
    }

    public void testOuterJoin_exceptionAsNPCJoinCriteria() throws Exception {
        String opTag;
        String ojQuery1;
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema emp");
        this.clientSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) partition by (lastname)");
        this.clientSQLExecute(1, "create table emp.DEPT(deptname varchar(30), depId int, lastname varchar(30)) partition by (lastname) colocate with (emp.EMPLOYEE)");
        this.clientSQLExecute(1, "insert into emp.employee values ('Jones', 33), ('Rafferty', 31), ('Robinson', 34), ('Steinberg', 33), ('Smith', 34), ('John', null)");
        this.clientSQLExecute(1, "insert into emp.dept values ('sales', 31, 'ln1'), ('engineering', 33, 'ln2'), ('clerical', 34, 'ln3'), ('marketing', 35, 'ln4')");
        boolean gotex = false;
        try {
            ojQuery1 = this.ojQueries_one[0];
            opTag = this.xmlOutPutTags_one[0];
            this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            OuterJoinQueriesDUnit.fail((String)"expected an exception");
        }
        catch (Exception ex) {
            gotex = true;
            this.getLogWriter().info((Object)"trace", (Throwable)ex);
        }
        OuterJoinQueriesDUnit.assertTrue((boolean)gotex);
        gotex = false;
        try {
            ojQuery1 = this.ojQueries_one[1];
            opTag = this.xmlOutPutTags_one[1];
            this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            OuterJoinQueriesDUnit.fail((String)"expected an exception");
        }
        catch (Exception ex) {
            gotex = true;
            this.getLogWriter().info((Object)"trace2", (Throwable)ex);
        }
        OuterJoinQueriesDUnit.assertTrue((boolean)gotex);
    }

    public void testOuterJoin_PR_PR_PR_But_IJC() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) partition by (bid)");
        this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) partition by (bid) colocate with (bdg)");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) partition by (bid) colocate with (bdg)");
        this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
        this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
        this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
        String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.rid = dom.rid on bdg.bid = res.bid";
        String opTag = "threeTableOJ_PRPRPR";
        try {
            this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            OuterJoinQueriesDUnit.fail((String)"expected an exception as join condition is invalid");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testOuterJoin_PR_PR_PR_But_ICC() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) partition by (bid)");
        this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) partition by (bid) colocate with (bdg)");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) partition by (bid)");
        this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
        this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
        this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
        String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.rid = dom.rid on bdg.bid = res.bid";
        String opTag = "threeTableOJ_PRPRPR";
        try {
            this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            OuterJoinQueriesDUnit.fail((String)"expected an exception as colocation is not satisfied");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testOuterJoin_PR_PR_PR() throws Exception {
        this.startVMs(1, 3);
        for (int i = 0; i < 2; ++i) {
            this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) partition by (bid)");
            this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) partition by (bid) colocate with (bdg)");
            this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) partition by (bid) colocate with (bdg)");
            this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
            this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
            this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
            if (i == 1) {
                this.createSecondSetOfIndex();
            }
            String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.bid = dom.bid on bdg.bid = res.bid";
            String opTag = "threeTableOJ_PRPRPR";
            this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            this.dropSecondSetOfTables();
        }
    }

    public void testOuterJoin_RR_RR_RR() throws Exception {
        this.startVMs(1, 3);
        for (int i = 0; i < 2; ++i) {
            this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) replicate");
            this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) replicate");
            this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) replicate");
            this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
            this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
            this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
            if (i == 1) {
                this.createSecondSetOfIndex();
            }
            String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.bid = dom.bid on bdg.bid = res.bid";
            String opTag = "threeTableOJ_PRPRPR";
            this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            this.dropSecondSetOfTables();
        }
    }

    public void testOuterJoin_PR_RR_RR() throws Exception {
        this.startVMs(1, 3);
        for (int i = 0; i < 2; ++i) {
            this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) partition by (bid)");
            this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) replicate");
            this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) replicate");
            this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
            this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
            this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
            if (i == 1) {
                this.createSecondSetOfIndex();
            }
            String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.bid = dom.bid on bdg.bid = res.bid";
            String opTag = "threeTableOJ_PRPRPR";
            this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
            this.dropSecondSetOfTables();
        }
    }

    public void testOuterJoin_PR_PR_RR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) partition by (bid)");
        this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) partition by (bid) colocate with (bdg)");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) replicate");
        this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
        this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
        this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
        String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.bid = dom.bid on bdg.bid = res.bid";
        String opTag = "threeTableOJ_PRPRPR";
        this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
    }

    public void testOuterJoin_RR_PR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema emp");
        this.clientSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) replicate");
        this.clientSQLExecute(1, "create table emp.DEPT(deptname varchar(30), depId int, lastname varchar(30)) partition by (lastname)");
        this.createFirstSetOfIndex();
        this.clientSQLExecute(1, "insert into emp.employee values ('Jones', 33), ('Rafferty', 31), ('Robinson', 34), ('Steinberg', 33), ('Smith', 34), ('John', null)");
        this.clientSQLExecute(1, "insert into emp.dept values ('sales', 31, 'ln1'), ('engineering', 33, 'ln2'), ('clerical', 34, 'ln3'), ('marketing', 35, 'ln4')");
        String ojQuery1 = this.ojQueries_one[0];
        String opTag = this.xmlOutPutTags_one[0];
        this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
    }

    public void testOuterJoin_RR_PR_RR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) replicate");
        this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) partition by (bid)");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) replicate");
        this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
        this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
        this.createSecondSetOfIndex();
        this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
        String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.bid = dom.bid on bdg.bid = res.bid";
        String opTag = "threeTableOJ_PRPRPR";
        this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
    }

    public void testOuterJoin_RR_PR_RR_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) replicate");
        this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) partition by list (bid) ( values(0,2) )");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) replicate");
        this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
        this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
        this.createSecondSetOfIndex();
        this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
        String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.bid = dom.bid on bdg.bid = res.bid";
        String opTag = "threeTableOJ_PRPRPR";
        this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
    }

    public void testOuterJoin_RR_PR_Bug() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) replicate");
        this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null) partition by (bid)");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) replicate");
        this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
        this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
        this.createSecondSetOfIndex();
        this.clientSQLExecute(1, "insert into dom values('www.grahamellis.co.uk', 1, 101), ('www.sheepbingo.co.uk', 2, 102 )");
        String ojQuery1 = "select * from bdg left outer join      res on bdg.bid = res.bid";
        String opTag = "twoTableOJ_RRPR";
        this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
    }

    public void testOuterJoin_RR_RR_PR() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) replicate");
        this.clientSQLExecute(1, "create table res(person varchar(30), bid int not null, rid int not null)  replicate");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) partition by column(bid)");
        this.clientSQLExecute(1, "insert into bdg values('404', 1), ('405', 2)");
        this.clientSQLExecute(1, "insert into res values('graham', 1, 101), ('lisa', 1, 102)");
        String ojQuery1 = "select * from bdg left outer join      res left outer join dom on res.bid = dom.bid on bdg.bid = res.bid";
        String opTag = "ThreeTableOJ_RR_RR_PR";
        this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
    }

    public void testOuterJoin_RR_RR_PR2() throws Exception {
        Properties props = new Properties();
        this.startVMs(1, 1, 0, null, props);
        this.startVMs(0, 2, 0, "SG2, SG3", props);
        this.clientSQLExecute(1, "create table trade.customers (cust_cid int not null, cust_name varchar(100), cust_tid int, primary key (cust_cid))  replicate");
        this.clientSQLExecute(1, "create table trade.portfolio (port_cid int not null, port_sid int not null, port_qty int not null, port_tid int, constraint portf_pk primary key (port_cid, port_sid), constraint cust_fk foreign key (port_cid) references trade.customers (cust_cid) on delete restrict )  replicate");
        this.clientSQLExecute(1, "create table trade.sellorders (sell_oid int not null constraint orders_pk primary key, sell_cid int, sell_sid int, sell_qty int) partition by column (sell_qty)  SERVER GROUPS (SG2,SG3)");
        Connection conn = TestUtil.getConnection(props);
        PreparedStatement ps1 = conn.prepareStatement("insert into trade.customers values (?, ?, ?)");
        for (int i = 1; i <= 2; ++i) {
            ps1.setInt(1, i);
            ps1.setString(2, "name" + i);
            ps1.setInt(3, i);
            ps1.execute();
        }
        Statement st1 = conn.createStatement();
        st1.execute("insert into trade.portfolio values(1, 1, 100, 1), (1, 2, 150, 1), (2, 2, 200, 1) ");
        Statement st2 = conn.createStatement();
        st2.execute("insert into trade.sellorders values(1, 2, 2, 100)");
        PreparedStatement ps3 = conn.prepareStatement("insert into trade.sellorders values (?, ?, ?, ?)");
        for (int i = 1000; i <= 2000; ++i) {
            ps3.setInt(1, i);
            ps3.setInt(2, i);
            ps3.setInt(3, i);
            ps3.setInt(4, i);
            ps3.execute();
        }
        String ojQuery1 = "select * from trade.customers c LEFT OUTER JOIN trade.portfolio f LEFT OUTER JOIN trade.sellorders so on f.port_cid = so.sell_cid on c.cust_cid= f.port_cid where f.port_tid = 1";
        Statement st3 = conn.createStatement();
        st3.execute(ojQuery1);
        String opTag = "ThreeTableOJ_RR_RR_PR2";
        TestUtil.verifyResults(true, st3, false, this.goldenTextFile, opTag);
        String ojQuery2 = "select * from (trade.customers c LEFT OUTER JOIN trade.portfolio f on c.cust_cid= f.port_cid) LEFT OUTER JOIN trade.sellorders so on f.port_cid = so.sell_cid where f.port_tid = 1";
        Statement st4 = conn.createStatement();
        st4.execute(ojQuery2);
        TestUtil.verifyResults(true, st4, false, this.goldenTextFile, opTag);
    }

    public void testOuterJoin_RR_PR_PR() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table bdg(name varchar(30), bid int not null) replicate");
        this.clientSQLExecute(1, "create table res( person varchar(30), bid int not null, rid int not null) partition by list (rid) (values(0,1), values(2,3) , values(4,7))");
        this.clientSQLExecute(1, "create table dom(domain varchar(30), bid int not null, rid int not null) partition by list(rid) (values(0,1), values(2,3) , values(4,7) ) colocate with (res)");
        int k = 1;
        for (i = 1; i < 7; ++i) {
            this.clientSQLExecute(1, "insert into bdg values('bdg" + i + "'," + k++ + ")");
            if (k != 4) continue;
            k = 1;
        }
        k = 1;
        for (i = 1; i < 7; ++i) {
            this.clientSQLExecute(1, "insert into res values('res" + i + "'," + k++ + "," + (i + 100) + ")");
            if (k != 4) continue;
            k = 1;
        }
        for (i = 1; i < 4; ++i) {
            this.clientSQLExecute(1, "insert into dom values('dom" + i + "'," + (i + 6) + "," + (i + 100) + ")");
        }
        String ojQuery1 = "select * from bdg left outer join  res on bdg.bid = res.bid  left outer join dom on res.rid = dom.rid";
        String opTag = "Three_tableOJ_RR_PR_PR";
        this.sqlExecuteVerify(new int[]{1}, null, ojQuery1, this.goldenTextFile, opTag);
    }

    public void testForumBugFromPgibb() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement stmnt = conn.createStatement();
        stmnt.execute("create table Customers(CustomerId integer not null generated always as identity, CustomerCode varchar(8) not null, constraint PKCustomers primary key (CustomerId), constraint UQCustomers unique (CustomerCode)) partition by column (CustomerId) redundancy 1 persistent");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC1')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC2')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC3')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC4')");
        stmnt.execute("create table Devices(DeviceId integer not null generated always as identity, CustomerId integer not null, MACAddress varchar(12) not null, constraint PKDevices primary key (DeviceId), constraint UQDevices unique (CustomerId, MACAddress), constraint FKDevicesCustomers foreign key (CustomerId) references Customers (CustomerId)) partition by column (CustomerId) colocate with (Customers) redundancy 1 persistent");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000001')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000002')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000001')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000002')");
        String[] queries = new String[]{"select c.CustomerCode, count(d.DeviceId) from Customers c left outer join Devices d on c.CustomerId = d.CustomerId group by c.CustomerCode", "select c.*, d.DeviceId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId", "select c.*, d.DeviceId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId", "select c.*, d.MACAddress from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId", "select c.*, d.MACAddress from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId"};
        int[] numRows = new int[]{4, 6, 6, 6, 6};
        for (int i = 0; i < queries.length; ++i) {
            System.out.println("executing query(" + i + "): " + queries[i]);
            stmnt.execute(queries[i]);
            ResultSet rs = stmnt.getResultSet();
            int numcols = rs.getMetaData().getColumnCount();
            int cnt = 0;
            System.out.println("--------------------------------------");
            while (rs.next()) {
                ++cnt;
                String result = "";
                for (int j = 0; j < numcols; ++j) {
                    result = j == numcols - 1 ? result + rs.getObject(j + 1) : result + rs.getObject(j + 1) + ", ";
                }
                System.out.println(result);
            }
            OuterJoinQueriesDUnit.assertEquals((int)numRows[i], (int)cnt);
            System.out.println("--------------------------------------\n\n");
        }
        stmnt.execute("drop table Devices");
        stmnt.execute("drop table Customers");
    }

    public void testForumBugFromPgibb_RR_PR() throws Exception {
        this.startVMs(1, 0);
        this.startVMs(0, 3);
        Connection conn = TestUtil.getConnection();
        Statement stmnt = conn.createStatement();
        stmnt.execute("create table Customers(CustomerId integer not null generated always as identity, CustomerCode varchar(8) not null, constraint PKCustomers primary key (CustomerId), constraint UQCustomers unique (CustomerCode))  replicate");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC1')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC2')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC3')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC4')");
        stmnt.execute("create table Devices(DeviceId integer not null generated always as identity, CustomerId integer not null, MACAddress varchar(12) not null, constraint PKDevices primary key (DeviceId), constraint UQDevices unique (CustomerId, MACAddress), constraint FKDevicesCustomers foreign key (CustomerId) references Customers (CustomerId)) partition by column (CustomerId) redundancy 1 persistent");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000001')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000002')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000001')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000002')");
        String[] queries = new String[]{"select c.CustomerCode, count(d.DeviceId) from Customers c left outer join Devices d on c.CustomerId = d.CustomerId group by c.CustomerCode", "select c.*, d.DeviceId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId", "select c.*, d.DeviceId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId", "select c.*, d.MACAddress from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId", "select c.*, d.MACAddress from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId"};
        int[] numRows = new int[]{4, 6, 6, 6, 6};
        for (int i = 0; i < queries.length; ++i) {
            System.out.println("executing query(" + i + "): " + queries[i]);
            stmnt.execute(queries[i]);
            ResultSet rs = stmnt.getResultSet();
            int numcols = rs.getMetaData().getColumnCount();
            int cnt = 0;
            System.out.println("--------------------------------------");
            while (rs.next()) {
                ++cnt;
                String result = "";
                for (int j = 0; j < numcols; ++j) {
                    result = j == numcols - 1 ? result + rs.getObject(j + 1) : result + rs.getObject(j + 1) + ", ";
                }
                System.out.println(result);
            }
            OuterJoinQueriesDUnit.assertEquals((int)numRows[i], (int)cnt);
            System.out.println("--------------------------------------\n\n");
        }
        stmnt.execute("drop table Devices");
        stmnt.execute("drop table Customers");
    }

    public void testBug45380() throws Exception {
        this.startVMs(1, 0);
        this.startVMs(0, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.t1Rep ( id int primary key, name varchar(10), type int) replicate");
        s.execute("Insert into  trade.t1Rep values(1,'a',21)");
        s.execute("Insert into  trade.t1Rep values(2,'b',22)");
        s.execute("Insert into  trade.t1Rep values(3,'c',23)");
        s.execute("Insert into  trade.t1Rep values(4,'d',24)");
        s.execute("Insert into  trade.t1Rep values(5,'e',25)");
        s.execute("create table trade.t2Rep ( id int primary key, name varchar(10), type int) replicate");
        s.execute("Insert into  trade.t2Rep values(1,'a',21)");
        s.execute("Insert into  trade.t2Rep values(2,'b',22)");
        s.execute("Insert into  trade.t2Rep values(3,'c',23)");
        s.execute("Insert into  trade.t2Rep values(4,'d',24)");
        s.execute("Insert into  trade.t2Rep values(5,'e',25)");
        s.execute("create table trade.t1Par ( id int primary key, name varchar(10), type int) partition by primary key");
        s.execute("Insert into  trade.t1Par values(1,'a',21)");
        s.execute("Insert into  trade.t1Par values(2,'b',22)");
        s.execute("Insert into  trade.t1Par values(3,'c',23)");
        s.execute("Insert into  trade.t1Par values(4,'d',24)");
        s.execute("Insert into  trade.t1Par values(5,'e',25)");
        s.execute("create table trade.t2Par ( id int primary key, name varchar(10), type int) partition by primary key colocate with (trade.t1Par)");
        s.execute("Insert into  trade.t2Par values(1,'a',21)");
        s.execute("Insert into  trade.t2Par values(2,'b',22)");
        s.execute("Insert into  trade.t2Par values(3,'c',23)");
        s.execute("Insert into  trade.t2Par values(4,'d',24)");
        s.execute("Insert into  trade.t2Par values(5,'e',25)");
        String query = "select t1.type, t1.id, t1.name from trade.t1Rep as t1  left outer join trade.t2Rep as t2 on t1.id = t2.id where case when t1.id is not null then 1 else -1 end IN (?,?,?)";
        PreparedStatement ps1 = conn.prepareStatement(query);
        ps1.setInt(1, 1);
        ps1.setInt(2, 2);
        ps1.setInt(3, 3);
        ResultSet rs = ps1.executeQuery();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        OuterJoinQueriesDUnit.assertEquals((int)5, (int)count);
        query = "select t1.type, t1.id, t1.name from trade.t1Par as t1  left outer join trade.t2Par as t2 on t1.id = t2.id where case when t1.id is not null then 1 else -1 end IN (?,?,?)";
        ps1 = conn.prepareStatement(query);
        ps1.setInt(1, 1);
        ps1.setInt(2, 2);
        ps1.setInt(3, 3);
        rs = ps1.executeQuery();
        count = 0;
        while (rs.next()) {
            ++count;
        }
        OuterJoinQueriesDUnit.assertEquals((int)5, (int)count);
    }
}

