/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import io.snappydata.test.dunit.DistributedTestBase;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class NodesPruningHelper {
    public static final int noCheck = 0;
    public static final int byrange = 1;
    public static final int bylist = 2;
    public static final int bycolumn = 3;
    public static final int ANDing = 4;
    public static final int ORing = 5;
    public static final int allnodes = 6;

    public static void setupObserverOnClient(final QueryInfo[] sqi) {
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qi, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                sqi[0] = qi;
            }
        });
    }

    public static void setupObserverOnClient(final QueryInfo[] sqi, final Activation[] activationArray) {
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qi, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                sqi[0] = qi;
            }

            public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
                activationArray[0] = activation;
            }
        });
    }

    public static void validateNodePruningForQuery(String query, QueryInfo sqi, Object[][] routingInfo, DistributedTestBase test, Activation activation) throws StandardException {
        Set<DistributedMember> expected = NodesPruningHelper.getExpectedNodes(query, sqi, routingInfo, test.getLogWriter());
        HashSet<InternalDistributedMember> actual = new HashSet<InternalDistributedMember>();
        HashSet<Object> actualRoutingKeys = new HashSet<Object>();
        actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
        sqi.computeNodes(actualRoutingKeys, activation, false);
        actual.addAll(NodesPruningHelper.convertRoutingKeysIntoMembersForPR(actualRoutingKeys, (PartitionedRegion)sqi.getRegion()));
        DistributedTestBase.assertEquals((int)expected.size(), (int)actual.size());
        actual.removeAll(expected);
        DistributedTestBase.assertTrue((boolean)actual.isEmpty());
    }

    public static void validateNodePruningForQuery(String query, QueryInfo sqi, Object[][] routingInfo, DistributedTestBase test) throws StandardException {
        NodesPruningHelper.validateNodePruningForQuery(query, sqi, routingInfo, test, null);
    }

    public static Set<InternalDistributedMember> convertRoutingKeysIntoMembersForPR(Set<Object> routingKeys, PartitionedRegion prgn) {
        if (routingKeys.contains(ResolverUtils.TOK_ALL_NODES)) {
            Set nodesOfPr = prgn.getRegionAdvisor().adviseDataStore();
            if (prgn.getLocalMaxMemory() > 0) {
                nodesOfPr.add(prgn.getDistributionManager().getId());
            }
            return nodesOfPr;
        }
        Set nodesOfPr = prgn.getMembersFromRoutingObjects(routingKeys.toArray());
        return nodesOfPr;
    }

    public static Set<DistributedMember> getExpectedNodes(String query, QueryInfo sqi, Object[][] routingInfo, Logger logger) throws StandardException {
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        pr.getPartitionResolver();
        Set allNodes = pr.getRegionAdvisor().adviseDataStore();
        HashSet<DistributedMember> expected = new HashSet<DistributedMember>();
        expected.addAll(allNodes);
        block6: for (int i = 0; i < routingInfo.length; ++i) {
            Object[] currentConditionRow = routingInfo[i];
            int partitioningType = (Integer)currentConditionRow[0];
            switch (partitioningType) {
                case 1: {
                    NodesPruningHelper.handleRangePartitioning(sqi, currentConditionRow, allNodes, expected, i, logger);
                    continue block6;
                }
                case 2: {
                    NodesPruningHelper.handleListPartitioning(sqi, currentConditionRow, allNodes, expected, i, logger);
                    continue block6;
                }
                case 3: {
                    NodesPruningHelper.handleColumnPartitioning(sqi, currentConditionRow, allNodes, expected, i, logger);
                    continue block6;
                }
                case 6: {
                    expected.addAll(allNodes);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("The partition type is undefined");
                }
            }
        }
        return expected;
    }

    private static void handleRangePartitioning(QueryInfo sqi, Object[] currentRowRoutingInfo, Set<InternalDistributedMember> allNodes, Set<DistributedMember> prunedNodes, int conditionNumIndx, Logger logger) {
        Object[] routingObjects;
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
        Set currentCondnNodes = null;
        currentCondnNodes = null;
        DataValueDescriptor lowerbound = (DataValueDescriptor)currentRowRoutingInfo[1];
        DataValueDescriptor upperbound = (DataValueDescriptor)currentRowRoutingInfo[3];
        boolean lboundinclusive = false;
        boolean uboundinclusive = false;
        if (lowerbound != null) {
            lboundinclusive = (Boolean)currentRowRoutingInfo[2];
        }
        if (upperbound != null) {
            uboundinclusive = (Boolean)currentRowRoutingInfo[4];
        }
        routingObjects = (routingObjects = spr.getRoutingObjectsForRange(lowerbound, lboundinclusive, upperbound, uboundinclusive)) != null ? routingObjects : new Object[]{};
        logger.info((Object)("Range   [" + lowerbound + " inclusive = " + lboundinclusive + " to " + upperbound + " inclusive = " + uboundinclusive + "] : routing keys = " + routingObjects.length));
        for (Object entry : routingObjects) {
            logger.info((Object)("   routing keys = [" + entry.toString() + "]"));
        }
        if (routingObjects.length > 0) {
            currentCondnNodes = pr.getMembersFromRoutingObjects(routingObjects);
        }
        if (currentRowRoutingInfo.length > 5) {
            if ((Integer)currentRowRoutingInfo[5] == 4) {
                if (currentCondnNodes != null) {
                    prunedNodes.retainAll(currentCondnNodes);
                }
            } else if (currentCondnNodes != null) {
                prunedNodes.addAll(currentCondnNodes);
            } else {
                prunedNodes.addAll(allNodes);
            }
        } else if (currentCondnNodes != null) {
            prunedNodes.retainAll(currentCondnNodes);
        }
    }

    private static void handleColumnPartitioning(QueryInfo sqi, Object[] currentRowRoutingInfo, Set<InternalDistributedMember> allNodes, Set<DistributedMember> prunedNodes, int conditionNumIndx, Logger logger) {
        Object[] routingObjects;
        Object[] objectArray;
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
        Set currentCondnNodes = null;
        currentCondnNodes = null;
        int end = conditionNumIndx == 0 ? currentRowRoutingInfo.length : currentRowRoutingInfo.length - 1;
        DataValueDescriptor[] keysForIn = new DataValueDescriptor[end - 1];
        for (int i = 1; i < end; ++i) {
            keysForIn[i - 1] = (DataValueDescriptor)currentRowRoutingInfo[i];
        }
        for (DataValueDescriptor entry : keysForIn) {
            logger.info((Object)(" Column based partitioning: partition key = [" + entry.toString() + "]"));
        }
        Object routingKey = null;
        if (spr == null) {
            int hash = 0;
            for (int i = 0; i < keysForIn.length; ++i) {
                hash ^= keysForIn[i].hashCode();
            }
            routingKey = hash;
        } else {
            routingKey = spr.getRoutingObjectsForPartitioningColumns(keysForIn);
        }
        if (routingKey != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = routingKey;
        } else {
            objectArray = new Object[]{};
        }
        for (Object entry : routingObjects = objectArray) {
            logger.info((Object)(" Column based partition key Routing key= [" + entry.toString() + "]"));
        }
        if (routingObjects.length > 0) {
            currentCondnNodes = pr.getMembersFromRoutingObjects(routingObjects);
        }
        if (conditionNumIndx > 0) {
            if ((Integer)currentRowRoutingInfo[currentRowRoutingInfo.length - 1] == 4) {
                if (currentCondnNodes != null) {
                    prunedNodes.retainAll(currentCondnNodes);
                }
            } else if (currentCondnNodes != null) {
                prunedNodes.addAll(currentCondnNodes);
            } else {
                prunedNodes.addAll(allNodes);
            }
        } else if (currentCondnNodes != null) {
            prunedNodes.retainAll(currentCondnNodes);
        }
    }

    private static void handleListPartitioning(QueryInfo sqi, Object[] currentRowRoutingInfo, Set<InternalDistributedMember> allNodes, Set<DistributedMember> prunedNodes, int conditionNumIndx, Logger logger) {
        PartitionedRegion pr = (PartitionedRegion)sqi.getRegion();
        GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
        Set currentCondnNodes = null;
        currentCondnNodes = null;
        int end = conditionNumIndx == 0 ? currentRowRoutingInfo.length : currentRowRoutingInfo.length - 1;
        DataValueDescriptor[] keysForIn = new DataValueDescriptor[end - 1];
        for (int i = 1; i < end; ++i) {
            keysForIn[i - 1] = (DataValueDescriptor)currentRowRoutingInfo[i];
        }
        for (DataValueDescriptor entry : keysForIn) {
            logger.info((Object)(" List partition key of In= [" + entry.toString() + "]"));
        }
        Object[] routingObjects = spr.getRoutingObjectsForList(keysForIn);
        for (Object entry : routingObjects = routingObjects != null ? routingObjects : new Object[]{}) {
            logger.info((Object)(" List partition key Routing key= [" + entry.toString() + "]"));
        }
        if (routingObjects.length > 0) {
            currentCondnNodes = pr.getMembersFromRoutingObjects(routingObjects);
        }
        if (conditionNumIndx > 0) {
            if ((Integer)currentRowRoutingInfo[currentRowRoutingInfo.length - 1] == 4) {
                if (currentCondnNodes != null) {
                    prunedNodes.retainAll(currentCondnNodes);
                }
            } else if (currentCondnNodes != null) {
                prunedNodes.addAll(currentCondnNodes);
            } else {
                prunedNodes.addAll(allNodes);
            }
        } else if (currentCondnNodes != null) {
            prunedNodes.retainAll(currentCondnNodes);
        }
    }
}

