/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;

public class NCJoinTwoNonCollocatedTablesDUnit
extends DistributedSQLTestBase {
    public NCJoinTwoNonCollocatedTablesDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        NCJoinTwoNonCollocatedTablesDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJoinTwoNonCollocatedTablesDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    public void testPR_PK_COL() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (String s : securities) {
            expected.add(s);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  ";
        Connection conn = TestUtil.getConnection();
        Statement s1 = conn.createStatement();
        ResultSet rs = s1.executeQuery(query);
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_COL_RED() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key redundancy 2");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid) redundancy 2");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (String s : securities) {
            expected.add(s);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  ";
        Connection conn = TestUtil.getConnection();
        Statement s1 = conn.createStatement();
        ResultSet rs = s1.executeQuery(query);
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_COL_QualLeft() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 6; i < 10; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 10);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_COL_QualBoth() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_COL_GroupByAVG() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expectedVID = new HashSet<String>();
        expectedVID.add("DAM");
        expectedVID.add("DPM");
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(4);
        expectedID.add(6);
        String query = "Select B.VID, AVG (B.ID) as aid from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ?  GROUP BY B.VID";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(2)));
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.remove(rs.getString(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.isEmpty());
    }

    public void testPR_PK_COL_GroupBySUM() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expectedVID = new HashSet<String>();
        expectedVID.add("AM");
        expectedVID.add("PM");
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(4);
        expectedID.add(6);
        String query = "Select A.VID, AVG (A.ID) as aid from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ?  GROUP BY A.VID";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(2)));
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.remove(rs.getString(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.isEmpty());
    }

    public void testPR_PK_COL_Like_In() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where B.VID like ? and A.SID IN (?, ?)";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setString(1, "DA%");
        s1.setInt(2, 4);
        s1.setInt(3, 6);
        ResultSet rs = s1.executeQuery();
        for (int i2 = 0; i2 < 2; ++i2) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)rs.next());
            NCJoinTwoNonCollocatedTablesDUnit.assertEquals((String)"AM", (String)rs.getString(2));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertFalse((boolean)rs.next());
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(0);
        expectedID.add(1);
        expectedID.add(2);
        expectedID.add(3);
        expectedID.add(4);
        String query2 = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where B.VID like ? and A.VID IN (?, ?)";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s12 = conn2.prepareStatement(query2);
        s12.setString(1, "DA%");
        s12.setString(2, "AM");
        s12.setString(3, "PM");
        ResultSet rs2 = s12.executeQuery();
        while (rs2.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs2.getInt(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        expectedID.clear();
        expectedID.add(0);
        expectedID.add(1);
        expectedID.add(2);
        expectedID.add(3);
        expectedID.add(4);
        query2 = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.VID like ? and B.VID IN (?, ?)";
        conn2 = TestUtil.getConnection();
        s12 = conn2.prepareStatement(query2);
        s12.setString(1, "A%");
        s12.setString(2, "DAM");
        s12.setString(3, "DPM");
        rs2 = s12.executeQuery();
        while (rs2.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs2.getInt(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
    }

    public void testPR_PK_COL_Equality() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        expected.add(securities[8]);
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID = ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        expected.add(securities[8]);
        query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.ID = ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 8);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_PK() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (String s : securities) {
            expected.add(s);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  ";
        Connection conn = TestUtil.getConnection();
        Statement s1 = conn.createStatement();
        ResultSet rs = s1.executeQuery(query);
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_PK_NoProj() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        String query = "Select * from  tpk A inner join tdriver B  on A.ID = B.ID  ";
        Connection conn = TestUtil.getConnection();
        Statement s1 = conn.createStatement();
        ResultSet rs = s1.executeQuery(query);
        for (int i = 0; i < 10; ++i) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)rs.next());
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertFalse((boolean)rs.next());
    }

    public void testPR_PK_PK_QualLeft() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 6; i < 10; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 10);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_PK_QualBoth() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_PK_PK_GroupByAVG() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expectedVID = new HashSet<String>();
        expectedVID.add("DAM");
        expectedVID.add("DPM");
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(4);
        expectedID.add(6);
        String query = "Select B.VID, AVG (B.ID) as aid from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ?  GROUP BY B.VID";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(2)));
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.remove(rs.getString(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.isEmpty());
    }

    public void testPR_PK_PK_GroupBySUM() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expectedVID = new HashSet<String>();
        expectedVID.add("AM");
        expectedVID.add("PM");
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(4);
        expectedID.add(6);
        String query = "Select A.VID, AVG (A.ID) as aid from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ?  GROUP BY A.VID";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(2)));
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.remove(rs.getString(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.isEmpty());
    }

    public void testPR_PK_PK_Like_In() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(0);
        expectedID.add(1);
        expectedID.add(2);
        expectedID.add(3);
        expectedID.add(4);
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where B.VID like ? and A.VID IN (?, ?)";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setString(1, "DA%");
        s1.setString(2, "AM");
        s1.setString(3, "PM");
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        expectedID.clear();
        expectedID.add(0);
        expectedID.add(1);
        expectedID.add(2);
        expectedID.add(3);
        expectedID.add(4);
        query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.VID like ? and B.VID IN (?, ?)";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setString(1, "A%");
        s1.setString(2, "DAM");
        s1.setString(3, "DPM");
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
    }

    public void testPR_PK_PK_Equality() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        expected.add(securities[8]);
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID = ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        expected.add(securities[8]);
        query = "Select A.ID, A.VID, B.ID, B.VID from  tpk A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.ID = ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 8);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_COL() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (String s : securities) {
            expected.add(s);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  ";
        Connection conn = TestUtil.getConnection();
        Statement s1 = conn.createStatement();
        ResultSet rs = s1.executeQuery(query);
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_COL_QualLeft() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 6; i < 10; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 10);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_COL_QualBoth() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_COL_QualBoth_incomingNode() throws Exception {
        this.startServerVMs(1, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        this.startServerVMs(2, 0, "SG1");
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_COL_ThinClient() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        Properties props = new Properties();
        props.setProperty("log-level", this.getLogLevel());
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, props);
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_PK() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (String s : securities) {
            expected.add(s);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  ";
        Connection conn = TestUtil.getConnection();
        Statement s1 = conn.createStatement();
        ResultSet rs = s1.executeQuery(query);
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_PK_QualLeft() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 6; i < 10; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 10);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_PK_QualBoth() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_PK_QualBoth_LessCols() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i = 4; i < 8; ++i) {
            expected.add(securities[i]);
        }
        String query = "Select A.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
    }

    public void testPR_GI_PK_GroupByAVG() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expectedVID = new HashSet<String>();
        expectedVID.add("DAM");
        expectedVID.add("DPM");
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(4);
        expectedID.add(6);
        String query = "Select B.VID, AVG (B.ID) as aid from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ?  GROUP BY B.VID";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(2)));
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.remove(rs.getString(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.isEmpty());
    }

    public void testPR_GI_PK_GroupBySUM() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<String> expectedVID = new HashSet<String>();
        expectedVID.add("AM");
        expectedVID.add("PM");
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(4);
        expectedID.add(6);
        String query = "Select A.VID, AVG (A.ID) as aid from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > ? and B.SID < ?  GROUP BY A.VID";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 6);
        s1.setInt(2, 16);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(2)));
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.remove(rs.getString(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedVID.isEmpty());
    }

    public void testPR_GI_PK_Like_In() throws Exception {
        String s;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        for (i = 0; i < 5; ++i) {
            s = "AM";
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        for (i = 5; i < 10; ++i) {
            s = "PM";
            this.clientSQLExecute(1, "Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            this.clientSQLExecute(1, "Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        HashSet<Integer> expectedID = new HashSet<Integer>();
        expectedID.add(0);
        expectedID.add(1);
        expectedID.add(2);
        expectedID.add(3);
        expectedID.add(4);
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where B.VID like ? and A.VID IN (?, ?)";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setString(1, "DA%");
        s1.setString(2, "AM");
        s1.setString(3, "PM");
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
        expectedID.clear();
        expectedID.add(0);
        expectedID.add(1);
        expectedID.add(2);
        expectedID.add(3);
        expectedID.add(4);
        query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.VID like ? and B.VID IN (?, ?)";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setString(1, "A%");
        s1.setString(2, "DAM");
        s1.setString(3, "DPM");
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.remove(rs.getInt(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expectedID.isEmpty());
    }

    public void testBug_ColMismatch() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.tpk ( pid int primary key, pvid varchar(10), psid int not null) partition by primary key");
        this.clientSQLExecute(1, "create table trade.tcol ( cid int not null, cvid varchar(10), csid int primary key) partition by primary key");
        int baseId = 50;
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into trade.tpk values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            st.execute("Insert into trade.tcol values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        for (int i2 = 0; i2 < 10; ++i2) {
            expected.add(baseId * i2);
        }
        String query = "Select A.PSID, B.CSID from  trade.tpk A inner join trade.tcol B on A.PSID = B.CSID";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s1 = conn2.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinTwoNonCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        Connection conn3 = TestUtil.getConnection();
        Statement st2 = conn3.createStatement();
        st2.execute("drop table trade.tcol");
        st2.execute("drop table trade.tpk");
        st2.execute("drop schema trade restrict");
    }
}

