/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;

public class NCJoinOnNorthWindTradersSchemaDUnit
extends DistributedSQLTestBase {
    public NCJoinOnNorthWindTradersSchemaDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        NCJoinOnNorthWindTradersSchemaDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJoinOnNorthWindTradersSchemaDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    protected void createSchema1() throws Exception {
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.Customers (customerID int primary key  ,companyName varchar(10) ,cityName varchar(10) ,postalCode int not null) partition by primary key");
        this.clientSQLExecute(1, "create table trade.Employees (employeeID int primary key  ,firstName varchar(10) ,lastName varchar(10) ,postalCode int not null) partition by primary key");
        this.clientSQLExecute(1, "create table trade.Products (productID int primary key  ,productName varchar(10) ,productLabel varchar(10) ,unitPrice int not null) partition by primary key");
        this.clientSQLExecute(1, "create table trade.Orders (orderID int primary key  ,shipName varchar(10) ,countryName varchar(10) ,shipPostalCode int not null ,customerID int not null ,employeeID int not null ,FOREIGN KEY (customerID) REFERENCES trade.Customers(customerID) ,FOREIGN KEY (employeeID) REFERENCES trade.Employees(employeeID)) partition by column(shipPostalCode)");
        this.clientSQLExecute(1, "create table trade.OrderDetails (orderID int  ,unitPrice int not null ,quantity int ,productID int not null ,FOREIGN KEY (orderID) REFERENCES trade.Orders(orderID) ,FOREIGN KEY (productID) REFERENCES trade.Products(productID)) partition by column(unitPrice)");
    }

    protected void populateSchema1() throws Exception {
        int i;
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Customers values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + ")");
        }
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Employees values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + ")");
        }
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Products values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + ")");
        }
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Orders values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + "," + i + "," + i + ")");
        }
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.OrderDetails values(" + i + "," + i + "," + i + "," + i + ")");
        }
    }

    protected void populateSchema2() throws Exception {
        int i;
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 0; i < 30; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Customers values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + ")");
        }
        for (i = 0; i < 30; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Employees values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + ")");
        }
        for (i = 0; i < 30; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Products values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + ")");
        }
        for (i = 0; i < 60; ++i) {
            this.clientSQLExecute(1, "Insert into trade.Orders values(" + i + ",'" + securities[i % 10] + "'" + ",'" + securities[i % 10] + "'" + "," + i + "," + i % 30 + "," + i % 30 + ")");
        }
        for (i = 0; i < 60; ++i) {
            this.clientSQLExecute(1, "Insert into trade.OrderDetails values(" + i + "," + i + "," + i + "," + i % 30 + ")");
        }
    }

    protected void dropSchema1() throws Exception {
        this.clientSQLExecute(1, "drop table trade.orderdetails");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop table trade.products");
        this.clientSQLExecute(1, "drop table trade.employees");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_aggregate1() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.createSchema1();
        this.populateSchema1();
        AbstractCollection expected = new HashSet<Integer>();
        for (int i = 1; i < 31; ++i) {
            ((HashSet)expected).add(i);
        }
        String query = "Select A.orderID, A.customerID, B.customerID, B.postalCode from  trade.ORDERS A  inner join trade.Customers B on A.customerID = B.customerID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(1)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i = 1; i < 31; ++i) {
            ((HashSet)expected).add(i);
        }
        query = "Select B.customerID, AVG(A.quantity) as Sales from trade.ORDERDETAILS A join trade.ORDERS B on A.orderID = B.orderID group by B.customerID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(1)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        expected = new ArrayList();
        for (int i = 1; i < 31; ++i) {
            expected.add(i);
        }
        query = "Select B.customerID, AVG(A.quantity) as Sales from trade.ORDERDETAILS A join trade.ORDERS B on A.orderID = B.orderID group by B.customerID order by Sales ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((rs.getInt(1) == ((Integer)expected.remove(0)).intValue() ? 1 : 0) != 0);
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i = 1; i < 11; ++i) {
            ((HashSet)expected).add(i);
        }
        query = "Select B.customerID, AVG(A.quantity) as Sales from trade.ORDERDETAILS A join trade.ORDERS B on A.orderID = B.orderID group by B.customerID order by Sales fetch first 10 rows only ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(1)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i = 1; i < 31; ++i) {
            ((HashSet)expected).add(i * i);
        }
        query = "Select B.customerID, AVG(A.unitPrice * A.quantity) as Sales from trade.ORDERDETAILS A join trade.ORDERS B on A.orderID = B.orderID group by B.customerID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(2)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i = 1; i < 11; ++i) {
            ((HashSet)expected).add(i * i);
        }
        query = "Select B.customerID, AVG(A.unitPrice * A.quantity) as Sales from trade.ORDERDETAILS A join trade.ORDERS B on A.orderID = B.orderID group by B.customerID order by Sales fetch first 10 rows only ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(2)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        expected = new HashSet();
        ((HashSet)expected).add(8);
        query = "Select A.companyName, C.unitPrice, C.quantity, D.productName from trade.CUSTOMERS A inner join trade.ORDERS B on A.customerID = B.customerID inner join trade.ORDERDETAILS C on B.orderID = C.orderID inner join trade.PRODUCTS D on C.productID = D.productID where A.postalCode=8";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(2)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        this.dropSchema1();
    }

    public void test_aggregate2() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.createSchema1();
        this.populateSchema1();
        AbstractCollection expected = new HashSet<Integer>();
        for (int i = 1; i < 31; ++i) {
            ((HashSet)expected).add(i);
        }
        String query = "Select A.customerID, AVG(C.unitPrice * C.quantity) as Sales from trade.CUSTOMERS A inner join trade.ORDERS B on A.customerID = B.customerID inner join trade.ORDERDETAILS C on B.orderID = C.orderID inner join trade.PRODUCTS D on C.productID = D.productID group by A.customerID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(1)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        expected = new ArrayList();
        for (int i = 1; i < 31; ++i) {
            expected.add(i);
        }
        query = "Select A.customerID, AVG(C.unitPrice * C.quantity) as Sales from trade.CUSTOMERS A inner join trade.ORDERS B on A.customerID = B.customerID inner join trade.ORDERDETAILS C on B.orderID = C.orderID inner join trade.PRODUCTS D on C.productID = D.productID group by A.customerID order by Sales ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((rs.getInt(1) == ((Integer)expected.remove(0)).intValue() ? 1 : 0) != 0);
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i = 1; i < 11; ++i) {
            ((HashSet)expected).add(i);
        }
        query = "Select A.customerID, AVG(C.unitPrice * C.quantity) as Sales from trade.CUSTOMERS A inner join trade.ORDERS B on A.customerID = B.customerID inner join trade.ORDERDETAILS C on B.orderID = C.orderID inner join trade.PRODUCTS D on C.productID = D.productID group by A.customerID order by Sales fetch first 10 rows only ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).remove(rs.getInt(1)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)((HashSet)expected).isEmpty());
        s1.close();
        this.dropSchema1();
    }

    public void test_aggregate3() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.createSchema1();
        this.populateSchema2();
        HashSet<Integer> expected = new HashSet<Integer>();
        for (int i = 0; i < 30; ++i) {
            expected.add(i);
        }
        String query = "Select A.customerID, AVG(C.unitPrice * C.quantity) as Sales from trade.CUSTOMERS A inner join trade.ORDERS B on A.customerID = B.customerID inner join trade.ORDERDETAILS C on B.orderID = C.orderID inner join trade.PRODUCTS D on C.productID = D.productID group by A.customerID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i = 0; i < 30; ++i) {
            int plusi = i + 30;
            int sum1 = i * i;
            int sum2 = plusi * plusi;
            int avg = (sum1 + sum2) / 2;
            expected.add(avg);
        }
        query = "Select A.customerID, AVG(C.unitPrice * C.quantity) as Sales from trade.CUSTOMERS A inner join trade.ORDERS B on A.customerID = B.customerID inner join trade.ORDERDETAILS C on B.orderID = C.orderID inner join trade.PRODUCTS D on C.productID = D.productID group by A.customerID order by Sales ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.remove(rs.getInt(2)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i = 0; i < 10; ++i) {
            expected.add(i);
        }
        query = "Select A.customerID, AVG(C.unitPrice * C.quantity) as Sales from trade.CUSTOMERS A inner join trade.ORDERS B on A.customerID = B.customerID inner join trade.ORDERDETAILS C on B.orderID = C.orderID inner join trade.PRODUCTS D on C.productID = D.productID group by A.customerID order by Sales fetch first 10 rows only ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinOnNorthWindTradersSchemaDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.dropSchema1();
    }
}

