/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import junit.framework.TestCase;

public class NCJoinMultiTablesDUnit
extends DistributedSQLTestBase {
    static int[] remoteCallbackInvokeCount = new int[]{0, 0, 0, 0};
    final GemFireXDQueryObserver ncjPullResultSetOpenCoreObserver = new GemFireXDQueryObserverAdapter(){

        public void ncjPullResultSetOpenCoreInvoked() {
            remoteCallbackInvokeCount[0] = remoteCallbackInvokeCount[0] + 1;
        }

        public void getAllInvoked(int numElements) {
            remoteCallbackInvokeCount[1] = remoteCallbackInvokeCount[1] + 1;
        }

        public void getAllGlobalIndexInvoked(int numElements) {
            remoteCallbackInvokeCount[2] = remoteCallbackInvokeCount[2] + 1;
        }

        public void getAllLocalIndexExecuted() {
            remoteCallbackInvokeCount[3] = remoteCallbackInvokeCount[3] + 1;
        }
    };
    NcjPullResultsetTestSerializableRunnable ncjPullResultSetOpenCoreObserverVerify = new NcjPullResultsetTestSerializableRunnable("Verify ncjPullResultSetOpenCoreObserver");
    SerializableRunnable ncjPullResultSetOpenCoreObserverSet = new SerializableRunnable("Set ncjPullResultSetOpenCoreObserver"){

        public void run() throws CacheException {
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[0] = 0;
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[1] = 0;
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[2] = 0;
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[3] = 0;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)NCJoinMultiTablesDUnit.this.ncjPullResultSetOpenCoreObserver);
        }
    };
    SerializableRunnable ncjPullResultSetOpenCoreObserverReset = new SerializableRunnable("Reset ncjPullResultSetOpenCoreObserver"){

        public void run() throws CacheException {
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[0] = 0;
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[1] = 0;
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[2] = 0;
            NCJoinMultiTablesDUnit.remoteCallbackInvokeCount[3] = 0;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
        }
    };
    SerializableRunnable ncjRootIDObserverServerSet = new SerializableRunnable("Set ncjRootIDServerObserverServerSet"){

        public void run() throws CacheException {
            ncjRootID = 0L;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)NCJoinMultiTablesDUnit.this.ncjRootIDServerObserver);
        }
    };
    SerializableRunnable ncjRootIDObserverClientSet = new SerializableRunnable("Set ncjRootIDServerObserverClientSet"){

        public void run() throws CacheException {
            ncjRootID = 0L;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)NCJoinMultiTablesDUnit.this.ncjRootIDClientObserver);
        }
    };
    SerializableRunnable ncjRootIDObserverReSet = new SerializableRunnable("Set ncjRootIDServerObserverReset"){

        public void run() throws CacheException {
            ncjRootID = 0L;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
        }
    };
    static long ncjRootID = 0L;
    final GemFireXDQueryObserver ncjRootIDClientObserver = new GemFireXDQueryObserverAdapter(){

        public void getStatementIDs(long stmtID, long rootID, int stmtLevel) {
            ncjRootID = stmtID;
        }
    };
    final GemFireXDQueryObserver ncjRootIDServerObserver = new GemFireXDQueryObserverAdapter(){

        public void getStatementIDs(long stmtID, long rootID, int stmtLevel) {
            if (stmtLevel == 2) {
                ncjRootID = rootID;
            }
        }
    };
    NcjRootIDSerializableRunnable ncjRootIDObserverVerify = new NcjRootIDSerializableRunnable("Verify ncjRootIDObserver");

    public NCJoinMultiTablesDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        NCJoinMultiTablesDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJoinMultiTablesDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    public void test_Three_PK_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 1, 0);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 1, 0);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 1, 0);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 1, 0);
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Three_GI_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by column (OSID)");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by column (TID)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 2, 0);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 2, 0);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 2, 0);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 2, 2, 0);
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Three_LI_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create INDEX trade.t1index on trade.ORDERS(OID)");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int primary key, TSID int not null, TVID varchar(10)) partition by  primary key");
        this.clientSQLExecute(1, "create INDEX trade.t2index on trade.TRIPLI(TSID)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 1, 1, 1);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 1, 1, 1);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 1, 1, 1);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 1, 1, 1);
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Predicate_Three_PK_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 11; i < 41; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 21; i < 51; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID where B.DID > ? and TID < ?";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 23);
        s1.setInt(2, 27);
        expected.clear();
        expected.add(24);
        expected.add(25);
        expected.add(26);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 24);
        s1.setInt(2, 28);
        expected.clear();
        expected.add(27);
        expected.add(25);
        expected.add(26);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 23);
        s1.setInt(2, 27);
        expected.clear();
        expected.add(24);
        expected.add(25);
        expected.add(26);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.close();
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID where B.DID > ? and TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 23);
        s1.setInt(2, 27);
        expected.clear();
        expected.add(24);
        expected.add(25);
        expected.add(26);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 24);
        s1.setInt(2, 28);
        expected.clear();
        expected.add(27);
        expected.add(25);
        expected.add(26);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 23);
        s1.setInt(2, 27);
        expected.clear();
        expected.add(24);
        expected.add(25);
        expected.add(26);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.close();
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    private void execute_and_verify_ThreeTables(PreparedStatement prepSt, HashSet<Integer> expected, int param0, int param1, int param2, int param3) throws Exception {
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverSet);
        ResultSet rs = prepSt.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        rs.close();
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverVerify.setVerifyCount(param0, param1, param2, param3));
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverReset);
    }

    public void test_Four_PK_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.FORTI (FID int not null, FSID int primary key, FVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 9; i < 19; ++i) {
            this.clientSQLExecute(1, "Insert into trade.FORTI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(9);
        expected.add(10);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID, D.FID, D.FVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  inner join trade.FORTI D on C.TSID = D.FSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(9);
        expected.add(10);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID, D.FID, D.FVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  inner join trade.FORTI D on C.TSID = D.FSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.FORTI");
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Three_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int not null, DSID int primary key, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int primary key, TSID int not null, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Predicate_ThreeTables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int not null, DSID int primary key, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int primary key, TSID int not null, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 11; i < 41; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 21; i < 51; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  where A.OID > ? and B.DID <> ? and C.TID < ?";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        expected.clear();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 21);
        s1.setInt(2, 24);
        s1.setInt(3, 28);
        expected.clear();
        expected.add(22);
        expected.add(23);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        expected.clear();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.close();
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  where A.OID > ? and B.DID <> ? and C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        expected.clear();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 21);
        s1.setInt(2, 24);
        s1.setInt(3, 28);
        expected.clear();
        expected.add(22);
        expected.add(23);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        expected.clear();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        this.execute_and_verify_ThreeTables(s1, expected, 3, 0, 0, 0);
        s1.close();
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Four_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int not null, DSID int primary key, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int primary key, TSID int not null, TVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.FORTI (FID int primary key, FSID int not null, FVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 9; i < 19; ++i) {
            this.clientSQLExecute(1, "Insert into trade.FORTI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(9);
        expected.add(10);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID, D.FID, D.FVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  inner join trade.FORTI D on C.TSID = D.FSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(9);
        expected.add(10);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID, D.FID, D.FVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  inner join trade.FORTI D on C.TSID = D.FSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.FORTI");
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Three_Tables_MultiColumn() throws Exception {
        int sId;
        int vId;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID int not null) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID int not null) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID int not null) partition by primary key");
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.orders values (?, ?, ?)");
        for (i = 1; i < 31; ++i) {
            vId = i + 5000;
            sId = i % 2 == 0 ? i + 100 : i + 1000;
            psInsert.setInt(1, i);
            psInsert.setInt(2, sId);
            psInsert.setInt(3, vId);
            psInsert.executeUpdate();
        }
        psInsert = conn.prepareStatement("insert into trade.DUPLI values (?, ?, ?)");
        for (i = 11; i < 41; ++i) {
            if (i % 2 == 0) {
                sId = i + 100;
                vId = i > 25 ? i + 600 : i + 6000;
            } else {
                sId = i + 2000;
                vId = i + 7000;
            }
            psInsert.setInt(1, i);
            psInsert.setInt(2, sId);
            psInsert.setInt(3, vId);
            psInsert.executeUpdate();
        }
        psInsert = conn.prepareStatement("insert into trade.TRIPLI values (?, ?, ?)");
        for (i = 21; i < 51; ++i) {
            if (i % 2 == 0) {
                sId = i + 100;
                vId = i > 25 ? i + 600 : i + 8000;
            } else {
                sId = i + 3000;
                vId = i + 9000;
            }
            psInsert.setInt(1, i);
            psInsert.setInt(2, sId);
            psInsert.setInt(3, vId);
            psInsert.executeUpdate();
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(22);
        expected.add(24);
        expected.add(26);
        expected.add(28);
        expected.add(30);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID and A.OSID = B.DSID  inner join trade.TRIPLI C on B.DID = C.TID ";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s1 = conn2.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(22);
        expected.add(24);
        expected.add(26);
        expected.add(28);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID and A.OSID = B.DSID  inner join trade.TRIPLI C on B.DID = C.TID and B.DSID = C.TSID ";
        conn2 = TestUtil.getConnection();
        s1 = conn2.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(26);
        expected.add(28);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID and A.OSID = B.DSID  inner join trade.TRIPLI C on B.DID = C.TID and B.DVID = C.TVID ";
        conn2 = TestUtil.getConnection();
        s1 = conn2.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Three_Tables_MultiColumn_VarChar() throws Exception {
        int sId;
        String vId;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.orders values (?, ?, ?)");
        for (i = 1; i < 31; ++i) {
            vId = "1" + securities[i % 10];
            sId = i % 2 == 0 ? i + 100 : i + 1000;
            psInsert.setInt(1, i);
            psInsert.setInt(2, sId);
            psInsert.setString(3, vId);
            psInsert.executeUpdate();
        }
        psInsert = conn.prepareStatement("insert into trade.DUPLI values (?, ?, ?)");
        for (i = 11; i < 41; ++i) {
            vId = securities[i % 10];
            if (i % 2 == 0) {
                sId = i + 100;
                if (i < 25) {
                    vId = "2" + vId;
                }
            } else {
                sId = i + 2000;
                vId = "3" + vId;
            }
            psInsert.setInt(1, i);
            psInsert.setInt(2, sId);
            psInsert.setString(3, vId);
            psInsert.executeUpdate();
        }
        psInsert = conn.prepareStatement("insert into trade.TRIPLI values (?, ?, ?)");
        for (i = 21; i < 51; ++i) {
            vId = securities[i % 10];
            if (i % 2 == 0) {
                sId = i + 100;
                if (i < 25) {
                    vId = "4" + vId;
                }
            } else {
                sId = i + 3000;
                vId = "5" + vId;
            }
            psInsert.setInt(1, i);
            psInsert.setInt(2, sId);
            psInsert.setString(3, vId);
            psInsert.executeUpdate();
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(22);
        expected.add(24);
        expected.add(26);
        expected.add(28);
        expected.add(30);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID and A.OSID = B.DSID  inner join trade.TRIPLI C on B.DID = C.TID ";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s1 = conn2.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(26);
        expected.add(28);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID and A.OSID = B.DSID  inner join trade.TRIPLI C on B.DID = C.TID and B.DVID = C.TVID ";
        conn2 = TestUtil.getConnection();
        s1 = conn2.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Three_Tables_OR_predicates() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int not null, DSID int primary key, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int primary key, TSID int not null, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 31; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 11; i < 41; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 21; i < 51; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  where A.OID > ? AND B.DID <> ? AND C.TID < ?";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        expected.add(28);
        expected.add(29);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  where A.OID > ? or B.DID <> ? AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        expected.add(28);
        expected.add(29);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  where A.OID > ? or (B.DID <> ? AND C.TID < ?)";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  where (A.OID > ? or B.DID <> ?) AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  where A.OID > ? AND B.DID <> ? AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        expected.add(28);
        expected.add(29);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  where A.OID > ? or B.DID <> ? AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        expected.add(28);
        expected.add(29);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  where A.OID > ? or (B.DID <> ? AND C.TID < ?)";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID  where (A.OID > ? or B.DID <> ?) AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(23);
        expected.add(24);
        expected.add(26);
        expected.add(27);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TID  where A.OID > ? AND B.DID <> ? AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        expected.add(28);
        expected.add(29);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TID  where A.OID > ? or B.DID <> ? AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        expected.add(28);
        expected.add(29);
        expected.add(30);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TID  where A.OID > ? or (B.DID <> ? AND C.TID < ?)";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        expected.add(21);
        expected.add(22);
        expected.add(23);
        expected.add(24);
        expected.add(25);
        expected.add(26);
        expected.add(27);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TID  where (A.OID > ? or B.DID <> ?) AND C.TID < ?";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, 22);
        s1.setInt(2, 25);
        s1.setInt(3, 28);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void testRootIdForNCJLevel2Queries_Three_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int not null, DSID int primary key, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int primary key, TSID int not null, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverServerSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverClientSet);
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(ncjRootID));
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(ncjRootID));
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(ncjRootID));
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverReSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverServerSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverClientSet);
        expected = new HashSet();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(ncjRootID));
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(ncjRootID));
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(ncjRootID));
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverReSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverReSet);
    }

    public void testRootIdForNCJLevel2Queries_Three_PK_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverServerSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverClientSet);
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        rs.close();
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(0L));
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(0L));
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(0L));
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverReSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverServerSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverServerSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverClientSet);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMultiTablesDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinMultiTablesDUnit.assertTrue((boolean)expected.isEmpty());
        rs.close();
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(0L));
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(0L));
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverVerify.setVerifyCount(0L));
        this.serverExecute(1, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(2, (Runnable)this.ncjRootIDObserverReSet);
        this.serverExecute(3, (Runnable)this.ncjRootIDObserverReSet);
        this.clientExecute(1, (Runnable)this.ncjRootIDObserverReSet);
    }

    class NcjRootIDSerializableRunnable
    extends SerializableRunnable {
        private long verifyStatementID;

        public NcjRootIDSerializableRunnable(String name) {
            super(name);
            this.verifyStatementID = 0L;
        }

        public SerializableRunnable setVerifyCount(long ncjRootID) {
            this.verifyStatementID = ncjRootID;
            return this;
        }

        public void run() throws CacheException {
            StringBuilder sb = new StringBuilder();
            if (ncjRootID != this.verifyStatementID) {
                sb.append("ncjPullResultSet rootID for level 2 statements should be set correctly; ");
                sb.append("givenRootID=").append(this.verifyStatementID).append(" ,gotRootID=").append(ncjRootID).append(";");
            }
            if (sb.length() > 0) {
                TestCase.fail((String)sb.toString());
            }
        }
    }

    class NcjPullResultsetTestSerializableRunnable
    extends SerializableRunnable {
        private int[] verifyCount;

        public SerializableRunnable setVerifyCount(int param0, int param1, int param2, int param3) {
            this.verifyCount[0] = param0;
            this.verifyCount[1] = param1;
            this.verifyCount[2] = param2;
            this.verifyCount[3] = param3;
            return this;
        }

        public NcjPullResultsetTestSerializableRunnable(String name) {
            super(name);
            this.verifyCount = new int[]{0, 0, 0, 0};
        }

        public void run() throws CacheException {
            StringBuilder sb = new StringBuilder();
            if (remoteCallbackInvokeCount[0] != this.verifyCount[0]) {
                sb.append("remoteCallbackInvokeCount[0]=").append(remoteCallbackInvokeCount[0]).append(" ,verifyCount[0]=").append(this.verifyCount[0]).append(";");
            }
            if (remoteCallbackInvokeCount[1] != this.verifyCount[1]) {
                sb.append("remoteCallbackInvokeCount[1]=").append(remoteCallbackInvokeCount[1]).append(" ,verifyCount[1]=").append(this.verifyCount[1]).append(";");
            }
            if (remoteCallbackInvokeCount[2] != this.verifyCount[2]) {
                sb.append("remoteCallbackInvokeCount[2]=").append(remoteCallbackInvokeCount[2]).append(" ,verifyCount[2]=").append(this.verifyCount[2]).append(";");
            }
            if (remoteCallbackInvokeCount[3] != this.verifyCount[3]) {
                sb.append("remoteCallbackInvokeCount[3]=").append(remoteCallbackInvokeCount[3]).append(" ,verifyCount[3]=").append(this.verifyCount[3]).append(";");
            }
            if (sb.length() > 0) {
                TestCase.fail((String)sb.toString());
            }
        }
    }
}

