/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;

public class NCJoinMixCollocatedTablesDUnit
extends DistributedSQLTestBase {
    public NCJoinMixCollocatedTablesDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        NCJoinMixCollocatedTablesDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJoinMixCollocatedTablesDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    public void testMixTables_MultiColJoin() throws Exception {
        String sec;
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int not null, vid varchar(10) primary key, sid int not null) partition by primary key");
        this.clientSQLExecute(1, "create table tcol ( id int not null, vid varchar(10), sid int primary key) partition by column(id)");
        this.clientSQLExecute(1, "create table tcol2 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        this.clientSQLExecute(1, "create table tcol3 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        this.clientSQLExecute(1, "create table trep ( id int primary key, vid varchar(10), sid int not null) replicate");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (i = 0; i < 10; ++i) {
            sec = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tpk values(" + i + "," + (sec != null ? "'" + sec + "'" : "null") + "," + baseId * i + ")");
        }
        securities[0] = null;
        for (i = 0; i < 10; ++i) {
            sec = securities[i % 10];
            this.clientSQLExecute(1, "Insert into trep values(" + i + "," + (sec != null ? "'" + sec + "'" : "null") + "," + baseId * i + ")");
        }
        securities[1] = null;
        for (i = 0; i < 10; ++i) {
            sec = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tcol values(" + i + "," + (sec != null ? "'" + sec + "'" : "null") + "," + baseId * i + ")");
        }
        securities[2] = null;
        for (i = 0; i < 10; ++i) {
            sec = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tcol2 values(" + i + "," + (sec != null ? "'" + sec + "'" : "null") + "," + baseId * i + ")");
        }
        securities[3] = null;
        for (i = 0; i < 10; ++i) {
            sec = securities[i % 10];
            this.clientSQLExecute(1, "Insert into tcol3 values(" + i + "," + (sec != null ? "'" + sec + "'" : "null") + "," + baseId * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i2 = 5; i2 < 9; ++i2) {
            expected.add(securities[i2]);
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID, C.ID, C.VID, D.ID, D.VID, E.ID, E.VID from  tpk A inner join tcol B on A.VID = B.VID and A.ID = B.ID inner join tcol2 C on B.ID = C.ID and B.VID = C.VID inner join tcol3 D on C.ID = D.ID and D.VID = C.VID inner join trep E on E.ID = D.ID and E.VID = D.VID where A.SID < ? and B.SID != ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i3 = 5; i3 < 9; ++i3) {
            expected.add(securities[i3]);
        }
        expected.add("IBM");
        expected.add("INTC");
        expected.add("MOT");
        expected.add("TEK");
        query = "Select A.ID, A.VID from  tpk A inner join tcol B on A.ID = B.ID inner join tcol2 C on B.SID = C.SID  inner join tcol3 D on C.SID = D.SID  inner join trep E on E.SID = D.SID  where A.SID < ? and B.SID != ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            String val = rs.getString(2);
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(val));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table if exists tcol3");
        this.clientSQLExecute(1, "drop table if exists tcol2");
        this.clientSQLExecute(1, "drop table if exists tcol");
    }

    public void testMixTables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int not null) partition by primary key");
        this.clientSQLExecute(1, "create table tgi ( id int not null, vid varchar(10), sid int primary key) partition by column(id)");
        this.clientSQLExecute(1, "create table tcol ( id int not null, vid varchar(10), sid int primary key) partition by primary key");
        this.clientSQLExecute(1, "create table tcol2 ( id int not null, vid varchar(10), sid int primary key) partition by primary key colocate with (tcol)");
        this.clientSQLExecute(1, "create table tcol3 ( id int not null, vid varchar(10), sid int primary key) partition by primary key colocate with (tcol)");
        this.clientSQLExecute(1, "create table trep ( id int primary key, vid varchar(10), sid int not null) replicate");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tgi values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into trep values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol3 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i2 = 5; i2 < 9; ++i2) {
            expected.add(securities[i2]);
        }
        String query = "Select A.ID, A.VID from  tpk A inner join tcol B on A.ID = B.ID inner join tcol2 C on B.SID = C.SID  inner join tcol3 D on C.SID = D.SID  inner join trep E on E.SID = D.SID  where A.SID < ? and B.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i3 = 5; i3 < 9; ++i3) {
            expected.add(securities[i3]);
        }
        query = "Select A.ID, A.VID from  tgi A inner join tcol B on A.SID = B.SID inner join tcol2 C on B.SID = C.SID  inner join tcol3 D on C.SID = D.SID  inner join trep E on E.SID = D.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table if exists tcol3");
        this.clientSQLExecute(1, "drop table if exists tcol2");
        this.clientSQLExecute(1, "drop table if exists tcol");
    }

    public void testReplicatedTables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tncl1 ( id int primary key, vid varchar(10), sid int not null) partition by primary key");
        this.clientSQLExecute(1, "create table tncl2 ( id int primary key, vid varchar(10), sid int not null) partition by column(sid)");
        this.clientSQLExecute(1, "create table trep1 ( id int primary key, vid varchar(10), sid int not null) replicate");
        this.clientSQLExecute(1, "create table trep2 ( id int primary key, vid varchar(10), sid int not null) replicate");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tncl1 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tncl2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into trep1 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into trep2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i2 = 5; i2 < 9; ++i2) {
            expected.add(securities[i2]);
        }
        String query = "Select A.ID, A.VID from  tncl1 A inner join tncl2 B on A.ID = B.ID inner join trep1 C on B.SID = C.SID  inner join trep2 D on C.SID = D.SID  where A.SID < ? and B.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i3 = 5; i3 < 9; ++i3) {
            expected.add(securities[i3]);
        }
        query = "Select A.ID, A.VID from  tncl1 A inner join tncl2 B on A.ID = B.ID inner join trep1 C on B.SID = C.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i4 = 5; i4 < 9; ++i4) {
            expected.add(securities[i4]);
        }
        query = "Select A.ID, A.VID from  tncl1 A inner join trep2 B on A.ID = B.ID inner join trep1 C on B.SID = C.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
    }

    public void testCollocatedTables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int not null) partition by primary key");
        this.clientSQLExecute(1, "create table tcol ( id int not null, vid varchar(10), sid int primary key) partition by primary key");
        this.clientSQLExecute(1, "create table tcol2 ( id int not null, vid varchar(10), sid int primary key) partition by primary key colocate with (tcol)");
        this.clientSQLExecute(1, "create table tcol3 ( id int not null, vid varchar(10), sid int primary key) partition by primary key colocate with (tcol)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol3 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i2 = 5; i2 < 9; ++i2) {
            expected.add(securities[i2]);
        }
        String query = "Select A.ID, A.VID from  tpk A inner join tcol B on A.ID = B.ID inner join tcol2 C on B.SID = C.SID  where A.SID < ? and B.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i3 = 5; i3 < 9; ++i3) {
            expected.add(securities[i3]);
        }
        query = "Select A.ID, A.VID from  tpk A inner join tcol3 B on A.ID = B.ID inner join tcol2 C on B.SID = C.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i4 = 5; i4 < 9; ++i4) {
            expected.add(securities[i4]);
        }
        query = "Select A.ID, A.VID from  tpk A inner join tcol B on A.ID = B.ID inner join tcol2 C on B.SID = C.SID  inner join tcol3 D on D.ID = C.ID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table if exists tcol3");
        this.clientSQLExecute(1, "drop table if exists tcol2");
        this.clientSQLExecute(1, "drop table if exists tcol");
    }

    public void testSelfJoin() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table tpk ( id int primary key, vid varchar(10), sid int not null) partition by primary key");
        this.clientSQLExecute(1, "create table tpk2 ( id int primary key, vid varchar(10), sid int not null) partition by primary key");
        this.clientSQLExecute(1, "create table tcol ( id int not null, vid varchar(10), sid int primary key) partition by primary key");
        this.clientSQLExecute(1, "create table tcol2 ( id int not null, vid varchar(10), sid int primary key) partition by primary key colocate with (tcol)");
        this.clientSQLExecute(1, "create table tcol3 ( id int not null, vid varchar(10), sid int primary key) partition by primary key colocate with (tcol)");
        this.clientSQLExecute(1, "create table trep ( id int primary key, vid varchar(10), sid int not null) replicate");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tpk values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tpk2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into trep values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        for (i = 0; i < 10; ++i) {
            this.clientSQLExecute(1, "Insert into tcol3 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        HashSet<String> expected = new HashSet<String>();
        for (int i2 = 5; i2 < 9; ++i2) {
            expected.add(securities[i2]);
        }
        String query = "Select A.ID, A.VID from  tpk A inner join tpk B on A.ID = B.ID where A.SID < ? and B.SID > ? ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i3 = 5; i3 < 9; ++i3) {
            expected.add(securities[i3]);
        }
        query = "Select A.ID, A.VID from  tpk A inner join tpk2 B on A.ID = B.ID inner join tpk2 C on B.SID = C.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i4 = 5; i4 < 9; ++i4) {
            expected.add(securities[i4]);
        }
        query = "Select A.ID, A.VID from  tpk A inner join tcol B on A.ID = B.ID inner join tcol C on B.SID = C.SID  inner join tcol3 D on C.SID = D.SID  inner join trep E on E.SID = D.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i5 = 5; i5 < 9; ++i5) {
            expected.add(securities[i5]);
        }
        query = "Select A.ID, A.VID from  tpk A inner join tcol B on A.ID = B.ID inner join tcol C on B.SID = C.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        expected = new HashSet();
        for (int i6 = 5; i6 < 9; ++i6) {
            expected.add(securities[i6]);
        }
        query = "Select A.ID, A.VID from  tpk A inner join tcol B on A.ID = B.ID inner join trep C on B.SID = C.SID  inner join tcol3 D on C.SID = D.SID  inner join trep E on E.SID = D.SID  where A.SID < ? and B.SID > ? ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        s1.setInt(1, baseId * 9);
        s1.setInt(2, baseId * 4);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table if exists tcol3");
        this.clientSQLExecute(1, "drop table if exists tcol2");
        this.clientSQLExecute(1, "drop table if exists tcol");
    }

    public void testMix_3NC_1REP_2COL_Tables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DRIVER (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.rep ( rid int not null, rsid int primary key, rvid varchar(10)) replicate");
        this.clientSQLExecute(1, "create table trade.col ( cid int not null, csid int primary key, cvid varchar(10)) partition by column(csid) colocate with (trade.DRIVER)");
        this.clientSQLExecute(1, "create table trade.dcol ( dcid int not null, dcsid int primary key, dcvid varchar(10)) partition by column(dcsid) colocate with (trade.DRIVER)");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 61; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 11; i < 71; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DRIVER values(" + i + "," + i + ",'" + "2" + securities[i % 10] + "'" + ")");
        }
        for (i = 21; i < 81; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + "3" + securities[i % 10] + "'" + ")");
        }
        for (i = 31; i < 91; ++i) {
            this.clientSQLExecute(1, "Insert into trade.rep values(" + i + "," + i + ",'" + "4" + securities[i % 10] + "'" + ")");
        }
        for (i = 41; i < 101; ++i) {
            this.clientSQLExecute(1, "Insert into trade.col values(" + i + "," + i + ",'" + "5" + securities[i % 10] + "'" + ")");
        }
        for (i = 51; i < 111; ++i) {
            this.clientSQLExecute(1, "Insert into trade.dcol values(" + i + "," + i + ",'" + "6" + securities[i % 10] + "'" + ")");
        }
        AbstractCollection expected2 = new HashSet<String>();
        AbstractCollection expected8 = new HashSet<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            ((HashSet)expected2).add(securities[i2]);
            ((HashSet)expected8).add("4" + securities[i2]);
        }
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID, D.RID, D.RVID, E.CID, E.CVID, F.DCID, F.DCVID from  trade.ORDERS A  inner join trade.DRIVER B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  inner join trade.REP D on C.TID = D.RID  inner join trade.COL E on D.RSID = E.CSID  inner join trade.DCOL F on E.CSID = F.DCSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)((HashSet)expected2).remove(rs.getString(2)));
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)((HashSet)expected8).remove(rs.getString(8)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)((HashSet)expected2).isEmpty());
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)((HashSet)expected8).isEmpty());
        s1.close();
        expected2 = new ArrayList();
        expected8 = new ArrayList();
        for (int i3 = 0; i3 < 20; ++i3) {
            expected2.add((String)securities[i3 % 10]);
            expected8.add("4" + securities[i3 % 10]);
        }
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID, D.RID, D.RVID, E.CID, E.CVID from  trade.ORDERS A  inner join trade.DRIVER B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID  inner join trade.REP D on C.TID = D.RID  inner join trade.COL E on D.RSID = E.CSID ";
        conn = TestUtil.getConnection();
        s1 = conn.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            String val2 = rs.getString(2);
            String val8 = rs.getString(8);
            NCJoinMixCollocatedTablesDUnit.assertTrue((String)(((Object)expected2).toString() + " " + val2), (boolean)expected2.remove(val2));
            NCJoinMixCollocatedTablesDUnit.assertTrue((String)(((Object)expected8).toString() + " " + val8), (boolean)expected8.remove(val8));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected2.isEmpty());
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected8.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.REP");
        this.clientSQLExecute(1, "drop table trade.col");
        this.clientSQLExecute(1, "drop table trade.dcol");
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DRIVER");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void testSelfJoin_threeTables() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema EMP");
        st.execute("create table EMP.REPTABLE1 (IDP1 int not null, CIDP1 int not null, DESCRIPTIONP1 varchar(1024) not null, ADDRESSP1 varchar(1024) not null, primary key (DESCRIPTIONP1)) REPLICATE  ");
        st.execute("create table EMP.REPTABLE3 (IDP3 int not null, CIDP3 int not null,  DESCRIPTIONP3 varchar(1024) not null, ADDRESSP3 varchar(1024) not null, primary key (DESCRIPTIONP3)) REPLICATE  ");
        for (i = 1; i <= 4; ++i) {
            st.execute("insert into EMP.REPTABLE1 values (" + i + "," + 2 * i + ", 'First1" + i + "', 'J1')");
            st.execute("insert into EMP.REPTABLE3 values (" + i + "," + 4 * i + ", 'First3" + i + "', 'J3')");
        }
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("create table EMP.PARTTABLE1 (IDP1 int not null, CIDP1 int not null, DESCRIPTIONP1 varchar(1024) not null, ADDRESSP1 varchar(1024) not null, primary key (DESCRIPTIONP1))PARTITION BY Column (ADDRESSP1)");
        st.execute("create table EMP.PARTTABLE3 (IDP3 int not null, CIDP3 int not null,  DESCRIPTIONP3 varchar(1024) not null, ADDRESSP3 varchar(1024) not null, primary key (DESCRIPTIONP3))PARTITION BY Column (ADDRESSP3)");
        for (i = 1; i <= 4; ++i) {
            st.execute("insert into EMP.PARTTABLE1 values (" + i + "," + 2 * i + ", 'First1" + i + "', 'J1')");
            st.execute("insert into EMP.PARTTABLE3 values (" + i + "," + 4 * i + ", 'First3" + i + "', 'J3')");
        }
        HashSet<String> expected = new HashSet<String>();
        String query = "select * from EMP.REPTABLE1 p1, EMP.REPTABLE1 p2, EMP.REPTABLE3 p3  where  p3.CIDP3 = p1.CIDP1  and p1.CIDP1 = p2.CIDP1  and p1.IDP1 = p2.IDP1  and p1.ADDRESSP1 = 'J1'";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s1 = conn2.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            expected.add(rs.getString(2));
        }
        NCJoinMixCollocatedTablesDUnit.assertFalse((boolean)expected.isEmpty());
        s1.close();
        query = "select * from EMP.PARTTABLE1 p1, EMP.PARTTABLE1 p2, EMP.PARTTABLE3 p3  where  p3.CIDP3 = p1.CIDP1  and p1.CIDP1 = p2.CIDP1  and p1.IDP1 = p2.IDP1  and p1.ADDRESSP1 = 'J1'";
        conn2 = TestUtil.getConnection();
        s1 = conn2.prepareStatement(query);
        rs = s1.executeQuery();
        while (rs.next()) {
            NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.remove(rs.getString(2)));
        }
        NCJoinMixCollocatedTablesDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table if exists EMP.PARTTABLE1");
        this.clientSQLExecute(1, "drop table if exists EMP.PARTTABLE3");
        this.clientSQLExecute(1, "drop table if exists EMP.REPTABLE1");
        this.clientSQLExecute(1, "drop table if exists EMP.REPTABLE3");
        this.clientSQLExecute(1, "drop schema EMP restrict");
    }
}

