/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class NCJoinEquiJoinQueryDUnit
extends DistributedSQLTestBase {
    public NCJoinEquiJoinQueryDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    public String getOverflowSuffix() {
        return " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourWithSingleColumnAsPartitoningKey_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY COLUMN ( ID2 ) " + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select ID1, DESCRIPTION2 from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID1 IN (7,9) ", new Object[][]{{new Integer(6), new SQLInteger(7)}, {new Integer(6), new SQLInteger(9), new Integer(5)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                Activation[] actArr = new Activation[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr, actArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this, actArr[0]);
                rs.close();
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                es.close();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourWithSingleColumnAsPartitoningKey_2() throws Exception {
        NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            }
        });
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY RANGE ( ID1 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY RANGE ( ID2 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select * from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID1 > 1 and ID1 < 6  ", new Object[][]{{new Integer(6), new SQLInteger(1), Boolean.FALSE, new SQLInteger(6), Boolean.FALSE}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                }
                NCJoinEquiJoinQueryDUnit.assertEquals((int)cnt, (int)4);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                rs.close();
            }
        }
        catch (Throwable throwable) {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
            NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                public void run() {
                    System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                }
            });
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
        this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39862() throws Exception {
        NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            }
        });
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY RANGE ( ID1 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY RANGE ( ID2 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select ID1, ID2 from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID1 > 1 and ID1 < 6  ", new Object[][]{{new Integer(6), new SQLInteger(1), Boolean.FALSE, new SQLInteger(6), Boolean.FALSE}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + queryString + "\"";
                HashSet<Integer> rslts = new HashSet<Integer>();
                for (int j = 2; j < 6; ++j) {
                    rslts.add(j);
                }
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                    NCJoinEquiJoinQueryDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
                }
                NCJoinEquiJoinQueryDUnit.assertTrue((boolean)rslts.isEmpty());
                NCJoinEquiJoinQueryDUnit.assertFalse((boolean)rs.next());
                NCJoinEquiJoinQueryDUnit.assertEquals((int)cnt, (int)4);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                rs.close();
            }
        }
        catch (Throwable throwable) {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
            try {
                System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                    }
                });
            }
            catch (Throwable t) {
                throw new AssertionError((Object)("Couldn't clear STATEMENT OPTIMIZATION flag. " + t));
            }
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
        this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        try {
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
            NCJoinEquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)("Couldn't clear STATEMENT OPTIMIZATION flag. " + t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquijoinQueryForPRAndReplicatedRegion_1() throws Exception {
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY Column ( ID1 )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select * from TESTTABLE1, TESTTABLE2 where  ID2 = 1 ", new Object[][]{{new Integer(6)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + queryString + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                while (rs.next()) {
                }
                Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this.getLogWriter());
                Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(queryString, (QueryInfo)sqiArr[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
                allNodes.removeAll(expectedPrunedNodes);
                this.verifyQueryExecution(sqiArr[0], expectedPrunedNodes, allNodes, 3, 0);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                es.close();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testEquijoinQueryForPRAndReplicatedRegionWithServerGroups() throws Exception {
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1", null);
                                        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2", null);
                                        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG3", null);
                                        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, null, null);
                                        this.startClientVMs(1, 0, null);
                                        this.joinVMs(true, async1, async2, async3, async4);
                                        this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY Column (ID1) SERVER GROUPS (SG1,SG2)");
                                        this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (ID11 int not null,  DESCRIPTION11 varchar(1024) not null, ADDRESS11 varchar(1024) not null, primary key (ID11))PARTITION BY Column (ID11)" + this.getOverflowSuffix());
                                        this.clientSQLExecute(1, "create table EMP.PARTTABLE3 (ID12 int not null,  DESCRIPTION12 varchar(1024) not null, ADDRESS12 varchar(1024) not null, primary key (ID12))PARTITION BY Column (ID12) SERVER GROUPS (SG1,SG2)" + this.getOverflowSuffix());
                                        this.clientSQLExecute(1, "create table EMP.TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE SERVER GROUPS (SG1,SG2, sg3)" + this.getOverflowSuffix());
                                        this.serverSQLExecute(1, "create table EMP.TESTTABLE3 (ID3 int not null,  DESCRIPTION3 varchar(1024) not null, ADDRESS3 varchar(1024) not null, primary key (ID3)) REPLICATE SERVER GROUPS (SG1)" + this.getOverflowSuffix());
                                        this.serverSQLExecute(2, "create table EMP.TESTTABLE4 (ID4 int not null,  DESCRIPTION4 varchar(1024) not null, ADDRESS4 varchar(1024) not null, primary key (ID4)) REPLICATE SERVER GROUPS (SG1, SG2)" + this.getOverflowSuffix());
                                        this.serverSQLExecute(1, "create table EMP.TESTTABLE5 (ID5 int not null,  DESCRIPTION5 varchar(1024) not null, ADDRESS5 varchar(1024) not null, primary key (ID5)) REPLICATE" + this.getOverflowSuffix());
                                        for (int i = 0; i <= 10; ++i) {
                                            this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
                                            this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
                                            this.serverSQLExecute(2, "insert into EMP.PARTTABLE3 values (" + (i + 1) + ", 'First3" + (i + 1) + "', 'J3 604')");
                                            this.clientSQLExecute(1, "insert into EMP.TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
                                            this.serverSQLExecute(1, "insert into EMP.TESTTABLE3 values (" + (i + 1) + ", 'First3" + (i + 1) + "', 'J3 604')");
                                            this.serverSQLExecute(3, "insert into EMP.TESTTABLE4 values (" + (i + 1) + ", 'First4" + (i + 1) + "', 'J4 604')");
                                            this.serverSQLExecute(2, "insert into EMP.TESTTABLE5 values (" + (i + 1) + ", 'First5" + (i + 1) + "', 'J5 604')");
                                        }
                                        try {
                                            this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.TESTTABLE3 where ID1 = 4 and ID3 = 1");
                                            NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                                        }
                                        catch (SQLException ex) {
                                            if ("0A000".equals(ex.getSQLState())) break block20;
                                            throw ex;
                                        }
                                    }
                                    try {
                                        this.clientSQLExecute(1, "select * from EMP.PARTTABLE2, EMP.TESTTABLE3 where ID11 = 4 and ID3 = 1");
                                        NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                                    }
                                    catch (SQLException ex) {
                                        if ("0A000".equals(ex.getSQLState())) break block21;
                                        throw ex;
                                    }
                                }
                                try {
                                    this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.PARTTABLE2 where ID1 = 4 and ID11 = 1");
                                    NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                                }
                                catch (SQLException ex) {
                                    if ("0A000".equals(ex.getSQLState())) break block22;
                                    throw ex;
                                }
                            }
                            try {
                                this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.PARTTABLE2 where ID1 = ID11");
                                NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                            }
                            catch (SQLException ex) {
                                if ("0A000".equals(ex.getSQLState())) break block23;
                                throw ex;
                            }
                        }
                        try {
                            this.clientSQLExecute(1, "select * from EMP.PARTTABLE2, EMP.TESTTABLE4 where ID11 = 4 and ID4 = 1");
                            NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                        }
                        catch (SQLException ex) {
                            if ("0A000".equals(ex.getSQLState())) break block24;
                            throw ex;
                        }
                    }
                    try {
                        this.clientSQLExecute(1, "select * from EMP.TESTTABLE3, EMP.PARTTABLE2, EMP.TESTTABLE4");
                        NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                    }
                    catch (SQLException ex) {
                        if ("0A000".equals(ex.getSQLState())) break block25;
                        throw ex;
                    }
                }
                try {
                    this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.PARTTABLE3 where ADDRESS1 = ADDRESS12");
                    NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in improper join condition");
                }
                catch (SQLException ex) {
                    if ("0A000".equals(ex.getSQLState())) break block26;
                    throw ex;
                }
            }
            try {
                this.clientSQLExecute(1, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.PARTTABLE3");
                NCJoinEquiJoinQueryDUnit.fail((String)"expected exception in join for tables in improper join condition");
            }
            catch (SQLException ex) {
                if ("0A000".equals(ex.getSQLState())) break block27;
                throw ex;
            }
        }
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.PARTTABLE1, EMP.TESTTABLE2 where ID2 = 1 AND ID1 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "sgs_1");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.PARTTABLE1, EMP.TESTTABLE4 where ID4 = 1 AND ID1 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "sgs_2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.TESTTABLE2, EMP.TESTTABLE4 where ID2 = 1 AND ID4 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "sgs_3");
        isQueryExecutedOnNode = false;
        NCJoinEquiJoinQueryDUnit.invokeInEveryVM(DistributedSQLTestBase.class, (String)"reset");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        VM dataStore4 = (VM)this.serverVMs.get(3);
        SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
        this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3, dataStore4}, sqiArr);
        try {
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE2, EMP.TESTTABLE3", false, false, true);
            this.checkQueryExecution(true, dataStore1);
            this.serverSQLExecute(3, "select * from EMP.PARTTABLE1, EMP.TESTTABLE5", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE2, EMP.TESTTABLE5", true, false, true);
            this.checkQueryExecution(true, dataStore1, dataStore2, dataStore3);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE5", false, false, true);
            this.checkQueryExecution(true, dataStore1, dataStore2, dataStore3, dataStore4);
            this.serverSQLExecute(1, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.PARTTABLE3 where ID1 = ID12", false, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.serverSQLExecute(2, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.TESTTABLE2", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.serverSQLExecute(3, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.TESTTABLE2, EMP.PARTTABLE3 where ID1 = ID12", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE2, EMP.PARTTABLE1, EMP.TESTTABLE4, EMP.PARTTABLE3 where ID1 = ID12", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE4, EMP.PARTTABLE3, EMP.TESTTABLE2, EMP.PARTTABLE1, EMP.TESTTABLE5 where ID1 = ID12 and ADDRESS1 = ADDRESS12", false, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
        }
    }

    public void testEquiJoinPRAndReplicatedMix_40307() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY Column (ID1)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY Column (ID2) " + this.getOverflowSuffix());
        this.serverSQLExecute(1, "create table EMP.REPLTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) REPLICATE" + this.getOverflowSuffix());
        this.serverSQLExecute(2, "create table EMP.REPLTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 1; i <= 4; ++i) {
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + i + ", 'First1" + i + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + i + ", 'First2" + i + "', 'J2 604')");
            this.serverSQLExecute(1, "insert into EMP.REPLTABLE1 values (" + i + ", 'RFirst1" + i + "', 'J1 604')");
            this.serverSQLExecute(3, "insert into EMP.REPLTABLE2 values (" + i + ", 'First2" + i + "', 'RJ2 604')");
        }
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2 where p1.ID1 = p2.ID2 and r1.ADDRESS1 = p1.ADDRESS1 and r1.ID1 = p2.ID2", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "pr_repl_mix1");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2, EMP.REPLTABLE2 r2 where p1.ID1 = p2.ID2 and r1.ADDRESS1 = p1.ADDRESS1 and r1.ID1 = p2.ID2 and r1.ID1 = r2.ID2 and r2.ID2 = 3", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "pr_repl_mix2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.REPLTABLE1 r1, EMP.REPLTABLE2 r2, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2 where p1.ID1 = p2.ID2 and r1.ID1 = 2 and r2.ID2 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "pr_repl_mix3");
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE1");
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE1");
    }

    public void testQueryConvertibleToJoin() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int primary key,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null)PARTITION BY Primary key" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int  primary key,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null,ID_FK int, foreign key (ID_FK) references TESTTABLE1(ID1))" + this.getOverflowSuffix());
        for (i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604' )");
        }
        for (i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604', " + (i + 1) + " )");
        }
        this.sqlExecuteVerify(new int[]{1}, null, "select ID2 from TESTTABLE2 where ADDRESS2 like '%604' AND ID_FK IN (select ID1 from TESTTABLE1 )", TestUtil.getResourcesDir() + "/lib/checkStatementQueryDUnit.xml", "testLikePredicateQuery_2", false, false);
    }

    public void testPRAndReplicatedMix_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (IDP1 int not null,  DESCRIPTIONP1 varchar(1024) not null, ADDRESSP1 varchar(1024) not null, primary key (IDP1))PARTITION BY Column (IDP1)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (IDP2 int not null,  DESCRIPTIONP2 varchar(1024) not null, ADDRESSP2 varchar(1024) not null, primary key (IDP2))PARTITION BY Column (IDP2) " + this.getOverflowSuffix());
        this.serverSQLExecute(1, "create table EMP.REPLTABLE1 (IDR1 int not null,  DESCRIPTIONR1 varchar(1024) not null, ADDRESSR1 varchar(1024) not null, primary key (IDR1)) REPLICATE" + this.getOverflowSuffix());
        this.serverSQLExecute(2, "create table EMP.REPLTABLE2 (IDR2 int not null,  DESCRIPTIONR2 varchar(1024) not null, ADDRESSR2 varchar(1024) not null, primary key (IDR2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 1; i <= 4; ++i) {
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + i + ", 'First1" + i + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + i + ", 'First2" + i + "', 'J2 604')");
            this.serverSQLExecute(1, "insert into EMP.REPLTABLE1 values (" + i + ", 'RFirst1" + i + "', 'J1 604')");
            this.serverSQLExecute(3, "insert into EMP.REPLTABLE2 values (" + i + ", 'First2" + i + "', 'RJ2 604')");
        }
        String query = "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2, EMP.REPLTABLE2 r2 where p1.IDP1 = p2.IDP2 and r1.ADDRESSR1 = p1.ADDRESSP1 and r1.IDR1 = p2.IDP2 and r1.IDR1 = r2.IDR2 and p1.IDP1 = ?";
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(3);
        Connection conn = TestUtil.getConnection();
        PreparedStatement st = conn.prepareStatement(query);
        st.setInt(1, 3);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.isEmpty());
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE1");
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE1");
    }

    public void testPRAndReplicatedMix_2() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (IDP1 int not null,  DESCRIPTIONP1 varchar(1024) not null, ADDRESSP1 varchar(1024) not null, primary key (ADDRESSP1))PARTITION BY Column (IDP1)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (IDP2 int not null,  DESCRIPTIONP2 varchar(1024) not null, ADDRESSP2 varchar(1024) not null, primary key (ADDRESSP2))PARTITION BY Column (IDP2) " + this.getOverflowSuffix());
        this.serverSQLExecute(1, "create table EMP.REPLTABLE1 (IDR1 int not null,  DESCRIPTIONR1 varchar(1024) not null, ADDRESSR1 varchar(1024) not null, primary key (ADDRESSR1)) REPLICATE" + this.getOverflowSuffix());
        this.serverSQLExecute(2, "create table EMP.REPLTABLE2 (IDR2 int not null,  DESCRIPTIONR2 varchar(1024) not null, ADDRESSR2 varchar(1024) not null, primary key (ADDRESSR2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 1; i <= 4; ++i) {
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + i + ", 'First1" + i + "', 'J1 604" + i + "')");
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + i + ", 'First2" + i + "', 'J2 604" + i + "')");
            this.serverSQLExecute(1, "insert into EMP.REPLTABLE1 values (" + i + ", 'RFirst1" + i + "', 'J1 604" + i + "')");
            this.serverSQLExecute(3, "insert into EMP.REPLTABLE2 values (" + i + ", 'First2" + i + "', 'RJ2 604" + i + "')");
        }
        String query = "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2, EMP.REPLTABLE2 r2 where p1.IDP1 = p2.IDP2 and r1.ADDRESSR1 = p1.ADDRESSP1 and r1.IDR1 = p2.IDP2 and r1.IDR1 = r2.IDR2 and p1.IDP1 = ?";
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(3);
        Connection conn = TestUtil.getConnection();
        PreparedStatement st = conn.prepareStatement(query);
        st.setInt(1, 3);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.isEmpty());
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE1");
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE1");
    }

    public void testPRAndReplicatedMix_3() throws Exception {
        Integer value;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (IDP1 int not null,  DESCRIPTIONP1 varchar(1024) not null, ADDRESSP1 varchar(1024) not null, primary key (IDP1))PARTITION BY Column (IDP1)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (IDP2 int not null,  DESCRIPTIONP2 varchar(1024) not null, ADDRESSP2 varchar(1024) not null, primary key (IDP2))PARTITION BY Column (IDP2) " + this.getOverflowSuffix());
        this.serverSQLExecute(1, "create table EMP.REPLTABLE1 (IDR1 int not null,  DESCRIPTIONR1 varchar(1024) not null, ADDRESSR1 varchar(1024) not null, primary key (IDR1)) REPLICATE" + this.getOverflowSuffix());
        this.serverSQLExecute(2, "create table EMP.REPLTABLE2 (IDR2 int not null,  DESCRIPTIONR2 varchar(1024) not null, ADDRESSR2 varchar(1024) not null, primary key (IDR2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 1; i <= 4; ++i) {
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + i + ", 'First1" + i + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + i + ", 'First2" + i + "', 'J2 604')");
            this.serverSQLExecute(1, "insert into EMP.REPLTABLE1 values (" + i + ", 'RFirst1" + i + "', 'J1 604')");
            this.serverSQLExecute(3, "insert into EMP.REPLTABLE2 values (" + i + ", 'First2" + i + "', 'RJ2 604')");
        }
        String query = "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2, EMP.REPLTABLE2 r2 where p1.IDP1 = p2.IDP2 and r1.ADDRESSR1 = p1.ADDRESSP1 and r1.IDR1 = p2.IDP2 and r1.IDR1 = r2.IDR2 ";
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (int i = 1; i <= 4; ++i) {
            expected.add(i);
        }
        Connection conn = TestUtil.getConnection();
        PreparedStatement st = conn.prepareStatement(query);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            value = rs.getInt(1);
            NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.contains(value));
            expected.remove(value);
        }
        NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.isEmpty());
        query = "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2, EMP.REPLTABLE2 r2 where p1.IDP1 = p2.IDP2  and r1.IDR1 = p2.IDP2  and r1.IDR1 = r2.IDR2 ";
        expected = new ArrayList();
        for (int i = 1; i <= 4; ++i) {
            expected.add(i);
        }
        conn = TestUtil.getConnection();
        st = conn.prepareStatement(query);
        rs = st.executeQuery();
        while (rs.next()) {
            value = rs.getInt(1);
            NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.contains(value));
            expected.remove(value);
        }
        NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.isEmpty());
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE1");
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE1");
    }

    public void testPRAndReplicatedMix_4() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (IDP1 int not null,  DESCRIPTIONP1 varchar(1024) not null, ADDRESSP1 varchar(1024) not null, primary key (IDP1))PARTITION BY Column (IDP1)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (IDP2 int not null,  DESCRIPTIONP2 varchar(1024) not null, ADDRESSP2 varchar(1024) not null, primary key (IDP2))PARTITION BY Column (IDP2) " + this.getOverflowSuffix());
        this.serverSQLExecute(1, "create table EMP.REPLTABLE1 (IDR1 int not null,  DESCRIPTIONR1 varchar(1024) not null, ADDRESSR1 varchar(1024) not null, primary key (IDR1)) REPLICATE" + this.getOverflowSuffix());
        this.serverSQLExecute(2, "create table EMP.REPLTABLE2 (IDR2 int not null,  DESCRIPTIONR2 varchar(1024) not null, ADDRESSR2 varchar(1024) not null, primary key (IDR2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 1; i <= 4; ++i) {
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + i + ", 'First1" + i + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + i + ", 'First2" + i + "', 'J2 604')");
            this.serverSQLExecute(1, "insert into EMP.REPLTABLE1 values (" + i + ", 'RFirst1" + i + "', 'J1 604')");
            this.serverSQLExecute(3, "insert into EMP.REPLTABLE2 values (" + i + ", 'First2" + i + "', 'RJ2 604')");
        }
        String query = "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2, EMP.REPLTABLE2 r2 where p1.IDP1 = p2.IDP2 and r1.ADDRESSR1 = p1.ADDRESSP1 and r1.IDR1 = r2.IDR2 ";
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (int i = 1; i <= 4; ++i) {
            for (int j = 1; j <= 4; ++j) {
                expected.add(i);
            }
        }
        Connection conn = TestUtil.getConnection();
        PreparedStatement st = conn.prepareStatement(query);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            Integer value = rs.getInt(1);
            NCJoinEquiJoinQueryDUnit.assertTrue((String)(expected.toString() + " " + value), (boolean)expected.remove(value));
        }
        NCJoinEquiJoinQueryDUnit.assertTrue((boolean)expected.isEmpty());
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE1");
        this.clientSQLExecute(1, "drop table EMP.REPLTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE1");
    }
}

