/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;

public class NCJPerformanceTestDUnit
extends DistributedSQLTestBase {
    private static boolean debugLog = false;

    public NCJPerformanceTestDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        NCJPerformanceTestDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJPerformanceTestDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    @Override
    protected String reduceLogging() {
        if (debugLog) {
            return super.reduceLogging();
        }
        return "config";
    }

    public void testDummy() {
    }

    public void _testNCJperf1_3_100_100_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_globalIndex_1(100, 100, 100, conn, "1_3_100_100_100");
    }

    public void _testNCJperf1_2_666_666_100() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_globalIndex_1(666, 666, 100, conn, "1_2_666_666_100");
    }

    public void _testNCJperf1_3_1000_1000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_globalIndex_1(1000, 1000, 100, conn, "1_3_1000_1000_100");
    }

    public void _testNCJperf1_4_1333_1333_100() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_globalIndex_1(1333, 1333, 100, conn, "1_4_1333_1333_100");
    }

    public void _testNCJperf1_3_5000_5000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_globalIndex_1(5000, 5000, 100, conn, "1_3_5000_5000_100");
    }

    public void _testNCJperf1_3_100_100_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_globalIndex_1(100, 100, 100, conn, "1_3_100_100_100_tc");
    }

    public void _testNCJperf1_2_666_666_100_tc() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_globalIndex_1(666, 666, 100, conn, "1_2_666_666_100_tc");
    }

    public void _testNCJperf1_3_1000_1000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_globalIndex_1(1000, 1000, 100, conn, "1_3_1000_1000_100_tc");
    }

    public void _testNCJperf1_4_1333_1333_100_tc() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_globalIndex_1(1333, 1333, 100, conn, "1_4_1333_1333_100_tc");
    }

    public void _testNCJperf1_5_1666_1666_100_tc() throws Exception {
        Properties cprops = new Properties();
        cprops.setProperty("host-data", "true");
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1", cprops);
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_globalIndex_1(1666, 1666, 100, conn, "1_5_1666_1666_100_tc");
    }

    public void _testNCJperf1_3_5000_5000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_globalIndex_1(5000, 5000, 100, conn, "1_3_5000_5000_100_tc");
    }

    public void _testNCJperf2_3_100_100_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_pk_1(100, 100, 100, conn, "2_3_100_100_100");
    }

    public void _testNCJperf2_2_666_666_100() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_pk_1(666, 666, 100, conn, "2_2_666_666_100");
    }

    public void _testNCJperf2_3_1000_1000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_pk_1(1000, 1000, 100, conn, "2_3_1000_1000_100");
    }

    public void _testNCJperf2_4_1333_1333_100() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_pk_1(1333, 1333, 100, conn, "2_4_1333_1333_100");
    }

    public void _testNCJperf2_3_5000_5000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_pk_1(5000, 5000, 100, conn, "2_3_5000_5000_100");
    }

    public void _testNCJperf2_3_100_100_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_pk_1(100, 100, 100, conn, "2_3_100_100_100_tc");
    }

    public void _testNCJperf2_2_666_666_100_tc() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_pk_1(666, 666, 100, conn, "2_2_666_666_100_tc");
    }

    public void _testNCJperf2_3_1000_1000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_pk_1(1000, 1000, 100, conn, "2_3_1000_1000_100_tc");
    }

    public void _testNCJperf2_4_1333_1333_100_tc() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_pk_1(1333, 1333, 100, conn, "2_4_1333_1333_100_tc");
    }

    public void _testNCJperf2_5_1666_1666_100_tc() throws Exception {
        Properties cprops = new Properties();
        cprops.setProperty("host-data", "true");
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1", cprops);
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_pk_1(1666, 1666, 100, conn, "2_5_1666_1666_100_tc");
    }

    public void _testNCJperf2_3_5000_5000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_pk_1(5000, 5000, 100, conn, "2_3_5000_5000_100_tc");
    }

    public void _testSUBQperf1_3_100_100_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_subq_1(100, 100, 100, conn, "1_3_100_100_100");
    }

    public void _testSUBQperf1_2_666_666_100() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_subq_1(666, 666, 100, conn, "1_2_666_666_100");
    }

    public void _testSUBQperf1_3_1000_1000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_subq_1(1000, 1000, 100, conn, "1_3_1000_1000_100");
    }

    public void _testSUBQperf1_4_1333_1333_100() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_subq_1(1333, 1333, 100, conn, "1_4_1333_1333_100");
    }

    public void _testSUBQperf1_3_5000_5000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_subq_1(5000, 5000, 100, conn, "1_3_5000_5000_100");
    }

    public void _testSUBQperf1_3_100_100_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_subq_1(100, 100, 100, conn, "1_3_100_100_100_tc");
    }

    public void _testSUBQperf1_2_666_666_100_tc() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_subq_1(666, 666, 100, conn, "1_2_666_666_100_tc");
    }

    public void _testSUBQperf1_3_1000_1000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_subq_1(1000, 1000, 100, conn, "1_3_1000_1000_100_tc");
    }

    public void _testSUBQperf1_4_1333_1333_100_tc() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_subq_1(1333, 1333, 100, conn, "1_4_1333_1333_100_tc");
    }

    public void _testSUBQperf1_5_1666_1666_100_tc() throws Exception {
        Properties cprops = new Properties();
        cprops.setProperty("host-data", "true");
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1", cprops);
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_subq_1(1666, 1666, 100, conn, "1_5_1666_1666_100_tc");
    }

    public void _testSUBQperf1_3_5000_5000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_subq_1(5000, 5000, 100, conn, "1_3_5000_5000_100_tc");
    }

    public void _testCOLperf1_3_100_100_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_col_1(100, 100, 100, conn, "1_3_100_100_100");
    }

    public void _testCOLperf1_2_666_666_100() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_col_1(666, 666, 100, conn, "1_2_666_666_100");
    }

    public void _testCOLperf1_3_1000_1000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_col_1(1000, 1000, 100, conn, "1_3_1000_1000_100");
    }

    public void _testCOLperf1_4_1333_1333_100() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_col_1(1333, 1333, 100, conn, "1_4_1333_1333_100");
    }

    public void _testCOLperf1_3_5000_5000_100() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        this.djPerfTest_col_1(5000, 5000, 100, conn, "1_3_5000_5000_100");
    }

    public void _testCOLperf1_3_100_100_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_col_1(100, 100, 100, conn, "1_3_100_100_100_tc");
    }

    public void _testCOLperf1_2_666_666_100_tc() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_col_1(666, 666, 100, conn, "1_2_666_666_100_tc");
    }

    public void _testCOLperf1_3_1000_1000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_col_1(1000, 1000, 100, conn, "1_3_1000_1000_100_tc");
    }

    public void _testCOLperf1_4_1333_1333_100_tc() throws Exception {
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_col_1(1333, 1333, 100, conn, "1_4_1333_1333_100_tc");
    }

    public void _testCOLperf1_5_1666_1666_100_tc() throws Exception {
        Properties cprops = new Properties();
        cprops.setProperty("host-data", "true");
        this.startServerVMs(4, 0, "SG1");
        this.startClientVMs(1, 0, "SG1", cprops);
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_col_1(1666, 1666, 100, conn, "1_5_1666_1666_100_tc");
    }

    public void _testCOLperf1_3_5000_5000_100_tc() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, "SG1");
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        this.djPerfTest_col_1(5000, 5000, 100, conn, "1_3_5000_5000_100_tc");
    }

    private void djPerfTest_pk_1(int insertTimes, int resultCount, int runTimes, Connection conn, String methodName) throws Exception {
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by primary key");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        for (int i = 1; i <= insertTimes; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            this.clientSQLExecute(1, "Insert into  tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B on A.ID = B.ID where A.SID > ?";
        PreparedStatement s1 = conn.prepareStatement(query);
        for (int i = 1; i <= runTimes; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID where A.SID > ?";
        s1 = conn.prepareStatement(query);
        long starttime = System.nanoTime();
        for (int i = 1; i <= runTimes; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestNCJperf djPerfTest_pk_1 " + methodName + ": " + "for executing " + query + " with " + insertTimes + " inserted rows, output rows=" + resultCount + " took " + runTimes + " times, with time taken was " + diff + " ns"));
    }

    private void djPerfTest_globalIndex_1(int insertTimes, int resultCount, int runTimes, Connection conn, String methodName) throws Exception {
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        for (int i = 1; i <= insertTimes; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            this.clientSQLExecute(1, "Insert into  tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B on A.ID = B.ID where A.SID > ?";
        PreparedStatement s1 = conn.prepareStatement(query);
        for (int i = 1; i <= 1000; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID where A.SID > ?";
        s1 = conn.prepareStatement(query);
        long starttime = System.nanoTime();
        for (int i = 1; i <= runTimes; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestNCJperf djPerfTest_globalIndex_1 " + methodName + ": " + "for executing " + query + " with " + insertTimes + " inserted rows, output rows=" + resultCount + " took " + runTimes + " times, with time taken was " + diff + " ns"));
    }

    private void djPerfTest_subq_1(int insertTimes, int resultCount, int runTimes, Connection conn, String methodName) throws Exception {
        this.clientSQLExecute(1, "create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        this.clientSQLExecute(1, "create table tdriver ( id int primary key, vid varchar(10), sid int) partition by primary key");
        for (int i = 1; i <= insertTimes; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            this.clientSQLExecute(1, "Insert into  tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        String query = "Select B.ID, B.SID, B.VID from tdriver B where B.ID in (Select A.ID from tglobalindex A) and B.SID > ?";
        PreparedStatement s1 = conn.prepareStatement(query);
        for (int i = 1; i <= 1000; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        query = "Select B.ID, B.SID, B.VID from tdriver B where B.ID in (Select A.ID from tglobalindex A) and B.SID > ?";
        s1 = conn.prepareStatement(query);
        long starttime = System.nanoTime();
        for (int i = 1; i <= runTimes; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestNCJperf djPerfTest_subq_1 " + methodName + ": " + "for executing " + query + " with " + insertTimes + " inserted rows, output rows=" + resultCount + " took " + runTimes + " times, with time taken was " + diff + " ns"));
    }

    private void djPerfTest_col_1(int insertTimes, int resultCount, int runTimes, Connection conn, String methodName) throws Exception {
        this.clientSQLExecute(1, "create table tglobalindex ( id int not null, vid varchar(10), sid int primary key) partition by column(id)");
        this.clientSQLExecute(1, "create table tdriver ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tglobalindex)");
        for (int i = 1; i <= insertTimes; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            this.clientSQLExecute(1, "Insert into  tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        String query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B on A.ID = B.ID where A.SID > ?";
        PreparedStatement s1 = conn.prepareStatement(query);
        for (int i = 1; i <= 1000; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        query = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B on A.ID = B.ID where A.SID > ?";
        s1 = conn.prepareStatement(query);
        long starttime = System.nanoTime();
        for (int i = 1; i <= runTimes; ++i) {
            s1.setInt(1, 0);
            ResultSet rs = s1.executeQuery();
            for (int j = 1; j <= resultCount; ++j) {
                NCJPerformanceTestDUnit.assertTrue((boolean)rs.next());
            }
            NCJPerformanceTestDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestNCJperf djPerfTest_col_1 " + methodName + ": " + "for executing " + query + " with " + insertTimes + " inserted rows, output rows=" + resultCount + " took " + runTimes + " times, with time taken was " + diff + " ns"));
    }
}

