/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.TestCase;

public class NCJCachingDUnit
extends DistributedSQLTestBase {
    static int remoteCallbackInvokeCount = 0;
    final GemFireXDQueryObserver ncjPullResultSetOpenCoreObserver = new GemFireXDQueryObserverAdapter(){

        public void ncjPullResultSetVerifyCacheSize(int value) {
            remoteCallbackInvokeCount = value;
        }
    };
    NcjPullResultsetTestCacheSerializableRunnable ncjPullResultSetOpenCoreObserverVerify = new NcjPullResultsetTestCacheSerializableRunnable("Verify ncjPullResultSetOpenCoreObserver");
    SerializableRunnable ncjPullResultSetOpenCoreObserverSet = new SerializableRunnable("Set ncjPullResultSetOpenCoreObserver"){

        public void run() throws CacheException {
            remoteCallbackInvokeCount = 0;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)NCJCachingDUnit.this.ncjPullResultSetOpenCoreObserver);
        }
    };
    SerializableRunnable ncjPullResultSetOpenCoreObserverReset = new SerializableRunnable("Reset ncjPullResultSetOpenCoreObserver"){

        public void run() throws CacheException {
            remoteCallbackInvokeCount = 0;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
        }
    };

    public NCJCachingDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        NCJCachingDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJCachingDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    private void execute_and_verify_cacheSize(PreparedStatement prepSt, HashSet<Integer> expected, int cacheSize) throws Exception {
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverSet);
        ResultSet rs = prepSt.executeQuery();
        while (rs.next()) {
            NCJCachingDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJCachingDUnit.assertTrue((boolean)expected.isEmpty());
        rs.close();
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverVerify.setVerifyCount(cacheSize));
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverReset);
    }

    public void test_Caching_Properties() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        int netPort = this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Properties props = new Properties();
        props.put("gemfirexd.ncj-cache-size", String.valueOf(50));
        Connection conn = TestUtil.getConnection(props);
        PreparedStatement s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s1, expected, 50);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s1, expected, 50);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID ";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s12 = conn2.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s12, expected, 0);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s12, expected, 0);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        props = new Properties();
        props.setProperty("ncj-cache-size", "500");
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn3 = DriverManager.getConnection(url, TestUtil.getNetProperties(props));
        PreparedStatement s13 = conn3.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s13, expected, 500);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s13, expected, 500);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        props = new Properties();
        props.put("gemfirexd.ncj-cache-size", String.valueOf(600));
        conn = TestUtil.getConnection(props);
        s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s1, expected, 600);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_cacheSize(s1, expected, 600);
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    class NcjPullResultsetTestCacheSerializableRunnable
    extends SerializableRunnable {
        private int verifyCount;

        public SerializableRunnable setVerifyCount(int param) {
            this.verifyCount = param;
            return this;
        }

        public NcjPullResultsetTestCacheSerializableRunnable(String name) {
            super(name);
            this.verifyCount = 0;
        }

        public void run() throws CacheException {
            TestCase.assertTrue((String)("remoteCallbackInvokeCount=" + remoteCallbackInvokeCount + " ,verifyCount=" + this.verifyCount), (remoteCallbackInvokeCount == this.verifyCount ? 1 : 0) != 0);
        }
    }
}

