/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import io.snappydata.test.dunit.SerializableRunnable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.TestCase;

public class NCJBatchingDUnit
extends DistributedSQLTestBase {
    static int remoteCallbackInvokeCount = 0;
    final GemFireXDQueryObserver ncjPullResultSetOpenCoreObserver = new GemFireXDQueryObserverAdapter(){

        public void ncjPullResultSetVerifyBatchSize(int value) {
            remoteCallbackInvokeCount = value;
        }
    };
    NcjPullResultsetTestCacheSerializableRunnable ncjPullResultSetOpenCoreObserverVerify = new NcjPullResultsetTestCacheSerializableRunnable("Verify ncjPullResultSetOpenCoreObserver");
    SerializableRunnable ncjPullResultSetOpenCoreObserverSet = new SerializableRunnable("Set ncjPullResultSetOpenCoreObserver"){

        public void run() throws CacheException {
            remoteCallbackInvokeCount = 0;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)NCJBatchingDUnit.this.ncjPullResultSetOpenCoreObserver);
        }
    };
    SerializableRunnable ncjPullResultSetOpenCoreObserverReset = new SerializableRunnable("Reset ncjPullResultSetOpenCoreObserver"){

        public void run() throws CacheException {
            remoteCallbackInvokeCount = 0;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
        }
    };

    public NCJBatchingDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        System.clearProperty("ncj-batch-size");
        NCJBatchingDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
                System.clearProperty("ncj-batch-size");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        NCJBatchingDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    private void execute_and_verify_batchSize(PreparedStatement prepSt, HashSet<Integer> expected, int batchSize) throws Exception {
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverSet);
        ResultSet rs = prepSt.executeQuery();
        while (rs.next()) {
            NCJBatchingDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJBatchingDUnit.assertTrue((boolean)expected.isEmpty());
        rs.close();
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverVerify.setVerifyCount(batchSize));
        this.serverExecute(1, (Runnable)this.ncjPullResultSetOpenCoreObserverReset);
    }

    public void test_Batching_Properties() throws Exception {
        int i;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        int netPort = this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int primary key, OSID int not null, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int primary key, DSID int not null, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int not null, TSID int primary key, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (i = 1; i < 11; ++i) {
            this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 4; i < 14; ++i) {
            this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        for (i = 7; i < 17; ++i) {
            this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + i + "," + i + ",'" + securities[i % 10] + "'" + ")");
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        Properties props = new Properties();
        props.put("gemfirexd.ncj-batch-size", String.valueOf(50));
        Connection conn = TestUtil.getConnection(props);
        PreparedStatement s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s1, expected, 50);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s1, expected, 50);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID ";
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement s12 = conn2.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s12, expected, 0);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s12, expected, 0);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        props = new Properties();
        props.setProperty("ncj-batch-size", "500");
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn3 = DriverManager.getConnection(url, TestUtil.getNetProperties(props));
        PreparedStatement s13 = conn3.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s13, expected, 500);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s13, expected, 500);
        expected = new HashSet();
        query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DID = C.TSID ";
        props = new Properties();
        props.put("gemfirexd.ncj-batch-size", String.valueOf(500));
        conn = TestUtil.getConnection(props);
        s1 = conn.prepareStatement(query);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s1, expected, 500);
        expected.clear();
        expected.add(7);
        expected.add(8);
        expected.add(9);
        expected.add(10);
        this.execute_and_verify_batchSize(s1, expected, 500);
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    public void test_Three_Tables() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.ORDERS (OID int not null, OSID int primary key, OVID varchar(10)) partition by primary key");
        this.clientSQLExecute(1, "create table trade.DUPLI (DID int not null, DSID int primary key, DVID varchar(10)) partition by column (DSID)");
        this.clientSQLExecute(1, "create table trade.TRIPLI (TID int primary key, TSID int not null, TVID varchar(10)) partition by primary key");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int j = 0; j < 10; ++j) {
            int i;
            int k = j * 100;
            for (i = 1; i < 51; ++i) {
                this.clientSQLExecute(1, "Insert into trade.ORDERS values(" + (i + k) + "," + (i + k) + ",'" + securities[i % 10] + "'" + ")");
            }
            for (i = 21; i < 71; ++i) {
                this.clientSQLExecute(1, "Insert into trade.DUPLI values(" + (i + k) + "," + (i + k) + ",'" + securities[i % 10] + "'" + ")");
            }
            for (i = 41; i < 91; ++i) {
                this.clientSQLExecute(1, "Insert into trade.TRIPLI values(" + (i + k) + "," + (i + k) + ",'" + securities[i % 10] + "'" + ")");
            }
        }
        HashSet<Integer> expected = new HashSet<Integer>();
        for (int j = 0; j < 10; ++j) {
            int k = j * 100;
            for (int i = 41; i < 51; ++i) {
                expected.add(k + i);
            }
        }
        String query = "Select A.OID, A.OVID, B.DID, B.DVID, C.TID, C.TVID from  trade.ORDERS A  inner join trade.DUPLI B on A.OID = B.DID  inner join trade.TRIPLI C on B.DSID = C.TSID ";
        Connection conn = TestUtil.getConnection();
        PreparedStatement s1 = conn.prepareStatement(query);
        ResultSet rs = s1.executeQuery();
        while (rs.next()) {
            NCJBatchingDUnit.assertTrue((boolean)expected.remove(rs.getInt(1)));
        }
        NCJBatchingDUnit.assertTrue((boolean)expected.isEmpty());
        s1.close();
        this.clientSQLExecute(1, "drop table trade.TRIPLI");
        this.clientSQLExecute(1, "drop table trade.DUPLI");
        this.clientSQLExecute(1, "drop table trade.orders");
        this.clientSQLExecute(1, "drop schema trade restrict");
    }

    class NcjPullResultsetTestCacheSerializableRunnable
    extends SerializableRunnable {
        private int verifyCount;

        public SerializableRunnable setVerifyCount(int param) {
            this.verifyCount = param;
            return this;
        }

        public NcjPullResultsetTestCacheSerializableRunnable(String name) {
            super(name);
            this.verifyCount = 0;
        }

        public void run() throws CacheException {
            TestCase.assertTrue((String)("remoteCallbackInvokeCount=" + remoteCallbackInvokeCount + " ,verifyCount=" + this.verifyCount), (remoteCallbackInvokeCount == this.verifyCount ? 1 : 0) != 0);
        }
    }
}

