/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import io.snappydata.test.dunit.SerializableRunnable;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class MultipleInsertsLeveragingPutAllDUnit
extends DistributedSQLTestBase {
    private final String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
    private BatchInsertObserver bos;

    public MultipleInsertsLeveragingPutAllDUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    private void setUpBatchObserver() {
        this.bos = new BatchInsertObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.bos);
    }

    private void checkObservedNumber(Integer num) {
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)num, (int)this.bos.getBatchSize());
    }

    public void testBug47444() throws Exception {
        this.startVMs(1, 1);
        this.serverExecute(1, (Runnable)new SerializableRunnable(""){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new BatchInsertObserver());
            }
        });
        this.serverSQLExecute(1, "create schema emp");
        this.serverSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int) partition by (depId) redundancy 0" + this.getSuffix());
        this.setUpBatchObserver();
        PreparedStatement pstmnt = TestUtil.getPreparedStatement("INSERT INTO emp.employee VALUES (?, ?)");
        pstmnt.setString(1, "Jones");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        int[] status = pstmnt.executeBatch();
        this.checkObservedNumber(1);
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)status[0], (int)1);
        String jdbcSQL = "select * from emp.Employee";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, this.goldenTextFile, "singleInsertBatch");
    }

    public void testStatementBatchInsert_NoPutAll() throws Exception {
        this.startVMs(1, 3);
        this.serverSQLExecute(1, "create schema emp");
        this.serverSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int) partition by (depId)" + this.getSuffix());
        this.setUpBatchObserver();
        Statement stmnt = TestUtil.getStatement();
        stmnt.addBatch("insert into emp.employee VALUES ('Jones', 33)");
        stmnt.addBatch("insert into emp.employee VALUES ('Rafferty', 31)");
        stmnt.addBatch("insert into emp.employee VALUES ('Robinson', 34)");
        stmnt.addBatch("insert into emp.employee VALUES ('Steinberg', 33)");
        stmnt.addBatch("create table emp.dummy(id int not null)" + this.getSuffix());
        stmnt.addBatch("insert into emp.dummy VALUES (1), (2), (3), (4)");
        stmnt.addBatch("insert into emp.employee VALUES ('Smith', 34)");
        stmnt.addBatch("insert into emp.employee VALUES ('John', null)");
        stmnt.executeBatch();
        this.checkObservedNumber(4);
        String jdbcSQL = "select * from emp.Employee";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, this.goldenTextFile, "multInsert");
    }

    public void testPrepStatementBatchInsert() throws Exception {
        this.startVMs(1, 3);
        this.serverSQLExecute(1, "create schema emp");
        this.serverSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int) partition by (depId)" + this.getSuffix());
        this.setUpBatchObserver();
        PreparedStatement pstmnt = TestUtil.getPreparedStatement("INSERT INTO emp.employee VALUES (?, ?)");
        pstmnt.setString(1, "Jones");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Rafferty");
        pstmnt.setInt(2, 31);
        pstmnt.addBatch();
        pstmnt.setString(1, "Robinson");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        pstmnt.setString(1, "Steinberg");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Smith");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        pstmnt.setString(1, "John");
        pstmnt.setNull(2, 4);
        pstmnt.addBatch();
        int[] status = pstmnt.executeBatch();
        this.checkObservedNumber(6);
        for (int i = 0; i < 6; ++i) {
            MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)status[i], (int)1);
        }
        String jdbcSQL = "select * from emp.Employee";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, this.goldenTextFile, "multInsert");
    }

    public void testMultipleInsertSameSQLStmnt() throws Exception {
        this.startVMs(1, 3);
        this.serverSQLExecute(1, "create schema emp");
        this.serverSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) partition by (depId)" + this.getSuffix());
        this.setUpBatchObserver();
        this.clientSQLExecute(1, "insert into emp.employee values ('Jones', 33), ('Rafferty', 31), ('Robinson', 34), ('Steinberg', 33), ('Smith', 34), ('John', null)");
        this.checkObservedNumber(6);
        String jdbcSQL = "select * from emp.Employee";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, this.goldenTextFile, "multInsert");
    }

    public void testMultipleInsertSamePreptmnt() throws Exception {
        this.startVMs(1, 3);
        this.serverSQLExecute(1, "create schema emp");
        this.serverSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30), depId int) partition by (depId)" + this.getSuffix());
        this.setUpBatchObserver();
        PreparedStatement pstmnt = TestUtil.getPreparedStatement("INSERT INTO emp.employee VALUES (?, ?)");
        pstmnt.setString(1, "Jones");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Rafferty");
        pstmnt.setInt(2, 31);
        pstmnt.addBatch();
        pstmnt.setString(1, "Robinson");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        int[] status = pstmnt.executeBatch();
        this.checkObservedNumber(3);
        for (int i = 0; i < 3; ++i) {
            MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)status[i], (int)1);
        }
        String jdbcSQL = "select * from emp.Employee";
        pstmnt.setString(1, "Steinberg");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Smith");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        pstmnt.setString(1, "John");
        pstmnt.setNull(2, 4);
        pstmnt.addBatch();
        status = pstmnt.executeBatch();
        this.checkObservedNumber(3);
        for (int i = 0; i < 3; ++i) {
            MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)status[i], (int)1);
        }
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, this.goldenTextFile, "multInsert");
    }

    public void testPrepStatementBatchInsert_WithInvalidInsert() throws Exception {
        int[] isolationLevels;
        int[] status;
        PreparedStatement pstmnt;
        block7: {
            Properties props = new Properties();
            props.setProperty("sync-commits", "true");
            this.startVMs(1, 3, 0, null, props);
            this.serverSQLExecute(1, "create schema emp");
            this.serverSQLExecute(1, "create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int) partition by (depId)" + this.getSuffix());
            this.setUpBatchObserver();
            pstmnt = TestUtil.getPreparedStatement("INSERT INTO emp.employee VALUES (?, ?)");
            pstmnt.setString(1, "Jones");
            pstmnt.setInt(2, 33);
            pstmnt.addBatch();
            pstmnt.setString(1, "Rafferty");
            pstmnt.setInt(2, 31);
            pstmnt.addBatch();
            pstmnt.setString(1, "Robinson");
            pstmnt.setInt(2, 34);
            pstmnt.addBatch();
            pstmnt.setString(1, "Rafferty");
            pstmnt.setInt(2, 351);
            pstmnt.addBatch();
            status = null;
            try {
                status = pstmnt.executeBatch();
                MultipleInsertsLeveragingPutAllDUnit.fail((String)"expected a constraint violation");
            }
            catch (SQLException sqle) {
                if ("23505".equals(sqle.getSQLState())) break block7;
                throw sqle;
            }
        }
        String jdbcSQL = "select * from emp.Employee";
        this.clientSQLExecute(1, "delete from emp.Employee");
        pstmnt.setString(1, "Jones");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Rafferty");
        pstmnt.setInt(2, 31);
        pstmnt.addBatch();
        pstmnt.setString(1, "Robinson");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        pstmnt.setString(1, "Steinberg");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Smith");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        pstmnt.setString(1, "John");
        pstmnt.setNull(2, 4);
        pstmnt.addBatch();
        status = pstmnt.executeBatch();
        this.checkObservedNumber(6);
        this.bos.clear();
        for (int i = 0; i < 6; ++i) {
            MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)status[i], (int)1);
        }
        this.sqlExecuteVerify(null, new int[]{1}, "select * from emp.Employee", this.goldenTextFile, "multInsert");
        for (final int isolationLevel : isolationLevels = new int[]{2, 4}) {
            block8: {
                this.clientSQLExecute(1, "delete from emp.Employee");
                TestUtil.jdbcConn.setTransactionIsolation(isolationLevel);
                pstmnt.setString(1, "Jones");
                pstmnt.setInt(2, 33);
                pstmnt.addBatch();
                pstmnt.setString(1, "Rafferty");
                pstmnt.setInt(2, 31);
                pstmnt.addBatch();
                pstmnt.setString(1, "Robinson");
                pstmnt.setInt(2, 34);
                pstmnt.addBatch();
                pstmnt.setString(1, "Rafferty");
                pstmnt.setInt(2, 351);
                pstmnt.addBatch();
                try {
                    status = pstmnt.executeBatch();
                    MultipleInsertsLeveragingPutAllDUnit.fail((String)"expected a constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block8;
                    throw sqle;
                }
            }
            pstmnt.setString(1, "Jones");
            pstmnt.setInt(2, 33);
            pstmnt.addBatch();
            pstmnt.setString(1, "Rafferty");
            pstmnt.setInt(2, 31);
            pstmnt.addBatch();
            pstmnt.setString(1, "Robinson");
            pstmnt.setInt(2, 34);
            pstmnt.addBatch();
            pstmnt.setString(1, "Steinberg");
            pstmnt.setInt(2, 33);
            pstmnt.addBatch();
            pstmnt.setString(1, "Smith");
            pstmnt.setInt(2, 34);
            pstmnt.addBatch();
            pstmnt.setString(1, "John");
            pstmnt.setNull(2, 4);
            pstmnt.addBatch();
            status = pstmnt.executeBatch();
            this.checkObservedNumber(6);
            this.bos.clear();
            for (int i = 0; i < 6; ++i) {
                MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)status[i], (int)1);
            }
            TestUtil.jdbcConn.commit();
            this.serverExecute(1, (Runnable)new SerializableRunnable(){

                public void run() {
                    try {
                        Connection conn = TestUtil.jdbcConn;
                        conn.setTransactionIsolation(isolationLevel);
                        TestUtil.sqlExecuteVerifyText("select * from emp.Employee", MultipleInsertsLeveragingPutAllDUnit.this.goldenTextFile, "multInsert", true, false);
                        conn.commit();
                    }
                    catch (Exception e) {
                        MultipleInsertsLeveragingPutAllDUnit.this.getLogWriter().error((Object)"unexpected exception", (Throwable)e);
                        DistributedSQLTestBase.fail("unexpected exception", e);
                    }
                }
            });
        }
    }

    public void testPrepStatementBatchInsert_WithInvalidInsert_andThenReuseSamePrepStmnt() throws Exception {
    }

    public void testMultipleInsert() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null)");
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        int actual = s.executeUpdate("insert into backup select * from account");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null) replicate" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null) replicate" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null)" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
    }

    public void testMultipleInsertWithWhereClause() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) partition by range(balance) (values between 100 and 350, values between 350 and 450)" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        int actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) replicate" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) replicate" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) partition by range(balance) (values between 100 and 350, values between 350 and 450)" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
    }

    public void testMultipleInsert_prepStmnt() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null)" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        PreparedStatement ps = conn.prepareStatement("insert into backup select * from account where id > ?");
        ps.setInt(1, 0);
        int actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("create table backup2 as select * from account with no data" + this.getSuffix());
        ps = conn.prepareStatement("insert into backup2 select * from account where id > ?");
        ps.setInt(1, 10);
        actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null) replicate" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        ps = conn.prepareStatement("insert into backup select * from account where id > ?");
        ps.setInt(1, 0);
        actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("create table backup2 as select * from account with no data replicate" + this.getSuffix());
        ps = conn.prepareStatement("insert into backup2 select * from account where id > ?");
        ps.setInt(1, 10);
        actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null) replicate" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        ps = conn.prepareStatement("insert into backup select * from account where id > ?");
        ps.setInt(1, 0);
        actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("create table backup2 as select * from account with no data" + this.getSuffix());
        ps = conn.prepareStatement("insert into backup2 select * from account where id > ?");
        ps.setInt(1, 10);
        actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null)" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        ps = conn.prepareStatement("insert into backup select * from account where id > ?");
        ps.setInt(1, 0);
        actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("create table backup2 as select * from account with no data replicate" + this.getSuffix());
        ps = conn.prepareStatement("insert into backup2 select * from account where id > ?");
        ps.setInt(1, 10);
        actual = ps.executeUpdate();
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
    }

    public void testMultipleInsertWithWhereClause_pbc() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) partition by column(name) " + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        int actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where name = 'name3'");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)1, (int)actual);
        s.execute("select * from backup2");
        ResultSet rs = s.getResultSet();
        MultipleInsertsLeveragingPutAllDUnit.assertTrue((boolean)rs.next());
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)rs.getInt(1));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"name3", (String)rs.getString(2));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"addr3", (String)rs.getString(3));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) replicate " + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where name = 'name3'");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)1, (int)actual);
        s.execute("select * from backup2");
        rs = s.getResultSet();
        MultipleInsertsLeveragingPutAllDUnit.assertTrue((boolean)rs.next());
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)rs.getInt(1));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"name3", (String)rs.getString(2));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"addr3", (String)rs.getString(3));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) partition by column(name) " + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data replicate" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where name = 'name3'");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)1, (int)actual);
        s.execute("select * from backup2");
        rs = s.getResultSet();
        MultipleInsertsLeveragingPutAllDUnit.assertTrue((boolean)rs.next());
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)rs.getInt(1));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"name3", (String)rs.getString(2));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"addr3", (String)rs.getString(3));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) replicate" + this.getSuffix());
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data" + this.getSuffix());
        actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)actual);
        s.execute("create table backup2 as select * from account with no data" + this.getSuffix());
        actual = s.executeUpdate("insert into backup2 select * from account where balance > 50");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)4, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where balance >= 50 and balance <= 85");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)0, (int)actual);
        s.execute("truncate table backup2");
        actual = s.executeUpdate("insert into backup2 select * from account where name = 'name3'");
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)1, (int)actual);
        s.execute("select * from backup2");
        rs = s.getResultSet();
        MultipleInsertsLeveragingPutAllDUnit.assertTrue((boolean)rs.next());
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)rs.getInt(1));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"name3", (String)rs.getString(2));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"addr3", (String)rs.getString(3));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("drop table backup2");
    }

    public void testInsertSubSelect() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) partition by column(name) " + this.getSuffix());
        s.execute("insert into trade.account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table trade.account2 (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) partition by column(name) " + this.getSuffix());
        s.execute("insert into trade.account2 select * from trade.account where name = 'name3'");
        s.execute("select * from trade.account2");
        ResultSet rs = s.getResultSet();
        MultipleInsertsLeveragingPutAllDUnit.assertTrue((boolean)rs.next());
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)3, (int)rs.getInt(1));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"name3", (String)rs.getString(2));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)"addr3", (String)rs.getString(3));
        MultipleInsertsLeveragingPutAllDUnit.assertEquals((int)300, (int)rs.getInt(4));
        s.execute("drop table trade.account");
        s.execute("drop table trade.account2");
        s.execute("drop schema trade RESTRICT");
    }

    public void testInsertSubSelect_unsupported_case() throws Exception {
        this.startVMs(1, 4);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.account (id int not null primary key, name varchar(20), addr varchar(20), balance int not null) partition by column(name) " + this.getSuffix());
        s.execute("insert into trade.account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table trade.account2 (id int not null primary key, name varchar(20), addr varchar(20), balance int not null) partition by column(name) " + this.getSuffix());
        try {
            s.execute("insert into trade.account2 (id, balance) select count(balance), max(balance) from trade.account group by id");
            MultipleInsertsLeveragingPutAllDUnit.fail((String)"Test should fail: inserts as sub selects not supported for selects which needs aggregation");
        }
        catch (SQLException sqle) {
            MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)sqle.getSQLState(), (String)"0A000");
        }
        try {
            s.execute("insert into trade.account2 (id, balance) select id, balance from trade.account where id >  (select max(id) from trade.account2)");
            MultipleInsertsLeveragingPutAllDUnit.fail((String)"Test should fail: inserts as sub selects not supported for selects which needs aggregation");
        }
        catch (SQLException sqle) {
            MultipleInsertsLeveragingPutAllDUnit.assertEquals((String)sqle.getSQLState(), (String)"0A000");
        }
        s.execute("drop table trade.account");
        s.execute("drop table trade.account2");
        s.execute("drop schema trade RESTRICT");
    }

    public void testImportExport() throws Exception {
        this.startVMs(1, 4);
        Connection conn = TestUtil.getConnection();
        File outfile = new File("eximFile.flt");
        if (outfile.exists()) {
            outfile.delete();
        }
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))" + this.getSuffix());
        stmt.execute("insert into t1 values (1, 1, 'kingfisher'), (1, 2, 'jet'), (2, 1, 'ai'), (3, 1, 'ial')");
        stmt.execute("CALL SYSCS_UTIL.EXPORT_TABLE(null, 't1', 'myfile.flt', null, null, null)");
        stmt.execute("create table imported_t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT IMPORTED_FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))" + this.getSuffix());
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE(null, 'imported_t1', 'myfile.flt', null, null, null, 0)");
        stmt.execute("select * from imported_t1");
        ResultSet rs = stmt.getResultSet();
        while (rs.next()) {
            System.out.println(rs.getInt(1) + ", " + rs.getInt(2) + ", " + rs.getString(3));
        }
        stmt.close();
        conn.close();
    }

    public String getSuffix() throws Exception {
        return "  ";
    }

    public static class BulkGetObserver
    extends GemFireXDQueryObserverAdapter {
        private int batchSize;

        public void getAllInvoked(int numElements) {
            this.batchSize = numElements;
        }

        public int getBatchSize() {
            return this.batchSize;
        }
    }

    public static class BatchInsertObserver
    extends GemFireXDQueryObserverAdapter {
        private int batchSize;
        private boolean posDup;

        public void insertMultipleRowsBeingInvoked(int numElements) {
            this.batchSize = numElements;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void clear() {
            this.batchSize = 0;
        }

        public void putAllCalledWithMapSize(int size) {
            this.batchSize = size;
        }

        public void afterGlobalIndexInsert(boolean posDup) {
            if (!this.posDup) {
                this.posDup = posDup;
                throw new CacheClosedException();
            }
        }
    }
}

