/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class GlobalIndexPerfDUnit
extends DistributedSQLTestBase {
    private static long timeTookWithCaching;
    private static long timeTookWithoutCaching;

    public GlobalIndexPerfDUnit(String name) {
        super(name);
    }

    public void testDummy() throws Exception {
    }

    public void _testSelectsPerfNoCaching() throws Exception {
        this.startVMs(1, 3);
        this.runSelectsToGetTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testSelectsPerfCaching() throws Exception {
        this.startVMs(1, 3);
        try {
            GlobalIndexPerfDUnit.invokeInEveryVM(GlobalIndexPerfDUnit.class, (String)"setCachingInAllVMs", (Object[])new Object[]{Boolean.TRUE});
            this.runSelectsToGetTest(true);
            this.getLogWriter().info((Object)("Time taken to run 10K selects without caching = " + timeTookWithoutCaching));
            this.getLogWriter().info((Object)("Time taken to run 10K selects with caching = " + timeTookWithCaching));
        }
        catch (Throwable throwable) {
            GlobalIndexPerfDUnit.invokeInEveryVM(GlobalIndexPerfDUnit.class, (String)"setCachingInAllVMs", (Object[])new Object[]{Boolean.FALSE});
            throw throwable;
        }
        GlobalIndexPerfDUnit.invokeInEveryVM(GlobalIndexPerfDUnit.class, (String)"setCachingInAllVMs", (Object[])new Object[]{Boolean.FALSE});
    }

    private void runSelectsToGetTest(boolean caching) throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(address) redundancy 1");
        this.insertTenKRows(conn);
        this.runTenKSelects(conn, false, false);
        this.runTenKSelects(conn, false, false);
        this.runTenKSelects(conn, true, caching);
    }

    private void runTenKSelects(Connection conn, boolean recordTime, boolean caching) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("select * from TESTTABLE where ID = ?");
        long startTime = 0L;
        long endTime = 0L;
        if (recordTime) {
            startTime = System.currentTimeMillis();
        }
        for (int i = 0; i < 10000; ++i) {
            ps.setInt(1, i);
            ResultSet rs = ps.executeQuery();
            GlobalIndexPerfDUnit.assertTrue((boolean)rs.next());
            GlobalIndexPerfDUnit.assertFalse((boolean)rs.next());
        }
        if (recordTime) {
            endTime = System.currentTimeMillis();
            long diff = endTime - startTime;
            if (caching) {
                this.getLogWriter().info((Object)("setting time took with caching with val=" + diff));
                timeTookWithCaching = diff;
            } else {
                this.getLogWriter().info((Object)("setting time took without caching with val=" + diff));
                timeTookWithoutCaching = diff;
            }
        }
    }

    private void insertTenKRows(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("insert into TESTTABLE values (?, ?, ?)");
        for (int i = 0; i < 10000; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "descp" + i);
            ps.setString(3, "addr" + i);
            ps.executeUpdate();
        }
    }

    static void setCachingInAllVMs(boolean set) {
        if (set) {
            System.setProperty("gemfirexd.cacheGlobalIndex", "true");
        } else {
            System.clearProperty("gemfirexd.cacheGlobalIndex");
        }
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }
}

