/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.VM;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;

public class GlobalIndexNodesPruningDUnit
extends DistributedSQLTestBase {
    public GlobalIndexNodesPruningDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleNodesPruningUsingGlobalIndex() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2'";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID), unique(ADDRESS))");
        for (int i = 0; i < 7; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 2; i < 3; ++i) {
                rslts.add(i);
            }
            ResultSet rs = stmnt.executeQuery(query);
            for (int i = 2; i < 3; ++i) {
                GlobalIndexNodesPruningDUnit.assertTrue((boolean)rs.next());
                GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            GlobalIndexNodesPruningDUnit.assertFalse((boolean)rs.next());
            Object[][] routingInfo = new Object[][]{{new Integer(3), new SQLInteger(2)}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingExplicitGlobalIndex() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2'";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "CREATE GLOBAL HASH INDEX address_global ON TESTTABLE ( ADDRESS)");
        for (int i = 0; i < 7; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 2; i < 3; ++i) {
                rslts.add(i);
            }
            ResultSet rs = stmnt.executeQuery(query);
            for (int i = 2; i < 3; ++i) {
                GlobalIndexNodesPruningDUnit.assertTrue((boolean)rs.next());
                GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            GlobalIndexNodesPruningDUnit.assertFalse((boolean)rs.next());
            Object[][] routingInfo = new Object[][]{{new Integer(3), new SQLInteger(2)}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingExplicitGlobalIndexOnMultiColumnPartitioning_1() throws Exception {
        String query = "select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2' and DESCRIPTION = 'First2'";
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "CREATE  GLOBAL HASH  INDEX address_global ON TESTTABLE ( ADDRESS)");
        for (int i = 0; i < 7; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
        }
        try {
            SelectQueryInfo[] sqi = new SelectQueryInfo[1];
            this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
            TestUtil.setupConnection();
            EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            HashSet<Integer> rslts = new HashSet<Integer>();
            for (int i = 2; i < 3; ++i) {
                rslts.add(i);
            }
            ResultSet rs = stmnt.executeQuery(query);
            for (int i = 2; i < 3; ++i) {
                GlobalIndexNodesPruningDUnit.assertTrue((boolean)rs.next());
                GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
            }
            GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
            GlobalIndexNodesPruningDUnit.assertFalse((boolean)rs.next());
            Object[][] routingInfo = new Object[][]{{new Integer(3), new SQLInteger(2)}};
            Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], routingInfo, this.getLogWriter());
            Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(query, (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
            allNodes.removeAll(expectedPrunedNodes);
            this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, 1, 2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesPruningUsingExplicitGlobalIndexOnMultiColumnPartitioning_2() throws Exception {
        String[] queries = new String[]{"select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2' and DESCRIPTION = 'First2'", "select ID, DESCRIPTION from TESTTABLE where ADDRESS = 'abc2'"};
        Object[][][] routingInfo = new Object[][][]{{{new Integer(3), new SQLInteger(2)}}, {{new Integer(6)}}};
        int[] numPrunedNodes = new int[]{1, 3};
        int[] numNoQueryNodes = new int[]{2, 0};
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "CREATE GLOBAL HASH INDEX address_description_global ON TESTTABLE (ADDRESS, DESCRIPTION)");
        try {
            for (int i = 0; i < 7; ++i) {
                this.clientSQLExecute(1, "insert into TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'abc" + (i + 1) + "')");
            }
            for (int j = 0; j < queries.length; ++j) {
                try {
                    SelectQueryInfo[] sqi = new SelectQueryInfo[1];
                    this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqi);
                    TestUtil.setupConnection();
                    EmbedStatement stmnt = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                    HashSet<Integer> rslts = new HashSet<Integer>();
                    for (int i = 2; i < 3; ++i) {
                        rslts.add(i);
                    }
                    ResultSet rs = stmnt.executeQuery(queries[j]);
                    for (int i = 2; i < 3; ++i) {
                        GlobalIndexNodesPruningDUnit.assertTrue((boolean)rs.next());
                        GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
                    }
                    GlobalIndexNodesPruningDUnit.assertTrue((boolean)rslts.isEmpty());
                    GlobalIndexNodesPruningDUnit.assertFalse((boolean)rs.next());
                    Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(queries[j], (QueryInfo)sqi[0], routingInfo[j], this.getLogWriter());
                    Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(queries[j], (QueryInfo)sqi[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
                    allNodes.removeAll(expectedPrunedNodes);
                    this.verifyQueryExecution(sqi[0], expectedPrunedNodes, allNodes, numPrunedNodes[j], numNoQueryNodes[j]);
                    continue;
                }
                finally {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    isQueryExecutedOnNode = false;
                    GlobalIndexNodesPruningDUnit.invokeInEveryVM(DistributedSQLTestBase.class, (String)"reset");
                }
            }
        }
        finally {
            this.clientSQLExecute(1, "Drop table TESTTABLE ");
        }
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        GlobalIndexNodesPruningDUnit.reset();
    }
}

