/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import com.pivotal.gemfirexd.jdbc.TestRowLoader;
import io.snappydata.test.dunit.SerializableRunnable;
import java.net.InetAddress;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import javax.sql.rowset.serial.SerialBlob;
import junit.framework.TestCase;

public class GetAllLocalIndexQueryDUnit
extends DistributedSQLTestBase {
    private static boolean changeDefaultTestProperties = false;
    static boolean[] remoteCallbackInvoked = new boolean[]{false, false, false, false, false};

    @Override
    protected String reduceLogging() {
        if (changeDefaultTestProperties) {
            return "config";
        }
        return super.reduceLogging();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
            }
        });
    }

    public GetAllLocalIndexQueryDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleParameters() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            s.execute("Insert into  t1 values(1,'asif',2)");
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(1));
            GetAllLocalIndexQueryDUnit.assertEquals((String)"asif", (String)rs.getString(3));
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleParameters_noData() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithMultipleParameters_ThinClient_singleHopEnabled() throws Exception {
        this.startVMs(0, 4, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "true");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        String logLevel = this.getLogLevel();
        connSHOPProps.setProperty("log-level", logLevel);
        if (logLevel.startsWith("fine")) {
            connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        }
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn = DriverManager.getConnection(url, TestUtil.getNetProperties(connSHOPProps));
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        GemFireXDQueryObserverAdapter getAllObserver = new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                if (qInfo instanceof SelectQueryInfo) {
                    GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[0] = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                    TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                    TestCase.assertTrue((boolean)sqi.isDynamic());
                    TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                    Object[] pks = (Object[])sqi.getPrimaryKey();
                    TestCase.assertNull((Object)pks);
                    try {
                        TestCase.assertTrue((boolean)sqi.createGFEActivation());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestCase.fail((String)e.toString());
                    }
                }
            }

            public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                if (rs instanceof GemFireResultSet) {
                    GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[1] = true;
                }
            }

            public void getAllInvoked(int numElements) {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[3] = true;
            }

            public void getAllLocalIndexExecuted() {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[4] = true;
            }

            public void getAllLocalIndexInvoked(int numElements) {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[2] = true;
                TestCase.assertEquals((int)3, (int)numElements);
            }
        };
        SerializableRunnable getAllObsSet = new SerializableRunnable("Set GetAll Observer", (GemFireXDQueryObserver)getAllObserver){
            final /* synthetic */ GemFireXDQueryObserver val$getAllObserver;
            {
                this.val$getAllObserver = gemFireXDQueryObserver;
                super(x0);
            }

            public void run() throws CacheException {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[0] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[1] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[2] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[3] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[4] = false;
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$getAllObserver);
            }
        };
        SerializableRunnable getAllObsReset = new SerializableRunnable("Reset GetAll Observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
            }
        };
        SerializableRunnable clearStmtCache = new SerializableRunnable("Clear Stmt Cache"){

            public void run() throws CacheException {
                try {
                    TestUtil.clearStatementCache();
                    GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[3] = true;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        SerializableRunnable verifyStmtCache = new SerializableRunnable("Verify Stmt Cache"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[3]);
            }
        };
        SerializableRunnable getAllObsVerify_noData = new SerializableRunnable("Verify GetAll Observer"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[2]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[3]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[4]);
            }
        };
        SerializableRunnable getAllObsVerify = new SerializableRunnable("Verify GetAll Observer"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[2]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[3]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[4]);
            }
        };
        try {
            this.serverExecute(1, (Runnable)getAllObsSet);
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            this.serverExecute(1, (Runnable)getAllObsVerify_noData);
            this.serverExecute(1, (Runnable)clearStmtCache);
            this.serverExecute(1, (Runnable)verifyStmtCache);
            s.execute("Insert into  t1 values(1,'asif',1)");
            s.execute("Insert into  t1 values(2,'asif',2)");
            s.execute("Insert into  t1 values(3,'asif',3)");
            s.execute("Insert into  t1 values(4,'asif',4)");
            s.execute("Insert into  t1 values(5,'asif',5)");
            this.serverExecute(1, (Runnable)getAllObsSet);
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            rs = ps1.executeQuery();
            HashSet<Integer> hashi = new HashSet<Integer>();
            hashi.add(1);
            hashi.add(2);
            hashi.add(3);
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashi.remove(rs.getInt(1)));
            }
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashi.isEmpty());
            this.serverExecute(1, (Runnable)getAllObsVerify);
            rs.close();
        }
        finally {
            this.serverExecute(1, (Runnable)getAllObsReset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithMultipleParameters_ThinClient_singleHopDisabled() throws Exception {
        this.startVMs(0, 4, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "false");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        String logLevel = this.getLogLevel();
        connSHOPProps.setProperty("log-level", logLevel);
        if (logLevel.startsWith("fine")) {
            connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        }
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn = DriverManager.getConnection(url, TestUtil.getNetProperties(connSHOPProps));
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        GemFireXDQueryObserverAdapter getAllObserver = new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                if (qInfo instanceof SelectQueryInfo) {
                    GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[0] = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                    TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                    TestCase.assertTrue((boolean)sqi.isDynamic());
                    TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                    Object[] pks = (Object[])sqi.getPrimaryKey();
                    TestCase.assertNull((Object)pks);
                    try {
                        TestCase.assertTrue((boolean)sqi.createGFEActivation());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestCase.fail((String)e.toString());
                    }
                }
            }

            public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                if (rs instanceof GemFireResultSet) {
                    GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[1] = true;
                }
            }

            public void getAllInvoked(int numElements) {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[3] = true;
            }

            public void getAllLocalIndexExecuted() {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[4] = true;
            }

            public void getAllLocalIndexInvoked(int numElements) {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[2] = true;
                TestCase.assertEquals((int)3, (int)numElements);
            }
        };
        SerializableRunnable getAllObsSet = new SerializableRunnable("Set GetAll Observer to false", (GemFireXDQueryObserver)getAllObserver){
            final /* synthetic */ GemFireXDQueryObserver val$getAllObserver;
            {
                this.val$getAllObserver = gemFireXDQueryObserver;
                super(x0);
            }

            public void run() throws CacheException {
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[0] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[1] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[2] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[3] = false;
                GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[4] = false;
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$getAllObserver);
            }
        };
        SerializableRunnable getAllObsReset = new SerializableRunnable("Reset GetAll Observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
            }
        };
        SerializableRunnable clearStmtCache = new SerializableRunnable("Clear Stmt Cache"){

            public void run() throws CacheException {
                try {
                    TestUtil.clearStatementCache();
                    GetAllLocalIndexQueryDUnit.remoteCallbackInvoked[3] = true;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        SerializableRunnable verifyStmtCache = new SerializableRunnable("Verify Stmt Cache"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[3]);
            }
        };
        SerializableRunnable getAllObsVerify_noData = new SerializableRunnable("Verify GetAll Observer"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[2]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[3]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[4]);
            }
        };
        SerializableRunnable getAllObsVerify = new SerializableRunnable("Verify GetAll Observer"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[2]);
                TestCase.assertFalse((boolean)remoteCallbackInvoked[3]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[4]);
            }
        };
        try {
            this.serverExecute(1, (Runnable)getAllObsSet);
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            this.serverExecute(1, (Runnable)getAllObsVerify_noData);
            this.serverExecute(1, (Runnable)clearStmtCache);
            this.serverExecute(1, (Runnable)verifyStmtCache);
            s.execute("Insert into  t1 values(1,'asif',1)");
            s.execute("Insert into  t1 values(2,'asif',2)");
            s.execute("Insert into  t1 values(3,'asif',3)");
            s.execute("Insert into  t1 values(4,'asif',4)");
            s.execute("Insert into  t1 values(5,'asif',5)");
            this.serverExecute(1, (Runnable)getAllObsSet);
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            rs = ps1.executeQuery();
            HashSet<Integer> hashi = new HashSet<Integer>();
            hashi.add(1);
            hashi.add(2);
            hashi.add(3);
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashi.remove(rs.getInt(1)));
            }
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashi.isEmpty());
            this.serverExecute(1, (Runnable)getAllObsVerify);
            rs.close();
        }
        finally {
            this.serverExecute(1, (Runnable)getAllObsReset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleParameters_Replicated() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) replicate");
        s.execute("create INDEX t1index on t1(id)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertFalse((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireDistributedResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)0, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            s.execute("Insert into  t1 values(1,'asif',2)");
            rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(1));
            GetAllLocalIndexQueryDUnit.assertEquals((String)"asif", (String)rs.getString(3));
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleParametersAndDuplicateKeys() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 1);
            ps1.setInt(3, 1);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(1));
            GetAllLocalIndexQueryDUnit.assertEquals((String)"asif", (String)rs.getString(3));
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithConstantAndParameterizedFields() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (?,?,3,4)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)2, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)4, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(1));
            GetAllLocalIndexQueryDUnit.assertEquals((String)"asif", (String)rs.getString(3));
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleConstantFields() throws Exception {
        this.startVMs(1, 3);
        Properties props = new Properties();
        props.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(props);
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select id, name from t1 where id IN (1, 2, 1000, 2000)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertFalse((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)0, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)4, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ResultSet rs = ps1.executeQuery();
            HashSet<String> hashs = new HashSet<String>();
            hashs.add("asif");
            HashSet<Integer> hashi = new HashSet<Integer>();
            hashi.add(1);
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashi.remove(rs.getInt(1)));
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashs.remove(rs.getString(2)));
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashi.isEmpty());
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)hashs.isEmpty());
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40413_1() throws Exception {
        Connection systemconn;
        block9: {
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement s = conn.createStatement();
            s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
            s.execute("create table t1 ( id int, name varchar(10), type int primary key, address varchar(50))partition by primary key");
            s.execute("create INDEX t1index on t1(id)");
            s.execute("Insert into  t1 values(1,'asif',21, 'J 604')");
            s.execute("Insert into  t1 values(2,'neeraj',22, 'J 604')");
            s.execute("Insert into  t1 values(3,'shoubhik',23, 'J 604')");
            s.execute("Insert into  t1 values(4,'eric',24, 'J 604')");
            String query = null;
            ResultSet rs = null;
            GemFireXDQueryObserver old = null;
            final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
            systemconn = TestUtil.getConnection();
            try {
                int i;
                CallableStatement cusr = systemconn.prepareCall("call SYSCS_UTIL.SET_DATABASE_PROPERTY(?,?)");
                cusr.setString(1, "gemfirexd.enable-getall-local-index-embed-gfe");
                cusr.setString(2, "true");
                cusr.execute();
                cusr.close();
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            callbackInvoked[0] = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                            TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                            TestCase.assertTrue((boolean)sqi.isDynamic());
                            Object[] pks = (Object[])sqi.getPrimaryKey();
                            TestCase.assertNull((Object)pks);
                            try {
                                TestCase.assertFalse((boolean)sqi.createGFEActivation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)e.toString());
                            }
                        }
                    }

                    public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                        if (rs instanceof GemFireResultSet) {
                            callbackInvoked[1] = true;
                        }
                    }

                    public void getAllInvoked(int numElements) {
                        callbackInvoked[3] = true;
                    }

                    public void getAllLocalIndexExecuted() {
                        callbackInvoked[4] = true;
                    }

                    public void getAllLocalIndexInvoked(int numElements) {
                        callbackInvoked[2] = true;
                    }
                });
                Statement stmt = conn.createStatement();
                query = "select substr(name,1,2) from t1 where  id IN (1,1)";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                HashSet<String> hash = new HashSet<String>();
                hash.add("as");
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertTrue((boolean)hash.remove(rs.getString(1)));
                }
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)hash.isEmpty());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1, 3)";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((String)"604", (String)rs.getString(1));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct address, id  from t1 where  id IN (1,3) order by id  asc , address desc";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct address, id  from t1 where  id IN (1,3) group by id, address   order by id ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  distinct type, AVG(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  distinct type, AVG(type), MAX(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  address, id  from t1 where  id IN (1,3) group by id, address  order by id";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct address  from t1 where  id IN (1,3) ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  address  from t1 where  id IN (1,3)  group by address ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select type from t1 where  id IN (3,1,4,2)  order by id ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                for (i = 21; i < 25; ++i) {
                    rs.next();
                    GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
                }
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select type from t1 where  id IN (1,3,4,2)  order by id desc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                for (i = 24; i > 20; --i) {
                    rs.next();
                    GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
                }
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select type from t1 where  id IN (3,1,4,2)  order by id asc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                for (i = 21; i < 25; ++i) {
                    rs.next();
                    GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
                }
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                if (old == null) break block9;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                if (systemconn != null) {
                    systemconn.close();
                }
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        if (systemconn != null) {
            systemconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40413_2() throws Exception {
        Connection systemconn;
        block9: {
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement s = conn.createStatement();
            s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
            s.execute("create table t1 ( id int, name varchar(10), type int primary key, address varchar(50))partition by primary key");
            s.execute("create INDEX t1index on t1(id)");
            s.execute("Insert into  t1 values(1,'asif',21, 'J 604')");
            s.execute("Insert into  t1 values(2,'neeraj',22, 'J 604')");
            s.execute("Insert into  t1 values(3,'shoubhik',23, 'J 604')");
            s.execute("Insert into  t1 values(4,'eric',24, 'J 604')");
            String query = "select substr(name,1,2) from t1 where  id = 1";
            GemFireXDQueryObserver old = null;
            final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
            systemconn = TestUtil.getConnection();
            try {
                int i;
                CallableStatement cusr = systemconn.prepareCall("call SYSCS_UTIL.SET_DATABASE_PROPERTY(?,?)");
                cusr.setString(1, "gemfirexd.enable-getall-local-index-embed-gfe");
                cusr.setString(2, "true");
                cusr.execute();
                cusr.close();
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            callbackInvoked[0] = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                            TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                            TestCase.assertTrue((boolean)sqi.isDynamic());
                            Object[] pks = (Object[])sqi.getPrimaryKey();
                            TestCase.assertNull((Object)pks);
                            try {
                                TestCase.assertFalse((boolean)sqi.createGFEActivation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)e.toString());
                            }
                        }
                    }

                    public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                        if (rs instanceof GemFireResultSet) {
                            callbackInvoked[1] = true;
                        }
                    }

                    public void getAllInvoked(int numElements) {
                        callbackInvoked[3] = true;
                    }

                    public void getAllLocalIndexExecuted() {
                        callbackInvoked[4] = true;
                    }

                    public void getAllLocalIndexInvoked(int numElements) {
                        callbackInvoked[2] = true;
                    }
                });
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                HashSet<String> hash = new HashSet<String>();
                hash.add("as");
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertTrue((boolean)hash.remove(rs.getString(1)));
                }
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)hash.isEmpty());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1, 3,1000)";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((String)"604", (String)rs.getString(1));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct address, id  from t1 where  id IN (1,3,1000) order by id  asc , address desc";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct address, id  from t1 where  id IN (1,3,1000) group by id, address   order by id ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  distinct type, AVG(type)  from t1 where id IN (1,3,1000) group by type order by AVG(type) desc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  distinct type, AVG(type), MAX(type)  from t1 where id IN (1,3,1000) group by type order by AVG(type) desc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  address, id  from t1 where  id IN (1,3,1000) group by id, address  order by id";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct address  from t1 where  id IN (1,3,1000) ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select  address  from t1 where  id IN (1,3,1000)  group by address ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select type from t1 where  id IN (3,1,4,2,1000)  order by id ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                for (i = 21; i < 25; ++i) {
                    rs.next();
                    GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
                }
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select type from t1 where  id IN (1,3,4,2,1000)  order by id desc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                for (i = 24; i > 20; --i) {
                    rs.next();
                    GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
                }
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select type from t1 where  id IN (3,1,4,2,1000)  order by id asc ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                for (i = 21; i <= 24; ++i) {
                    rs.next();
                    GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
                }
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                if (old == null) break block9;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                if (systemconn != null) {
                    systemconn.close();
                }
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        if (systemconn != null) {
            systemconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_2_RowLoader() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        s.execute("create table t1 ( id int, name varchar(10), type int primary key, address varchar(50))partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        GfxdCallbacksTest.addLoader(null, "t1", "com.pivotal.gemfirexd.internal.engine.distributed.GetAllLocalIndexQueryDUnit$TestBug40413_2_RowLoader", "");
        s.execute("Insert into  t1 values(1,'asif',21, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',22, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',23, 'J 604')");
        s.execute("Insert into  t1 values(4,'eric',24, 'J 604')");
        String query = "select substr(name,1,2) from t1 where  id = 1";
        GemFireXDQueryObserver old = null;
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        try {
            int i;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertFalse((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                }
            });
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            HashSet<String> hash = new HashSet<String>();
            hash.add("as");
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)hash.remove(rs.getString(1)));
            }
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)hash.isEmpty());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1, 3,1000)";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertEquals((String)"604", (String)rs.getString(1));
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3,1000) order by id  asc , address desc";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3,1000) group by id, address   order by id ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select  distinct type, AVG(type)  from t1 where id IN (1,3,1000) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select  distinct type, AVG(type), MAX(type)  from t1 where id IN (1,3,1000) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select  address, id  from t1 where  id IN (1,3,1000) group by id, address  order by id";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select distinct address  from t1 where  id IN (1,3,1000) ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select  address  from t1 where  id IN (1,3,1000)  group by address ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select type from t1 where  id IN (3,1,4,2,1000)  order by id ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            for (i = 21; i < 25; ++i) {
                rs.next();
                GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select type from t1 where  id IN (1,3,4,2,1000)  order by id desc ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            for (i = 24; i > 20; --i) {
                rs.next();
                GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "select type from t1 where  id IN (3,1,4,2,1000)  order by id asc ";
            rs = stmt.executeQuery(query);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            for (i = 21; i <= 24; ++i) {
                rs.next();
                GetAllLocalIndexQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40413_3() throws Exception {
        Connection systemconn;
        block5: {
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement s = conn.createStatement();
            s.execute("create table t1 ( id int, name varchar(10), type int primary key, address varchar(50))partition by primary key");
            s.execute("create INDEX t1index on t1(id)");
            s.execute("Insert into  t1 values(1,'asif',8, 'J 601')");
            s.execute("Insert into  t1 values(2,'neeraj',9, 'J 602')");
            s.execute("Insert into  t1 values(4,'sumedh',11, 'J 604')");
            s.execute("Insert into  t1 values(3,'shoubhik',10, 'J 603')");
            String query = "select substr(address,4,5),substr(name,1,2) from t1 where  id  IN (1,3,4) order by name desc";
            final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
            GemFireXDQueryObserver old = null;
            systemconn = TestUtil.getConnection();
            try {
                CallableStatement cusr = systemconn.prepareCall("call SYSCS_UTIL.SET_DATABASE_PROPERTY(?,?)");
                cusr.setString(1, "gemfirexd.enable-getall-local-index-embed-gfe");
                cusr.setString(2, "true");
                cusr.execute();
                cusr.close();
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            callbackInvoked[0] = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                            TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                            TestCase.assertTrue((boolean)sqi.isDynamic());
                            Object[] pks = (Object[])sqi.getPrimaryKey();
                            TestCase.assertNull((Object)pks);
                            try {
                                TestCase.assertFalse((boolean)sqi.createGFEActivation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)e.toString());
                            }
                        }
                    }

                    public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                        if (rs instanceof GemFireResultSet) {
                            callbackInvoked[1] = true;
                        }
                    }

                    public void getAllInvoked(int numElements) {
                        callbackInvoked[3] = true;
                    }

                    public void getAllLocalIndexExecuted() {
                        callbackInvoked[4] = true;
                    }

                    public void getAllLocalIndexInvoked(int numElements) {
                        callbackInvoked[2] = true;
                    }
                });
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((String)"04", (String)rs.getString(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"su", (String)rs.getString(2));
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((String)"03", (String)rs.getString(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"sh", (String)rs.getString(2));
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((String)"01", (String)rs.getString(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"as", (String)rs.getString(2));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                if (old == null) break block5;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                if (systemconn != null) {
                    systemconn.close();
                }
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        if (systemconn != null) {
            systemconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40413_4() throws Exception {
        Connection systemconn;
        block5: {
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement s1 = conn.createStatement();
            s1.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
            Statement s = conn.createStatement();
            s.execute("create table t1 ( id int, name varchar(10), type int primary key, address varchar(50))partition by primary key");
            s.execute("create INDEX t1index on t1(id)");
            s.execute("create index i1 on t1 (type)");
            s.execute("Insert into  t1 values(1,'asif',3, 'J 604')");
            s.execute("Insert into  t1 values(2,'neeraj',4, 'J 604')");
            s.execute("Insert into  t1 values(3,'shoubhik',5, 'J 604')");
            String query = "select type,TestUDF(name,1,4) from t1 where id IN (1,3) order by name desc";
            final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
            GemFireXDQueryObserver old = null;
            systemconn = TestUtil.getConnection();
            try {
                CallableStatement cusr = systemconn.prepareCall("call SYSCS_UTIL.SET_DATABASE_PROPERTY(?,?)");
                cusr.setString(1, "gemfirexd.enable-getall-local-index-embed-gfe");
                cusr.setString(2, "true");
                cusr.execute();
                cusr.close();
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            callbackInvoked[0] = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                            TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                            TestCase.assertTrue((boolean)sqi.isDynamic());
                            Object[] pks = (Object[])sqi.getPrimaryKey();
                            TestCase.assertNull((Object)pks);
                            try {
                                TestCase.assertFalse((boolean)sqi.createGFEActivation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)e.toString());
                            }
                        }
                    }

                    public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                        if (rs instanceof GemFireResultSet) {
                            callbackInvoked[1] = true;
                        }
                    }

                    public void getAllInvoked(int numElements) {
                        callbackInvoked[3] = true;
                    }

                    public void getAllLocalIndexExecuted() {
                        callbackInvoked[4] = true;
                    }

                    public void getAllLocalIndexInvoked(int numElements) {
                        callbackInvoked[2] = true;
                    }
                });
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)5, (int)rs.getInt(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"hou", (String)rs.getString(2));
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)3, (int)rs.getInt(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"sif", (String)rs.getString(2));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct address from t1 where  id IN (1,3) ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((String)"J 604", (String)rs.getString(1));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1,3) ";
                rs = stmt.executeQuery(query);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((String)"604", (String)rs.getString(1));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                if (old == null) break block5;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                if (systemconn != null) {
                    systemconn.close();
                }
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        if (systemconn != null) {
            systemconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testEQWithMultipleIndexes() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, did int, name varchar(10), type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertTrue((sqi.getParameterCount() == 1 || sqi.getParameterCount() == 2 ? 1 : 0) != 0);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)1, (int)numElements);
                }
            });
            s.execute("Insert into  t1 values(1, 1, 'a1111', 11)");
            s.execute("Insert into  t1 values(1, 2, 'a1222', 22)");
            s.execute("Insert into  t1 values(1, 3, 'a1333', 33)");
            s.execute("Insert into  t1 values(2, 1, 'a2121', 21)");
            String query = "select type, id, name from t1 where id = ?";
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 2);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(2));
            GetAllLocalIndexQueryDUnit.assertEquals((int)21, (int)rs.getInt(1));
            GetAllLocalIndexQueryDUnit.assertEquals((String)"a2121", (String)rs.getString(3));
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            rs.close();
            s.execute("create INDEX t2index on t1(id,did)");
            query = "select type, id, name from t1 where id = ? and did = ?";
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
            GetAllLocalIndexQueryDUnit.assertEquals((int)22, (int)rs.getInt(1));
            GetAllLocalIndexQueryDUnit.assertEquals((String)"a1222", (String)rs.getString(3));
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    public void _testINperf() throws Exception {
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        this.clientSQLExecute(1, "create INDEX t1index on t1(id)");
        for (int i = 0; i < 10000; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  t1 values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        Connection conn = TestUtil.getConnection();
        String query = "select type, id, name from t1 where id = ?";
        PreparedStatement ps1 = conn.prepareStatement(query);
        long starttime = System.nanoTime();
        int times = 100;
        for (int i = 0; i < times; ++i) {
            ps1.setInt(1, i + 1);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, time taken was " + diff + " ns"));
        conn = TestUtil.getConnection();
        query = "select type, id, name from t1 where id IN (?,?)";
        ps1 = conn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        int insize = 2;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            ResultSet rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
        }
        long endtime2 = System.nanoTime();
        long diff2 = endtime2 - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff2 + " ns"));
        conn = TestUtil.getConnection();
        query = "select type, id, name from t1 where id IN (?,?,?,?,?)";
        ps1 = conn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        insize = 5;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            ResultSet rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
        }
        endtime = System.nanoTime();
        diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
    }

    public void _testINperf_thinClient() throws Exception {
        this.startServerVMs(3, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
        this.clientSQLExecute(1, "create INDEX t1index on t1(id)");
        for (int i = 0; i < 10000; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  t1 values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        String query = "select type, id, name from t1 where id = ?";
        PreparedStatement ps1 = conn.prepareStatement(query);
        long starttime = System.nanoTime();
        int times = 100;
        for (int i = 0; i < times; ++i) {
            ps1.setInt(1, i + 1);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, time taken was " + diff + " ns"));
        conn = TestUtil.getNetConnection(clientPort, null, null);
        query = "select type, id, name from t1 where id IN (?,?)";
        ps1 = conn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        int insize = 2;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            ResultSet rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
        }
        long endtime2 = System.nanoTime();
        long diff2 = endtime2 - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff2 + " ns"));
        conn = TestUtil.getNetConnection(clientPort, null, null);
        query = "select type, id, name from t1 where id IN (?,?,?,?,?)";
        ps1 = conn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        insize = 5;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            ResultSet rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
        }
        endtime = System.nanoTime();
        diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug48246() throws Exception {
        Connection systemconn;
        block8: {
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement s = conn.createStatement();
            s.execute("create schema trade");
            s.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle int not null, c_id int not null, c_last int not null, c_d_id int not null, c_w_id int not null) partition by column (c_balance)");
            s.execute("alter table trade.customer add constraint trade.pk_customer primary key (c_w_id, c_d_id, c_id)");
            s.execute("create index trade.ndx_customer_name  on trade.customer (c_w_id, c_d_id, c_last)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?, ?, ?, ?)");
            for (int i = 0; i < 3; ++i) {
                psInsert.setInt(1, i * 1);
                psInsert.setInt(2, i * 2);
                psInsert.setInt(3, i * 3);
                psInsert.setInt(4, i * 4);
                psInsert.setInt(5, 5);
                psInsert.setInt(6, 6);
                psInsert.setInt(7, 7);
                psInsert.executeUpdate();
            }
            String query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_last = ? AND c_d_id = ? AND c_w_id = ? ORDER BY c_w_id, c_d_id, c_last, c_first";
            final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
            GemFireXDQueryObserver old = null;
            systemconn = TestUtil.getConnection();
            try {
                CallableStatement cusr = systemconn.prepareCall("call SYSCS_UTIL.SET_DATABASE_PROPERTY(?,?)");
                cusr.setString(1, "gemfirexd.enable-getall-local-index-embed-gfe");
                cusr.setString(2, "true");
                cusr.execute();
                cusr.close();
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            callbackInvoked[0] = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                            TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                            TestCase.assertTrue((boolean)sqi.isDynamic());
                            TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                            Object[] pks = (Object[])sqi.getPrimaryKey();
                            TestCase.assertNull((Object)pks);
                            try {
                                TestCase.assertFalse((boolean)sqi.createGFEActivation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)e.toString());
                            }
                        }
                    }

                    public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                        if (rs instanceof GemFireResultSet) {
                            callbackInvoked[1] = true;
                        }
                    }

                    public void getAllInvoked(int numElements) {
                        callbackInvoked[3] = true;
                    }

                    public void getAllLocalIndexExecuted() {
                        callbackInvoked[4] = true;
                    }

                    public void getAllLocalIndexInvoked(int numElements) {
                        callbackInvoked[2] = true;
                        TestCase.assertEquals((int)1, (int)numElements);
                    }
                });
                PreparedStatement ps1 = conn.prepareStatement(query);
                for (int i = 0; i < 5; ++i) {
                    ps1.setInt(1, 5);
                    ps1.setInt(2, 6);
                    ps1.setInt(3, 7);
                    ResultSet rs = ps1.executeQuery();
                    GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                    GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                    GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                    int count = 0;
                    while (rs.next()) {
                        GetAllLocalIndexQueryDUnit.assertEquals((int)count, (int)rs.getInt(2));
                        count += 2;
                    }
                    GetAllLocalIndexQueryDUnit.assertEquals((int)6, (int)count);
                    GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                    GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                    rs.close();
                }
                if (old == null) break block8;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                if (systemconn != null) {
                    systemconn.close();
                }
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        if (systemconn != null) {
            systemconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug48233_48380() throws Exception {
        int i;
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle varchar(10), c_id int not null, c_last int not null, c_d_id int not null, c_w_id int not null) partition by column (c_balance)");
        s.execute("alter table trade.customer add constraint trade.pk_customer primary key (c_w_id, c_d_id, c_id)");
        s.execute("create index trade.ndx_customer_name  on trade.customer (c_w_id, c_d_id, c_last)");
        s.execute("create index trade.ndx_customer_balance  on trade.customer (c_balance)");
        String[] securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?, ?, ?, ?)");
        for (i = 0; i < 5; ++i) {
            psInsert.setInt(1, 1);
            psInsert.setInt(2, i * 2);
            psInsert.setString(3, securities[i % 9]);
            psInsert.setInt(4, i * 4);
            psInsert.setInt(5, 5);
            psInsert.setInt(6, 6);
            psInsert.setInt(7, 7);
            psInsert.executeUpdate();
        }
        s.execute("create table trade.portfolio (c_balance int not null, c_first int not null, c_middle varchar(10), c_id int primary key, c_last int not null, c_d_id int not null, c_w_id int not null) partition by primary key");
        securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        psInsert = conn.prepareStatement("insert into trade.portfolio values (?, ?, ?, ?, ?, ?, ?)");
        for (i = 0; i < 5; ++i) {
            psInsert.setInt(1, 1);
            psInsert.setInt(2, i * 2);
            psInsert.setString(3, securities[i % 9]);
            psInsert.setInt(4, i * 4);
            psInsert.setInt(5, 5);
            psInsert.setInt(6, 6);
            psInsert.setInt(7, 7);
            psInsert.executeUpdate();
        }
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertFalse((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)2, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)1, (int)numElements);
                }
            });
            String query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_first = ?";
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            int count = 0;
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
            }
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)count);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? offset ? row fetch first row only";
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            count = 0;
            while (rs.next()) {
                ++count;
                GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(1));
            }
            GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)count);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_middle like ?";
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setString(2, "M%");
            rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            count = 0;
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
            }
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)count);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            callbackInvoked[3] = false;
            callbackInvoked[4] = false;
            query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_id IN (select c_id from trade.portfolio where c_first = ? )";
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 4);
            rs = ps1.executeQuery();
            count = 0;
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 4), (int)rs.getInt(2));
            }
            GetAllLocalIndexQueryDUnit.assertEquals((int)4, (int)count);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    private static byte[] getByteArray(int arrayLength) {
        byte[] byteArray = new byte[arrayLength];
        for (int j = 0; j < arrayLength; ++j) {
            byteArray[j] = (byte)(j % 256);
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug49028() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name blob, type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            Blob blob;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[3] = true;
                }

                public void getAllLocalIndexExecuted() {
                    callbackInvoked[4] = true;
                }

                public void getAllLocalIndexInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            PreparedStatement psInsert = conn.prepareStatement("insert into t1 values (?, ?, ?)");
            for (int i = 0; i < 10; ++i) {
                psInsert.setInt(1, i % 4);
                psInsert.setBlob(2, new SerialBlob(GetAllLocalIndexQueryDUnit.getByteArray(10000)));
                psInsert.setInt(3, i);
                psInsert.executeUpdate();
            }
            String query = "select type, name from t1 where id IN (?,?,?)";
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            int count = 0;
            while (rs.next()) {
                GetAllLocalIndexQueryDUnit.assertTrue((rs.getInt(1) > 0 ? 1 : 0) != 0);
                blob = rs.getBlob(2);
                GetAllLocalIndexQueryDUnit.assertTrue((blob.length() > 0L ? 1 : 0) != 0);
                TestUtil.convertByteArrayToString(blob.getBytes(1L, (int)blob.length()));
                ++count;
            }
            GetAllLocalIndexQueryDUnit.assertEquals((int)7, (int)count);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            rs.close();
            query = "select name from t1 where id IN (?,?,?)";
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            rs = ps1.executeQuery();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            count = 0;
            while (rs.next()) {
                blob = rs.getBlob(1);
                GetAllLocalIndexQueryDUnit.assertTrue((blob.length() > 0L ? 1 : 0) != 0);
                TestUtil.convertByteArrayToString(blob.getBytes(1L, (int)blob.length()));
                ++count;
            }
            GetAllLocalIndexQueryDUnit.assertEquals((int)7, (int)count);
            GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49028_thinClient() throws Exception {
        Blob blob;
        this.startVMs(0, 4, 0, null, null);
        int netPort = this.startNetworkServer(1, null, null);
        TestUtil.loadNetDriver();
        Properties connSHOPProps = new Properties();
        connSHOPProps.setProperty("single-hop-enabled", "false");
        connSHOPProps.setProperty("single-hop-max-connections", "5");
        String logLevel = this.getLogLevel();
        connSHOPProps.setProperty("log-level", logLevel);
        if (logLevel.startsWith("fine")) {
            connSHOPProps.setProperty("gemfirexd.debug.true", "TraceSingleHop");
        }
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort);
        Connection conn = DriverManager.getConnection(url, TestUtil.getNetProperties(connSHOPProps));
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int, name blob, type int primary key) partition by primary key");
        s.execute("create INDEX t1index on t1(id)");
        PreparedStatement psInsert = conn.prepareStatement("insert into t1 values (?, ?, ?)");
        for (int i = 0; i < 10; ++i) {
            psInsert.setInt(1, i % 4);
            psInsert.setBlob(2, new SerialBlob(GetAllLocalIndexQueryDUnit.getByteArray(10000)));
            psInsert.setInt(3, i);
            psInsert.executeUpdate();
        }
        String query = "select type, name from t1 where id IN (?,?,?)";
        PreparedStatement ps1 = conn.prepareStatement(query);
        ps1.setInt(1, 1);
        ps1.setInt(2, 2);
        ps1.setInt(3, 3);
        ResultSet rs = ps1.executeQuery();
        int count = 0;
        while (rs.next()) {
            GetAllLocalIndexQueryDUnit.assertTrue((String)("count=" + count), (rs.getInt(1) > 0 ? 1 : 0) != 0);
            blob = rs.getBlob(2);
            GetAllLocalIndexQueryDUnit.assertTrue((String)("count=" + count), (blob.length() > 0L ? 1 : 0) != 0);
            TestUtil.convertByteArrayToString(blob.getBytes(1L, (int)blob.length()));
            ++count;
        }
        GetAllLocalIndexQueryDUnit.assertEquals((int)7, (int)count);
        rs.close();
        query = "select name from t1 where id IN (?,?,?)";
        ps1 = conn.prepareStatement(query);
        ps1.setInt(1, 1);
        ps1.setInt(2, 2);
        ps1.setInt(3, 3);
        rs = ps1.executeQuery();
        count = 0;
        while (rs.next()) {
            blob = rs.getBlob(1);
            GetAllLocalIndexQueryDUnit.assertTrue((String)("count=" + count), (blob.length() > 0L ? 1 : 0) != 0);
            TestUtil.convertByteArrayToString(blob.getBytes(1L, (int)blob.length()));
            ++count;
        }
        GetAllLocalIndexQueryDUnit.assertEquals((int)7, (int)count);
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug51466() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table test (col1 int, col2 int, col3 int) partition by range (col1)(VALUES BETWEEN 0 AND 3, VALUES BETWEEN 3 AND 5)");
        st.execute("create index test_index on test(col3)");
        st.execute("create view test_v1 as select * from test");
        st.execute("create view test_v2 as select * from test_v1");
        st.execute("insert into test values(1,1,1), (2,2,2), (3,3,3), (4,4,4), (5,5,5)");
        GemFireXDQueryObserver old = null;
        try {
            final boolean[] getAllInvoked = new boolean[]{false};
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void getAllLocalIndexExecuted() {
                    getAllInvoked[0] = true;
                }
            });
            ResultSet rs1 = st.executeQuery("select col2 from test_v1 where col3 = 2");
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs1.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs1.getInt(1));
            rs1.close();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)getAllInvoked[0]);
            getAllInvoked[0] = false;
            ResultSet rs2 = st.executeQuery("select col2 from test_v2 where col3 = 4");
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs2.next());
            GetAllLocalIndexQueryDUnit.assertEquals((int)4, (int)rs2.getInt(1));
            rs2.close();
            GetAllLocalIndexQueryDUnit.assertTrue((boolean)getAllInvoked[0]);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug51466_reExecute() throws Exception {
        block3: {
            this.startVMs(1, 2);
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create table test (col1 int, col2 int, col3 int) partition by range (col1)(VALUES BETWEEN 0 AND 3, VALUES BETWEEN 3 AND 5)");
            st.execute("create index test_index on test(col3)");
            st.execute("create view test_v1 as select * from test");
            st.execute("create view test_v2 as select * from test_v1");
            st.execute("insert into test values(1,1,1), (2,2,2), (3,3,3), (4,4,4), (5,5,5)");
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
                GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
                    }
                });
                final boolean[] getAllInvoked = new boolean[]{false};
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void getAllLocalIndexExecuted() {
                        getAllInvoked[0] = true;
                    }
                });
                ResultSet rs1 = st.executeQuery("select col2 from test_v1 where col3 = 2");
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs1.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs1.getInt(1));
                rs1.close();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)getAllInvoked[0]);
                getAllInvoked[0] = false;
                ResultSet rs2 = st.executeQuery("select col2 from test_v2 where col3 = 4");
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs2.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)4, (int)rs2.getInt(1));
                rs2.close();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)getAllInvoked[0]);
                getAllInvoked[0] = false;
                rs1 = st.executeQuery("select col2 from test_v1 where col3 = 2");
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs1.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs1.getInt(1));
                rs1.close();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)getAllInvoked[0]);
                getAllInvoked[0] = false;
                rs2 = st.executeQuery("select col2 from test_v2 where col3 = 4");
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs2.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)4, (int)rs2.getInt(1));
                rs2.close();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)getAllInvoked[0]);
                if (old == null) break block3;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
                GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
                    }
                });
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
        GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testINWithMultipleParameters_reExecute() throws Exception {
        block3: {
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement s = conn.createStatement();
            s.execute("create table t1 ( id int, name varchar(10), type int primary key) partition by primary key");
            s.execute("create INDEX t1index on t1(id)");
            String query = "select type, id, name from t1 where id IN (?,?,?)";
            final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
                GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
                    }
                });
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            callbackInvoked[0] = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                            TestCase.assertTrue((boolean)sqi.isGetAllOnLocalIndex());
                            TestCase.assertTrue((boolean)sqi.isDynamic());
                            TestCase.assertEquals((int)3, (int)sqi.getParameterCount());
                            Object[] pks = (Object[])sqi.getPrimaryKey();
                            TestCase.assertNull((Object)pks);
                            try {
                                TestCase.assertTrue((boolean)sqi.createGFEActivation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)e.toString());
                            }
                        }
                    }

                    public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                        if (rs instanceof GemFireResultSet) {
                            callbackInvoked[1] = true;
                        }
                    }

                    public void getAllInvoked(int numElements) {
                        callbackInvoked[3] = true;
                    }

                    public void getAllLocalIndexExecuted() {
                        callbackInvoked[4] = true;
                    }

                    public void getAllLocalIndexInvoked(int numElements) {
                        callbackInvoked[2] = true;
                        TestCase.assertEquals((int)3, (int)numElements);
                    }
                });
                PreparedStatement ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setInt(2, 2);
                ps1.setInt(3, 3);
                s.execute("Insert into  t1 values(1,'asif',2)");
                ResultSet rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"asif", (String)rs.getString(3));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"asif", (String)rs.getString(3));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(2));
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)rs.getInt(1));
                GetAllLocalIndexQueryDUnit.assertEquals((String)"asif", (String)rs.getString(3));
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)rs.next());
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[4]);
                rs.close();
                if (old == null) break block3;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
                GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
                    }
                });
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
        GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug48233_48380_reExecute() throws Exception {
        block13: {
            int i;
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement s = conn.createStatement();
            s.execute("create schema trade");
            s.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle varchar(10), c_id int not null, c_last int not null, c_d_id int not null, c_w_id int not null) partition by column (c_balance)");
            s.execute("alter table trade.customer add constraint trade.pk_customer primary key (c_w_id, c_d_id, c_id)");
            s.execute("create index trade.ndx_customer_name  on trade.customer (c_w_id, c_d_id, c_last)");
            s.execute("create index trade.ndx_customer_balance  on trade.customer (c_balance)");
            String[] securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?, ?, ?, ?)");
            for (i = 0; i < 5; ++i) {
                psInsert.setInt(1, 1);
                psInsert.setInt(2, i * 2);
                psInsert.setString(3, securities[i % 9]);
                psInsert.setInt(4, i * 4);
                psInsert.setInt(5, 5);
                psInsert.setInt(6, 6);
                psInsert.setInt(7, 7);
                psInsert.executeUpdate();
            }
            s.execute("create table trade.portfolio (c_balance int not null, c_first int not null, c_middle varchar(10), c_id int primary key, c_last int not null, c_d_id int not null, c_w_id int not null) partition by primary key");
            securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
            psInsert = conn.prepareStatement("insert into trade.portfolio values (?, ?, ?, ?, ?, ?, ?)");
            for (i = 0; i < 5; ++i) {
                psInsert.setInt(1, 1);
                psInsert.setInt(2, i * 2);
                psInsert.setString(3, securities[i % 9]);
                psInsert.setInt(4, i * 4);
                psInsert.setInt(5, 5);
                psInsert.setInt(6, 6);
                psInsert.setInt(7, 7);
                psInsert.executeUpdate();
            }
            final boolean[] callbackInvoked = new boolean[]{false, false, false, false, false};
            GemFireXDQueryObserver old = null;
            try {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
                GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
                    }
                });
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                        if (qInfo instanceof SelectQueryInfo) {
                            callbackInvoked[0] = true;
                            TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                            TestCase.assertFalse((boolean)sqi.isGetAllOnLocalIndex());
                            TestCase.assertTrue((boolean)sqi.isDynamic());
                            TestCase.assertEquals((int)2, (int)sqi.getParameterCount());
                            Object[] pks = (Object[])sqi.getPrimaryKey();
                            TestCase.assertNull((Object)pks);
                            try {
                                TestCase.assertTrue((boolean)sqi.createGFEActivation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)e.toString());
                            }
                        }
                    }

                    public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                        if (rs instanceof GemFireResultSet) {
                            callbackInvoked[1] = true;
                        }
                    }

                    public void getAllInvoked(int numElements) {
                        callbackInvoked[3] = true;
                    }

                    public void getAllLocalIndexExecuted() {
                        callbackInvoked[4] = true;
                    }

                    public void getAllLocalIndexInvoked(int numElements) {
                        callbackInvoked[2] = true;
                        TestCase.assertEquals((int)1, (int)numElements);
                    }
                });
                String query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_first = ?";
                PreparedStatement ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setInt(2, 2);
                ResultSet rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                int count = 0;
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)count);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? offset ? row fetch first row only";
                ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setInt(2, 2);
                rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                count = 0;
                while (rs.next()) {
                    ++count;
                    GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(1));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)count);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_middle like ?";
                ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setString(2, "M%");
                rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                count = 0;
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)count);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_id IN (select c_id from trade.portfolio where c_first = ? )";
                ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setInt(2, 4);
                rs = ps1.executeQuery();
                count = 0;
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 4), (int)rs.getInt(2));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)4, (int)count);
                GetAllLocalIndexQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_first = ?";
                ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setInt(2, 2);
                rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                count = 0;
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)count);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? offset ? row fetch first row only";
                ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setInt(2, 2);
                rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                count = 0;
                while (rs.next()) {
                    ++count;
                    GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)rs.getInt(1));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)1, (int)count);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_middle like ?";
                ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setString(2, "M%");
                rs = ps1.executeQuery();
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                count = 0;
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)2, (int)count);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[3]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[4]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                callbackInvoked[3] = false;
                callbackInvoked[4] = false;
                query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_balance = ? AND c_id IN (select c_id from trade.portfolio where c_first = ? )";
                ps1 = conn.prepareStatement(query);
                ps1.setInt(1, 1);
                ps1.setInt(2, 4);
                rs = ps1.executeQuery();
                count = 0;
                while (rs.next()) {
                    GetAllLocalIndexQueryDUnit.assertEquals((int)(count += 4), (int)rs.getInt(2));
                }
                GetAllLocalIndexQueryDUnit.assertEquals((int)4, (int)count);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
                GetAllLocalIndexQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                rs.close();
                callbackInvoked[0] = false;
                callbackInvoked[1] = false;
                callbackInvoked[2] = false;
                if (old == null) break block13;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
                GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
                    }
                });
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
        GetAllLocalIndexQueryDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
    }

    public static class TestBug40413_2_RowLoader
    extends TestRowLoader {
        @Override
        public Object getRow(String schemaName, String tableName, Object[] primaryKey) throws SQLException {
            SanityManager.DEBUG_PRINT((String)"GfxdTestRowLoader", (String)("load called with key=" + primaryKey[0] + " in VM " + Misc.getDistributedSystem().getDistributedMember()));
            if (primaryKey[0].equals(1000)) {
                return new Object[]{1000, "rowLoad", 25, "J 604"};
            }
            return null;
        }
    }
}

