/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.PrimaryDynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.TestCase;

public class GetAllConvertibleQueryDUnit
extends DistributedSQLTestBase {
    private static boolean changeDefaultTestProperties = false;
    static boolean[] remoteCallbackInvoked = new boolean[]{false, false, false};

    @Override
    protected String reduceLogging() {
        if (changeDefaultTestProperties) {
            return "config";
        }
        return super.reduceLogging();
    }

    public GetAllConvertibleQueryDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleParameters() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)3);
                        for (int i = 0; i < pks.length; ++i) {
                            TestCase.assertTrue((boolean)(pks[i] instanceof PrimaryDynamicKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            s.execute("Insert into  t1 values(1,'asif',2)");
            rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(2), (int)1);
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)2);
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(3), (String)"asif");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testINWithMultipleParameters_ThinClient() throws Exception {
        this.startVMs(1, 3);
        Properties props = new Properties();
        props.setProperty("log-level", this.getLogLevel());
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, props);
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        GemFireXDQueryObserverAdapter getAllObserver = new GemFireXDQueryObserverAdapter(){

            public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                if (qInfo instanceof SelectQueryInfo) {
                    GetAllConvertibleQueryDUnit.remoteCallbackInvoked[0] = true;
                    TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                    SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                    TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                    TestCase.assertTrue((boolean)sqi.isDynamic());
                    TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                    Object[] pks = (Object[])sqi.getPrimaryKey();
                    TestCase.assertEquals((int)pks.length, (int)3);
                    for (int i = 0; i < pks.length; ++i) {
                        TestCase.assertTrue((boolean)(pks[i] instanceof PrimaryDynamicKey));
                    }
                    try {
                        TestCase.assertTrue((boolean)sqi.createGFEActivation());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestCase.fail((String)e.toString());
                    }
                }
            }

            public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                if (rs instanceof GemFireResultSet) {
                    GetAllConvertibleQueryDUnit.remoteCallbackInvoked[1] = true;
                }
            }

            public void getAllInvoked(int numElements) {
                GetAllConvertibleQueryDUnit.remoteCallbackInvoked[2] = true;
                TestCase.assertEquals((int)3, (int)numElements);
            }
        };
        SerializableRunnable getAllObsSet = new SerializableRunnable("Set GetAll Observer", (GemFireXDQueryObserver)getAllObserver){
            final /* synthetic */ GemFireXDQueryObserver val$getAllObserver;
            {
                this.val$getAllObserver = gemFireXDQueryObserver;
                super(x0);
            }

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$getAllObserver);
            }
        };
        SerializableRunnable getAllObsReset = new SerializableRunnable("Reset GetAll Observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){});
            }
        };
        SerializableRunnable getAllObsVerify = new SerializableRunnable("Verify GetAll Observer"){

            public void run() throws CacheException {
                TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                TestCase.assertTrue((boolean)remoteCallbackInvoked[2]);
            }
        };
        try {
            this.serverExecute(1, (Runnable)getAllObsSet);
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            this.serverExecute(1, (Runnable)getAllObsVerify);
            s.execute("Insert into  t1 values(1,'asif',2)");
            rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(2), (int)1);
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)2);
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(3), (String)"asif");
            this.serverExecute(1, (Runnable)getAllObsVerify);
            rs.close();
        }
        finally {
            this.serverExecute(1, (Runnable)getAllObsReset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleParameters_Replicated() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int) replicate");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ps1.setInt(3, 3);
            ResultSet rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            s.execute("Insert into  t1 values(1,'asif',2)");
            rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(2), (int)1);
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)2);
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(3), (String)"asif");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleParametersAndDuplicateKeys() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (?,?,?)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)3);
                        for (int i = 0; i < pks.length; ++i) {
                            TestCase.assertTrue((boolean)(pks[i] instanceof PrimaryDynamicKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)1, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 1);
            ps1.setInt(3, 1);
            ResultSet rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(2), (int)1);
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)2);
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(3), (String)"asif");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithConstantAndParameterizedFields() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10), type int)");
        s.execute("Insert into  t1 values(1,'asif',2)");
        String query = "select type, id, name from t1 where id IN (?,?,3,4)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)2);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)4);
                        for (int i = 0; i < pks.length; ++i) {
                            if (i < 2) {
                                TestCase.assertTrue((boolean)(pks[i] instanceof PrimaryDynamicKey));
                                continue;
                            }
                            TestCase.assertTrue((boolean)(pks[i] instanceof RegionKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)4, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 1);
            ps1.setInt(2, 2);
            ResultSet rs = ps1.executeQuery();
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(2), (int)1);
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)2);
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(3), (String)"asif");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testINWithMultipleConstantFields() throws Exception {
        this.startVMs(1, 3);
        Properties props = new Properties();
        props.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(props);
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int primary key, name varchar(10))");
        s.execute("Insert into  t1 values(1, 'asif')");
        GfxdCallbacksTest.addLoader(null, "t1", "com.pivotal.gemfirexd.jdbc.TestRowLoader", "");
        String query = "select id, name from t1 where id IN (1, 2, 1000, 2000)";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertFalse((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)0);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)4, (int)pks.length);
                        for (int i = 0; i < pks.length; ++i) {
                            TestCase.assertTrue((boolean)(pks[i] instanceof RegionKey));
                        }
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)4, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            ResultSet rs = ps1.executeQuery();
            HashSet<String> hashs = new HashSet<String>();
            hashs.add("asif");
            hashs.add("Mark Black");
            HashSet<Integer> hashi = new HashSet<Integer>();
            hashi.add(1);
            hashi.add(1000);
            while (rs.next()) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)hashi.remove(rs.getInt(1)));
                GetAllConvertibleQueryDUnit.assertTrue((boolean)hashs.remove(rs.getString(2)));
            }
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_1() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        s.execute("Insert into  t1 values(4,'eric',2, 'J 604')");
        String query = "select substr(name,1,2) from t1 where  id IN (1,1)";
        GemFireXDQueryObserver old = null;
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        try {
            int i;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                }
            });
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            HashSet<String> hash = new HashSet<String>();
            hash.add("as");
            while (rs.next()) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)hash.remove(rs.getString(1)));
            }
            GetAllConvertibleQueryDUnit.assertTrue((boolean)hash.isEmpty());
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1, 3)";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(1), (String)"604");
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) order by id  asc , address desc";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) group by id, address   order by id ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  distinct type, AVG(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            rs.close();
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  distinct type, AVG(type), MAX(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  address, id  from t1 where  id IN (1,3) group by id, address  order by id";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct address  from t1 where  id IN (1,3) ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  address  from t1 where  id IN (1,3)  group by address ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  id  from t1 where  id IN (1,3,4,2)  order by id desc ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            for (i = 4; i > 0; --i) {
                rs.next();
                GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id asc ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_2() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        GfxdCallbacksTest.addLoader(null, "t1", "com.pivotal.gemfirexd.jdbc.TestRowLoader", "");
        s.execute("Insert into  t1 values(1,'asif',2, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',2, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',2, 'J 604')");
        s.execute("Insert into  t1 values(4,'eric',2, 'J 604')");
        String query = "select substr(name,1,2) from t1 where  id = 1";
        GemFireXDQueryObserver old = null;
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        try {
            int i;
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                }
            });
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            HashSet<String> hash = new HashSet<String>();
            hash.add("as");
            while (rs.next()) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)hash.remove(rs.getString(1)));
            }
            GetAllConvertibleQueryDUnit.assertTrue((boolean)hash.isEmpty());
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1, 3)";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(1), (String)"604");
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) order by id  asc , address desc";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct address, id  from t1 where  id IN (1,3) group by id, address   order by id ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  distinct type, AVG(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  distinct type, AVG(type), MAX(type)  from t1 where id IN (1,3) group by type order by AVG(type) desc ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  address, id  from t1 where  id IN (1,3) group by id, address  order by id";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct address  from t1 where  id IN (1,3) ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  address  from t1 where  id IN (1,3)  group by address ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  id  from t1 where  id IN (1,3,4,2)  order by id desc ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            for (i = 4; i > 0; --i) {
                rs.next();
                GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select  id  from t1 where  id IN (3,1,4,2)  order by id asc ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            for (i = 1; i < 5; ++i) {
                rs.next();
                GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)i);
            }
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_3() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("Insert into  t1 values(1,'asif',8, 'J 601')");
        s.execute("Insert into  t1 values(2,'neeraj',9, 'J 602')");
        s.execute("Insert into  t1 values(4,'sumedh',11, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',10, 'J 603')");
        String query = "select substr(address,4,5),substr(name,1,2) from t1 where  id  IN (1,3,4) order by name desc";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                }
            });
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(1), (String)"04");
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(2), (String)"su");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(1), (String)"03");
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(2), (String)"sh");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(1), (String)"01");
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(2), (String)"as");
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug40413_4() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s1 = conn.createStatement();
        s1.execute("create function TestUDF(str varchar(100), startIndex integer, endIndex integer) returns varchar(100) parameter style java no sql language java external name 'com.pivotal.gemfirexd.functions.TestFunctions.substring'");
        Statement s = conn.createStatement();
        s.execute("create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id ))");
        s.execute("create index i1 on t1 (type)");
        s.execute("Insert into  t1 values(1,'asif',3, 'J 604')");
        s.execute("Insert into  t1 values(2,'neeraj',4, 'J 604')");
        s.execute("Insert into  t1 values(3,'shoubhik',5, 'J 604')");
        String query = "select type,TestUDF(name,1,4) from t1 where id IN (1,3) order by name desc";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                }
            });
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            rs.next();
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)5);
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(2), (String)"hou");
            rs.next();
            GetAllConvertibleQueryDUnit.assertEquals((int)rs.getInt(1), (int)3);
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(2), (String)"sif");
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct address from t1 where  id IN (1,3) ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            rs.next();
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(1), (String)"J 604");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "select distinct TestUDF(address,2,5)  from t1 where id IN (1,3) ";
            rs = stmt.executeQuery(query);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            rs.next();
            GetAllConvertibleQueryDUnit.assertEquals((String)rs.getString(1), (String)"604");
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug48246() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle int not null, c_id int primary key)  partition by primary key");
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?)");
        for (int i = 0; i < 3; ++i) {
            psInsert.setInt(1, i * 1);
            psInsert.setInt(2, i * 2);
            psInsert.setInt(3, i * 3);
            psInsert.setInt(4, i * 4);
            psInsert.executeUpdate();
        }
        String query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_id in (?, ?, ?) ORDER BY c_balance, c_first, c_middle, c_id";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)3);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertEquals((int)pks.length, (int)3);
                        for (int i = 0; i < pks.length; ++i) {
                            TestCase.assertTrue((boolean)(pks[i] instanceof PrimaryDynamicKey));
                        }
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            for (int i = 0; i < 5; ++i) {
                ps1.setInt(1, 0);
                ps1.setInt(2, 4);
                ps1.setInt(3, 8);
                ResultSet rs = ps1.executeQuery();
                int count = 0;
                while (rs.next()) {
                    GetAllConvertibleQueryDUnit.assertEquals((int)count, (int)rs.getInt(4));
                    count += 4;
                }
                GetAllConvertibleQueryDUnit.assertEquals((int)12, (int)count);
                GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[2]);
                rs.close();
            }
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug48246_get_noGetAll() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle int not null, c_id int primary key)  partition by primary key");
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?)");
        for (int i = 0; i < 3; ++i) {
            psInsert.setInt(1, i * 1);
            psInsert.setInt(2, i * 2);
            psInsert.setInt(3, i * 3);
            psInsert.setInt(4, i * 4);
            psInsert.executeUpdate();
        }
        String query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_id = ? ORDER BY c_balance, c_first, c_middle, c_id";
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)1);
                        Object pks = sqi.getPrimaryKey();
                        TestCase.assertTrue((pks != null ? 1 : 0) != 0);
                        try {
                            TestCase.assertFalse((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)1, (int)numElements);
                }
            });
            PreparedStatement ps1 = conn.prepareStatement(query);
            for (int i = 0; i < 3; ++i) {
                ps1.setInt(1, i * 4);
                ResultSet rs = ps1.executeQuery();
                int count = 0;
                while (rs.next()) {
                    GetAllConvertibleQueryDUnit.assertEquals((int)(i * 4), (int)rs.getInt(4));
                    ++count;
                }
                GetAllConvertibleQueryDUnit.assertEquals((int)1, (int)count);
                GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
                GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[1]);
                GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
                rs.close();
            }
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }

    public void _testINperf() throws Exception {
        ResultSet rs;
        this.startServerVMs(3, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table t1 ( id int primary key, name varchar(10), type int)");
        for (int i = 0; i < 10000; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  t1 values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        String query = "select type, id, name from t1 where id IN (?,?,?,?,?,?)";
        PreparedStatement ps1 = TestUtil.jdbcConn.prepareStatement(query);
        long starttime = System.nanoTime();
        int times = 100;
        int insize = 6;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
        query = "select type, id, name from t1 where id IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ps1 = TestUtil.jdbcConn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        insize = 30;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
        }
        endtime = System.nanoTime();
        diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
        query = "select type, id, name from t1 where id IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ps1 = TestUtil.jdbcConn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        insize = 60;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
        }
        endtime = System.nanoTime();
        diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
    }

    public void _testINperf_thinClient() throws Exception {
        ResultSet rs;
        this.startServerVMs(3, 0, "SG2");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table t1 ( id int primary key, name varchar(10), type int)");
        for (int i = 0; i < 10000; ++i) {
            String s = "n" + i;
            this.clientSQLExecute(1, "Insert into  t1 values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        int clientPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(clientPort, null, null);
        String query = "select type, id, name from t1 where id IN (?,?,?,?,?,?)";
        PreparedStatement ps1 = conn.prepareStatement(query);
        long starttime = System.nanoTime();
        int times = 100;
        int insize = 6;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
        }
        long endtime = System.nanoTime();
        long diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
        query = "select type, id, name from t1 where id IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ps1 = conn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        insize = 30;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
        }
        endtime = System.nanoTime();
        diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
        query = "select type, id, name from t1 where id IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ps1 = conn.prepareStatement(query);
        starttime = System.nanoTime();
        times = 100;
        insize = 60;
        for (int i = 0; i < times; ++i) {
            for (int j = 0; j < insize; ++j) {
                ps1.setInt(j + 1, i + j);
            }
            rs = ps1.executeQuery();
            for (int j = 0; j < insize; ++j) {
                GetAllConvertibleQueryDUnit.assertTrue((boolean)rs.next());
            }
            GetAllConvertibleQueryDUnit.assertFalse((boolean)rs.next());
        }
        endtime = System.nanoTime();
        diff = endtime - starttime;
        this.getLogWriter().info((Object)("logTestINperf: for executing " + query + " " + times + " times, with in list size " + insize + " time taken was " + diff + " ns"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testBug48223_48380() throws Exception {
        int i;
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customer (c_balance int not null, c_first int not null, c_middle varchar(10), c_id int not null, c_last int not null, c_d_id int not null, c_w_id int not null, constraint trade.pk_customer primary key (c_w_id, c_d_id, c_id)) partition by primary key");
        String[] securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?, ?, ?, ?)");
        for (i = 0; i < 5; ++i) {
            psInsert.setInt(1, 1);
            psInsert.setInt(2, i * 2);
            psInsert.setString(3, securities[i % 9]);
            psInsert.setInt(4, i * 4);
            psInsert.setInt(5, 5);
            psInsert.setInt(6, 6);
            psInsert.setInt(7, 7);
            psInsert.executeUpdate();
        }
        s.execute("create table trade.portfolio (c_balance int not null, c_first int primary key, c_middle varchar(10), c_id int not null, c_last int not null, c_d_id int not null, c_w_id int not null) partition by primary key");
        securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        psInsert = conn.prepareStatement("insert into trade.portfolio values (?, ?, ?, ?, ?, ?, ?)");
        for (i = 0; i < 5; ++i) {
            psInsert.setInt(1, 1);
            psInsert.setInt(2, i * 2);
            psInsert.setString(3, securities[i % 9]);
            psInsert.setInt(4, i * 4);
            psInsert.setInt(5, 5);
            psInsert.setInt(6, 6);
            psInsert.setInt(7, 7);
            psInsert.executeUpdate();
        }
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        callbackInvoked[0] = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertFalse((boolean)sqi.isPrimaryKeyBased());
                        TestCase.assertTrue((boolean)sqi.isDynamic());
                        TestCase.assertEquals((int)sqi.getParameterCount(), (int)4);
                        Object[] pks = (Object[])sqi.getPrimaryKey();
                        TestCase.assertNull((Object)pks);
                        try {
                            TestCase.assertTrue((boolean)sqi.createGFEActivation());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TestCase.fail((String)e.toString());
                        }
                    }
                }

                public void createdGemFireXDResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) {
                    if (rs instanceof GemFireResultSet) {
                        callbackInvoked[1] = true;
                    }
                }

                public void getAllInvoked(int numElements) {
                    callbackInvoked[2] = true;
                    TestCase.assertEquals((int)3, (int)numElements);
                }
            });
            String query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_id = ? AND c_d_id = ? AND c_w_id = ? AND c_first = ?";
            PreparedStatement ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 4);
            ps1.setInt(2, 6);
            ps1.setInt(3, 7);
            ps1.setInt(4, 2);
            ResultSet rs = ps1.executeQuery();
            int count = 0;
            while (rs.next()) {
                GetAllConvertibleQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
            }
            GetAllConvertibleQueryDUnit.assertEquals((int)2, (int)count);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.customer WHERE c_id = ? AND c_d_id = ? AND c_w_id = ? AND c_middle like ?";
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 4);
            ps1.setInt(2, 6);
            ps1.setInt(3, 7);
            ps1.setString(4, "M%");
            rs = ps1.executeQuery();
            count = 0;
            while (rs.next()) {
                GetAllConvertibleQueryDUnit.assertEquals((int)(count += 2), (int)rs.getInt(2));
            }
            GetAllConvertibleQueryDUnit.assertEquals((int)2, (int)count);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            query = "SELECT c_balance, c_first, c_middle, c_id FROM trade.portfolio WHERE c_first IN (?, ?, ?) AND c_id IN (select c_id from trade.customer where c_first = ? )";
            ps1 = conn.prepareStatement(query);
            ps1.setInt(1, 4);
            ps1.setInt(2, 6);
            ps1.setInt(3, 8);
            ps1.setInt(4, 4);
            rs = ps1.executeQuery();
            count = 0;
            while (rs.next()) {
                GetAllConvertibleQueryDUnit.assertEquals((int)(count += 4), (int)rs.getInt(2));
            }
            GetAllConvertibleQueryDUnit.assertEquals((int)4, (int)count);
            GetAllConvertibleQueryDUnit.assertTrue((boolean)callbackInvoked[0]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[1]);
            GetAllConvertibleQueryDUnit.assertFalse((boolean)callbackInvoked[2]);
            rs.close();
            callbackInvoked[0] = false;
            callbackInvoked[1] = false;
            callbackInvoked[2] = false;
            if (old == null) return;
        }
        catch (Throwable throwable) {
            if (old == null) throw throwable;
            GemFireXDQueryObserverHolder.setInstance(old);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
    }
}

