/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.stack.Protocol;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.GemFireXDHADUnit;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class GemFireXDReconnectDUnit
extends DistributedSQLTestBase {
    public GemFireXDReconnectDUnit(String name) {
        super(name);
    }

    public void testReconnectServer() throws Exception {
        int i;
        int i2;
        Properties props = new Properties();
        props.put("max-wait-time-reconnect", "15000");
        this.startVMs(1, 2, 0, null, props);
        this.clientSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) replicate");
        for (i2 = 1; i2 < 21; ++i2) {
            this.serverSQLExecute(1, "insert into Account values (" + i2 + ", 'Account " + i2 + "'," + i2 % 2 + " )");
        }
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{ShutdownException.class, CacheClosedException.class, ForcedDisconnectException.class});
        for (i2 = 0; i2 < 10; ++i2) {
            String createStmnt = "create table testTable" + i2 + "(id" + i2 + " int, name" + i2 + " varchar(100))";
            this.clientSQLExecute(1, createStmnt);
        }
        ArrayList<AsyncInvocation> ainvoke = new ArrayList<AsyncInvocation>();
        this.getLogWriter().info((Object)("client vm size = " + this.clientVMs.size()));
        GemFireXDHADUnit.selectQueryAndExecute((VM)this.clientVMs.get(0), ainvoke);
        this.forceDisconnectAServerVM((VM)this.serverVMs.get(0), true);
        this.getLogWriter().info((Object)"forcing a second reconnect");
        this.forceDisconnectAServerVM((VM)this.serverVMs.get(0), true);
        for (i = 0; i < ainvoke.size(); ++i) {
            GemFireXDHADUnit.joinAsyncInvocation((AsyncInvocation)ainvoke.get(i), 30000L);
        }
        for (i = 0; i < ainvoke.size(); ++i) {
            if (!((AsyncInvocation)ainvoke.get(i)).exceptionOccurred()) continue;
            GemFireXDReconnectDUnit.fail("exception during " + i, ((AsyncInvocation)ainvoke.get(i)).getException());
        }
        this.stopVM((VM)this.serverVMs.get(1), "server");
        GemFireXDHADUnit.selectQueryAndExecute((VM)this.clientVMs.get(0), ainvoke);
        for (i = 0; i < ainvoke.size(); ++i) {
            GemFireXDHADUnit.joinAsyncInvocation((AsyncInvocation)ainvoke.get(i), 30000L);
        }
        for (i = 0; i < ainvoke.size(); ++i) {
            if (!((AsyncInvocation)ainvoke.get(i)).exceptionOccurred()) continue;
            GemFireXDReconnectDUnit.fail("exception during " + i, ((AsyncInvocation)ainvoke.get(i)).getException());
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{ShutdownException.class, CacheClosedException.class, ForcedDisconnectException.class});
    }

    public void testReconnectLocator() throws Exception {
        int locPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int locPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String address = SocketCreator.getLocalHost().getHostAddress();
        String locators = address + '[' + locPort1 + "]," + address + '[' + locPort2 + "]";
        Properties props = new Properties();
        props.setProperty("locators", locators);
        props.setProperty("mcast-port", "0");
        props.put("max-wait-time-reconnect", "15000");
        this.startLocatorVM(address, locPort1, null, props);
        this.startLocatorVM(address, locPort2, null, props);
        this.addExpectedException(new int[0], new int[]{1, 2}, new Object[]{ShutdownException.class, CacheClosedException.class, ForcedDisconnectException.class});
        this.forceDisconnectAServerVM((VM)this.serverVMs.get(0), true);
        this.forceDisconnectAServerVM((VM)this.serverVMs.get(0), true);
        this.removeExpectedException(new int[0], new int[]{1, 2}, new Object[]{ShutdownException.class, CacheClosedException.class, ForcedDisconnectException.class});
        this.stopVMNum(-2);
        this.startVMs(1, 1, 0, null, props);
    }

    public void testReconnect_auth_and_netServer() throws Exception {
        int locPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int locPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String address = SocketCreator.getLocalHost().getHostAddress();
        String locators = address + '[' + locPort1 + "]," + address + '[' + locPort2 + "]";
        Properties props = new Properties();
        props.setProperty("locators", locators);
        props.setProperty("mcast-port", "0");
        props.put("max-wait-time-reconnect", "15000");
        props.setProperty("auth-provider", "BUILTIN");
        props.setProperty("gemfirexd.user.sd", "pwd");
        props.setProperty("user", "sd");
        props.setProperty("password", "pwd");
        props.setProperty("start-locator", "localhost[" + locPort1 + ']');
        this.startVMs(0, 1, 0, null, props);
        props.setProperty("start-locator", "localhost[" + locPort2 + ']');
        this.startVMs(0, 1, 0, null, props);
        props.remove("start-locator");
        this.startVMs(1, 1, 0, null, props);
        int inetPort = AvailablePort.getRandomAvailablePort((int)0);
        this.startNetworkServer(3, null, props, inetPort);
        Properties props2 = new Properties();
        props2.setProperty("user", "sd");
        props2.setProperty("password", "pwd");
        Connection conn = TestUtil.getNetConnection(inetPort, null, props2);
        Statement st = conn.createStatement();
        st.execute("create table t1(col1 int, col2 int)");
        this.addExpectedException(new int[0], new int[]{3}, new Object[]{ShutdownException.class, CacheClosedException.class, ForcedDisconnectException.class});
        this.forceDisconnectAServerVM((VM)this.serverVMs.get(2), true);
        conn = TestUtil.getNetConnection(inetPort, null, props2);
        st = conn.createStatement();
        st.execute("select * from t1");
        this.removeExpectedException(new int[0], new int[]{3}, new Object[]{ShutdownException.class, CacheClosedException.class, ForcedDisconnectException.class});
    }

    public boolean forceDisconnectAServerVM(VM vm, final boolean waitForReconnect) {
        return (Boolean)vm.invoke((Callable)new SerializableCallable("crash distributed system"){

            public Object call() throws Exception {
                Object wc;
                InternalDistributedSystem msys = InternalDistributedSystem.getAnyInstance();
                final FabricServiceImpl service = (FabricServiceImpl)FabricServiceManager.currentFabricServiceInstance();
                final Locator oldLocator = Locator.getLocator();
                MembershipManagerHelper.playDead((DistributedSystem)msys);
                JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                Protocol udp = c.getProtocolStack().findProtocol("UDP");
                udp.stop();
                udp.passUp(new Event(46, (Object)new ForcedDisconnectException("killing member's ds")));
                if (oldLocator != null) {
                    wc = new DistributedTestBase.WaitCriterion(){

                        public boolean done() {
                            return ((InternalLocator)oldLocator).isStopped();
                        }

                        public String description() {
                            return "waiting for locator to stop: " + oldLocator;
                        }
                    };
                    DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)10000L, (long)50L, (boolean)true);
                }
                if (waitForReconnect) {
                    wc = new DistributedTestBase.WaitCriterion(){

                        public boolean done() {
                            return service.status() == FabricService.State.RECONNECTING;
                        }

                        public String description() {
                            return "waiting for service to enter reconnecting state: " + service.status();
                        }
                    };
                    DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)200L, (boolean)true);
                    GemFireXDReconnectDUnit.this.getLogWriter().info((Object)"test is waiting for reconnect to finish");
                    boolean reconnected = service.waitUntilReconnected(3L, TimeUnit.MINUTES);
                    GemFireXDReconnectDUnit.this.getLogWriter().info((Object)("test is done waiting.  reconnected=" + reconnected));
                    if (!reconnected) {
                        TestCase.fail((String)"expected the system to reconnect");
                    }
                }
                return true;
            }
        });
    }
}

