/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.client.am.DisconnectException;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDumpLocalResultMessage;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class GemFireXDHADUnit
extends DistributedSQLTestBase {
    public GemFireXDHADUnit(String name) {
        super(name);
    }

    public static void joinAsyncInvocation(AsyncInvocation async, long ms) {
        if (async.isAlive()) {
            GemFireXDHADUnit.join((Thread)async, (long)ms, (Logger)GemFireXDHADUnit.getGlobalLogger());
        }
    }

    public void __testSelectsDataLoss() throws Exception {
        int i;
        this.startVMs(2, 3);
        this.clientSQLExecute(1, "create table Account ( id varchar(10) primary key, name varchar(100), type int ) partition by range(id)   ( values between 'A'  and 'B'    ,values between 'C'  and 'D'    ,values between 'E'  and 'F'    ,values between 'G'  and 'Z'    ,values between '1'  and '5'    ,values between '5'  and '15'    ,values between '15' and '20'   ) redundancy 1");
        for (int i2 = 1; i2 < 21; ++i2) {
            this.clientSQLExecute(1, "insert into Account values ('" + i2 + "', 'Account " + i2 + "'," + i2 % 2 + " )");
        }
        this.addExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
        ArrayList<AsyncInvocation> ainvoke = new ArrayList<AsyncInvocation>();
        GemFireXDHADUnit.selectQueryAndExecute((VM)this.clientVMs.get(1), ainvoke);
        ArrayList<VM> serverVMsForDisconnect = new ArrayList<VM>();
        serverVMsForDisconnect.add((VM)this.serverVMs.get(1));
        serverVMsForDisconnect.add((VM)this.serverVMs.get(2));
        GemFireXDHADUnit.disconnectVMs(serverVMsForDisconnect, ainvoke);
        for (i = 0; i < ainvoke.size(); ++i) {
            GemFireXDHADUnit.joinAsyncInvocation((AsyncInvocation)ainvoke.get(i), 1200000L);
        }
        for (i = 0; i < ainvoke.size(); ++i) {
            if (!((AsyncInvocation)ainvoke.get(i)).exceptionOccurred()) continue;
            GemFireXDHADUnit.fail("exception during " + i, ((AsyncInvocation)ainvoke.get(i)).getException());
        }
        this.removeExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
    }

    public void testRedundancyBug41407_41408() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table Account (id int primary key, name varchar(100), type int) redundancy 1");
        this.clientSQLExecute(1, "create table Account2 (id int primary key, name varchar(100), type int) redundancy 1 recoverydelay -1");
        this.clientSQLExecute(1, "create table Account3 (id int primary key, name varchar(100), type int) redundancy 1 recoverydelay 1500");
        this.serverSQLExecute(1, "insert into Account values (114, 'testBug1', 114)");
        this.serverSQLExecute(1, "insert into Account2 values (114, 'testBug1', 114)");
        this.clientSQLExecute(1, "insert into Account3 values (114, 'testBug1', 114)");
        this.startServerVMs(1, 0, null);
        this.serverSQLExecute(2, "insert into Account values (2, 'testBug2', 2)");
        this.serverSQLExecute(1, "insert into Account2 values (2, 'testBug2', 2)");
        this.clientSQLExecute(1, "insert into Account3 values (2, 'testBug2', 2)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from Account", null, "2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from Account2", null, "2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from Account3", null, "2");
        this.stopVMNums(-1, -2);
        this.addExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        try {
            this.sqlExecuteVerify(new int[]{1}, null, "select * from Account", null, "0");
            GemFireXDHADUnit.fail((String)"Test should have failed due to lack of data stores");
        }
        catch (SQLException sqle) {
            GemFireXDHADUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            this.sqlExecuteVerify(new int[]{1}, null, "select * from Account2", null, "0");
            GemFireXDHADUnit.fail((String)"Test should have failed due to lack of data stores");
        }
        catch (SQLException sqle) {
            GemFireXDHADUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        try {
            this.sqlExecuteVerify(new int[]{1}, null, "select * from Account3", null, "0");
            GemFireXDHADUnit.fail((String)"Test should have failed due to lack of data stores");
        }
        catch (SQLException sqle) {
            GemFireXDHADUnit.assertEquals((String)sqle.getSQLState(), (String)"X0Z08");
        }
        this.removeExpectedException(new int[]{1}, null, PartitionedRegionStorageException.class);
        this.restartVMNums(-1, -2);
        this.serverSQLExecute(2, "insert into Account values (1, 'testBug1', 1)");
        this.serverSQLExecute(1, "insert into Account2 values (1, 'testBug1', 1)");
        this.clientSQLExecute(1, "insert into Account3 values (1, 'testBug1', 1)");
        this.clientSQLExecute(1, "insert into Account values (115, 'testBug2', 115)");
        this.serverSQLExecute(1, "insert into Account2 values (115, 'testBug2', 115)");
        this.serverSQLExecute(2, "insert into Account3 values (115, 'testBug2', 115)");
        this.startServerVMs(1, 0, null);
        this.stopVMNums(-1);
        Thread.sleep(3000L);
        this.stopVMNums(-2);
        this.sqlExecuteVerify(new int[]{1}, new int[]{3}, "select count(*) from Account", null, "2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{3}, "select count(*) from Account2", null, "0");
        this.sqlExecuteVerify(new int[]{1}, new int[]{3}, "select count(*) from Account3", null, "2");
    }

    public void testStartupRecoveryDelay() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table Account (id int primary key, name varchar(100), type int) redundancy 1");
        this.clientSQLExecute(1, "create table Account2 (id int primary key, name varchar(100), type int) redundancy 1 startuprecoverydelay -1");
        this.clientSQLExecute(1, "create table Account3 (id int primary key, name varchar(100), type int) redundancy 1 startuprecoverydelay 1500");
        this.serverSQLExecute(1, "insert into Account values (114, 'testBug1', 114)");
        this.serverSQLExecute(1, "insert into Account2 values (114, 'testBug1', 114)");
        this.clientSQLExecute(1, "insert into Account3 values (114, 'testBug1', 114)");
        this.serverSQLExecute(1, "insert into Account values (2, 'testBug2', 2)");
        this.serverSQLExecute(1, "insert into Account2 values (2, 'testBug2', 2)");
        this.clientSQLExecute(1, "insert into Account3 values (2, 'testBug2', 2)");
        this.startServerVMs(1, 0, null);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from Account", null, "2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from Account2", null, "2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select count(*) from Account3", null, "2");
        Thread.sleep(3000L);
        this.stopVMNums(-1);
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select count(*) from Account", null, "2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select count(*) from Account2", null, "0");
        this.sqlExecuteVerify(new int[]{1}, new int[]{2}, "select count(*) from Account3", null, "2");
    }

    public void testSelects() throws Exception {
        GemFireXDHADUnit.sop("testSelects started");
        this.startServerVMs(4, 0, null);
        this.serverSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) partition by range(id)   ( values between 0  and 3    ,values between 3  and 8    ,values between 8  and 12    ,values between 12  and 17    ,values between 17  and 30   ) redundancy 1");
        for (int i = 1; i < 21; ++i) {
            this.serverSQLExecute(1, "insert into Account values (" + i + ", 'Account " + i + "'," + i % 2 + " )");
        }
        this.addExpectedException((int[])null, new int[]{1, 2, 3, 4}, new Object[]{ShutdownException.class, CacheClosedException.class});
        int serverVmToDisconnect = 3;
        ((VM)this.serverVMs.get(serverVmToDisconnect)).invoke(GemFireXDHADUnit.class, "disconnect");
        ((VM)this.serverVMs.get(2)).invoke(GemFireXDHADUnit.class, "fireSelects");
        GemFireXDHADUnit.sop("testSelects ended");
        this.removeExpectedException((int[])null, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
    }

    public void runUpdateDMLsIncludingOnClient(String testName, String dmlMethodName, int[] changeValues5) throws Exception {
        GemFireXDHADUnit.sop(testName + " started");
        Method dmlMethod = ((Object)((Object)this)).getClass().getMethod(dmlMethodName, Integer.class, Boolean.class, Integer.class, Connection.class);
        dmlMethod.setAccessible(true);
        this.startServerVMs(4, 0, null);
        int netPort4 = this.startNetworkServer(4, null, null);
        int netPort2 = this.startNetworkServer(2, null, null);
        this.attachConnectionListener(4, connListener);
        this.attachConnectionListener(2, connListener);
        Connection conn = TestUtil.getNetConnection(netPort4, null, null);
        conn.setTransactionIsolation(0);
        conn.setAutoCommit(false);
        conn.createStatement().execute("create table Account ( id int primary key, name varchar(100), type int ) partition by range(id)   ( values between 0  and 3    ,values between 3  and 8    ,values between 8  and 12    ,values between 12  and 17    ,values between 17  and 30   ) redundancy 1");
        this.assertNumConnections(-2, 0, 4);
        this.assertNumConnections(-1, -1, 2);
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    conn.setTransactionIsolation(0);
                    conn.setAutoCommit(false);
                    Statement stmt = conn.createStatement();
                    for (int i = 1; i < 21; ++i) {
                        stmt.executeUpdate("insert into Account values (" + i + ", 'Account " + i + "'," + i % 2 + " )");
                    }
                }
                catch (SQLException sqle) {
                    DistributedSQLTestBase.fail("unexpected exception in insert", sqle);
                }
            }
        });
        SerializableRunnable rebalanceWait = new SerializableRunnable(){

            public void run() {
                try {
                    InternalResourceManager rm = Misc.getGemFireCache().getResourceManager();
                    for (RebalanceOperation op : rm.getRebalanceOperations()) {
                        op.getResults();
                    }
                    rm.createRebalanceFactory().start().getResults();
                    for (RebalanceOperation op : rm.getRebalanceOperations()) {
                        op.getResults();
                    }
                }
                catch (Exception ex) {
                    DistributedSQLTestBase.fail("unexpected exception", ex);
                }
            }
        };
        this.addExpectedException((int[])null, new int[]{1, 2, 3, 4}, new Object[]{ShutdownException.class, CacheClosedException.class, DistributedSystemDisconnectedException.class});
        this.addExpectedException(null, new Object[]{DisconnectException.class, SQLNonTransientConnectionException.class});
        int serverVmToDisconnect = 4;
        ((VM)this.serverVMs.get(serverVmToDisconnect - 1)).invoke(TestUtil.class, "shutDown");
        int netPort1 = this.startNetworkServer(1, null, null);
        this.attachConnectionListener(1, connListener);
        dmlMethod.invoke((Object)this, netPort2, Boolean.FALSE, changeValues5[0], null);
        this.assertNumConnections(-2, 0, 4);
        this.assertNumConnections(-2, -2, 2);
        this.assertNumConnections(-1, -2, 1);
        GemFireXDHADUnit.sop(testName + " part1 ended");
        this.serverExecute(1, (Runnable)rebalanceWait);
        this.serverExecute(2, (Runnable)rebalanceWait);
        this.serverExecute(3, (Runnable)rebalanceWait);
        serverVmToDisconnect = 2;
        ((VM)this.serverVMs.get(serverVmToDisconnect - 1)).invoke(TestUtil.class, "shutDown");
        this.startNetworkServer(3, null, null);
        this.attachConnectionListener(3, connListener);
        dmlMethod.invoke((Object)this, netPort1, Boolean.FALSE, changeValues5[1], null);
        this.assertNumConnections(-2, 0, 4);
        this.assertNumConnections(-2, -2, 2);
        this.assertNumConnections(-3, -3, 1);
        this.assertNumConnections(-1, -2, 3);
        GemFireXDHADUnit.sop(testName + " part2 ended");
        this.serverExecute(1, (Runnable)rebalanceWait);
        this.serverExecute(3, (Runnable)rebalanceWait);
        dmlMethod.invoke((Object)this, netPort4, Boolean.FALSE, changeValues5[2], conn);
        this.assertNumConnections(-2, 0, 4);
        this.assertNumConnections(-2, -2, 2);
        this.assertNumConnections(-5, -5, 1, 3);
        GemFireXDHADUnit.sop(testName + " part3 ended");
        this.restartVMNums(new int[]{-2, -4}, 0, null, null);
        this.serverExecute(2, (Runnable)rebalanceWait);
        this.serverExecute(4, (Runnable)rebalanceWait);
        serverVmToDisconnect = 1;
        ((VM)this.serverVMs.get(serverVmToDisconnect - 1)).invoke(GemFireXDHADUnit.class, "disconnect");
        dmlMethod.invoke((Object)this, netPort1, Boolean.FALSE, changeValues5[3], null);
        this.assertNumConnections(-2, 0, 4);
        this.assertNumConnections(-2, -2, 2);
        this.assertNumConnections(-9, -6, 1, 3);
        conn.close();
        this.assertNumConnections(-2, 0, 4);
        this.assertNumConnections(-2, -2, 2);
        this.assertNumConnections(-9, -7, 1, 3);
        GemFireXDHADUnit.sop(testName + " part4 ended");
        this.serverExecute(2, (Runnable)rebalanceWait);
        this.serverExecute(4, (Runnable)rebalanceWait);
        serverVmToDisconnect = 3;
        ((VM)this.serverVMs.get(serverVmToDisconnect - 1)).invoke(GemFireXDHADUnit.class, "disconnect");
        ((VM)this.serverVMs.get(1)).invoke(GemFireXDHADUnit.class, dmlMethodName, new Object[]{null, Boolean.FALSE, changeValues5[4], null});
        GemFireXDHADUnit.sop(testName + " ended");
        this.removeExpectedException(null, new Object[]{DisconnectException.class, SQLNonTransientConnectionException.class});
        this.removeExpectedException((int[])null, new int[]{2, 4}, new Object[]{ShutdownException.class, CacheClosedException.class, DistributedSystemDisconnectedException.class});
    }

    public void testUpdatesIncludingOnClient() throws Exception {
        this.runUpdateDMLsIncludingOnClient("testUpdatesIncludingOnClient", "fireUpdates", new int[]{1, 2, 3, 4, 5});
    }

    public void __testUpdatesVerify() throws Exception {
        this.startServerVMs(4, 0, null);
        this.serverSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) partition by range(id)   ( values between 0  and 3    ,values between 3  and 8    ,values between 8  and 12    ,values between 12  and 17    ,values between 17  and 30   ) redundancy 1");
        for (int i = 1; i < 21; ++i) {
            this.serverSQLExecute(1, "insert into Account values (" + i + ", 'Account " + i + "'," + i % 2 + " )");
        }
        this.addExpectedException((int[])null, new int[]{1, 2, 3, 4}, new Object[]{ShutdownException.class, CacheClosedException.class});
        int serverVmToDisconnect = 3;
        ((VM)this.serverVMs.get(serverVmToDisconnect)).invoke(GemFireXDHADUnit.class, "disconnect");
        ((VM)this.serverVMs.get(2)).invoke(GemFireXDHADUnit.class, "fireUpdates", new Object[]{null, Boolean.TRUE, 1, null});
        this.removeExpectedException((int[])null, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
    }

    public void testDeletesIncludingOnClient() throws Exception {
        this.runUpdateDMLsIncludingOnClient("testDeletesIncludingOnClient", "fireDeletes", new int[]{15, 12, 8, 5, 2});
    }

    public void __testDeletesVerify() throws Exception {
        this.startServerVMs(4, 0, null);
        this.serverSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) partition by range(id)   ( values between 0  and 3    ,values between 3  and 8    ,values between 8  and 12    ,values between 12  and 17    ,values between 17  and 30   ) redundancy 1");
        for (int i = 1; i < 21; ++i) {
            this.serverSQLExecute(1, "insert into Account values (" + i + ", 'Account " + i + "'," + i % 2 + " )");
        }
        this.addExpectedException((int[])null, new int[]{1, 2, 3, 4}, new Object[]{ShutdownException.class, CacheClosedException.class});
        int serverVmToDisconnect = 3;
        ((VM)this.serverVMs.get(serverVmToDisconnect)).invoke(GemFireXDHADUnit.class, "disconnect");
        ((VM)this.serverVMs.get(2)).invoke(GemFireXDHADUnit.class, "fireDeletes", new Object[]{null, Boolean.TRUE, 5, null});
        this.removeExpectedException((int[])null, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
    }

    public void testInsertsIncludingOnClient() throws Exception {
        this.runUpdateDMLsIncludingOnClient("testInsertsIncludingOnClient", "fireInserts", new int[]{21, 26, 32, 36, 52});
    }

    public void testPKHang42429() throws Exception {
        this.startVMs(1, 2);
        this.serverSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) partition by range(id)   ( values between 0  and 3    ,values between 3  and 8    ,values between 8  and 12    ,values between 12  and 17    ,values between 17  and 30   ) redundancy 1");
        boolean serverVmToDisconnect = true;
        VM serverVM = (VM)this.serverVMs.get(0);
        serverVM.invoke((Runnable)new SerializableRunnable(){

            public void run() {
                PRHARedundancyProvider.setTestEndBucketCreationObserver((PRHARedundancyProvider.EndBucketCreationObserver)new PRHARedundancyProvider.EndBucketCreationObserver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void afterEndBucketCreationMessageSend(PartitionedRegion pr, int bucketId) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            PRHARedundancyProvider.setTestEndBucketCreationObserver(null);
                        }
                    }

                    public void afterEndBucketCreation(PartitionedRegion pr, int bucketId) {
                    }
                });
            }
        });
        AsyncInvocation async1 = serverVM.invokeAsync((Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    for (int i = 1; i < 3; ++i) {
                        Statement stmt = TestUtil.getStatement();
                        stmt.execute("insert into Account values (" + i + ", 'Account " + i + "'," + i % 2 + " )");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        AsyncInvocation async2 = serverVM.invokeAsync((Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    Thread.sleep(3000L);
                    TestUtil.shutDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ((VM)this.serverVMs.get(1)).invoke((Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    for (int i = 3; i < 8; ++i) {
                        Statement stmt = TestUtil.getStatement();
                        GemFireXDHADUnit.executeUpdate(stmt, "insert into Account values (" + i + ", 'Account " + i + "'," + i % 2 + " )");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ((VM)this.serverVMs.get(1)).invoke((Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    Statement stmt = TestUtil.getStatement();
                    GemFireXDHADUnit.executeUpdate(stmt, "update Account set type=2");
                }
                catch (SQLException sqle) {
                    throw new RuntimeException(sqle);
                }
            }
        });
        async1.join();
        async2.join();
    }

    public void testNoNewNodeParticipationPR() throws Exception {
        int i;
        int i2;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) partition by range(id)   ( values between 0  and 3    ,values between 3  and 8    ,values between 8  and 12    ,values between 12  and 17    ,values between 17  and 30   ) redundancy 1");
        for (i2 = 1; i2 < 21; ++i2) {
            this.serverSQLExecute(1, "insert into Account values (" + i2 + ", 'Account " + i2 + "'," + i2 % 2 + " )");
        }
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
        for (i2 = 0; i2 < 100; ++i2) {
            String createStmnt = "create table testTable" + i2 + "(id" + i2 + " int, name" + i2 + " varchar(100))";
            this.clientSQLExecute(1, createStmnt);
        }
        ArrayList<AsyncInvocation> ainvoke = new ArrayList<AsyncInvocation>();
        GemFireXDHADUnit.sop("client vm size = " + this.clientVMs.size());
        GemFireXDHADUnit.selectQueryAndExecute((VM)this.clientVMs.get(0), ainvoke);
        this.disconnectAndConnectAServerVM(2, 10L, false, ainvoke);
        for (i = 0; i < ainvoke.size(); ++i) {
            GemFireXDHADUnit.joinAsyncInvocation((AsyncInvocation)ainvoke.get(i), 1200000L);
        }
        for (i = 0; i < ainvoke.size(); ++i) {
            if (!((AsyncInvocation)ainvoke.get(i)).exceptionOccurred()) continue;
            GemFireXDHADUnit.fail("exception during " + i, ((AsyncInvocation)ainvoke.get(i)).getException());
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
    }

    public void testNoNewNodeParticipationDR() throws Exception {
        int i;
        int i2;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) replicate");
        for (i2 = 1; i2 < 21; ++i2) {
            this.serverSQLExecute(1, "insert into Account values (" + i2 + ", 'Account " + i2 + "'," + i2 % 2 + " )");
        }
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
        for (i2 = 0; i2 < 100; ++i2) {
            String createStmnt = "create table testTable" + i2 + "(id" + i2 + " int, name" + i2 + " varchar(100))";
            this.clientSQLExecute(1, createStmnt);
        }
        ArrayList<AsyncInvocation> ainvoke = new ArrayList<AsyncInvocation>();
        GemFireXDHADUnit.sop("client vm size = " + this.clientVMs.size());
        GemFireXDHADUnit.selectQueryAndExecute((VM)this.clientVMs.get(0), ainvoke);
        this.disconnectAndConnectAServerVM(2, 10L, false, ainvoke);
        for (i = 0; i < ainvoke.size(); ++i) {
            GemFireXDHADUnit.joinAsyncInvocation((AsyncInvocation)ainvoke.get(i), 1200000L);
        }
        for (i = 0; i < ainvoke.size(); ++i) {
            if (!((AsyncInvocation)ainvoke.get(i)).exceptionOccurred()) continue;
            GemFireXDHADUnit.fail("exception during " + i, ((AsyncInvocation)ainvoke.get(i)).getException());
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class});
    }

    public void test41261() throws Exception {
        int index;
        int i;
        int i2;
        this.startVMs(1, 4);
        this.clientSQLExecute(1, "create table Account ( id int primary key, name varchar(100), type int ) redundancy 2");
        this.clientSQLExecute(1, "create table AccountRef ( id int primary key, name varchar(100), aid int, foreign key (aid) references Account(id)) redundancy 2");
        for (i2 = 1; i2 <= 40; ++i2) {
            this.serverSQLExecute(1, "insert into Account values (" + i2 + ", 'Account " + i2 + "'," + i2 % 2 + " )");
        }
        for (i2 = 1; i2 <= 40; ++i2) {
            this.serverSQLExecute(1, "insert into AccountRef values (" + i2 + ", 'Account " + i2 + "'," + i2 + " )");
        }
        PreparedStatement pstmt1 = TestUtil.getPreparedStatement("delete from Account where id=?");
        PreparedStatement pstmt2 = TestUtil.getPreparedStatement("delete from AccountRef where id=?");
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class, FunctionException.class, "java.sql.SQLIntegrityConstraintViolationException", ShutdownException.class, CacheClosedException.class});
        for (int i3 = 1; i3 <= 2; ++i3) {
            this.getLogWriter().info((Object)("Deleting id " + i3 + " in AccountRef"));
            pstmt2.setInt(1, i3);
            GemFireXDHADUnit.assertEquals(1, pstmt2.executeUpdate());
            this.getLogWriter().info((Object)("Deleting id " + i3 + " in Account"));
            pstmt1.setInt(1, i3);
            GemFireXDHADUnit.assertEquals(1, pstmt1.executeUpdate());
        }
        ArrayList<AsyncInvocation> ainvoke = new ArrayList<AsyncInvocation>();
        VM serverVM1 = (VM)this.serverVMs.get(0);
        VM serverVM2 = (VM)this.serverVMs.get(2);
        ainvoke.add(serverVM1.invokeAsync(TestUtil.class, "shutDown"));
        ainvoke.add(serverVM2.invokeAsync(TestUtil.class, "shutDown"));
        Statement stmt1 = TestUtil.getStatement();
        Statement stmt2 = TestUtil.getStatement();
        for (i = 3; i <= 20; ++i) {
            this.getLogWriter().info((Object)("Deleting id " + i + " in AccountRef"));
            GemFireXDHADUnit.assertEquals(1, GemFireXDHADUnit.executeUpdate(stmt2, "delete from AccountRef where id=" + i));
            GemFireXDHADUnit.assertEquals(1, GemFireXDHADUnit.executeUpdate(stmt1, "delete from Account where id=" + i));
        }
        for (i = 21; i <= 40; ++i) {
            block10: {
                this.getLogWriter().info((Object)("Deleting id " + i + " in Account"));
                pstmt1.setInt(1, i);
                try {
                    GemFireXDHADUnit.executeUpdate(pstmt1, null);
                    GemFireXDHADUnit.fail((String)"expected to throw FK violation");
                }
                catch (SQLException ex) {
                    if ("23503".equals(ex.getSQLState())) break block10;
                    throw ex;
                }
            }
            this.getLogWriter().info((Object)("Deleting id " + i + " in AccountRef"));
            pstmt2.setInt(1, i);
            GemFireXDHADUnit.executeUpdate(pstmt2, null);
        }
        for (i = 21; i <= 40; ++i) {
            this.getLogWriter().info((Object)("Deleting id " + i + " in AccountRef"));
            pstmt2.setInt(1, i);
            GemFireXDHADUnit.assertEquals((String)"expected delete to fail", (int)0, (int)GemFireXDHADUnit.executeUpdate(pstmt2, null));
            this.getLogWriter().info((Object)("Deleting id " + i + " in Account"));
            pstmt1.setInt(1, i);
            GemFireXDHADUnit.executeUpdate(pstmt1, null);
        }
        for (index = 0; index < ainvoke.size(); ++index) {
            GemFireXDHADUnit.joinAsyncInvocation((AsyncInvocation)ainvoke.get(index), 1200000L);
        }
        for (index = 0; index < ainvoke.size(); ++index) {
            if (!((AsyncInvocation)ainvoke.get(index)).exceptionOccurred()) continue;
            GemFireXDHADUnit.fail("exception during " + index, ((AsyncInvocation)ainvoke.get(index)).getException());
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{ShutdownException.class, CacheClosedException.class, FunctionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
    }

    public static void disconnect() {
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                this.doShutDown();
            }

            public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                this.doShutDown();
            }

            public void beforeIndexUpdatesAtRegionLevel(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
                this.doShutDown();
            }

            private void doShutDown() {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Properties shutdownProperties = new Properties();
                            shutdownProperties.setProperty("stop-netservers", "false");
                            TestUtil.shutDown(shutdownProperties);
                        }
                        catch (SQLException se) {
                            DistributedSQLTestBase.fail("shutdown failed", se);
                        }
                    }
                }).start();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw new DistributedSystemDisconnectedException("throwing disconnected exception for test after shutdown");
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
    }

    public static void dumpAll() {
        try {
            GfxdDumpLocalResultMessage msg = new GfxdDumpLocalResultMessage();
            InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
            msg.send(sys, null);
            msg.executeLocally(sys.getDistributionManager(), false);
            GfxdDumpLocalResultMessage.sendBucketInfoDumpMsg(null, (boolean)false);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private static void fireOps(Integer clientPort, Integer verifyCnt, Connection conn, String dmlStmt, String verifyStmt, final int verifyStmtCnt) {
        try {
            PreparedStatement ps;
            boolean doClose = false;
            if (conn == null) {
                if (clientPort != null && clientPort > 0) {
                    GemFireXDHADUnit.getGlobalLogger().info((Object)"creating new client connection for current VM");
                    conn = TestUtil.getNetConnection(clientPort, null, null);
                    GemFireXDHADUnit.getGlobalLogger().info((Object)"created new client connection for current VM");
                } else {
                    GemFireXDHADUnit.getGlobalLogger().info((Object)"creating new server connection for current VM");
                    conn = TestUtil.getConnection();
                    GemFireXDHADUnit.getGlobalLogger().info((Object)"created new server connection for current VM");
                }
                conn.setTransactionIsolation(0);
                conn.setAutoCommit(false);
                doClose = true;
            }
            GemFireXDHADUnit.assertEquals(0, conn.getTransactionIsolation());
            GemFireXDHADUnit.assertFalse((boolean)conn.getAutoCommit());
            GemFireXDHADUnit.getGlobalLogger().info((Object)("Executing DML: " + dmlStmt));
            boolean usePrepStatement = PartitionedRegion.rand.nextBoolean();
            int cnt = -1;
            Statement stmt = conn.createStatement();
            if (usePrepStatement) {
                ps = conn.prepareStatement(dmlStmt);
                if (!ps.execute()) {
                    cnt = ps.getUpdateCount();
                }
                ps.close();
            } else if (!stmt.execute(dmlStmt)) {
                cnt = stmt.getUpdateCount();
            }
            if (verifyCnt != null) {
                GemFireXDHADUnit.assertEquals(verifyCnt, cnt);
            }
            if (verifyStmt != null) {
                GemFireXDHADUnit.getGlobalLogger().info((Object)("Verifying with DML: " + verifyStmt));
                ProcessResultSet<Object> verifyResult = new ProcessResultSet<Object>(){

                    @Override
                    public Object process(ResultSet rs) throws SQLException {
                        TestCase.assertTrue((boolean)rs.next());
                        if (verifyStmtCnt != rs.getInt(1)) {
                            try {
                                Host host = Host.getHost((int)0);
                                for (int vmNum = 0; vmNum <= host.getVMCount(); ++vmNum) {
                                    try {
                                        VM vm = host.getVM(vmNum);
                                        vm.invoke(GemFireXDHADUnit.class, "dumpAll");
                                        break;
                                    }
                                    catch (Throwable throwable) {
                                        continue;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            TestCase.fail((String)("Expected " + verifyStmtCnt + " results but got " + rs.getInt(1)));
                        }
                        TestCase.assertFalse((boolean)rs.next());
                        return null;
                    }
                };
                GemFireXDHADUnit.runSelects(conn, stmt, verifyStmt, verifyResult);
                ps = conn.prepareStatement(verifyStmt);
                GemFireXDHADUnit.runSelects(conn, ps, null, verifyResult);
                ps.close();
            }
            stmt.close();
            if (doClose) {
                GemFireXDHADUnit.getGlobalLogger().info((Object)"closing the new connection");
                conn.close();
                GemFireXDHADUnit.getGlobalLogger().info((Object)"closed the new connection");
            }
        }
        catch (SQLException e) {
            GemFireXDHADUnit.fail("unexpected exception occured in fireOps: ", e);
        }
    }

    public static void fireUpdates(Integer clientPort, Boolean doVerifyCnt, Integer startCnt, Connection conn) {
        if (startCnt == null) {
            startCnt = 1;
        }
        GemFireXDHADUnit.fireOps(clientPort, doVerifyCnt != false ? Integer.valueOf(10) : null, conn, "update Account set type=" + (startCnt + 1) + " where type=" + startCnt, "select count(*) from Account where type=" + (startCnt + 1), 10);
    }

    public static void fireDeletes(Integer clientPort, Boolean doVerifyCnt, Integer lastCnt, Connection conn) {
        GemFireXDHADUnit.fireOps(clientPort, doVerifyCnt != false ? Integer.valueOf(20 - lastCnt) : null, conn, "delete from Account where id > " + lastCnt, "select count(*) from Account", lastCnt);
    }

    public static void fireInserts(Integer clientPort, Boolean doVerifyCnt, Integer startCnt, Connection conn) {
        StringBuilder insertStmt = new StringBuilder("insert into Account values");
        int numInserts = PartitionedRegion.rand.nextInt(2) + 1;
        for (int i = startCnt.intValue(); i < startCnt + numInserts; ++i) {
            if (i > startCnt) {
                insertStmt.append(',');
            }
            insertStmt.append(" (").append(i).append(",'Account ").append(i).append("',").append(i % 2).append(')');
        }
        GemFireXDHADUnit.fireOps(clientPort, doVerifyCnt != false ? Integer.valueOf(numInserts) : null, conn, insertStmt.toString(), "select count(*) from Account where id >= " + startCnt, numInserts);
    }

    public static void fireSelects() throws Exception {
        GemFireXDHADUnit.assertEquals(20, GemFireXDHADUnit.doSelects(1));
    }

    private static int doSelects(int times) {
        int cnt = 0;
        try {
            Connection conn = TestUtil.getConnection();
            PreparedStatement ps = conn.prepareStatement("select * from Account");
            for (int i = 1; i <= times; ++i) {
                cnt = GemFireXDHADUnit.runSelects(conn, ps, null, new ProcessResultSet<Integer>(){

                    @Override
                    public Integer process(ResultSet rs) throws SQLException {
                        int cnt = 0;
                        while (rs.next()) {
                            ++cnt;
                        }
                        return cnt;
                    }
                });
            }
        }
        catch (SQLException e) {
            GemFireXDHADUnit.fail("unexpected exception occured in doSelects", e);
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T runSelects(Connection conn, Statement stmt, String sql, ProcessResultSet<T> processRS) throws SQLException {
        while (true) {
            try (ResultSet rs = sql != null ? stmt.executeQuery(sql) : ((PreparedStatement)stmt).executeQuery();){
                T t = processRS.process(rs);
                return t;
            }
            if (!(conn instanceof EmbedConnection) || !((EmbedConnection)conn).getLanguageConnection().streamingEnabled()) {
                GemFireXDHADUnit.fail((String)"unexpected retry exception for non-streaming case");
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public static void selectQueryAndExecute(VM vm, List<AsyncInvocation> ainvoke) {
        final SerializableRunnable createSelects = new SerializableRunnable("createSelects"){

            public void run() throws CacheException {
                GemFireXDHADUnit.doSelects(1000);
            }
        };
        if (vm != null) {
            ainvoke.add(vm.invokeAsync((Runnable)createSelects));
        } else {
            AsyncInvocation ai = new AsyncInvocation((Object)createSelects, "run", new Runnable(){

                @Override
                public void run() {
                    createSelects.run();
                }
            });
            ai.start();
            ainvoke.add(ai);
        }
    }

    private static void sop(String s) {
        GemFireXDHADUnit.getGlobalLogger().info((Object)s);
    }

    public static void disconnectVMs(List<VM> vms, List<AsyncInvocation> ainvoke) {
        SerializableRunnable disconnect = new SerializableRunnable("disconnect"){

            public void run() throws CacheException {
                try {
                    TestUtil.shutDown();
                }
                catch (SQLException e) {
                    throw new CacheException(e.toString()){};
                }
            }
        };
        for (int i = 0; i < vms.size(); ++i) {
            ainvoke.add(vms.get(i).invokeAsync((Runnable)disconnect));
            try {
                Thread.sleep(30L);
                continue;
            }
            catch (InterruptedException e) {
                GemFireXDHADUnit.fail("unexpected exception occured in disconnectVMs: ", e);
            }
        }
    }

    public static void assertEquals(int expected, int actual) {
        GemFireXDHADUnit.getGlobalLogger().info((Object)("comparing " + expected + " with actual " + actual));
        Assert.assertEquals((int)expected, (int)actual);
    }

    private static interface ProcessResultSet<T> {
        public T process(ResultSet var1) throws SQLException;
    }
}

