/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class EquiJoinQueryDUnit
extends DistributedSQLTestBase {
    public EquiJoinQueryDUnit(String name) {
        super(name);
    }

    public void testColocation() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, " create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))  partition by column (cid)");
        this.clientSQLExecute(1, " create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by column (cid) colocate with (trade.customers)");
        this.clientSQLExecute(1, "create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10) default 'open', tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, constraint status_ch check (status in ('cancelled', 'open', 'filled')))  partition by column (cid) colocate with (trade.portfolio)");
        this.clientSQLExecute(1, "select * from trade.customers c LEFT OUTER JOIN trade.portfolio f LEFT OUTER JOIN trade.sellorders so on f.cid = so.cid on c.cid= f.cid where f.tid = 0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourWithSingleColumnAsPartitoningKey_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY COLUMN ( ID2 ) Colocate with ( TESTTABLE1 )" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select ID1, DESCRIPTION2 from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID1 IN (7,9) ", new Object[][]{{new Integer(3), new SQLInteger(7)}, {new Integer(3), new SQLInteger(9), new Integer(5)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                Activation[] actArr = new Activation[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr, actArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                es.executeQuery(queryString);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this, actArr[0]);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                es.close();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testException_1() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY COLUMN ( ID2 )  " + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select ID1, DESCRIPTION2 from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID1 IN (7,9) ", new Object[][]{{new Integer(3), new SQLInteger(7)}, {new Integer(3), new SQLInteger(9), new Integer(5)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                es.executeQuery(queryString);
                EquiJoinQueryDUnit.fail((String)"The equijoin query without colocation should have failed");
            }
        }
        catch (SQLException sqle) {
            this.getLogWriter().info((Object)("Expected exception=" + sqle.getMessage()), (Throwable)sqle);
            EquiJoinQueryDUnit.assertTrue((sqle.getMessage().indexOf("not colocated with ") != -1 ? 1 : 0) != 0);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testException_2() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY COLUMN ( ID2 ) Colocate with ( TESTTABLE1 )" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select ID1, DESCRIPTION2 from TESTTABLE1, TESTTABLE2 where  ID1 IN (7,9) ", new Object[][]{{new Integer(3), new SQLInteger(7)}, {new Integer(3), new SQLInteger(9), new Integer(5)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                es.executeQuery(queryString);
                EquiJoinQueryDUnit.fail((String)"The equijoin query without colocation should have failed");
            }
        }
        catch (SQLException sqle) {
            this.getLogWriter().info((Object)("Expected exception=" + sqle.getMessage()), (Throwable)sqle);
            EquiJoinQueryDUnit.assertTrue((sqle.getMessage().indexOf("The query cannot be executed as it does not have all the required colocation equijoin conditions") != -1 ? 1 : 0) != 0);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNodesBehaviourWithSingleColumnAsPartitoningKey_2() throws Exception {
        EquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            }
        });
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY RANGE ( ID1 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY RANGE ( ID2 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )Colocate with ( TESTTABLE1 )" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select * from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID1 > 1 and ID1 < 6  ", new Object[][]{{new Integer(1), new SQLInteger(1), Boolean.FALSE, new SQLInteger(6), Boolean.FALSE}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + es.getSQLText() + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                }
                EquiJoinQueryDUnit.assertEquals((int)cnt, (int)4);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                rs.close();
            }
        }
        catch (Throwable throwable) {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
            EquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                public void run() {
                    System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                }
            });
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
        this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        EquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39862() throws Exception {
        EquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            }
        });
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY RANGE ( ID1 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY RANGE ( ID2 ) ( VALUES BETWEEN 1 and 4, VALUES BETWEEN  4 and 6, VALUES BETWEEN 6 and +infinity )Colocate with ( TESTTABLE1 )" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select ID1, ID2 from TESTTABLE1, TESTTABLE2 where ID1 = ID2 AND ID1 > 1 and ID1 < 6  ", new Object[][]{{new Integer(1), new SQLInteger(1), Boolean.FALSE, new SQLInteger(6), Boolean.FALSE}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                NodesPruningHelper.setupObserverOnClient((QueryInfo[])sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + queryString + "\"";
                HashSet<Integer> rslts = new HashSet<Integer>();
                for (int j = 2; j < 6; ++j) {
                    rslts.add(j);
                }
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                    EquiJoinQueryDUnit.assertTrue((boolean)rslts.remove(rs.getInt(1)));
                }
                EquiJoinQueryDUnit.assertTrue((boolean)rslts.isEmpty());
                EquiJoinQueryDUnit.assertFalse((boolean)rs.next());
                EquiJoinQueryDUnit.assertEquals((int)cnt, (int)4);
                NodesPruningHelper.validateNodePruningForQuery(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                rs.close();
            }
        }
        catch (Throwable throwable) {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
            try {
                System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                EquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                    public void run() {
                        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
                    }
                });
            }
            catch (Throwable t) {
                throw new AssertionError((Object)("Couldn't clear STATEMENT OPTIMIZATION flag. " + t));
            }
            throw throwable;
        }
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
        this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
        try {
            System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
            EquiJoinQueryDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)("Couldn't clear STATEMENT OPTIMIZATION flag. " + t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquijoinQueryForPRAndReplicatedRegion_1() throws Exception {
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY Column ( ID1 )" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        Object[][] queries = new Object[][]{{"select * from TESTTABLE1, TESTTABLE2 where  ID2 = 1 ", new Object[][]{{new Integer(6)}}}};
        TestUtil.setupConnection();
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr);
                String queryString = (String)queries[i][0];
                EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
                String log = "\nexecuting Query " + (i + 1) + " : \"" + queryString + "\"";
                this.getLogWriter().info((Object)log);
                ResultSet rs = es.executeQuery(queryString);
                while (rs.next()) {
                }
                Set<DistributedMember> expectedPrunedNodes = NodesPruningHelper.getExpectedNodes(queryString, (QueryInfo)sqiArr[0], (Object[][])queries[i][1], this.getLogWriter());
                Set<DistributedMember> allNodes = NodesPruningHelper.getExpectedNodes(queryString, (QueryInfo)sqiArr[0], new Object[][]{{new Integer(6)}}, this.getLogWriter());
                allNodes.removeAll(expectedPrunedNodes);
                this.verifyQueryExecution(sqiArr[0], expectedPrunedNodes, allNodes, 3, 0);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
                es.close();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE1 ");
            this.clientSQLExecute(1, "Drop table TESTTABLE2 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquijoinQueryForPRAndReplicatedRegionWithServerGroups() throws Exception {
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1", null);
                                            DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2", null);
                                            DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG3", null);
                                            DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, null, null);
                                            this.startClientVMs(1, 0, null);
                                            this.joinVMs(true, async1, async2, async3, async4);
                                            this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY Column (ID1) SERVER GROUPS (SG1,SG2)");
                                            this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (ID11 int not null,  DESCRIPTION11 varchar(1024) not null, ADDRESS11 varchar(1024) not null, primary key (ID11))PARTITION BY Column (ID11)" + this.getOverflowSuffix());
                                            try {
                                                this.clientSQLExecute(1, "create table EMP.PARTTABLE3 (ID12 int not null,  DESCRIPTION12 varchar(1024) not null, ADDRESS12 varchar(1024) not null, primary key (ID12))PARTITION BY Column (ID12) SERVER GROUPS (SG1,SG2) COLOCATE WITH (EMP.PARTTABLE1)" + this.getOverflowSuffix());
                                            }
                                            catch (SQLException ex) {
                                                if ("42X01".equals(ex.getSQLState())) break block22;
                                                throw ex;
                                            }
                                        }
                                        this.clientSQLExecute(1, "create table EMP.PARTTABLE3 (ID12 int not null,  DESCRIPTION12 varchar(1024) not null, ADDRESS12 varchar(1024) not null, primary key (ID12))PARTITION BY Column (ID12) COLOCATE WITH (EMP.PARTTABLE1) SERVER GROUPS (SG1,SG2)" + this.getOverflowSuffix());
                                        this.clientSQLExecute(1, "create table EMP.TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE SERVER GROUPS (SG1,SG2, sg3)" + this.getOverflowSuffix());
                                        this.serverSQLExecute(1, "create table EMP.TESTTABLE3 (ID3 int not null,  DESCRIPTION3 varchar(1024) not null, ADDRESS3 varchar(1024) not null, primary key (ID3)) REPLICATE SERVER GROUPS (SG1)" + this.getOverflowSuffix());
                                        this.serverSQLExecute(2, "create table EMP.TESTTABLE4 (ID4 int not null,  DESCRIPTION4 varchar(1024) not null, ADDRESS4 varchar(1024) not null, primary key (ID4)) REPLICATE SERVER GROUPS (SG1, SG2)" + this.getOverflowSuffix());
                                        this.serverSQLExecute(1, "create table EMP.TESTTABLE5 (ID5 int not null,  DESCRIPTION5 varchar(1024) not null, ADDRESS5 varchar(1024) not null, primary key (ID5)) REPLICATE" + this.getOverflowSuffix());
                                        for (int i = 0; i <= 10; ++i) {
                                            this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
                                            this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
                                            this.serverSQLExecute(2, "insert into EMP.PARTTABLE3 values (" + (i + 1) + ", 'First3" + (i + 1) + "', 'J3 604')");
                                            this.clientSQLExecute(1, "insert into EMP.TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
                                            this.serverSQLExecute(1, "insert into EMP.TESTTABLE3 values (" + (i + 1) + ", 'First3" + (i + 1) + "', 'J3 604')");
                                            this.serverSQLExecute(3, "insert into EMP.TESTTABLE4 values (" + (i + 1) + ", 'First4" + (i + 1) + "', 'J4 604')");
                                            this.serverSQLExecute(2, "insert into EMP.TESTTABLE5 values (" + (i + 1) + ", 'First5" + (i + 1) + "', 'J5 604')");
                                        }
                                        try {
                                            this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.TESTTABLE3 where ID1 = 4 and ID3 = 1");
                                            EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                                        }
                                        catch (SQLException ex) {
                                            if ("0A000".equals(ex.getSQLState())) break block23;
                                            throw ex;
                                        }
                                    }
                                    try {
                                        this.clientSQLExecute(1, "select * from EMP.PARTTABLE2, EMP.TESTTABLE3 where ID11 = 4 and ID3 = 1");
                                        EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                                    }
                                    catch (SQLException ex) {
                                        if ("0A000".equals(ex.getSQLState())) break block24;
                                        throw ex;
                                    }
                                }
                                try {
                                    this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.PARTTABLE2 where ID1 = 4 and ID11 = 1");
                                    EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                                }
                                catch (SQLException ex) {
                                    if ("0A000".equals(ex.getSQLState())) break block25;
                                    throw ex;
                                }
                            }
                            try {
                                this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.PARTTABLE2 where ID1 = ID11");
                                EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                            }
                            catch (SQLException ex) {
                                if ("0A000".equals(ex.getSQLState())) break block26;
                                throw ex;
                            }
                        }
                        try {
                            this.clientSQLExecute(1, "select * from EMP.PARTTABLE2, EMP.TESTTABLE4 where ID11 = 4 and ID4 = 1");
                            EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                        }
                        catch (SQLException ex) {
                            if ("0A000".equals(ex.getSQLState())) break block27;
                            throw ex;
                        }
                    }
                    try {
                        this.clientSQLExecute(1, "select * from EMP.TESTTABLE3, EMP.PARTTABLE2, EMP.TESTTABLE4");
                        EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in incompatible server groups");
                    }
                    catch (SQLException ex) {
                        if ("0A000".equals(ex.getSQLState())) break block28;
                        throw ex;
                    }
                }
                try {
                    this.clientSQLExecute(1, "select * from EMP.PARTTABLE1, EMP.PARTTABLE3 where ADDRESS1 = ADDRESS12");
                    EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in improper join condition");
                }
                catch (SQLException ex) {
                    if ("0A000".equals(ex.getSQLState())) break block29;
                    throw ex;
                }
            }
            try {
                this.clientSQLExecute(1, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.PARTTABLE3");
                EquiJoinQueryDUnit.fail((String)"expected exception in join for tables in improper join condition");
            }
            catch (SQLException ex) {
                if ("0A000".equals(ex.getSQLState())) break block30;
                throw ex;
            }
        }
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.PARTTABLE1, EMP.TESTTABLE2 where ID2 = 1 AND ID1 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "sgs_1");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.PARTTABLE1, EMP.TESTTABLE4 where ID4 = 1 AND ID1 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "sgs_2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.TESTTABLE2, EMP.TESTTABLE4 where ID2 = 1 AND ID4 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "sgs_3");
        isQueryExecutedOnNode = false;
        EquiJoinQueryDUnit.invokeInEveryVM(DistributedSQLTestBase.class, (String)"reset");
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        VM dataStore4 = (VM)this.serverVMs.get(3);
        SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
        this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3, dataStore4}, sqiArr);
        try {
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE2, EMP.TESTTABLE3", false, false, true);
            this.checkQueryExecution(true, dataStore1);
            this.serverSQLExecute(3, "select * from EMP.PARTTABLE1, EMP.TESTTABLE5", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE2, EMP.TESTTABLE5", true, false, true);
            this.checkQueryExecution(true, dataStore1, dataStore2, dataStore3);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE5", false, false, true);
            this.checkQueryExecution(true, dataStore1, dataStore2, dataStore3, dataStore4);
            this.serverSQLExecute(1, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.PARTTABLE3 where ID1 = ID12", false, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.serverSQLExecute(2, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.TESTTABLE2", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.serverSQLExecute(3, "select * from EMP.TESTTABLE5, EMP.PARTTABLE1, EMP.TESTTABLE2, EMP.PARTTABLE3 where ID1 = ID12", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE2, EMP.PARTTABLE1, EMP.TESTTABLE4, EMP.PARTTABLE3 where ID1 = ID12", true, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
            this.clientSQLExecute(1, "select * from EMP.TESTTABLE4, EMP.PARTTABLE3, EMP.TESTTABLE2, EMP.PARTTABLE1, EMP.TESTTABLE5 where ID1 = ID12 and ADDRESS1 = ADDRESS12", false, false, true);
            this.checkQueryExecution(false, dataStore1, dataStore2);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
        }
    }

    public void testEquiJoinPRAndReplicatedMix_40307() throws Exception {
        block3: {
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table EMP.PARTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY Column (ID1)" + this.getOverflowSuffix());
            this.clientSQLExecute(1, "create table EMP.PARTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2))PARTITION BY Column (ID2) COLOCATE WITH (EMP.PARTTABLE1)" + this.getOverflowSuffix());
            this.serverSQLExecute(1, "create table EMP.REPLTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) REPLICATE" + this.getOverflowSuffix());
            this.serverSQLExecute(2, "create table EMP.REPLTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE" + this.getOverflowSuffix());
            for (int i = 1; i <= 4; ++i) {
                this.clientSQLExecute(1, "insert into EMP.PARTTABLE1 values (" + i + ", 'First1" + i + "', 'J1 604')");
                this.clientSQLExecute(1, "insert into EMP.PARTTABLE2 values (" + i + ", 'First2" + i + "', 'J2 604')");
                this.serverSQLExecute(1, "insert into EMP.REPLTABLE1 values (" + i + ", 'RFirst1" + i + "', 'J1 604')");
                this.serverSQLExecute(3, "insert into EMP.REPLTABLE2 values (" + i + ", 'First2" + i + "', 'RJ2 604')");
            }
            this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2 where p1.ID1 = p2.ID2 and r1.ADDRESS1 = p1.ADDRESS1 and r1.ID1 = p2.ID2", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "pr_repl_mix1");
            this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.REPLTABLE1 r1, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2, EMP.REPLTABLE2 r2 where p1.ID1 = p2.ID2 and r1.ADDRESS1 = p1.ADDRESS1 and r1.ID1 = p2.ID2 and r1.ID1 = r2.ID2 and r2.ID2 = 3", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "pr_repl_mix2");
            this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select * from EMP.REPLTABLE1 r1, EMP.REPLTABLE2 r2, EMP.PARTTABLE1 p1, EMP.PARTTABLE2 p2 where p1.ID1 = p2.ID2 and r1.ID1 = 2 and r2.ID2 = 4", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "pr_repl_mix3");
            this.clientSQLExecute(1, "drop table EMP.REPLTABLE1");
            this.clientSQLExecute(1, "drop table EMP.REPLTABLE2");
            this.addExpectedException(new int[]{1}, null, UnsupportedOperationException.class);
            try {
                this.clientSQLExecute(1, "drop table EMP.PARTTABLE1");
                EquiJoinQueryDUnit.fail((String)"Expected exception in dropping the base table");
            }
            catch (SQLException ex) {
                if ("X0Y98".equals(ex.getSQLState())) break block3;
                throw ex;
            }
        }
        this.removeExpectedException(new int[]{1}, null, UnsupportedOperationException.class);
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE2");
        this.clientSQLExecute(1, "drop table EMP.PARTTABLE1");
    }

    private void checkReplicatedQueryExecution(boolean checkFirst, VM ... vms) {
        boolean isExecuted = false;
        for (VM vm : vms) {
            Boolean isExecutedOnNode = (Boolean)vm.invoke(DistributedSQLTestBase.class, "getQueryStatus");
            if (checkFirst && !isExecuted) {
                isExecutedOnNode = true;
            }
            EquiJoinQueryDUnit.assertFalse((String)("Did not expect query to execute on this node: " + vm.toString()), (checkFirst && isExecuted && isExecutedOnNode != false ? 1 : 0) != 0);
            if (!isExecutedOnNode.booleanValue()) continue;
            this.getLogWriter().info((Object)("Query executed on " + vm.toString()));
            EquiJoinQueryDUnit.assertFalse((String)"Did not expect query on replicated tables to execute on this node", (boolean)isExecuted);
            isExecuted = true;
            vm.invoke(DistributedSQLTestBase.class, "reset");
        }
        EquiJoinQueryDUnit.assertTrue((String)"Expected query to execute on exactly one node", (boolean)isExecuted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquijoinQueryForReplicatedRegions_1() throws Exception {
        this.startVMs(1, 3);
        VM dataStore1 = (VM)this.serverVMs.get(0);
        VM dataStore2 = (VM)this.serverVMs.get(1);
        VM dataStore3 = (VM)this.serverVMs.get(2);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1)) REPLICATE" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) REPLICATE" + this.getOverflowSuffix());
        for (int i = 0; i <= 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First1" + (i + 1) + "', 'J1 604')");
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First2" + (i + 1) + "', 'J2 604')");
        }
        String[][] queries = new String[][]{{"select * from TESTTABLE1, TESTTABLE2 where ID2 = 1", "query1"}, {"select * from TESTTABLE1, TESTTABLE2 where ID2 = ID1 AND ID1 = 2", "query2"}, {"select * from TESTTABLE1, TESTTABLE2 where ID2 = 1 AND ID1 = 4", "query3"}};
        try {
            for (int i = 0; i < queries.length; ++i) {
                SelectQueryInfo[] sqiArr = new SelectQueryInfo[1];
                this.setupObservers(new VM[]{dataStore1, dataStore2, dataStore3}, sqiArr);
                String queryString = queries[i][0];
                String log = "\nexecuting Query " + (i + 1) + " : \"" + queryString + "\"";
                this.getLogWriter().info((Object)log);
                this.sqlExecuteVerify(new int[]{1}, null, queryString, TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", queries[i][1]);
                EquiJoinQueryDUnit.assertFalse((String)"Did not expect query to be executed on this node", (boolean)isQueryExecutedOnNode);
                this.checkReplicatedQueryExecution(false, dataStore1, dataStore2, dataStore3);
                this.sqlExecuteVerify(null, new int[]{1}, queryString, TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", queries[i][1]);
                EquiJoinQueryDUnit.assertFalse((String)"Did not expect query to be executed on this node", (boolean)isQueryExecutedOnNode);
                this.checkReplicatedQueryExecution(true, dataStore1, dataStore2, dataStore3);
                this.sqlExecuteVerify(null, new int[]{2}, queryString, TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", queries[i][1]);
                EquiJoinQueryDUnit.assertFalse((String)"Did not expect query to be executed on this node", (boolean)isQueryExecutedOnNode);
                this.checkReplicatedQueryExecution(true, dataStore2, dataStore1, dataStore3);
                this.sqlExecuteVerify(null, new int[]{3}, queryString, TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", queries[i][1]);
                EquiJoinQueryDUnit.assertFalse((String)"Did not expect query to be executed on this node", (boolean)isQueryExecutedOnNode);
                this.checkReplicatedQueryExecution(true, dataStore3, dataStore1, dataStore2);
                this.getLogWriter().info((Object)("Query " + (i + 1) + " : succeeded"));
            }
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            isQueryExecutedOnNode = false;
            this.clientSQLExecute(1, "Drop table TESTTABLE1");
            this.clientSQLExecute(1, "Drop table TESTTABLE2");
        }
    }

    public void testQueryConvertibleToJoin() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table TESTTABLE1 (ID1 int primary key,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null)PARTITION BY Primary key" + this.getOverflowSuffix());
        this.clientSQLExecute(1, "create table TESTTABLE2 (ID2 int  primary key,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null,ID_FK int, foreign key (ID_FK) references TESTTABLE1(ID1))" + this.getOverflowSuffix());
        for (i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE1 values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604' )");
        }
        for (i = 0; i < 8; ++i) {
            this.clientSQLExecute(1, "insert into TESTTABLE2 values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604', " + (i + 1) + " )");
        }
        this.sqlExecuteVerify(new int[]{1}, null, "select ID2 from TESTTABLE2 where ADDRESS2 like '%604' AND ID_FK IN (select ID1 from TESTTABLE1 )", TestUtil.getResourcesDir() + "/lib/checkStatementQueryDUnit.xml", "testLikePredicateQuery_2", false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSupportedCorrelatedQueries_1() throws Exception {
        this.startVMs(1, 3);
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"orders", "customers"}, null);
        String table1 = "create table Customers (cust_id int primary key , cust_name varchar(1024) not null )";
        String table2 = "create table Orders (oid int  primary key, order_type varchar(1024) not null, order_amount int,  ordered_by int )";
        this.clientSQLExecute(1, table1 + "partition by column ( cust_id)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, table2 + "partition by column ( ordered_by ) colocate with ( Customers) " + this.getOverflowSuffix());
        derbyStmt.executeUpdate(table1);
        derbyStmt.executeUpdate(table2);
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsertCust = conn.prepareStatement("insert into customers values(?,?)");
        PreparedStatement psInsertCustDerby = derbyConn.prepareStatement("insert into customers values(?,?)");
        PreparedStatement ps = null;
        for (int k = 0; k < 2; ++k) {
            ps = k == 0 ? psInsertCust : psInsertCustDerby;
            for (int i = 1; i < 101; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "name_" + i);
                ps.executeUpdate();
            }
        }
        PreparedStatement psInsertOrdersGfxd = conn.prepareStatement("insert into Orders values(?,?,?,?)");
        PreparedStatement psInsertOrdersDerby = derbyConn.prepareStatement("insert into Orders values(?,?,?,?)");
        PreparedStatement psInsertOrders = null;
        for (int l = 0; l < 2; ++l) {
            psInsertOrders = l == 0 ? psInsertOrdersGfxd : psInsertOrdersDerby;
            int j = 1;
            for (int i = 1; i < 101; ++i) {
                for (int k = 1; k < 101; ++k) {
                    psInsertOrders.setInt(1, j++);
                    psInsertOrders.setString(2, "order_type_" + j);
                    psInsertOrders.setInt(3, i * k * 10);
                    psInsertOrders.setInt(4, i);
                }
            }
        }
        try {
            String query = "Select * from Customers where ( select sum(order_amount) from orders where ordered_by = cust_id ) > 50";
            this.validateResults(derbyStmt, query, -1, false);
        }
        catch (Throwable throwable) {
            this.clientSQLExecute(1, "drop table orders");
            this.clientSQLExecute(1, "drop table customers");
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"orders", "customers"}, derbyConn);
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.clientSQLExecute(1, "drop table orders");
        this.clientSQLExecute(1, "drop table customers");
        this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"orders", "customers"}, derbyConn);
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSupportedCorrelatedQueries_2() throws Exception {
        this.startVMs(1, 3);
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"orders", "customers"}, null);
        String table1 = "create table Customers (cust_id int primary key , cust_name varchar(1024) not null, address varchar(1024) )";
        String table2 = "create table Orders (oid int  primary key, order_type varchar(1024) not null, order_amount int,  ordered_by int, orderer_name varchar(1024) )";
        String table3 = "create table Suborders (sub_oid int  primary key, sub_order_type varchar(1024) not null, sub_order_amount int,  sub_ordered_by int, sub_orderer_name varchar(1024) )";
        String table4 = "create table sub_suborders (sub_sub_oid int  primary key, sub_sub_order_type varchar(1024) not null, sub_sub_order_amount int,  sub_sub_ordered_by int, sub_sub_orderer_name varchar(1024) )";
        this.clientSQLExecute(1, table1 + "partition by column (cust_id, cust_name) " + this.getOverflowSuffix());
        this.clientSQLExecute(1, table2 + "partition by column ( ordered_by,orderer_name) " + "colocate with  (customers) " + this.getOverflowSuffix());
        this.clientSQLExecute(1, table3 + "partition by column ( sub_ordered_by,sub_orderer_name ) " + "colocate with (orders) " + this.getOverflowSuffix());
        this.clientSQLExecute(1, table4 + "partition by column ( sub_sub_ordered_by,sub_sub_orderer_name ) " + "colocate with (customers)" + this.getOverflowSuffix());
        derbyStmt.executeUpdate(table1);
        derbyStmt.executeUpdate(table2);
        derbyStmt.executeUpdate(table3);
        derbyStmt.executeUpdate(table4);
        String query1 = "Select * from Customers where  ( select sum(order_amount) from orders where ordered_by = cust_id and orderer_name = cust_name ) > 1000 and  ( select sum(sub_order_amount) from suborders where  sub_orderer_name = cust_name  and sub_ordered_by = cust_id  and 12 = ( select Sum(sub_sub_ordered_by) from sub_suborders where sub_sub_ordered_by = sub_ordered_by  and sub_sub_orderer_name = cust_name))  < 500 ";
        String query2 = "Select * from Customers where  ( select sum(order_amount) from orders where ordered_by = cust_id and orderer_name = cust_name  and  oid >  ( select sum(sub_order_amount) from suborders where  sub_orderer_name = orderer_name  and sub_ordered_by = cust_id  and sub_oid  >  ( select sum(sub_sub_order_amount) from sub_suborders where  sub_sub_orderer_name = orderer_name  and sub_sub_ordered_by = sub_ordered_by ) )) > 100";
        String[] queries = new String[]{query1, query2};
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsertCust = conn.prepareStatement("insert into customers values(?,?,?)");
        PreparedStatement psInsertCustDerby = derbyConn.prepareStatement("insert into customers values(?,?,?)");
        PreparedStatement ps = null;
        for (int k = 0; k < 2; ++k) {
            ps = k == 0 ? psInsertCust : psInsertCustDerby;
            for (int i = 1; i < 101; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "name_" + i);
                ps.setString(3, "address_" + i);
                ps.executeUpdate();
            }
        }
        PreparedStatement psInsertOrdersGfxd = conn.prepareStatement("insert into Orders values(?,?,?,?,?)");
        PreparedStatement psInsertOrdersDerby = derbyConn.prepareStatement("insert into Orders values(?,?,?,?,?)");
        for (int l = 0; l < 2; ++l) {
            PreparedStatement psInsertOrders = l == 0 ? psInsertOrdersGfxd : psInsertOrdersDerby;
            int j = 1;
            for (int i = 1; i < 101; ++i) {
                for (int k = 1; k < 101; ++k) {
                    psInsertOrders.setInt(1, j++);
                    psInsertOrders.setString(2, "order_type_" + j);
                    psInsertOrders.setInt(3, i * k * 10);
                    psInsertOrders.setInt(4, i);
                    psInsertOrders.setString(5, "order_name_" + j);
                }
            }
        }
        PreparedStatement psInsertSubOrdersGfxd = conn.prepareStatement("insert into SubOrders values(?,?,?,?,?)");
        PreparedStatement psInsertSubOrdersDerby = derbyConn.prepareStatement("insert into SubOrders values(?,?,?,?,?)");
        for (int l = 0; l < 2; ++l) {
            PreparedStatement psInsertSubOrders = l == 0 ? psInsertSubOrdersGfxd : psInsertSubOrdersDerby;
            int j = 1;
            for (int i = 1; i < 101; ++i) {
                for (int k = 1; k < 101; ++k) {
                    psInsertSubOrders.setInt(1, j++);
                    psInsertSubOrders.setString(2, "sub_order_type_" + j);
                    psInsertSubOrders.setInt(3, i * k * 10);
                    psInsertSubOrders.setInt(4, i);
                    psInsertSubOrders.setString(5, "sub_order_name_" + j);
                }
            }
        }
        PreparedStatement psInsertSubSubOrdersGfxd = conn.prepareStatement("insert into SubOrders values(?,?,?,?,?)");
        PreparedStatement psInsertSubSubOrdersDerby = derbyConn.prepareStatement("insert into SubOrders values(?,?,?,?,?)");
        for (int l = 0; l < 2; ++l) {
            PreparedStatement psInsertSubSubOrders = l == 0 ? psInsertSubSubOrdersGfxd : psInsertSubSubOrdersDerby;
            int j = 1;
            for (int i = 1; i < 101; ++i) {
                for (int k = 1; k < 101; ++k) {
                    psInsertSubSubOrders.setInt(1, j++);
                    psInsertSubSubOrders.setString(2, "sub_order_type_" + j);
                    psInsertSubSubOrders.setInt(3, i * k * 10);
                    psInsertSubSubOrders.setInt(4, i);
                    psInsertSubSubOrders.setString(5, "sub_order_name_" + j);
                }
            }
        }
        try {
            for (String query : queries) {
                this.validateResults(derbyStmt, query, -1, false);
            }
        }
        catch (Throwable throwable) {
            this.clientSQLExecute(1, "drop table suborders");
            this.clientSQLExecute(1, "drop table sub_suborders");
            this.clientSQLExecute(1, "drop table orders");
            this.clientSQLExecute(1, "drop table customers");
            this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"sub_suborders", "suborders", "orders", "customers"}, derbyConn);
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
                throw throwable;
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) throw throwable;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        this.clientSQLExecute(1, "drop table suborders");
        this.clientSQLExecute(1, "drop table sub_suborders");
        this.clientSQLExecute(1, "drop table orders");
        this.clientSQLExecute(1, "drop table customers");
        this.cleanDerbyArtifacts(derbyStmt, new String[0], new String[0], new String[]{"sub_suborders", "suborders", "orders", "customers"}, derbyConn);
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            return;
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("shutdown") != -1) return;
            sqle.printStackTrace();
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnsupportedCorrelatedQueries_1() throws Exception {
        this.startVMs(1, 1);
        String table1 = "create table Customers (cust_id int primary key, cust_name varchar(1024) not null)";
        String table2 = "create table Orders (oid int  primary key, order_type varchar(1024) not null, order_amount int, ordered_by int)";
        String table3 = "create table Customers2 (cust_id int primary key, cust_name varchar(1024) not null, address varchar(1024))";
        String table4 = "create table Orders2 (oid int  primary key, order_type varchar(1024) not null, order_amount int, ordered_by int, orderer_name varchar(1024))";
        this.clientSQLExecute(1, table1 + "partition by column (cust_id)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, table2 + "partition by column (ordered_by)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, table3 + "partition by column (cust_id, cust_name)" + this.getOverflowSuffix());
        this.clientSQLExecute(1, table4 + "partition by column (ordered_by, " + "orderer_name) colocate with (Customers2) " + this.getOverflowSuffix());
        try {
            String query;
            block8: {
                try {
                    query = "Select * from Customers where ( select sum(order_amount) from orders where ordered_by = cust_id ) > 1000";
                    this.clientSQLExecute(1, query);
                    EquiJoinQueryDUnit.fail((String)"Query execution should have failed as it is not having colocated tables");
                }
                catch (SQLFeatureNotSupportedException sqle) {
                    if (sqle.toString().indexOf("not colocated with") != -1) break block8;
                    EquiJoinQueryDUnit.fail((String)("Did not get the expected exception. Exception occured: " + sqle));
                }
            }
            try {
                query = "Select * from customers2 where ( select sum(order_amount) from Orders2 where ordered_by = cust_id ) > 1000";
                this.clientSQLExecute(1, query);
                EquiJoinQueryDUnit.fail((String)"Should have failed  to execute as tables are not colocated");
            }
            catch (SQLFeatureNotSupportedException sqle) {
                if (sqle.toString().indexOf("The query cannot be executed as it does not have all the required colocation equijoin conditions") == -1) {
                    EquiJoinQueryDUnit.fail((String)("Did not get the expected exception. Exception occured: " + sqle));
                }
            }
        }
        finally {
            this.clientSQLExecute(1, "drop table orders");
            this.clientSQLExecute(1, "drop table customers");
            this.clientSQLExecute(1, "drop table orders2");
            this.clientSQLExecute(1, "drop table customers2");
        }
    }

    public void test43206() throws Exception {
        this.startVMs(2, 3);
        Connection conn = TestUtil.getConnection();
        conn.createStatement().execute("create table pizza (i int) ");
        ResultSet rs = conn.createStatement().executeQuery("select m.ID, m.hostdata from sys.systables t, sys.members m where t.tablename='PIZZA' and m.hostdata = 'true'");
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select m.ID, m.hostdata from sys.systables t, sys.members m where t.tablename='PIZZA' and m.hostdata = 1");
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select m.ID, m.hostdata from sys.systables t, sys.members m where t.tablename='PIZZA' and m.hostdata = 1");
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertTrue((boolean)rs.next());
        EquiJoinQueryDUnit.assertFalse((boolean)rs.next());
    }

    public String getOverflowSuffix() {
        return " ";
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        EquiJoinQueryDUnit.reset();
    }
}

