/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.NodesPruningHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Set;
import junit.framework.TestCase;

public class DeleteStatementDUnit
extends DistributedSQLTestBase {
    static volatile boolean isQueryExecutedOnNode = false;

    public DeleteStatementDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicNodePruningWithPrimaryKey() throws Exception {
        try {
            this.startServerVMs(3, 0, "SG1");
            this.startVMs(1, 0);
            String deleteQuery = "delete from EMP.TESTTABLE where ID > 0 AND ID < 3";
            this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null ) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 0 and 3, VALUES BETWEEN  3 and 6 , VALUES BETWEEN 6 and  +Infinity )" + this.getSuffix());
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStore();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            NodesPruningHelper.setupObserverOnClient(qi);
            TestUtil.setupConnection();
            EmbedStatement es = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            int n = es.executeUpdate(deleteQuery);
            DeleteStatementDUnit.assertEquals((int)2, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(0), Boolean.FALSE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(deleteQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = DeleteStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = DeleteStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
            ResultSet rs = es.executeQuery("Select ID, ADDRESS from EMP.TESTTABLE");
            int cnt = 0;
            while (rs.next()) {
                ++cnt;
            }
            DeleteStatementDUnit.assertEquals((int)6, (int)cnt);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateMissPrimaryKey() throws Exception {
        this.startVMs(1, 3);
        String deleteQuery = "delete from EMP.TESTTABLE where ID = ?";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null ) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 0 and 3, VALUES BETWEEN  3 and 6 , VALUES BETWEEN 6 and  +Infinity )" + this.getSuffix());
        try {
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStore();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            NodesPruningHelper.setupObserverOnClient(qi);
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(deleteQuery);
            this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, EntryNotFoundException.class);
            try {
                for (int i = 42; i <= 420; i += 42) {
                    ps.setInt(1, i);
                    int n = ps.executeUpdate();
                    DeleteStatementDUnit.assertEquals((int)0, (int)n);
                }
            }
            catch (Throwable throwable) {
                this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, EntryNotFoundException.class);
                throw throwable;
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, EntryNotFoundException.class);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPKDeleteOnNonExistentRowForReplicatedTable_Bug42862() throws Exception {
        this.startVMs(1, 3);
        String deleteQuery = "delete from EMP.TESTTABLE where ID = ?";
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null )  replicate" + this.getSuffix());
        try {
            for (int i = 0; i < 5; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            TestUtil.setupConnection();
            PreparedStatement ps = TestUtil.jdbcConn.prepareStatement(deleteQuery);
            ps.setInt(1, 100);
            int n = ps.executeUpdate();
            DeleteStatementDUnit.assertEquals((int)0, (int)n);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicNodePruningWithParameter() throws Exception {
        this.startVMs(1, 3);
        try {
            String deleteQuery = "delete from EMP.TESTTABLE where ID > ? AND ID < ?";
            this.clientSQLExecute(1, "create schema EMP");
            this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null ) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 0 and 3, VALUES BETWEEN  3 and 6 , VALUES BETWEEN 6 and  +Infinity )" + this.getSuffix());
            for (int i = 0; i < 8; ++i) {
                this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (" + (i + 1) + ", 'First" + (i + 1) + "', 'J 604" + (i + 1) + "')");
            }
            VM dataStore1 = (VM)this.serverVMs.get(0);
            VM dataStore2 = (VM)this.serverVMs.get(1);
            VM dataStore3 = (VM)this.serverVMs.get(2);
            SerializableRunnable setObserver = this.getGfxdQueryObserverIntializerForDataStoreForPrepStmnt();
            dataStore1.invoke((Runnable)setObserver);
            dataStore2.invoke((Runnable)setObserver);
            dataStore3.invoke((Runnable)setObserver);
            QueryInfo[] qi = new QueryInfo[1];
            Activation[] actArr = new Activation[1];
            NodesPruningHelper.setupObserverOnClient(qi, actArr);
            TestUtil.setupConnection();
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(deleteQuery);
            es.setInt(1, 0);
            es.setInt(2, 3);
            int n = es.executeUpdate();
            DeleteStatementDUnit.assertEquals((int)2, (int)n);
            Object[][] routingInfo = new Object[][]{{new Integer(1), new SQLInteger(0), Boolean.FALSE, new SQLInteger(3), Boolean.FALSE}};
            Set<DistributedMember> expectedNodesToUpdate = NodesPruningHelper.getExpectedNodes(deleteQuery, qi[0], routingInfo, this.getLogWriter());
            Set allNodes = ((PartitionedRegion)qi[0].getRegion()).getRegionAdvisor().adviseDataStore();
            SerializableRunnable validateNoQuerySend = DeleteStatementDUnit.getQueryNonExecutionValidator();
            SerializableRunnable validateQuerySend = DeleteStatementDUnit.getQueryExecutionValidator();
            this.executeOnVMs(expectedNodesToUpdate, validateQuerySend);
            allNodes.removeAll(expectedNodesToUpdate);
            this.executeOnVMs(allNodes, validateNoQuerySend);
            EmbedStatement s = (EmbedStatement)TestUtil.jdbcConn.createStatement();
            ResultSet rs = s.executeQuery("Select ID, ADDRESS from EMP.TESTTABLE");
            int cnt = 0;
            while (rs.next()) {
                ++cnt;
            }
            DeleteStatementDUnit.assertEquals((int)6, (int)cnt);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
            this.clientSQLExecute(1, "Drop schema EMP restrict");
        }
    }

    public String getSuffix() {
        return "  ";
    }

    public static final void reset() {
        isQueryExecutedOnNode = false;
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        DeleteStatementDUnit.reset();
    }

    private void executeOnVMs(Set<DistributedMember> members, SerializableRunnable runnable) {
        for (DistributedMember member : members) {
            VM vm = this.getHostVMForMember(member);
            vm.invoke((Runnable)runnable);
        }
    }

    private SerializableRunnable getGfxdQueryObserverIntializerForDataStore() {
        return new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
                            isQueryExecutedOnNode = true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private SerializableRunnable getGfxdQueryObserverIntializerForDataStoreForPrepStmnt() {
        return new SerializableRunnable("Set GemFireXDObserver"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                        public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
                            isQueryExecutedOnNode = true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private static SerializableRunnable getQueryExecutionValidator() {
        return new SerializableRunnable("validate Query execution"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertTrue((boolean)isQueryExecutedOnNode);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private static SerializableRunnable getQueryNonExecutionValidator() {
        return new SerializableRunnable("validate no query execution"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    TestCase.assertFalse((boolean)isQueryExecutedOnNode);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }
}

