/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CheckTableDUnit
extends DistributedSQLTestBase {
    public CheckTableDUnit(String name) {
        super(name);
    }

    public void testLocalIndexConsistency() throws Exception {
        Connection conn;
        block2: {
            this.startVMs(1, 2, 0, null, null);
            int netPort1 = this.startNetworkServer(1, null, null);
            conn = TestUtil.getNetConnection(netPort1, null, null);
            try {
                conn.createStatement().executeQuery("VALUES SYS.CHECK_TABLE_EX(NULL, 'TABLE1')");
                CheckTableDUnit.fail((String)"null argument to SYS.CHECK_TABLE_EX() should throw an error");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("22008")) break block2;
                throw se;
            }
        }
        this.checkLocalIndexConsistency(conn, false);
        this.checkLocalIndexConsistency(conn, true);
    }

    private void checkLocalIndexConsistency(Connection conn, boolean isReplicated) throws SQLException {
        Statement st;
        block6: {
            ResultSet rs1;
            VM serverVM2;
            VM serverVM1;
            block5: {
                st = conn.createStatement();
                String createTableDDL = null;
                createTableDDL = isReplicated ? "CREATE TABLE TEST.TABLE1 (COL1 INT, COL2 INT, COL3 VARCHAR(10)) REPLICATE PERSISTENT" : "CREATE TABLE TEST.TABLE1 (COL1 INT, COL2 INT, COL3 VARCHAR(10)) PARTITION BY RANGE (COL1) (VALUES BETWEEN 0 AND 50, VALUES BETWEEN 50 AND 100) REDUNDANCY 1";
                st.execute(createTableDDL);
                st.execute("CREATE INDEX TEST.IDX1 ON TEST.TABLE1(COL2)");
                PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST.TABLE1 VALUES(?, ?, ?)");
                for (int i = 0; i < 100; ++i) {
                    ps.setInt(1, i);
                    ps.setInt(2, i);
                    ps.setString(3, "" + i);
                    ps.addBatch();
                }
                ps.executeBatch();
                ResultSet rs0 = st.executeQuery("select count(*) from test.TABLE1");
                CheckTableDUnit.assertTrue((boolean)rs0.next());
                CheckTableDUnit.assertEquals((int)100, (int)rs0.getInt(1));
                rs0.close();
                rs0 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE1')");
                serverVM1 = (VM)this.serverVMs.get(0);
                serverVM2 = (VM)this.serverVMs.get(1);
                serverVM1.invoke(CheckTableDUnit.class, "deleteEntryFromLocalIndex", new Object[]{"/TEST/TABLE1", "IDX1"});
                serverVM2.invoke(CheckTableDUnit.class, "deleteEntryFromLocalIndex", new Object[]{"/TEST/TABLE1", "IDX1"});
                try {
                    rs1 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE1')");
                    CheckTableDUnit.fail((String)"SYS.CHECK_TABLE_EX should have thrown an exception");
                }
                catch (SQLException se1) {
                    if (se1.getSQLState().equals("X0Y55")) break block5;
                    throw se1;
                }
            }
            st.execute("DROP INDEX TEST.IDX1");
            st.execute("CREATE INDEX TEST.IDX2 ON TEST.TABLE1(COL2)");
            serverVM1.invoke(CheckTableDUnit.class, "updateEntryInLocalIndex", new Object[]{"/TEST/TABLE1", "IDX2"});
            serverVM2.invoke(CheckTableDUnit.class, "updateEntryInLocalIndex", new Object[]{"/TEST/TABLE1", "IDX2"});
            try {
                rs1 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE1')");
                CheckTableDUnit.fail((String)"SYS.CHECK_TABLE_EX should have thrown an exception");
            }
            catch (SQLException se2) {
                if (se2.getSQLState().equals("X0X61")) break block6;
                throw se2;
            }
        }
        st.execute("DROP TABLE TEST.TABLE1");
    }

    public static void logLocalIndexSize(String regionPath, String index) {
        LocalRegion r = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)false, (boolean)false);
        GfxdIndexManager sqlim = (GfxdIndexManager)r.getIndexUpdater();
        List list = sqlim.getAllIndexes();
        CheckTableDUnit.getGlobalLogger().info((Object)("list of index containers are: " + Arrays.toString(list.toArray())));
        for (GemFireContainer gfc : list) {
            if (!((String)gfc.getName()).contains(index)) continue;
            CheckTableDUnit.getGlobalLogger().info((Object)("size of the index is " + gfc.getSkipListMap().size()));
        }
    }

    public static void deleteEntryFromLocalIndex(String regionPath, String index) {
        LocalRegion r = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)false, (boolean)false);
        GfxdIndexManager sqlim = (GfxdIndexManager)r.getIndexUpdater();
        List list = sqlim.getAllIndexes();
        CheckTableDUnit.getGlobalLogger().info((Object)("list of index containers are: " + Arrays.toString(list.toArray())));
        for (GemFireContainer gfc : list) {
            if (!((String)gfc.getName()).contains(index)) continue;
            Iterator keys = gfc.getSkipListMap().keySet().iterator();
            Object k = keys.next();
            gfc.getSkipListMap().remove(k);
        }
    }

    public static void updateEntryInLocalIndex(String regionPath, String index) {
        LocalRegion r = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)false, (boolean)false);
        GfxdIndexManager sqlim = (GfxdIndexManager)r.getIndexUpdater();
        List list = sqlim.getAllIndexes();
        CheckTableDUnit.getGlobalLogger().info((Object)("list of index containers are: " + Arrays.toString(list.toArray())));
        for (GemFireContainer gfc : list) {
            if (!((String)gfc.getName()).contains(index)) continue;
            Map.Entry first = gfc.getSkipListMap().firstEntry();
            Map.Entry last = gfc.getSkipListMap().lastEntry();
            CheckTableDUnit.getGlobalLogger().info((Object)("e1 =" + first + " e2 =" + last));
            gfc.getSkipListMap().put(first.getKey(), last.getValue());
        }
    }

    public void testGlobalIndexConsistency() throws Exception {
        this.startVMs(1, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort1, null, null);
        this.checkGlobalIndexConsistency(conn, false);
        this.checkGlobalIndexConsistency(conn, true);
    }

    private void checkGlobalIndexConsistency(Connection conn, boolean isUniqueIndex) throws SQLException {
        Statement st;
        block7: {
            VM serverVM1;
            ResultSet rs0;
            PreparedStatement ps;
            int numRows;
            String createTableDDL;
            block6: {
                st = conn.createStatement();
                createTableDDL = null;
                createTableDDL = !isUniqueIndex ? "CREATE TABLE TEST.TABLE1 (COL1 INT, COL2 INT PRIMARY KEY, COL3 VARCHAR(10)) PARTITION BY RANGE (COL1) (VALUES BETWEEN 0 AND 50, VALUES BETWEEN 50 AND 100) REDUNDANCY 1" : "CREATE TABLE TEST.TABLE1 (COL1 INT PRIMARY KEY, COL2 INT NOT NULL UNIQUE, COL3 VARCHAR(10)) PARTITION BY RANGE (COL1) (VALUES BETWEEN 0 AND 50, VALUES BETWEEN 50 AND 100) REDUNDANCY 1";
                st.execute(createTableDDL);
                numRows = 100;
                ps = conn.prepareStatement("INSERT INTO TEST.TABLE1 VALUES(?, ?, ?)");
                for (int i = 0; i < numRows; ++i) {
                    ps.setInt(1, i);
                    ps.setInt(2, i);
                    ps.setString(3, "" + i);
                    ps.addBatch();
                }
                ps.executeBatch();
                rs0 = st.executeQuery("select count(*) from test.TABLE1");
                CheckTableDUnit.assertTrue((boolean)rs0.next());
                CheckTableDUnit.assertEquals((int)numRows, (int)rs0.getInt(1));
                rs0.close();
                rs0 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE1')");
                serverVM1 = (VM)this.serverVMs.get(0);
                VM serverVM2 = (VM)this.serverVMs.get(1);
                serverVM1.invoke(CheckTableDUnit.class, "deleteEntryFromGlobalIndex", new Object[]{"/TEST/TABLE1", new Object[]{new SQLInteger(2), new SQLInteger(90)}});
                try {
                    rs0 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE1')");
                    CheckTableDUnit.fail((String)"SYS.CHECK_TABLE_EX should have thrown an exception");
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("X0X64")) break block6;
                    throw se;
                }
            }
            st.execute("DROP TABLE TEST.TABLE1");
            st.execute(createTableDDL);
            for (int i = 0; i < numRows; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.setString(3, "" + i);
                ps.addBatch();
            }
            ps.executeBatch();
            serverVM1.invoke(CheckTableDUnit.class, "insertEntryIntoGlobalIndex", new Object[]{"/TEST/TABLE1", 55555, "somevalue"});
            try {
                rs0 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE1')");
                CheckTableDUnit.fail((String)"SYS.CHECK_TABLE_EX should have thrown an exception");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0Y55")) break block7;
                throw se;
            }
        }
        st.execute("DROP TABLE TEST.TABLE1");
    }

    private void checkGlobalIndexConsistencyCompositeKey(Connection conn) throws SQLException {
        Statement st;
        block3: {
            st = conn.createStatement();
            String createTableDDL = null;
            createTableDDL = "CREATE TABLE TEST.TABLE_CK (COL1 INT, COL2 INT, COL3 VARCHAR(10), CONSTRAINT P_KEY PRIMARY KEY (COL2, COL3)) PARTITION BY RANGE (COL1) (VALUES BETWEEN 0 AND 50, VALUES BETWEEN 50 AND 100) REDUNDANCY 1";
            st.execute(createTableDDL);
            PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST.TABLE_CK VALUES(?, ?, ?)");
            for (int i = 0; i < 100; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.setString(3, "" + i);
                ps.addBatch();
            }
            ps.executeBatch();
            ResultSet rs0 = st.executeQuery("select count(*) from test.TABLE_CK");
            CheckTableDUnit.assertTrue((boolean)rs0.next());
            CheckTableDUnit.assertEquals((int)100, (int)rs0.getInt(1));
            rs0.close();
            rs0 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE_CK')");
            VM serverVM1 = (VM)this.serverVMs.get(0);
            DataValueDescriptor[] dvds1 = new DataValueDescriptor[]{new SQLInteger(Integer.valueOf(2)), new SQLVarchar("2")};
            CompositeRegionKey key1 = new CompositeRegionKey(dvds1);
            DataValueDescriptor[] dvds2 = new DataValueDescriptor[]{new SQLInteger(Integer.valueOf(90)), new SQLVarchar("90")};
            CompositeRegionKey key2 = new CompositeRegionKey(dvds2);
            serverVM1.invoke(CheckTableDUnit.class, "deleteEntryFromGlobalIndex", new Object[]{"/TEST/TABLE_CK", new Object[]{key1, key2}});
            try {
                rs0 = st.executeQuery("VALUES SYS.CHECK_TABLE_EX('TEST', 'TABLE_CK')");
                CheckTableDUnit.fail((String)"SYS.CHECK_TABLE_EX should have thrown an exception");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0X64")) break block3;
                throw se;
            }
        }
        st.execute("DROP TABLE TEST.TABLE_CK");
    }

    public static void deleteEntryFromGlobalIndex(String regionPath, Object[] keys) {
        LocalRegion r = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)false, (boolean)false);
        GfxdIndexManager sqlim = (GfxdIndexManager)r.getIndexUpdater();
        List list = sqlim.getIndexContainers();
        CheckTableDUnit.getGlobalLogger().info((Object)("list of index containers are: " + Arrays.toString(list.toArray())));
        for (GemFireContainer gfc : list) {
            if (!gfc.isGlobalIndex()) continue;
            CheckTableDUnit.getGlobalLogger().info((Object)("global index region is =" + gfc.getRegion().getDisplayName()));
            for (Object key : keys) {
                gfc.getRegion().destroy(key);
            }
        }
    }

    public static void insertEntryIntoGlobalIndex(String regionPath, Object key, Object value) {
        LocalRegion r = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)false, (boolean)false);
        GfxdIndexManager sqlim = (GfxdIndexManager)r.getIndexUpdater();
        List list = sqlim.getIndexContainers();
        CheckTableDUnit.getGlobalLogger().info((Object)("list of index containers are: " + Arrays.toString(list.toArray())));
        for (GemFireContainer gfc : list) {
            if (!gfc.isGlobalIndex()) continue;
            DataValueDescriptor[] dvds = new DataValueDescriptor[]{new SQLInteger((Integer)key)};
            CompositeRegionKey k = new CompositeRegionKey(dvds);
            gfc.getRegion().put((Object)k, value);
        }
    }
}

