/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.org.jgroups.oswego.concurrent.WriterPreferenceReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.locks.impl.GfxdReentrantReadWriteLock;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import junit.framework.TestCase;

public class GfxdLocalLockTest
extends JdbcTestBase {
    private static final SharedStruct sharedVal = new SharedStruct();
    private static final AtomicInteger currentReaders = new AtomicInteger();
    private static final AtomicInteger currentWriters = new AtomicInteger();
    private static AcquireReleaseLocks currentLock;
    private static final AtomicInteger globalId;

    public GfxdLocalLockTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadWriteLockWithPerf() throws Exception {
        int numReaders = 100;
        int numWriters = 10;
        int totalRuns = 4000000;
        currentReaders.set(0);
        currentWriters.set(0);
        final Object startObject = new Object();
        Thread[] readers = new Thread[100];
        Thread[] writers = new Thread[10];
        Runnable readRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = startObject;
                    synchronized (object) {
                        startObject.wait();
                    }
                    for (int count = 1; count <= 40000; ++count) {
                        currentLock.acquireReadLock();
                        try {
                            long longVal = sharedVal.longVal;
                            currentReaders.incrementAndGet();
                            TestCase.assertEquals((int)0, (int)currentWriters.get());
                            double doubleVal = Double.longBitsToDouble(longVal);
                            double actualDouble = sharedVal.doubleVal;
                            long actualDoubleLong = Double.doubleToLongBits(actualDouble);
                            TestCase.assertEquals((long)longVal, (long)actualDoubleLong);
                            TestCase.assertEquals((Object)doubleVal, (Object)actualDouble);
                            TestCase.assertTrue((currentReaders.decrementAndGet() >= 0 ? 1 : 0) != 0);
                            continue;
                        }
                        finally {
                            currentLock.releaseReadLock();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        Runnable writeRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = startObject;
                    synchronized (object) {
                        startObject.wait();
                    }
                    for (int count = 1; count <= 40000; ++count) {
                        currentLock.acquireWriteLock();
                        TestCase.assertEquals((int)1, (int)currentWriters.incrementAndGet());
                        try {
                            for (int iters = 1; iters <= 10; ++iters) {
                                long longVal = sharedVal.longVal;
                                sharedVal.longVal += 10L;
                                TestCase.assertEquals((long)longVal, (long)Double.doubleToLongBits(sharedVal.doubleVal));
                                TestCase.assertEquals((int)0, (int)currentReaders.get());
                                TestCase.assertEquals((int)1, (int)currentWriters.get());
                                sharedVal.doubleVal = Double.longBitsToDouble(sharedVal.longVal);
                            }
                            currentWriters.decrementAndGet();
                            continue;
                        }
                        finally {
                            currentLock.releaseWriteLock();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        AcquireReleaseLocks[] allLocks = new AcquireReleaseLocks[]{new GfxdAcquireReleaseLocks(), new WriterPreferenceAcquireReleaseLocks(), new ReentrantAcquireReleaseLocks()};
        for (int times = 1; times <= 3; ++times) {
            AcquireReleaseLocks[] arr$ = allLocks;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int index;
                int index2;
                AcquireReleaseLocks lock;
                currentLock = lock = arr$[i$];
                for (index2 = 0; index2 < 100; ++index2) {
                    readers[index2] = new Thread(readRun);
                    readers[index2].start();
                }
                for (index2 = 0; index2 < 10; ++index2) {
                    writers[index2] = new Thread(writeRun);
                    writers[index2].start();
                }
                Thread.sleep(500L);
                sharedVal.init(0L);
                long start = System.currentTimeMillis();
                Object object = startObject;
                synchronized (object) {
                    startObject.notifyAll();
                }
                for (index = 0; index < 100; ++index) {
                    readers[index].join();
                }
                for (index = 0; index < 10; ++index) {
                    writers[index].join();
                }
                long end = System.currentTimeMillis();
                GfxdLocalLockTest.assertEquals((long)40000000L, (long)GfxdLocalLockTest.sharedVal.longVal);
                GfxdLocalLockTest.assertEquals((long)40000000L, (long)Double.doubleToLongBits(GfxdLocalLockTest.sharedVal.doubleVal));
                GfxdLocalLockTest.assertEquals((int)0, (int)currentReaders.get());
                GfxdLocalLockTest.assertEquals((int)0, (int)currentWriters.get());
                GfxdLocalLockTest.getLogger().info((Object)("Total time taken with " + currentLock + " in iteration " + times + ": " + (end - start) + "ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadWriteLockWithPerf2() throws Exception {
        int numReaders = 20;
        int numWriters = 2;
        int totalRuns = 4000000;
        int writerInterval = 1000;
        currentReaders.set(0);
        currentWriters.set(0);
        final Object startObject = new Object();
        Thread[] readers = new Thread[20];
        Thread[] writers = new Thread[2];
        Runnable readRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = startObject;
                    synchronized (object) {
                        startObject.wait();
                    }
                    for (int count = 1; count <= 200000; ++count) {
                        currentLock.acquireReadLock();
                        try {
                            long longVal = sharedVal.longVal;
                            currentReaders.incrementAndGet();
                            TestCase.assertEquals((int)0, (int)currentWriters.get());
                            double doubleVal = Double.longBitsToDouble(longVal);
                            double actualDouble = sharedVal.doubleVal;
                            long actualDoubleLong = Double.doubleToLongBits(actualDouble);
                            TestCase.assertEquals((long)longVal, (long)actualDoubleLong);
                            TestCase.assertEquals((Object)doubleVal, (Object)actualDouble);
                            TestCase.assertTrue((currentReaders.decrementAndGet() >= 0 ? 1 : 0) != 0);
                            continue;
                        }
                        finally {
                            currentLock.releaseReadLock();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        Runnable writeRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int myOffset = globalId.incrementAndGet() * 1000;
                    Object object = startObject;
                    synchronized (object) {
                        startObject.wait();
                    }
                    for (int count = 1; count <= 2000000; ++count) {
                        if (count < myOffset || (count - myOffset) % 1000 != 0) {
                            TestCase.assertTrue((currentReaders.get() >= 0 ? 1 : 0) != 0);
                            TestCase.assertTrue((currentWriters.get() >= 0 && currentWriters.get() < 2 ? 1 : 0) != 0);
                            continue;
                        }
                        currentLock.acquireWriteLock();
                        TestCase.assertEquals((int)1, (int)currentWriters.incrementAndGet());
                        try {
                            long longVal = sharedVal.longVal;
                            sharedVal.longVal += 10L;
                            TestCase.assertEquals((long)longVal, (long)Double.doubleToLongBits(sharedVal.doubleVal));
                            TestCase.assertEquals((int)0, (int)currentReaders.get());
                            TestCase.assertEquals((int)1, (int)currentWriters.get());
                            sharedVal.doubleVal = Double.longBitsToDouble(sharedVal.longVal);
                            currentWriters.decrementAndGet();
                            continue;
                        }
                        finally {
                            currentLock.releaseWriteLock();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        AcquireReleaseLocks[] allLocks = new AcquireReleaseLocks[]{new GfxdAcquireReleaseLocks(), new WriterPreferenceAcquireReleaseLocks(), new ReentrantAcquireReleaseLocks()};
        for (int times = 1; times <= 3; ++times) {
            AcquireReleaseLocks[] arr$ = allLocks;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int index;
                int index2;
                AcquireReleaseLocks lock;
                currentLock = lock = arr$[i$];
                globalId.set(0);
                for (index2 = 0; index2 < 20; ++index2) {
                    readers[index2] = new Thread(readRun);
                    readers[index2].start();
                }
                for (index2 = 0; index2 < 2; ++index2) {
                    writers[index2] = new Thread(writeRun);
                    writers[index2].start();
                }
                Thread.sleep(500L);
                sharedVal.init(10L);
                long start = System.currentTimeMillis();
                Object object = startObject;
                synchronized (object) {
                    startObject.notifyAll();
                }
                for (index = 0; index < 20; ++index) {
                    readers[index].join();
                }
                for (index = 0; index < 2; ++index) {
                    writers[index].join();
                }
                long end = System.currentTimeMillis();
                GfxdLocalLockTest.assertEquals((long)40000L, (long)GfxdLocalLockTest.sharedVal.longVal);
                GfxdLocalLockTest.assertEquals((long)40000L, (long)Double.doubleToLongBits(GfxdLocalLockTest.sharedVal.doubleVal));
                GfxdLocalLockTest.assertEquals((int)0, (int)currentReaders.get());
                GfxdLocalLockTest.assertEquals((int)0, (int)currentWriters.get());
                GfxdLocalLockTest.getLogger().info((Object)("Total time taken with " + currentLock + " in iteration " + times + ": " + (end - start) + "ms"));
            }
        }
    }

    static {
        globalId = new AtomicInteger(0);
    }

    private static final class ReentrantAcquireReleaseLocks
    extends ReentrantReadWriteLock
    implements AcquireReleaseLocks {
        private ReentrantAcquireReleaseLocks() {
        }

        @Override
        public void acquireReadLock() throws InterruptedException {
            this.readLock().lock();
        }

        @Override
        public void acquireWriteLock() throws InterruptedException {
            this.writeLock().lock();
        }

        @Override
        public void releaseReadLock() {
            this.readLock().unlock();
        }

        @Override
        public void releaseWriteLock() {
            this.writeLock().unlock();
        }
    }

    private static final class WriterPreferenceAcquireReleaseLocks
    extends WriterPreferenceReadWriteLock
    implements AcquireReleaseLocks {
        private WriterPreferenceAcquireReleaseLocks() {
        }

        @Override
        public void acquireReadLock() throws InterruptedException {
            this.readLock().acquire();
        }

        @Override
        public void acquireWriteLock() throws InterruptedException {
            this.writeLock().acquire();
        }

        @Override
        public void releaseReadLock() {
            this.readLock().release();
        }

        @Override
        public void releaseWriteLock() {
            this.writeLock().release();
        }
    }

    private static final class GfxdAcquireReleaseLocks
    implements AcquireReleaseLocks {
        private final GfxdReentrantReadWriteLock lock = new GfxdReentrantReadWriteLock((Object)"GfxdLocalLockTest", false);

        private GfxdAcquireReleaseLocks() {
        }

        @Override
        public void acquireReadLock() throws InterruptedException {
            this.lock.attemptReadLock(-1L, (Object)Thread.currentThread());
        }

        @Override
        public void acquireWriteLock() throws InterruptedException {
            this.lock.attemptWriteLock(-1L, (Object)Thread.currentThread());
        }

        @Override
        public void releaseReadLock() {
            this.lock.releaseReadLock();
        }

        @Override
        public void releaseWriteLock() {
            this.lock.releaseWriteLock((Object)Thread.currentThread());
        }

        public String toString() {
            return this.lock.toString();
        }
    }

    private static interface AcquireReleaseLocks {
        public void acquireReadLock() throws InterruptedException;

        public void releaseReadLock();

        public void acquireWriteLock() throws InterruptedException;

        public void releaseWriteLock();
    }

    private static final class SharedStruct {
        long longVal;
        double doubleVal;

        private SharedStruct() {
        }

        void init(long val) {
            this.longVal = val;
            this.doubleVal = Double.longBitsToDouble(val);
        }
    }
}

