/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.distributed.internal.AbstractDistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.junit.UnitTest;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.impl.io.DirFile;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.jdbc.ClientDriver;
import com.pivotal.gemfirexd.tools.GfxdUtilLauncher;
import com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher;
import io.snappydata.test.dunit.DistributedTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FabricServerTest
extends TestUtil
implements UnitTest {
    private static final String PROP_FILE_NAME = "gemfirexd-server.properties";

    public FabricServerTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUp() throws Exception {
        try {
            if (GemFireStore.getBootingInstance() != null) {
                FabricServerTest.shutDown();
            }
            currentUserName = null;
            currentUserPassword = null;
        }
        finally {
            super.setUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            FabricServerTest.shutDown();
            currentUserName = null;
            currentUserPassword = null;
        }
        finally {
            super.tearDown();
            new File(PROP_FILE_NAME).delete();
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(FabricServerTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNativeCalls() throws Exception {
        int serverProcId;
        NativeCalls nc = NativeCalls.getInstance();
        int myProcId = nc.getProcessId();
        FabricServerTest.assertTrue((myProcId != 0 ? 1 : 0) != 0);
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        FabricServerTest.assertTrue((String)("Unexpected my processID=" + myProcId + ", runtime name=" + jvmName), (boolean)jvmName.startsWith(String.valueOf(myProcId)));
        FabricServerTest.assertTrue((boolean)nc.isProcessActive(myProcId));
        String productDir = System.getProperty("GEMFIREXD");
        FabricServerTest.assertTrue((productDir != null && productDir.length() > 0 ? 1 : 0) != 0);
        DirFile file = new DirFile("nc-server");
        file.deleteAll();
        FabricServerTest.assertTrue((String)("failed to create directory " + file.getAbsolutePath()), (boolean)file.mkdir());
        String workingDir = file.getAbsolutePath();
        char pathSep = DirFile.separatorChar;
        String utilLauncher = nc.getOSType().isWindows() ? productDir + pathSep + "bin" + pathSep + "gfxd.bat" : productDir + pathSep + "bin" + pathSep + "gfxd";
        String[] startOps = new String[]{utilLauncher, "server", "start", "-dir=" + workingDir, "-run-netserver=false", "-log-file=./" + FabricServerTest.getTestName() + "-server.log", "-mcast-port=0"};
        Process serverProc = new ProcessBuilder(startOps).start();
        try {
            String output = FabricServerTest.getProcessOutput(serverProc, 0, 120000, null);
            Matcher mt = Pattern.compile("pid:\\s*([0-9]*)\\s*status:\\s*(\\w*)", 8).matcher(output);
            FabricServerTest.assertTrue((String)("Got output: " + output), (boolean)mt.find());
            FabricServerTest.assertEquals((int)2, (int)mt.groupCount());
            serverProcId = Integer.valueOf(output.substring(mt.start(1), mt.end(1)));
            FabricServerTest.assertTrue((boolean)output.substring(mt.start(2)).startsWith("running"));
            FabricServerTest.assertTrue((boolean)nc.isProcessActive(serverProcId));
            this.checkServerStatus(utilLauncher, workingDir, "running");
            FabricServerTest.assertTrue((boolean)nc.killProcess(serverProcId));
            while (nc.isProcessActive(serverProcId)) {
                Thread.sleep(200L);
            }
            this.checkServerStatus(utilLauncher, workingDir, "stopped");
        }
        catch (Throwable throwable) {
            this.waitForProcess(new ProcessBuilder(utilLauncher, "server", "stop", "-dir=" + workingDir).start(), 120000);
            throw throwable;
        }
        this.waitForProcess(new ProcessBuilder(utilLauncher, "server", "stop", "-dir=" + workingDir).start(), 120000);
        this.checkServerStatus(utilLauncher, workingDir, "stopped");
        FabricServerTest.assertFalse((boolean)nc.isProcessActive(serverProcId));
        FabricServerTest.assertEquals((String)productDir, (String)System.getenv("GEMFIREXD"));
        FabricServerTest.assertEquals((String)productDir, (String)nc.getEnvironment("GEMFIREXD"));
        nc.setEnvironment("GEMFIREXD_TEST", productDir);
        FabricServerTest.assertEquals((String)productDir, (String)System.getenv("GEMFIREXD_TEST"));
        FabricServerTest.assertEquals((String)productDir, (String)nc.getEnvironment("GEMFIREXD_TEST"));
        nc.setEnvironment("GEMFIREXD_TEST", null);
        FabricServerTest.assertNull((Object)System.getenv("GEMFIREXD_TEST"));
        FabricServerTest.assertNull((Object)nc.getEnvironment("GEMFIREXD_TEST"));
        nc.setEnvironment("GEMFIREXD", null);
        FabricServerTest.assertNull((Object)System.getenv("GEMFIREXD"));
        FabricServerTest.assertNull((Object)nc.getEnvironment("GEMFIREXD"));
        nc.setEnvironment("GEMFIREXD", productDir);
        FabricServerTest.assertEquals((String)productDir, (String)System.getenv("GEMFIREXD"));
        FabricServerTest.assertEquals((String)productDir, (String)nc.getEnvironment("GEMFIREXD"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGfxdServerLauncherStartupOptions() throws Exception {
        URI clientJarFile = ClientDriver.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        File clientJar = new File(clientJarFile);
        FabricServerTest.assertTrue((String)("client jar " + clientJarFile + " does not exist"), (boolean)clientJar.exists());
        FabricServerTest.assertTrue((String)("unexpected client jar length=" + clientJar.length()), (clientJar.length() < 6000000L ? 1 : 0) != 0);
        URI toolsJarFile = GfxdServerLauncher.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        File toolsJar = new File(toolsJarFile);
        FabricServerTest.assertTrue((String)("tools jar " + toolsJarFile + " does not exist"), (boolean)toolsJar.exists());
        FabricServerTest.assertTrue((String)("unexpected tools jar length=" + toolsJar.length()), (toolsJar.length() < 1000000L ? 1 : 0) != 0);
        DirFile file = new DirFile("utilLauncher");
        file.deleteAll();
        FabricServerTest.assertTrue((String)("failed to create directory " + file.getAbsolutePath()), (boolean)file.mkdir());
        file.deleteOnExit();
        CacheServerLauncher.DONT_EXIT_AFTER_LAUNCH = true;
        String workingdir = file.getAbsolutePath();
        String[] startOps = new String[]{"-dir=" + workingdir, "-run-netserver=false", "-log-file=./" + FabricServerTest.getTestName() + "-utilLauncher.log", "-mcast-port=0", "-heap-size=512m"};
        String[] cmd = new String[startOps.length + 2];
        cmd[0] = "server";
        cmd[1] = "start";
        for (int i = 2; i < startOps.length; ++i) {
            cmd[i] = startOps[i - 2];
        }
        try {
            GfxdServerLauncher l = new GfxdServerLauncher("Fabric Server Test Instance");
            Map m = l.getStartOptions(startOps);
            List vmargs = (List)m.get("vmargs");
            FabricServerTest.assertTrue((String)"expected UseParNewGC definition ", (boolean)vmargs.contains("-XX:+UseParNewGC"));
            FabricServerTest.assertTrue((String)"expected UseConcMarkSweepGC definition ", (boolean)vmargs.contains("-XX:+UseConcMarkSweepGC"));
            FabricServerTest.assertTrue((String)"expected CMSInitiatingOccupancyFraction definition", (boolean)vmargs.contains("-XX:CMSInitiatingOccupancyFraction=50"));
            GfxdUtilLauncher.main((String[])cmd);
        }
        catch (Throwable throwable) {
            try {
                GfxdUtilLauncher.main((String[])new String[]{"server", "stop", "-dir=" + workingdir});
            }
            finally {
                file.deleteAll();
            }
            throw throwable;
        }
        try {
            GfxdUtilLauncher.main((String[])new String[]{"server", "stop", "-dir=" + workingdir});
        }
        finally {
            file.deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGfxdServerScriptStartupOptions() throws Exception {
        DirFile file = new DirFile("utilLauncher");
        file.deleteAll();
        FabricServerTest.assertTrue((String)("failed to create directory " + file.getAbsolutePath()), (boolean)file.mkdir());
        file.deleteOnExit();
        String workingdir = file.getAbsolutePath();
        String productDir = System.getProperty("GEMFIREXD");
        String launcher = productDir + "/bin/gfxd";
        if (System.getProperty("os.name").startsWith("Windows")) {
            launcher = launcher + ".bat";
        }
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        try {
            Connection conn;
            File launcherFile = new File(launcher);
            if (!launcherFile.exists()) {
                throw new Exception("launcher " + launcher + " does not exist");
            }
            Object[] cmdOps = new String[]{launcher, "server", "start", "-dir=" + workingdir, "-client-bind-address=0.0.0.0", "-client-port=" + port, "-log-file=./" + FabricServerTest.getTestName() + "-utilLauncher.log", "-log-level=config", "-mcast-port=" + mcastPort, "-heap-size=512m"};
            FabricServerTest.getLogger().info((Object)("launching start with " + Arrays.toString(cmdOps)));
            Process proc = Runtime.getRuntime().exec((String[])cmdOps, null, (File)file);
            FabricServerTest.assertEquals((int)0, (int)this.waitForProcess(proc, 120000));
            int tries = 1;
            while (true) {
                try {
                    conn = FabricServerTest.getNetConnection(port, null, null);
                }
                catch (SQLException sqle) {
                    if (tries++ < 5 && ("08006".equals(sqle.getSQLState()) || "08001".equals(sqle.getSQLState()))) {
                        Thread.sleep(100L);
                        continue;
                    }
                    throw sqle;
                }
                break;
            }
            InetAddress host = SocketCreator.getLocalHost();
            ResultSet rs = conn.createStatement().executeQuery("select id from sys.members");
            FabricServerTest.assertTrue((boolean)rs.next());
            FabricServerTest.assertTrue((String)("member ID " + rs.getString(1) + " does not contain this host: " + host.getHostName()), (boolean)rs.getString(1).contains(host.getHostName()));
            FabricServerTest.assertFalse((boolean)rs.next());
            conn.close();
        }
        catch (Throwable throwable) {
            Object[] cmdOps = new String[]{launcher, "server", "stop", "-dir=" + workingdir};
            FabricServerTest.getLogger().info((Object)("launching stop with " + Arrays.toString(cmdOps)));
            Process proc = Runtime.getRuntime().exec((String[])cmdOps, null, (File)file);
            FabricServerTest.assertEquals((int)0, (int)this.waitForProcess(proc, 120000));
            file.deleteAll();
            throw throwable;
        }
        Object[] cmdOps = new String[]{launcher, "server", "stop", "-dir=" + workingdir};
        FabricServerTest.getLogger().info((Object)("launching stop with " + Arrays.toString(cmdOps)));
        Process proc = Runtime.getRuntime().exec((String[])cmdOps, null, (File)file);
        FabricServerTest.assertEquals((int)0, (int)this.waitForProcess(proc, 120000));
        file.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertiesFile() throws Exception {
        Properties outProps = new Properties();
        File f = this.createPropertyFile(outProps);
        System.setProperty("gemfirexd.properties", PROP_FILE_NAME);
        try {
            Class.forName("com.pivotal.gemfirexd.jdbc.EmbeddedDriver");
            jdbcConn = DriverManager.getConnection(FabricServerTest.getProtocol());
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            this.validateProperties(outProps);
        }
        finally {
            f.delete();
            try {
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertiesFileAbsolutePath() throws Exception {
        Properties outProps = new Properties();
        this.createPropertyFile(outProps);
        File f = new File(".");
        System.setProperty("gemfirexd.properties", f.getAbsolutePath() + File.separatorChar + PROP_FILE_NAME);
        try {
            FabricServer fab = FabricServiceManager.getFabricServerInstance();
            fab.start(null);
            jdbcConn = TestUtil.getConnection();
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            this.validateProperties(outProps);
        }
        finally {
            try {
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testPropertiesFileLocationPreference() throws Exception {
        Properties outProps = new Properties();
        File checkNoFile = new File(".", "gemfirexd.properties");
        FabricServerTest.assertFalse((boolean)checkNoFile.exists());
        File f = new File(System.getProperty("user.home") + File.separatorChar + "gemfirexd.properties");
        FabricServerTest.getLogger().info((Object)("creating file in " + f.getAbsolutePath()));
        f.createNewFile();
        this.createPropertyFile(outProps, f, null);
        try {
            FabricServer fab = FabricServiceManager.getFabricServerInstance();
            fab.start(null);
            jdbcConn = TestUtil.getConnection();
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            this.validateProperties(outProps);
        }
        finally {
            f.delete();
            try {
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
        FabricServerTest.assertFalse((boolean)f.exists());
        File wrongf = new File(System.getProperty("user.home") + File.separatorChar + "gemfirexd.properties");
        wrongf.createNewFile();
        Properties distort = new Properties();
        String locatoradd = InetAddress.getLocalHost().getHostName() + "[" + String.valueOf(AvailablePort.getRandomAvailablePort((int)0)) + "]";
        distort.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        distort.setProperty("locators", locatoradd);
        this.createPropertyFile(new Properties(), wrongf, distort);
        System.setProperty("gemfirexd.system.home", System.getProperty("java.io.tmpdir"));
        f = new File(System.getProperty("gemfirexd.system.home") + File.separatorChar + "gemfirexd.properties");
        f.createNewFile();
        this.createPropertyFile(outProps, f, null);
        try {
            FabricServer fab = FabricServiceManager.getFabricServerInstance();
            fab.start(null);
            jdbcConn = TestUtil.getConnection();
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            this.validateProperties(outProps);
        }
        finally {
            f.delete();
            wrongf.delete();
            try {
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocalPropertiesFileLocationPreference() throws Exception {
        Properties outProps = new Properties();
        File checkLocalFile = new File(".", "gemfirexd.properties");
        FabricServerTest.assertFalse((boolean)checkLocalFile.exists());
        File f = new File(".", "gemfirexd.properties");
        try {
            f.createNewFile();
        }
        catch (IOException ioe) {
            FabricServerTest.getLogger().error((Object)("File couldn't be created for " + f), (Throwable)ioe);
            throw ioe;
        }
        this.createPropertyFile(outProps, f, null);
        try {
            FabricServer fab = FabricServiceManager.getFabricServerInstance();
            fab.start(null);
            jdbcConn = TestUtil.getConnection();
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            this.validateProperties(outProps);
        }
        finally {
            f.delete();
            try {
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
        FabricServerTest.assertFalse((boolean)f.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionPropOverridingPropertiesFile() throws Exception {
        Properties outProps = new Properties();
        File f = this.createPropertyFile(outProps);
        System.setProperty("gemfirexd.properties", PROP_FILE_NAME);
        Properties connectionProps = new Properties();
        connectionProps.setProperty("conserve-sockets", "true");
        connectionProps.setProperty("enable-time-statistics", "false");
        connectionProps.setProperty("statistic-sampling-enabled", "false");
        connectionProps.setProperty("statistic-archive-file", FabricServerTest.getTestName() + ".connection_override.gfs");
        connectionProps.setProperty("log-file", FabricServerTest.getTestName() + ".connection_override.log");
        try {
            FabricServerTest.loadDriver();
            jdbcConn = DriverManager.getConnection(FabricServerTest.getProtocol(), connectionProps);
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            outProps.putAll((Map<?, ?>)connectionProps);
            this.validateProperties(outProps);
        }
        finally {
            try {
                f.delete();
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSystemPropOverridingPropertiesFile() throws Exception {
        Properties outProps = new Properties();
        File f = this.createPropertyFile(outProps);
        System.setProperty("gemfirexd.properties", PROP_FILE_NAME);
        System.setProperty("gemfire.conserve-sockets", "true");
        System.setProperty("gemfire.enable-time-statistics", "false");
        System.setProperty("gemfire.statistic-sampling-enabled", "false");
        System.setProperty("gemfire.statistic-archive-file", FabricServerTest.getTestName() + ".system_override.gfs");
        System.setProperty(GfxdConstants.GFXD_LOG_FILE, FabricServerTest.getTestName() + ".system_override.log");
        try {
            FabricServerTest.loadDriver();
            jdbcConn = DriverManager.getConnection(FabricServerTest.getProtocol());
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                if (key.startsWith("gemfire.")) {
                    outProps.put(key.substring("gemfire.".length()), val);
                    continue;
                }
                if (!key.startsWith(GfxdConstants.GFXD_PREFIX)) continue;
                outProps.put(key.substring(GfxdConstants.GFXD_PREFIX.length()), val);
            }
            this.validateProperties(outProps);
        }
        finally {
            f.delete();
            try {
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSystemPropOverridingConnPropOverridingPropertiesFile() throws Exception {
        Properties outProps = new Properties();
        File f = this.createPropertyFile(outProps);
        System.setProperty("gemfirexd.properties", PROP_FILE_NAME);
        System.setProperty("gemfire.conserve-sockets", "true");
        System.setProperty("gemfire.enable-time-statistics", "false");
        System.setProperty("gemfire.statistic-sampling-enabled", "false");
        System.setProperty("gemfire.statistic-archive-file", FabricServerTest.getTestName() + ".system_override.gfs");
        System.setProperty(GfxdConstants.GFXD_LOG_FILE, FabricServerTest.getTestName() + ".system_override.log");
        Properties connectionProps = new Properties();
        connectionProps.setProperty("enable-time-statistics", "false");
        connectionProps.setProperty("statistic-archive-file", FabricServerTest.getTestName() + ".connection_override.gfs");
        connectionProps.setProperty("log-file", FabricServerTest.getTestName() + ".connection_override.log");
        try {
            FabricServerTest.loadDriver();
            jdbcConn = DriverManager.getConnection(FabricServerTest.getProtocol(), connectionProps);
            jdbcConn.createStatement().execute("create table testtable1 ( t int)");
            outProps.putAll((Map<?, ?>)connectionProps);
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                if (key.startsWith("gemfire.")) {
                    outProps.put(key.substring("gemfire.".length()), val);
                    continue;
                }
                if (!key.startsWith(GfxdConstants.GFXD_PREFIX)) continue;
                outProps.put(key.substring(GfxdConstants.GFXD_PREFIX.length()), val);
            }
            this.validateProperties(outProps);
        }
        finally {
            f.delete();
            try {
                if (jdbcConn != null) {
                    FabricServerTest.shutDown();
                }
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNetworkStartupAPI() throws Exception {
        int port;
        Properties outProps = new Properties();
        File f = this.createPropertyFile(outProps);
        System.setProperty("gemfirexd.properties", PROP_FILE_NAME);
        System.setProperty("gemfirexd.drda.startNetworkServer", "true");
        while ((port = AvailablePort.getRandomAvailablePort((int)0)) <= 1527) {
        }
        System.setProperty("gemfirexd.drda.portNumber", String.valueOf(port));
        FabricServer fabapi = FabricServiceManager.getFabricServerInstance();
        try {
            fabapi.start(null);
            NetworkInterface ni = fabapi.startNetworkServer(null, -1, null);
            try {
                Connection conn;
                String netUrl;
                InetAddress localHost;
                block18: {
                    block17: {
                        ni.logConnections(true);
                        ni.setMaxThreads(20);
                        ni.setTimeSlice(10);
                        ni.trace(true);
                        int maxT = ni.getMaxThreads();
                        FabricServerTest.assertEquals((int)20, (int)maxT);
                        int timSl = ni.getTimeSlice();
                        FabricServerTest.assertEquals((int)10, (int)timSl);
                        ni.trace(false);
                        try {
                            ni.trace(2, true);
                        }
                        catch (Exception expect) {
                            if (expect.getMessage().equals("java.lang.Exception: Session, 2, not found or other error occurred starting tracing. Check runtimeinfo for valid session numbers and gemfirexd log for possible permission errors or IO errors accessing the trace file.")) break block17;
                            FabricServerTest.getLogger().error((Object)("got exception " + expect.getMessage()), (Throwable)expect);
                        }
                    }
                    Properties curProps = ni.getCurrentProperties();
                    StringBuilder sb = new StringBuilder("# --- Current Properties ---");
                    sb.append(SanityManager.lineSeparator);
                    for (Map.Entry<Object, Object> e : curProps.entrySet()) {
                        sb.append((String)e.getKey());
                        sb.append("=");
                        sb.append((String)e.getValue());
                        sb.append(SanityManager.lineSeparator);
                    }
                    FabricServerTest.getLogger().info((Object)sb.toString());
                    FabricServerTest.getLogger().info((Object)("sysInfo = " + ni.getSysinfo()));
                    FabricServerTest.getLogger().info((Object)("runtimeInfo = " + ni.getRuntimeInfo()));
                    localHost = InetAddress.getByName(null);
                    netUrl = TestUtil.getNetProtocol(localHost.getHostName(), 1527);
                    FabricServerTest.loadNetDriver();
                    conn = DriverManager.getConnection(netUrl);
                    ni.trace(13, true);
                    conn.createStatement().execute("create table testtable1 (v int)");
                    try {
                        conn.createStatement().execute("");
                        FabricServerTest.fail("expected syntax error");
                    }
                    catch (SQLException sqle) {
                        if ("42X01".equals(sqle.getSQLState())) break block18;
                        throw sqle;
                    }
                }
                conn.close();
                netUrl = TestUtil.getNetProtocol(localHost.getHostName(), port);
                Properties props = new Properties();
                props.setProperty("load-balance", "false");
                conn = DriverManager.getConnection(netUrl, FabricServerTest.getNetProperties(props));
                ResultSet rs = conn.createStatement().executeQuery("select KIND, NETSERVERS from SYS.MEMBERS");
                FabricServerTest.assertTrue((String)"expected one row in meta-data query", (boolean)rs.next());
                FabricServerTest.assertEquals((String)"datastore(normal)", (String)rs.getString(1));
                FabricServerTest.assertEquals((String)(this.getFullHost(localHost) + '[' + 1527 + "]," + this.getFullHost(localHost) + '[' + port + ']'), (String)rs.getString(2));
                FabricServerTest.assertFalse((String)"expected no more than one row from SYS.MEMBERS", (boolean)rs.next());
            }
            finally {
                ni.stop();
            }
        }
        finally {
            f.delete();
            try {
                fabapi.stop(null);
            }
            finally {
                System.clearProperty("gemfirexd.drda.startNetworkServer");
                System.clearProperty("gemfirexd.drda.portNumber");
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocatorStartupAPI() throws Exception {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        InetAddress localHost = SocketCreator.getLocalHost();
        Properties props = FabricServerTest.doCommonSetup(null);
        FabricLocator fabapi = FabricServiceManager.getFabricLocatorInstance();
        int port = FabricServerTest.startLocator(localHost.getHostAddress(), -1, props);
        try {
            block30: {
                conn = FabricServerTest.getConnection();
                stmt = conn.createStatement();
                FabricServerTest.addExpectedException(GemFireXDRuntimeException.class);
                try {
                    stmt.execute("create table testapi(id int)");
                    FabricServerTest.fail("expected DDL execution to fail");
                }
                catch (SQLException ex) {
                    if ("38000".equals(ex.getSQLState())) break block30;
                    throw ex;
                }
            }
            FabricServerTest.removeExpectedException(GemFireXDRuntimeException.class);
            rs = stmt.executeQuery("select KIND, LOCATOR from SYS.MEMBERS");
            FabricServerTest.assertTrue((String)"expected one row in meta-data query", (boolean)rs.next());
            FabricServerTest.assertEquals((String)"locator(normal)", (String)rs.getString(1));
            FabricServerTest.assertEquals((String)(localHost.getHostAddress() + '[' + port + ']'), (String)rs.getString(2));
            FabricServerTest.assertFalse((String)"expected no more than one row from SYS.MEMBERS", (boolean)rs.next());
        }
        finally {
            try {
                fabapi.stop(null);
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
        fabapi = FabricServiceManager.getFabricLocatorInstance();
        port = FabricServerTest.startLocator(null, -1, props);
        try {
            block33: {
                conn = FabricServerTest.getConnection();
                stmt = conn.createStatement();
                FabricServerTest.addExpectedException(GemFireXDRuntimeException.class);
                try {
                    stmt.execute("create table testapi(id int)");
                    FabricServerTest.fail("expected DDL execution to fail");
                }
                catch (SQLException ex) {
                    if ("38000".equals(ex.getSQLState())) break block33;
                    throw ex;
                }
            }
            FabricServerTest.removeExpectedException(GemFireXDRuntimeException.class);
            rs = stmt.executeQuery("select KIND, LOCATOR from SYS.MEMBERS");
            FabricServerTest.assertTrue((String)"expected one row in meta-data query", (boolean)rs.next());
            FabricServerTest.assertEquals((String)"locator(normal)", (String)rs.getString(1));
            FabricServerTest.assertEquals((String)("0.0.0.0[" + port + ']'), (String)rs.getString(2));
            FabricServerTest.assertFalse((String)"expected no more than one row from SYS.MEMBERS", (boolean)rs.next());
        }
        finally {
            try {
                fabapi.stop(null);
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
        fabapi = FabricServiceManager.getFabricServerInstance();
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        props = FabricServerTest.doCommonSetup(null);
        ((FabricServer)fabapi).start(props);
        fabapi.startNetworkServer("0.0.0.0", netPort, props);
        InternalLocator gfeLocator = null;
        try {
            int port2 = AvailablePort.getRandomAvailablePort((int)0);
            InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
            gfeLocator = InternalLocator.startLocator((int)port2, null, null, (LogWriterI18n)sys.getLogWriterI18n(), (LogWriterI18n)sys.getSecurityLogWriter().convertToLogWriterI18n(), (InetAddress)localHost, (boolean)false, null, (boolean)true, (boolean)true, null);
            Connection conn2 = FabricServerTest.getNetConnection(netPort, null, null);
            Statement stmt2 = conn2.createStatement();
            stmt2.execute("create table testapi(id int)");
            stmt2.execute("drop table testapi");
            ResultSet rs2 = stmt2.executeQuery("select KIND, LOCATOR, NETSERVERS from SYS.MEMBERS");
            FabricServerTest.assertTrue((String)"expected one row in meta-data query", (boolean)rs2.next());
            FabricServerTest.assertEquals((String)"datastore(loner)", (String)rs2.getString(1));
            if (!rs2.getString(2).equals(localHost.getHostAddress() + '[' + port2 + ']')) {
                FabricServerTest.assertEquals((String)(this.getFullHost(localHost) + '[' + port2 + ']'), (String)rs2.getString(2));
            }
            FabricServerTest.assertEquals((String)(localHost.getCanonicalHostName() + "/0.0.0.0[" + netPort + ']'), (String)rs2.getString(3));
            FabricServerTest.assertFalse((String)"expected no more than one row from SYS.MEMBERS", (boolean)rs2.next());
        }
        finally {
            try {
                if (gfeLocator != null) {
                    gfeLocator.stop();
                }
                fabapi.stop(null);
            }
            finally {
                DistributedSQLTestBase.deleteStrayDataDictionaryDir();
            }
        }
    }

    public void testLocatorStopProblem() throws Exception {
        String testsDir = TestUtil.getResourcesDir();
        System.setProperty("javax.net.debug", "ssl");
        Properties startProps = FabricServerTest.doCommonSetup(null);
        startProps.remove("locators");
        startProps.put("mcast-port", "0");
        startProps.put("log-level", "fine");
        startProps.put("security-log-level", "fine");
        startProps.put("auth-provider", "BUILTIN");
        startProps.put("gemfirexd.user.test", "test123");
        startProps.put("user", "test");
        startProps.put("password", "test123");
        System.setProperty("javax.net.ssl.keyStore", testsDir + "/lib/trusted.keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStore", testsDir + "/lib/trusted.keystore");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        Properties stopProps = new Properties();
        stopProps.put("user", "test");
        stopProps.put("password", "test123");
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        this.runLocatorRestartWithAuth(startProps, stopProps, netPort);
        this.runLocatorRestartWithAuth(startProps, stopProps, netPort);
    }

    private void runLocatorRestartWithAuth(Properties startProps, Properties stopProps, int netPort) throws Exception {
        stopProps.put("user", "test");
        stopProps.put("password", "test123");
        int locPort = AvailablePort.getRandomAvailablePort((int)0);
        FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
        locator.start(null, locPort, startProps);
        Properties socketProps = new Properties();
        socketProps.put("gemfirexd.drda.sslMode", "peerAuthentication");
        NetworkInterface ni = locator.startNetworkServer("localhost", netPort, socketProps);
        FabricServerTest.getLogger().info((Object)("GemFire XD started. State: " + locator.status()));
        ni.stop();
        FabricServerTest.getLogger().info((Object)("GemFire XD stopped. State: " + locator.status()));
        Thread.sleep(3000L);
        ni = locator.startNetworkServer("localhost", netPort, socketProps);
        FabricServerTest.getLogger().info((Object)("GemFire XD started. State: " + locator.status()));
        if (locator.status() == FabricService.State.RUNNING) {
            stopProps.put("stop-netservers", "true");
            locator.stop(stopProps);
            FabricServerTest.getLogger().info((Object)("GemFire XD stopped. State: " + locator.status()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionWithAuthentication() throws SQLException, InterruptedException {
        FabricServer fabapi = FabricServiceManager.getFabricServerInstance();
        String currentHost = DistributedTestBase.getIPLiteral();
        Properties shutdownProp = new Properties();
        shutdownProp.setProperty("user", "sysUser1");
        shutdownProp.setProperty("password", "pwd_sysUser1");
        Properties sysprop = null;
        int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        sysprop = FabricServerTest.doCommonSetup(null);
        sysprop = this.doSecuritySetup(sysprop);
        sysprop.setProperty("log-level", "fine");
        sysprop.setProperty("start-locator", currentHost + "[" + String.valueOf(locatorPort) + "]");
        sysprop.setProperty("locators", currentHost + "[" + String.valueOf(locatorPort) + "]");
        fabapi.start(sysprop);
        try {
            Connection conn;
            block18: {
                Properties p;
                block17: {
                    block16: {
                        block15: {
                            FabricServerTest.addExpectedException(SQLException.class);
                            try {
                                TestUtil.getConnection();
                                FabricServerTest.fail("Security exception expected ... ");
                            }
                            catch (SQLException sqle) {
                                if ("08004".equals(sqle.getSQLState())) break block15;
                                throw GemFireXDRuntimeException.newRuntimeException((String)"unexpected exception ", (Throwable)sqle);
                            }
                        }
                        Properties sysProp = new Properties();
                        sysProp.setProperty("user", "sysUser1");
                        sysProp.setProperty("password", "pwd_sysUser1");
                        conn = TestUtil.getConnection(sysProp);
                        CallableStatement cs = conn.prepareCall("CALL sys.create_user('firstDBUser', 'conectme')");
                        cs.execute();
                        conn.createStatement().execute("CALL sys.drop_user('firstDBUser')");
                        cs = conn.prepareCall("CALL sys.create_user('gemfirexd.user.sysUser1', 'raise_28503')");
                        try {
                            cs.execute();
                            FabricServerTest.fail("shouldn't have passed without exception ..");
                        }
                        catch (SQLException sqle) {
                            if ("28503".equals(sqle.getSQLState())) break block16;
                            throw GemFireXDRuntimeException.newRuntimeException((String)("unexpected exception with state " + sqle.getSQLState()), (Throwable)sqle);
                        }
                    }
                    conn.close();
                    p = new Properties();
                    p.put("sync-commits", "true");
                    conn = DriverManager.getConnection(TestUtil.getProtocol() + ";user=sysUser1;password=pwd_sysUser1;", p);
                    conn.createStatement().execute("create schema test_schema authorization firstDBUser ");
                    CallableStatement cs1 = conn.prepareCall("CALL sys.create_user('gemfirexd.user.firstDBUser', 'conectme__X')");
                    cs1.execute();
                    try {
                        CallableStatement cs3 = conn.prepareCall("CALL sys.create_user('gemfirexd.user.firstDBUser', 'conectme')");
                        cs3.execute();
                        FabricServerTest.fail("Expected user already defined exception.");
                    }
                    catch (SQLException sqle) {
                        if ("28504".equals(sqle.getSQLState())) break block17;
                        FabricServerTest.fail("Expected user already defined exception", sqle);
                    }
                }
                CallableStatement cs2 = conn.prepareCall("CALL sys.change_password('gemfirexd.user.firstDBUser', '', 'conectme')");
                cs2.execute();
                conn.close();
                conn = DriverManager.getConnection(TestUtil.getProtocol() + ";user=firstDBUser;password=conectme;", p);
                try {
                    conn.createStatement().execute("drop table test_schema.checkTab");
                }
                catch (SQLException se) {
                    if ("42Y55".equals(se.getSQLState())) break block18;
                    throw se;
                }
            }
            conn.createStatement().execute("create table test_schema.checkTab ( id int, cdesc varchar(10) )");
            conn.close();
        }
        finally {
            FabricServerTest.removeExpectedException(SQLException.class);
            try {
                fabapi.stop(shutdownProp);
            }
            catch (Exception ignore) {
                FabricServerTest.getLogger().warn((Object)"Exception occurred while shutting down with credential ", (Throwable)ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGatewayReceiverHNSCommandLineOptions() throws Exception {
        DirFile file = new DirFile("utilLauncher");
        file.deleteAll();
        FabricServerTest.assertTrue((String)("failed to create directory " + file.getAbsolutePath()), (boolean)file.mkdir());
        file.deleteOnExit();
        String workingdir = file.getAbsolutePath();
        String productDir = System.getProperty("GEMFIREXD");
        String launcher = productDir + "/bin/gfxd";
        if (System.getProperty("os.name").startsWith("Windows")) {
            launcher = launcher + ".bat";
        }
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        try {
            File launcherFile = new File(launcher);
            if (!launcherFile.exists()) {
                throw new Exception("launcher " + launcher + " does not exist");
            }
            Object[] cmdOps = new String[]{launcher, "server", "start", "-dir=" + workingdir, "-client-bind-address=0.0.0.0", "-client-port=" + port, "-log-file=./" + FabricServerTest.getTestName() + "-utilLauncher.log", "-log-level=config", "-mcast-port=" + mcastPort, "-heap-size=512m", "-custom-NICJVM=NIC1"};
            FabricServerTest.getLogger().info((Object)("launching start with " + Arrays.toString(cmdOps)));
            Process proc = Runtime.getRuntime().exec((String[])cmdOps, null, (File)file);
            FabricServerTest.assertEquals((int)0, (int)this.waitForProcess(proc, 120000));
            Connection conn = FabricServerTest.getNetConnection(port, null, null);
            int rs = conn.createStatement().executeUpdate("create gatewayreceiver ok (hostnameforsenders 'NICJVM');");
            ResultSet rs1 = conn.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
            FabricServerTest.assertTrue((boolean)rs1.next());
            FabricServerTest.assertEquals((String)"NIC1", (String)rs1.getString(9));
            FabricServerTest.assertFalse((boolean)rs1.next());
            rs1.close();
            conn.close();
        }
        catch (Throwable throwable) {
            Object[] cmdOps = new String[]{launcher, "server", "stop", "-dir=" + workingdir};
            FabricServerTest.getLogger().info((Object)("launching stop with " + Arrays.toString(cmdOps)));
            Process proc = Runtime.getRuntime().exec((String[])cmdOps, null, (File)file);
            FabricServerTest.assertEquals((int)0, (int)this.waitForProcess(proc, 120000));
            file.deleteAll();
            throw throwable;
        }
        Object[] cmdOps = new String[]{launcher, "server", "stop", "-dir=" + workingdir};
        FabricServerTest.getLogger().info((Object)("launching stop with " + Arrays.toString(cmdOps)));
        Process proc = Runtime.getRuntime().exec((String[])cmdOps, null, (File)file);
        FabricServerTest.assertEquals((int)0, (int)this.waitForProcess(proc, 120000));
        file.deleteAll();
    }

    private Properties doSecuritySetup(Properties props) {
        props.setProperty("mcast-port", "0");
        props.setProperty("gemfire.security-log-level", "finest");
        props.setProperty("gemfirexd.debug.true", "TraceAuthentication,TraceSystemProcedures,TraceFabricServiceBoot");
        props.setProperty("gemfirexd.authentication.required", Boolean.toString(true));
        props.setProperty("gemfirexd.sql-authorization", Boolean.toString(true));
        props.setProperty("gemfirexd.user.sysUser1", "pwd_sysUser1");
        props.setProperty(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", "sysUser1");
        props.setProperty("password", "pwd_sysUser1");
        props.setProperty("gemfirexd.auth-provider", "BUILTIN");
        return props;
    }

    private File createPropertyFile(Properties outProps) throws IOException {
        File file = new File(PROP_FILE_NAME);
        file.createNewFile();
        this.createPropertyFile(outProps, file, null);
        return file;
    }

    private void createPropertyFile(Properties outProps, File file, Properties wrongData) throws IOException {
        FabricServerTest.assertTrue((boolean)file.canWrite());
        String locatoradd = InetAddress.getLocalHost().getHostName() + "[" + String.valueOf(AvailablePort.getRandomAvailablePort((int)0)) + "]";
        FabricServerTest.getLogger().info((Object)("created writable file " + file.getAbsoluteFile() + " for " + TestUtil.currentTest + " with locator address " + locatoradd));
        FileOutputStream fs = new FileOutputStream(file);
        outProps.setProperty("gemfirexd.host-data", "true");
        outProps.setProperty("mcast-port", "0");
        outProps.setProperty("log-level", "config");
        outProps.setProperty("conserve-sockets", "false");
        outProps.setProperty("enable-time-statistics", "true");
        outProps.setProperty("statistic-sampling-enabled", "true");
        outProps.setProperty("start-locator", locatoradd);
        outProps.setProperty("locators", locatoradd);
        String filename = FabricServerTest.getTestName();
        outProps.setProperty("log-file", filename + ".log");
        outProps.setProperty("statistic-archive-file", filename + ".gfs");
        if (wrongData != null) {
            outProps.putAll((Map<?, ?>)wrongData);
        }
        outProps.store(fs, "-- gemfirexd default server properties ");
        fs.close();
    }

    private void validateProperties(Properties passedIn) {
        List<String> gfeProps = Arrays.asList(AbstractDistributionConfig._getAttNames());
        Properties connectedProps = InternalDistributedSystem.getConnectedInstance().getProperties();
        for (Map.Entry<Object, Object> e : passedIn.entrySet()) {
            String key = (String)e.getKey();
            if (!gfeProps.contains(key)) {
                if (!key.equals("gemfirexd.host-data")) continue;
                boolean isStore = "true".equalsIgnoreCase((String)e.getValue());
                GemFireStore.VMKind kind = Misc.getMemStore().getMyVMKind();
                FabricServerTest.assertTrue((String)(key + " not present"), (boolean)(isStore ? kind.isStore() : kind.isAccessor()));
                continue;
            }
            String val = (String)e.getValue();
            FabricServerTest.assertTrue((String)(key + " not present"), (boolean)connectedProps.containsKey(key));
            String connectedval = connectedProps.getProperty(key);
            if (key.contains("locators")) {
                FabricServerTest.assertTrue((String)(key + " connected val = " + connectedval + " passed val = " + val), (boolean)connectedval.contains(val));
                continue;
            }
            FabricServerTest.assertTrue((String)(key + " expected " + val + " found " + connectedval), (boolean)connectedval.equals(val));
        }
    }

    private String getFullHost(InetAddress addr) {
        String hostName = addr.getCanonicalHostName();
        if (hostName != null) {
            return hostName + '/' + addr.getHostAddress();
        }
        return '/' + addr.getHostAddress();
    }

    private void checkServerStatus(String utilLauncher, String workingDir, String expectedStatus) throws Exception {
        int maxWait = 30000;
        int loopWait = 500;
        String status = "";
        for (int i = 1; i <= 60; ++i) {
            Process serverProc = new ProcessBuilder(utilLauncher, "server", "status", "-dir=" + workingDir).start();
            String output = FabricServerTest.getProcessOutput(serverProc, 0, 120000, null);
            Matcher mt = Pattern.compile("status:\\s*(\\w*)", 8).matcher(output);
            FabricServerTest.assertTrue((String)("Got output: " + output), (boolean)mt.find());
            FabricServerTest.assertEquals((int)1, (int)mt.groupCount());
            status = output.substring(mt.start(1), mt.end(1));
            if (expectedStatus.equals(status)) {
                return;
            }
            Thread.sleep(500L);
        }
        FabricServerTest.assertEquals((String)expectedStatus, (String)status);
    }

    private int waitForProcess(Process p, int maxWaitMillis) throws InterruptedException {
        int loopWaitMillis = 100;
        int maxTries = maxWaitMillis / 100;
        while (maxTries-- > 0) {
            try {
                return p.exitValue();
            }
            catch (IllegalThreadStateException itse) {
                Thread.sleep(100L);
            }
        }
        return -1;
    }
}

