/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.client.am;

import com.pivotal.gemfirexd.internal.client.am.Connection;
import com.pivotal.gemfirexd.internal.client.am.LogicalStatementEntity;
import com.pivotal.gemfirexd.internal.client.am.StatementCacheInteractor;
import com.pivotal.gemfirexd.internal.client.am.stmtcache.JDBCStatementCache;
import com.pivotal.gemfirexd.internal.client.am.stmtcache.StatementKey;
import com.pivotal.gemfirexd.internal.client.am.stmtcache.StatementKeyFactory;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LogicalStatementEntityTest
extends BaseJDBCTestCase {
    public LogicalStatementEntityTest(String name) {
        super(name);
    }

    public void testCloseBehaviorExternalPs() throws SQLException {
        String sql = "values 7";
        PreparedStatement ps = this.prepareStatement("values 7");
        JDBCStatementCache cache = new JDBCStatementCache(10);
        this.insertStatementIntoCache(cache, ps, "values 7");
        LogicalStatementEntity logic = this.createLogicalStatementEntity("values 7", false, cache);
        LogicalStatementEntityTest.assertSame((Object)ps, (Object)logic.getPhysPs());
        LogicalStatementEntityTest.assertFalse((boolean)logic.isLogicalEntityClosed());
        logic.close();
        LogicalStatementEntityTest.assertTrue((boolean)logic.isLogicalEntityClosed());
        logic.close();
        logic.close();
        LogicalStatementEntityTest.assertTrue((boolean)logic.isLogicalEntityClosed());
        try {
            logic.getPhysPs();
            LogicalStatementEntityTest.fail((String)"Should have thrown exception");
        }
        catch (SQLException sqle) {
            LogicalStatementEntityTest.assertSQLState("XJ012", sqle);
        }
    }

    public void testCloseBehaviorExternalCs() throws SQLException {
        String sql = "values 3";
        CallableStatement cs = this.prepareCall("values 3");
        JDBCStatementCache cache = new JDBCStatementCache(10);
        this.insertStatementIntoCache(cache, cs, "values 3");
        LogicalStatementEntity logic = this.createLogicalStatementEntity("values 3", true, cache);
        LogicalStatementEntityTest.assertSame((Object)cs, (Object)logic.getPhysCs());
        LogicalStatementEntityTest.assertFalse((boolean)logic.isLogicalEntityClosed());
        logic.close();
        LogicalStatementEntityTest.assertTrue((boolean)logic.isLogicalEntityClosed());
        logic.close();
        logic.close();
        LogicalStatementEntityTest.assertTrue((boolean)logic.isLogicalEntityClosed());
        try {
            logic.getPhysCs();
            LogicalStatementEntityTest.fail((String)"Should have thrown exception");
        }
        catch (SQLException sqle) {
            LogicalStatementEntityTest.assertSQLState("XJ012", sqle);
        }
    }

    public void testCloseOnDuplicateStatement() throws SQLException {
        String sql = "values 7";
        PreparedStatement ps = this.prepareStatement("values 7");
        JDBCStatementCache cache = new JDBCStatementCache(10);
        StatementKey stmtKey = this.insertStatementIntoCache(cache, ps, "values 7");
        LogicalStatementEntity logic = this.createLogicalStatementEntity("values 7", false, cache);
        LogicalStatementEntityTest.assertSame((Object)ps, (Object)logic.getPhysPs());
        LogicalStatementEntityTest.assertFalse((boolean)logic.isLogicalEntityClosed());
        PreparedStatement psDupe = this.prepareStatement("values 7");
        this.insertStatementIntoCache(cache, psDupe, "values 7");
        LogicalStatementEntity logicDupe = this.createLogicalStatementEntity("values 7", false, cache);
        logic.close();
        logicDupe.close();
        LogicalStatementEntityTest.assertTrue((boolean)logicDupe.isLogicalEntityClosed());
        try {
            psDupe.execute();
            LogicalStatementEntityTest.fail((String)"Statement should have been closed and throw an exception");
        }
        catch (SQLException sqle) {
            LogicalStatementEntityTest.assertSQLState("XJ012", sqle);
        }
        PreparedStatement psCached = cache.getCached(stmtKey);
        LogicalStatementEntityTest.assertSame((Object)ps, (Object)psCached);
        ResultSet rs = psCached.executeQuery();
        JDBC.assertSingleValueResultSet(rs, "7");
    }

    public void testCloseWhenStatementShallBeCached() throws SQLException {
        String sql = "values 9";
        PreparedStatement ps = this.prepareStatement("values 9");
        JDBCStatementCache cache = new JDBCStatementCache(10);
        StatementKey stmtKey = this.insertStatementIntoCache(cache, ps, "values 9");
        LogicalStatementEntity logic = this.createLogicalStatementEntity("values 9", false, cache);
        LogicalStatementEntityTest.assertSame((Object)ps, (Object)logic.getPhysPs());
        LogicalStatementEntityTest.assertFalse((boolean)logic.isLogicalEntityClosed());
        logic.close();
        LogicalStatementEntityTest.assertTrue((boolean)logic.isLogicalEntityClosed());
        ResultSet rs = ps.executeQuery();
        JDBC.assertSingleValueResultSet(rs, "9");
        LogicalStatementEntityTest.assertSame((Object)ps, (Object)cache.getCached(stmtKey));
    }

    public void testClosedUnderlyingStatement() throws SQLException {
        String sql = "values 19";
        PreparedStatement ps = this.prepareStatement("values 19");
        JDBCStatementCache cache = new JDBCStatementCache(10);
        this.insertStatementIntoCache(cache, ps, "values 19");
        LogicalStatementEntity logic = this.createLogicalStatementEntity("values 19", false, cache);
        LogicalStatementEntityTest.assertSame((Object)ps, (Object)logic.getPhysPs());
        LogicalStatementEntityTest.assertFalse((boolean)logic.isLogicalEntityClosed());
        PreparedStatement logicalPs = (PreparedStatement)logic;
        LogicalStatementEntityTest.assertNotNull((Object)logicalPs.getMetaData());
        ps.close();
        try {
            logicalPs.getMetaData();
            LogicalStatementEntityTest.fail((String)"Getting meta data on a closed connection should fail");
        }
        catch (SQLException sqle) {
            LogicalStatementEntityTest.assertSQLState("XJ012", sqle);
        }
        logicalPs.close();
    }

    public void testEvictionFromCache() throws SQLException {
        JDBCStatementCache cache = new JDBCStatementCache(2);
        String sql1 = "values 1";
        String sql2 = "values 2";
        String sql3 = "values 3";
        PreparedStatement ps1 = this.prepareStatement("values 1");
        PreparedStatement ps2 = this.prepareStatement("values 2");
        PreparedStatement ps3 = this.prepareStatement("values 3");
        StatementKey stmtKey1 = this.insertStatementIntoCache(cache, ps1, "values 1");
        StatementKey stmtKey2 = this.insertStatementIntoCache(cache, ps2, "values 2");
        LogicalStatementEntity logic1 = this.createLogicalStatementEntity("values 1", false, cache);
        LogicalStatementEntity logic2 = this.createLogicalStatementEntity("values 2", false, cache);
        StatementKey stmtKey3 = this.insertStatementIntoCache(cache, ps3, "values 3");
        LogicalStatementEntity logic3 = this.createLogicalStatementEntity("values 3", false, cache);
        LogicalStatementEntityTest.assertSame((Object)ps1, (Object)logic1.getPhysPs());
        LogicalStatementEntityTest.assertSame((Object)ps2, (Object)logic2.getPhysPs());
        LogicalStatementEntityTest.assertSame((Object)ps3, (Object)logic3.getPhysPs());
        logic1.close();
        logic2.close();
        JDBC.assertSingleValueResultSet(ps1.executeQuery(), "1");
        JDBC.assertSingleValueResultSet(ps2.executeQuery(), "2");
        logic3.close();
        JDBC.assertSingleValueResultSet(ps3.executeQuery(), "3");
        LogicalStatementEntityTest.assertNull((String)"ps1 still in the cache", (Object)cache.getCached(stmtKey1));
        try {
            ps1.executeQuery();
            LogicalStatementEntityTest.fail((String)"ps1 should have been closed by the cache");
        }
        catch (SQLException sqle) {
            LogicalStatementEntityTest.assertSQLState("XJ012", sqle);
        }
        LogicalStatementEntityTest.assertSame((Object)ps2, (Object)cache.getCached(stmtKey2));
        LogicalStatementEntityTest.assertSame((Object)ps3, (Object)cache.getCached(stmtKey3));
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(LogicalStatementEntityTest.class);
    }

    private LogicalStatementEntity createLogicalStatementEntity(String sql, boolean isCallable, JDBCStatementCache cache) throws SQLException {
        StatementCacheInteractor cacheInteractor = new StatementCacheInteractor(cache, (Connection)this.getConnection());
        LogicalStatementEntity entity = isCallable ? (LogicalStatementEntity)cacheInteractor.prepareCall(sql) : (LogicalStatementEntity)cacheInteractor.prepareStatement(sql);
        return entity;
    }

    private StatementKey insertStatementIntoCache(JDBCStatementCache cache, PreparedStatement ps, String sql) throws SQLException {
        StatementKey key = ps instanceof CallableStatement ? StatementKeyFactory.newCallable((String)sql, (String)"APP", (int)this.getConnection().getHoldability()) : StatementKeyFactory.newPrepared((String)sql, (String)"APP", (int)this.getConnection().getHoldability());
        LogicalStatementEntityTest.assertTrue((boolean)cache.cacheStatement(key, ps));
        return key;
    }
}

