/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.insert;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.PartitionedRegionDistributionException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import java.sql.SQLException;
import junit.framework.TestCase;

public class MultipleInsertsPutAllDUnit
extends DistributedSQLTestBase {
    public MultipleInsertsPutAllDUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testMultInsertPK() throws Exception {
        this.startVMs(1, 2);
        GemFireXDQueryObserverAdapter putAllObserver = new GemFireXDQueryObserverAdapter(){

            public void putAllCalledWithMapSize(int size) {
                TestCase.assertEquals((int)3, (int)size);
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)putAllObserver);
        this.clientSQLExecute(1, "create schema emp");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_PARENT (ID int primary key, SECONDID int , THIRDID int )");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_PARENT values(2,4,6), (4,6,8), (6,8,10)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.PARTITIONTESTTABLE_PARENT", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
    }

    public void testMultInsertNoPK() throws Exception {
        this.startVMs(1, 2);
        GemFireXDQueryObserverAdapter putAllObserver = new GemFireXDQueryObserverAdapter(){

            public void putAllCalledWithMapSize(int size) {
                TestCase.assertEquals((int)3, (int)size);
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)putAllObserver);
        this.clientSQLExecute(1, "create schema emp");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_PARENT (ID int, SECONDID int , THIRDID int )");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_PARENT values(2,4,6), (4,6,8), (6,8,10)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.PARTITIONTESTTABLE_PARENT", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
    }

    public void testMultInsertConstraintViolation() throws Exception {
        this.startVMs(1, 2);
        GemFireXDQueryObserverAdapter putAllObserver = new GemFireXDQueryObserverAdapter(){

            public void putAllCalledWithMapSize(int size) {
                TestCase.assertEquals((int)3, (int)size);
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)putAllObserver);
        this.clientSQLExecute(1, "create schema emp");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_PARENT (ID int primary key, SECONDID int , THIRDID int )");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_PARENT values(6,8,10)");
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{SQLException.class, EntryExistsException.class, PartitionedRegionDistributionException.class});
        this.checkKeyViolation(1, "insert into EMP.PARTITIONTESTTABLE_PARENT values(2,4,6), (4,6,8), (6,9,11)");
        this.checkKeyViolation(-1, "insert into EMP.PARTITIONTESTTABLE_PARENT values(2,4,6), (4,6,8), (6,9,11)");
        this.checkKeyViolation(-2, "insert into EMP.PARTITIONTESTTABLE_PARENT values(2,4,6), (4,6,8), (6,9,11)");
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{SQLException.class, EntryExistsException.class, PartitionedRegionDistributionException.class});
    }
}

