/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.insert;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class InsertUpdateUniqueKeyDUnit
extends DistributedSQLTestBase {
    public InsertUpdateUniqueKeyDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFor40040() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate");
        this.clientSQLExecute(1, "insert into trade.securities values (1, 'IBM', 3, 'fse' , 1)");
        this.addExpectedException(new int[]{1}, new int[]{1}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        try {
            for (int i = 0; i < 20; ++i) {
                this.checkKeyViolation(1, "insert into trade.securities values (2, 'IBM', 3, 'fse' , 1)");
                this.checkKeyViolation(-1, "insert into trade.securities values (2, 'IBM', 3, 'fse' , 1)");
            }
        }
        catch (Throwable throwable) {
            this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class, "java.sql.SQLIntegrityConstraintViolationException"});
            throw throwable;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class, "java.sql.SQLIntegrityConstraintViolationException"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFor40040UsingPreparedStatements() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate");
        Connection con = TestUtil.jdbcConn;
        PreparedStatement ps = con.prepareStatement("insert into trade.securities values (?, ?, ?, ? , ?)");
        ps.setInt(1, 1);
        ps.setString(2, "IBM");
        ps.setDouble(3, 3.0);
        ps.setString(4, "fse");
        ps.setInt(5, 1);
        int rows = ps.executeUpdate();
        InsertUpdateUniqueKeyDUnit.assertEquals((String)"Insert should update one row ", (int)1, (int)rows);
        this.addExpectedException(new int[]{1}, new int[]{1}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        try {
            for (int i = 0; i < 1; ++i) {
                try {
                    ps.setInt(1, 2);
                    ps.setString(2, "IBM");
                    ps.setDouble(3, 3.0);
                    ps.setString(4, "fse");
                    ps.setInt(5, 1);
                    ps.executeUpdate();
                    InsertUpdateUniqueKeyDUnit.fail((String)"Insert should not be allowed.");
                    continue;
                }
                catch (SQLException sqle) {
                    InsertUpdateUniqueKeyDUnit.assertEquals((String)sqle.toString(), (String)"23505", (String)sqle.getSQLState());
                }
            }
        }
        catch (Throwable throwable) {
            this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class, "java.sql.SQLIntegrityConstraintViolationException"});
            throw throwable;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{EntryExistsException.class, FunctionExecutionException.class, SQLException.class, "java.sql.SQLIntegrityConstraintViolationException"});
    }
}

