/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.insert;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.util.TestException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Random;

public class InsertUpdateForeignKeyDUnit
extends DistributedSQLTestBase {
    public InsertUpdateForeignKeyDUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testInvalidKeyInsert() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table t1(id int not null, primary key(id))");
        this.clientSQLExecute(1, "create table t2(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t1(id))");
        this.clientSQLExecute(1, "insert into t1 values(1)");
        this.clientSQLExecute(1, "insert into t2 values(1, 1)");
        this.addExpectedException(new int[]{1}, new int[]{1}, new Object[]{FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        for (int i = 20; i < 30; ++i) {
            this.checkFKViolation(i % 2 == 0 ? 1 : -1, "insert into t2 values(2, " + i + " )");
        }
        this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        this.clientSQLExecute(1, "drop table t2");
        this.clientSQLExecute(1, "drop table t1");
    }

    public void testInvalidKeyUpdate() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(1, 0, "SG1");
        this.clientSQLExecute(1, "create table t1(id int not null, primary key(id))");
        this.clientSQLExecute(1, "create table t2(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t1(id)) server groups (sg1)");
        this.clientSQLExecute(1, "insert into t1 values(1)");
        this.clientSQLExecute(1, "insert into t2 values(1, 1)");
        this.addExpectedException(new int[]{1}, new int[]{1}, new Object[]{FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException", FunctionException.class});
        for (int i = 20; i < 30; ++i) {
            this.checkFKViolation(i % 2 == 0 ? 1 : -1, "update t2 set t2.fkId=" + i + " where t2.fkId=1");
        }
        this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{FunctionException.class, FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        this.clientSQLExecute(1, "drop table t2");
        this.clientSQLExecute(1, "drop table t1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertForeignTablePartitionedByColumnNotPk() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table t1(id int not null, partitionId int not null, primary key(id)) PARTITION BY COLUMN ( partitionId )");
        this.clientSQLExecute(1, "create table t2(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t1(id))");
        this.clientSQLExecute(1, "insert into t1 values(1, 1)");
        this.clientSQLExecute(1, "insert into t2 values(1, 1)");
        this.addExpectedException(new int[]{1}, new int[]{1}, new Object[]{FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException", FunctionException.class, EntryNotFoundException.class});
        try {
            this.checkFKViolation(1, "insert into t2 values(2, 2)");
        }
        catch (Throwable throwable) {
            this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{FunctionException.class, EntryNotFoundException.class, FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
            this.clientSQLExecute(1, "drop table t2");
            this.clientSQLExecute(1, "drop table t1");
            throw throwable;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{FunctionException.class, EntryNotFoundException.class, FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        this.clientSQLExecute(1, "drop table t2");
        this.clientSQLExecute(1, "drop table t1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerGroupsReplicatedAccessorFK() throws Exception {
        String keyStr;
        int key;
        int initialCapacity = 10;
        Properties props = new Properties();
        props.setProperty("default-initial-capacity", String.valueOf(10));
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1,SG2", props);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG1", props);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "SG2", props);
        this.startClientVMs(1, 0, null, props);
        this.joinVMs(true, async1, async2, async3);
        this.clientSQLExecute(1, "create table t1(id int not null, partitionId int not null, primary key(id)) replicate server groups (sg1)");
        this.serverSQLExecute(1, "create table t2(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t1(id)) server groups (sg1, sg2)");
        this.serverSQLExecute(2, "create table t3(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id)) server groups (sg2)");
        this.serverSQLExecute(3, "create table t4(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id)) server groups (sg1, sg2)");
        RegionAttributesCreation replAttrs = new RegionAttributesCreation();
        replAttrs.setDataPolicy(DataPolicy.REPLICATE);
        replAttrs.setScope(Scope.DISTRIBUTED_ACK);
        replAttrs.setInitialCapacity(10);
        replAttrs.setConcurrencyChecksEnabled(false);
        replAttrs.setAllHasFields(true);
        replAttrs.setHasDiskDirs(false);
        replAttrs.setHasDiskWriteAttributes(false);
        RegionAttributesCreation emptyAttrs = new RegionAttributesCreation();
        emptyAttrs.setDataPolicy(DataPolicy.EMPTY);
        emptyAttrs.setScope(Scope.DISTRIBUTED_ACK);
        emptyAttrs.setInitialCapacity(10);
        emptyAttrs.setConcurrencyChecksEnabled(false);
        emptyAttrs.setAllHasFields(true);
        emptyAttrs.setHasDiskDirs(false);
        emptyAttrs.setHasDiskWriteAttributes(false);
        this.clientVerifyRegionProperties(1, null, "t1", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(1, null, "t1", (RegionAttributes<?, ?>)replAttrs);
        this.serverVerifyRegionProperties(2, null, "t1", (RegionAttributes<?, ?>)replAttrs);
        this.serverVerifyRegionProperties(3, null, "t1", (RegionAttributes<?, ?>)emptyAttrs);
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        GfxdPartitionByExpressionResolver resolver = new GfxdPartitionByExpressionResolver();
        PartitionAttributes pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        expectedAttrs.setInitialCapacity(10);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        emptyAttrs.setHasDiskDirs(false);
        emptyAttrs.setHasDiskWriteAttributes(false);
        emptyAttrs = new RegionAttributesCreation();
        emptyAttrs.setDataPolicy(DataPolicy.PARTITION);
        emptyAttrs.setConcurrencyChecksEnabled(false);
        pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver).setLocalMaxMemory(0).create();
        emptyAttrs.setPartitionAttributes(pattrs);
        emptyAttrs.setInitialCapacity(10);
        emptyAttrs.setConcurrencyChecksEnabled(false);
        emptyAttrs.setAllHasFields(true);
        emptyAttrs.setHasScope(false);
        emptyAttrs.setHasDiskDirs(false);
        emptyAttrs.setHasDiskWriteAttributes(false);
        this.clientVerifyRegionProperties(1, null, "t2", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(1, null, "t2", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, null, "t2", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(3, null, "t2", (RegionAttributes<?, ?>)expectedAttrs);
        this.clientVerifyRegionProperties(1, null, "t3", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(1, null, "t3", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, null, "t3", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(3, null, "t3", (RegionAttributes<?, ?>)expectedAttrs);
        String colocatedT2 = '/' + InsertUpdateForeignKeyDUnit.getCurrentDefaultSchemaName() + "/T2";
        pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver).setColocatedWith(colocatedT2).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver).setLocalMaxMemory(0).setColocatedWith(colocatedT2).create();
        emptyAttrs.setPartitionAttributes(pattrs);
        this.clientVerifyRegionProperties(1, null, "t4", (RegionAttributes<?, ?>)emptyAttrs);
        this.serverVerifyRegionProperties(1, null, "t4", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(2, null, "t4", (RegionAttributes<?, ?>)expectedAttrs);
        this.serverVerifyRegionProperties(3, null, "t4", (RegionAttributes<?, ?>)expectedAttrs);
        this.clientSQLExecute(1, "insert into t1 values(1, 1)");
        this.serverSQLExecute(3, "insert into t2 values(1, 1)");
        this.serverSQLExecute(2, "insert into t3 values(1, 1)");
        this.serverSQLExecute(1, "insert into t4 values(1, 1)");
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        try {
            for (key = 2; key <= 200; ++key) {
                keyStr = String.valueOf(key);
                this.checkFKViolation(-3, "insert into t2 values(" + keyStr + ", " + keyStr + ")");
                this.checkFKViolation(-2, "insert into t3 values(" + keyStr + ", " + keyStr + ")");
                this.checkFKViolation(-1, "insert into t4 values(" + keyStr + ", " + keyStr + ")");
                this.checkFKViolation(1, "insert into t3 values(" + keyStr + ", " + keyStr + ")");
                this.checkFKViolation(-3, "update t2 set fkId=" + keyStr + " where id=1");
                this.checkFKViolation(-3, "update t2 set fkId=" + keyStr + " where fkId=1");
                this.checkFKViolation(-2, "update t3 set fkId=" + keyStr + " where id=1");
                this.checkFKViolation(-2, "update t3 set fkId=" + keyStr + " where fkId=1");
                this.checkFKViolation(-1, "update t3 set fkId=" + keyStr + " where id=1");
                this.checkFKViolation(-1, "update t3 set fkId=" + keyStr + " where fkId=1");
                this.checkFKViolation(1, "update t2 set fkId=" + keyStr + " where id=1");
                this.checkFKViolation(1, "update t2 set fkId=" + keyStr + " where fkId=1");
            }
        }
        catch (Throwable throwable) {
            this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
            throw throwable;
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{FunctionExecutionException.class, "java.sql.SQLIntegrityConstraintViolationException"});
        for (key = 2; key <= 200; ++key) {
            keyStr = String.valueOf(key);
            this.clientSQLExecute(1, "insert into t1 values(" + keyStr + ", " + keyStr + ")");
            this.serverSQLExecute(3, "insert into t2 values(" + keyStr + ", " + keyStr + ")");
            this.serverSQLExecute(2, "update t2 set fkId=" + keyStr + " where id=1");
            this.serverSQLExecute(2, "insert into t4 values(" + keyStr + ", " + keyStr + ")");
            this.serverSQLExecute(1, "update t3 set fkId=" + keyStr + " where id=1");
            this.serverSQLExecute(3, "insert into t3 values(" + keyStr + ", " + keyStr + ")");
        }
    }

    public void test40171() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.customers (cid int not null, cust_name varchar(100), since int, addr varchar(100), tid int, primary key (cid)) replicate");
        s.execute("insert into trade.customers values (1, 'XXXX1', 1, 'BEAV1', 1)");
        ResultSet rs = s.executeQuery("select * from trade.customers where since=1");
        while (rs.next()) {
            InsertUpdateForeignKeyDUnit.assertEquals((int)1, (int)rs.getInt(1));
            InsertUpdateForeignKeyDUnit.assertEquals((String)"XXXX1", (String)rs.getString(2).trim());
            InsertUpdateForeignKeyDUnit.assertEquals((int)1, (int)rs.getInt(3));
            InsertUpdateForeignKeyDUnit.assertEquals((String)"BEAV1", (String)rs.getString(4));
            InsertUpdateForeignKeyDUnit.assertEquals((int)1, (int)rs.getInt(5));
        }
        int numUpdate = s.executeUpdate("update trade.customers set since=2 where cid=1");
        InsertUpdateForeignKeyDUnit.assertEquals((String)"Should update one row", (int)1, (int)numUpdate);
        rs = s.executeQuery("select * from trade.customers where since=1");
        if (rs.next()) {
            this.getLogWriter().info((Object)("XXXX col1 : " + rs.getInt(1) + " #2 : " + rs.getString(2).trim() + " #3 : " + rs.getInt(3) + " #4 " + rs.getString(4) + " #5 : " + rs.getInt(5)));
            throw new TestException("Should not return any rows");
        }
    }

    public void test40234() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  ");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        this.clientSQLExecute(1, "create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id), constraint bo_qty_ck check (qty>=0))");
        this.clientSQLExecute(1, "insert into trade.securities values (1,'IBM', 25.25, 'nasdaq', 5)");
        Date since = new Date(System.currentTimeMillis());
        Connection conn = TestUtil.jdbcConn;
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        psInsertCust.setInt(1, 1);
        psInsertCust.setString(2, "XXXX1");
        psInsertCust.setDate(3, since);
        psInsertCust.setString(4, "XXXX1");
        psInsertCust.setInt(5, 1);
        psInsertCust.executeUpdate();
        PreparedStatement psInsertBuy = conn.prepareStatement("insert into trade.buyorders values (?,?,?,?,?,?,?,?)");
        BigDecimal value = new BigDecimal(Double.toString((double)(new Random().nextInt(10000) + 1) * 0.01));
        Timestamp tstmp = new Timestamp(System.currentTimeMillis());
        psInsertBuy.setInt(1, 1);
        psInsertBuy.setInt(2, 1);
        psInsertBuy.setInt(3, 1);
        psInsertBuy.setInt(4, 10);
        psInsertBuy.setBigDecimal(5, value);
        psInsertBuy.setTimestamp(6, tstmp);
        psInsertBuy.setString(7, "open");
        psInsertBuy.setInt(8, 1);
        psInsertBuy.executeUpdate();
        PreparedStatement psUpdateBuy = conn.prepareStatement("update trade.buyorders set status = 'cancelled' where (ordertime >? or sid=?) and status = 'open' and tid =?");
        psUpdateBuy.setTimestamp(1, tstmp);
        psUpdateBuy.setInt(2, 1);
        psUpdateBuy.setInt(3, 1);
        int numUpdate = psUpdateBuy.executeUpdate();
        InsertUpdateForeignKeyDUnit.assertEquals((String)"Should update one row", (int)1, (int)numUpdate);
    }

    public void testIndexScans() throws Exception {
        this.startVMs(2, 2);
        Connection conn = TestUtil.jdbcConn;
        Statement s = conn.createStatement();
        PreparedStatement psInsertBrokerTickets = null;
        s.execute("Create table broker_tickets (id int not null, ticketPrice int not null , firmId int not null ,  price double, quantity int, ticker varchar(20))  redundancy 1");
        psInsertBrokerTickets = conn.prepareStatement("insert into broker_tickets (id, ticketPrice, firmId,  price, quantity, ticker ) values (?, ?, ?, ?, ?, ?)");
        int numInserts = 1000;
        int key = 0;
        double price = 1.0;
        int quantity = 10;
        for (int i = 0; i < numInserts; ++i) {
            psInsertBrokerTickets.setInt(1, key + 10);
            if (i % 2 == 0) {
                psInsertBrokerTickets.setInt(2, 10);
            } else {
                psInsertBrokerTickets.setInt(2, 20);
            }
            psInsertBrokerTickets.setInt(3, key + 10);
            psInsertBrokerTickets.setDouble(4, price);
            psInsertBrokerTickets.setInt(5, quantity);
            psInsertBrokerTickets.setString(6, "YYYY" + key);
            int rt = psInsertBrokerTickets.executeUpdate();
            InsertUpdateForeignKeyDUnit.assertEquals((String)"Insert should return 1.", (int)1, (int)rt);
            key += 10;
            price += 0.01;
        }
        s.execute("create index index_ticketPrice on broker_tickets (ticketPrice)");
        ResultSet rs = s.executeQuery("select avg(distinct ticketPrice) from broker_tickets");
        while (rs.next()) {
            InsertUpdateForeignKeyDUnit.assertEquals((String)"Result should match ", (int)15, (int)rs.getInt(1));
        }
    }

    public void testBug41168() throws Exception {
        this.startVMs(2, 3);
        this.clientSQLExecute(1, "create table BinaryTree (id int primary key, leftId int, rightId int, depth int not null, foreign key (leftId) references BinaryTree(id), foreign key (rightId) references BinaryTree(id)) replicate");
        this.doBinaryTreeChecks(true);
        this.serverSQLExecute(2, "drop table BinaryTree");
        this.clientSQLExecute(1, "create table BinaryTree (id int primary key, leftId int, rightId int, depth int not null, foreign key (leftId) references BinaryTree(id), foreign key (rightId) references BinaryTree(id))");
        this.doBinaryTreeChecks(false);
    }

    private void doBinaryTreeChecks(boolean doSelfJoins) throws Exception {
        ResultSet rs;
        this.clientSQLExecute(2, "insert into BinaryTree values (3, null, null, 2)");
        this.serverSQLExecute(1, "insert into BinaryTree values (2, null, null, 1)");
        this.serverSQLExecute(2, "insert into BinaryTree values (1, 3, null, 1)");
        this.serverSQLExecute(3, "insert into BinaryTree values (0, 1, 2, 0)");
        this.checkFKViolation(1, "insert into BinaryTree values (4, 5, null, 2)");
        this.checkFKViolation(2, "insert into BinaryTree values (5, null, 4, 2)");
        this.checkFKViolation(-1, "update BinaryTree set leftId=4 where id=2");
        this.checkFKViolation(-2, "update BinaryTree set rightId=5 where id=2");
        this.clientSQLExecute(2, "insert into BinaryTree values (10, 10, 10, 3)");
        this.serverSQLExecute(1, "insert into BinaryTree values (11, 10, 11, 4)");
        this.serverSQLExecute(2, "insert into BinaryTree values (12, 11, 12, 3)");
        this.serverSQLExecute(3, "insert into BinaryTree values (13, 13, 3, 4)");
        this.serverSQLExecute(3, "insert into BinaryTree values (4, null, null, 2)");
        this.serverSQLExecute(2, "insert into BinaryTree values (5, null, null, 2)");
        this.serverSQLExecute(1, "update BinaryTree set leftId=4 where id=2");
        this.clientSQLExecute(2, "update BinaryTree set rightId=5 where id=2");
        Statement stmt = TestUtil.jdbcConn.createStatement();
        if (doSelfJoins) {
            rs = stmt.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 3");
            InsertUpdateForeignKeyDUnit.assertTrue((String)"expected one result", (boolean)rs.next());
            InsertUpdateForeignKeyDUnit.assertEquals((int)1, (int)rs.getInt(1));
            InsertUpdateForeignKeyDUnit.assertFalse((String)"expected one result", (boolean)rs.next());
        }
        this.addExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
        this.checkFKViolation(-2, "delete from BinaryTree where id=4");
        this.checkFKViolation(2, "delete from BinaryTree where id=5");
        this.removeExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
        this.serverSQLExecute(1, "delete from BinaryTree where id=13");
        this.checkFKViolation(1, "delete from BinaryTree where id=11");
        this.serverSQLExecute(2, "delete from BinaryTree where id=12");
        this.checkFKViolation(-3, "delete from BinaryTree where id=10");
        try {
            this.clientSQLExecute(1, "update BinaryTree set depth=null where id=2");
        }
        catch (SQLException sqle) {
            InsertUpdateForeignKeyDUnit.assertEquals((String)sqle.toString(), (String)"23502", (String)sqle.getSQLState());
        }
        this.serverSQLExecute(3, "update BinaryTree set leftId=null where id=2");
        this.clientSQLExecute(2, "update BinaryTree set rightId=null where id=2");
        this.serverSQLExecute(1, "delete from BinaryTree where id=5");
        this.serverSQLExecute(2, "delete from BinaryTree where id=4");
        if (doSelfJoins) {
            rs = stmt.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 4");
            InsertUpdateForeignKeyDUnit.assertFalse((String)"expected no result", (boolean)rs.next());
            rs = stmt.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 5");
            InsertUpdateForeignKeyDUnit.assertFalse((String)"expected no result", (boolean)rs.next());
        }
    }

    public void testBug43104() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement s = conn.createStatement();
        s.execute("create table app.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) redundancy 1");
        s.execute("create table app.portfolio (cid int not null, tid int, primary key (cid), constraint pf_cust_fk foreign key (cid) references app.customers (cid)) redundancy 1 ");
        s.execute("insert into app.customers values (1, 'XXXX1',1)");
        this.startServerVMs(1, 0, null);
        Thread.sleep(5000L);
        SerializableRunnable cacheCloser = new SerializableRunnable("CacheCloser"){

            public void run() throws CacheException {
                try {
                    PartitionedRegion pr = (PartitionedRegion)Misc.getRegionForTable((String)"APP.CUSTOMERS", (boolean)true);
                    pr.getDataStore().setBucketReadHook(new Runnable(){

                        @Override
                        public void run() {
                            Misc.getGemFireCache().close("", null, false, true);
                        }
                    });
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
        this.serverExecute(1, (Runnable)cacheCloser);
        s.execute("insert into app.portfolio values (1, 1)");
    }
}

