/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.insert;

import com.gemstone.gemfire.cache.CacheException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireInsertResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.util.TestException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.TestCase;

public class DistributedInsertDUnit
extends DistributedSQLTestBase {
    static boolean[] remoteCallbackInvoked = new boolean[]{false, false};

    public DistributedInsertDUnit(String name) {
        super(name);
    }

    public void testDistribuedInsertOnPartitionedTables() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        PreparedStatement custSt = null;
        try {
            custSt = DistributedInsertDUnit.getPreparedStatement("insert into trade.customers values (?, ?, ?, ?, ?)");
        }
        catch (SQLException e) {
            throw new TestException("Exception getting preparedStatment ", (Throwable)e);
        }
        try {
            int maxRows = 100;
            for (int i = 0; i < maxRows; ++i) {
                custSt.setInt(1, i);
                custSt.setString(2, "XXXX" + i);
                custSt.setDate(3, new Date(System.currentTimeMillis()));
                custSt.setString(4, "BEAV" + i);
                custSt.setInt(5, i);
                int r = custSt.executeUpdate();
                DistributedInsertDUnit.assertEquals((String)"Distribted Insert failed ", (int)1, (int)r);
            }
        }
        catch (SQLException e) {
            throw new TestException("Exception trying to execute prepared statement", (Throwable)e);
        }
    }

    public void testDistribuedInsertOnReplicatedTables() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) REPLICATE");
        PreparedStatement custSt = null;
        try {
            custSt = DistributedInsertDUnit.getPreparedStatement("insert into trade.customers values (?, ?, ?, ?, ?)");
        }
        catch (SQLException e) {
            throw new TestException("Exception getting preparedStatment ", (Throwable)e);
        }
        try {
            int maxRows = 100;
            for (int i = 0; i < maxRows; ++i) {
                custSt.setInt(1, i);
                custSt.setString(2, "XXXX" + i);
                custSt.setDate(3, new Date(System.currentTimeMillis()));
                custSt.setString(4, "BEAV" + i);
                custSt.setInt(5, i);
                int r = custSt.executeUpdate();
                DistributedInsertDUnit.assertEquals((String)"Distribted Insert failed ", (int)1, (int)r);
            }
        }
        catch (SQLException e) {
            throw new TestException("Exception trying to execute prepared statement", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug47029() throws Exception {
        block8: {
            Properties props = new Properties();
            props.setProperty(GfxdConstants.MAX_LOCKWAIT, "10000");
            this.startVMs(1, 2, 0, null, props);
            GemFireXDQueryObserver old = null;
            try {
                this.clientSQLExecute(1, "create schema trade");
                this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
                this.clientSQLExecute(1, "create index trade.tid_idx on trade.customers (TID)");
                final boolean[] callbackInvoked = new boolean[]{false, false};
                final SerializableCallable obsAction = new SerializableCallable("Drop Index"){

                    public Object call() throws CacheException {
                        try {
                            TestUtil.setupConnection();
                            Statement stmt = TestUtil.jdbcConn.createStatement();
                            stmt.executeUpdate("drop index trade.tid_idx");
                            TestCase.fail((String)"Test should fail with LOCK_TIMEOUT");
                        }
                        catch (SQLException sqle) {
                            TestCase.assertEquals((String)"40XL1", (String)sqle.getSQLState());
                            DistributedInsertDUnit.remoteCallbackInvoked[0] = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        DistributedInsertDUnit.remoteCallbackInvoked[1] = true;
                        return remoteCallbackInvoked[0];
                    }
                };
                SerializableRunnable obsVerify = new SerializableRunnable("Verify Observer"){

                    public void run() throws CacheException {
                        TestCase.assertTrue((boolean)remoteCallbackInvoked[0]);
                        TestCase.assertTrue((boolean)remoteCallbackInvoked[1]);
                    }
                };
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void afterGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) {
                        TestCase.assertTrue((boolean)(rs instanceof GemFireInsertResultSet));
                        TestCase.assertTrue((boolean)((GemFireInsertResultSet)rs).isPreparedBatch());
                        callbackInvoked[0] = true;
                    }

                    public void beforeFlushBatch(ResultSet rs, LanguageConnectionContext lcc) throws StandardException {
                        TestCase.assertTrue((boolean)(rs instanceof GemFireInsertResultSet));
                        try {
                            TestCase.assertTrue((boolean)((Boolean)DistributedInsertDUnit.this.serverExecute(1, (Callable<?>)obsAction)));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }

                    public void afterFlushBatch(ResultSet rs, LanguageConnectionContext lcc) throws StandardException {
                        TestCase.assertTrue((boolean)(rs instanceof GemFireInsertResultSet));
                        try {
                            DistributedInsertDUnit.this.clientSQLExecute(1, "drop index trade.tid_idx");
                            callbackInvoked[1] = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                PreparedStatement custSt = null;
                try {
                    custSt = DistributedInsertDUnit.getPreparedStatement("insert into trade.customers values (?, ?, ?, ?, ?)");
                }
                catch (SQLException e) {
                    throw new TestException("Exception getting preparedStatment ", (Throwable)e);
                }
                try {
                    int maxRows = 100;
                    for (int i = 0; i < maxRows; ++i) {
                        custSt.setInt(1, i);
                        custSt.setString(2, "XXXX" + i);
                        custSt.setDate(3, new Date(System.currentTimeMillis()));
                        custSt.setString(4, "BEAV" + i);
                        custSt.setInt(5, i);
                        custSt.addBatch();
                    }
                    int[] r = custSt.executeBatch();
                    DistributedInsertDUnit.assertEquals((String)"Distribted Insert failed ", (int)maxRows, (int)r.length);
                    DistributedInsertDUnit.assertTrue((boolean)callbackInvoked[0]);
                    this.serverExecute(1, (Runnable)obsVerify);
                    DistributedInsertDUnit.assertTrue((boolean)callbackInvoked[1]);
                }
                catch (SQLException e) {
                    throw new TestException("Exception trying to execute prepared statement", (Throwable)e);
                }
                if (old == null) break block8;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    GemFireXDQueryObserverHolder.setInstance(old);
                }
                DistributedInsertDUnit.remoteCallbackInvoked[0] = false;
                DistributedInsertDUnit.remoteCallbackInvoked[1] = false;
                throw throwable;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        }
        DistributedInsertDUnit.remoteCallbackInvoked[0] = false;
        DistributedInsertDUnit.remoteCallbackInvoked[1] = false;
    }

    public static PreparedStatement getPreparedStatement(String sql) throws SQLException {
        TestUtil.setupConnection();
        PreparedStatement stmt = TestUtil.jdbcConn.prepareStatement(sql);
        return stmt;
    }
}

