/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.insert;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class DMLsWithRedundancyDUnit
extends DistributedSQLTestBase {
    public DMLsWithRedundancyDUnit(String name) {
        super(name);
    }

    public void testDeletesWithIndexes() throws Exception {
        int i;
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   partition by range (cid) ( VALUES BETWEEN 0 AND 999, VALUES BETWEEN 1000 AND 1102, VALUES BETWEEN 1103 AND 1250, VALUES BETWEEN 1251 AND 1677, VALUES BETWEEN 1678 AND 1700) REDUNDANCY 1");
        Date since = new Date(System.currentTimeMillis());
        Connection conn = TestUtil.jdbcConn;
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        for (int i2 = 0; i2 < 500; ++i2) {
            psInsertCust.setInt(1, i2);
            psInsertCust.setString(2, "XXXX" + i2);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i2);
            psInsertCust.setInt(5, i2);
            psInsertCust.executeUpdate();
        }
        this.clientSQLExecute(1, "create  index index1_8 on trade.customers ( SINCE   )");
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select * from trade.customers");
        for (i = 0; i < 500; ++i) {
            DMLsWithRedundancyDUnit.assertTrue((String)("ResultSet should have more rows" + i), (boolean)rs.next());
        }
        DMLsWithRedundancyDUnit.assertFalse((String)("ResultSet should only have " + i + " rows but has more "), (boolean)rs.next());
        for (int k = 0; k < 250; ++k) {
            this.clientSQLExecute(1, "delete from trade.customers where cid = " + k);
        }
        rs = s.executeQuery("select * from trade.customers");
        for (i = 0; i < 250; ++i) {
            DMLsWithRedundancyDUnit.assertTrue((String)("ResultSet should have more rows" + i), (boolean)rs.next());
        }
        DMLsWithRedundancyDUnit.assertFalse((String)("ResultSet should only have " + i + " rows but it has more "), (boolean)rs.next());
        this.clientSQLExecute(1, "delete from trade.customers where cid > 0");
        rs = s.executeQuery("select * from trade.customers");
        DMLsWithRedundancyDUnit.assertFalse((String)"ResultSet should be empty", (boolean)rs.next());
    }

    public void testUpdatesWithIndexes() throws Exception {
        int i;
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   partition by range (cid) ( VALUES BETWEEN 0 AND 999, VALUES BETWEEN 1000 AND 1102, VALUES BETWEEN 1103 AND 1250, VALUES BETWEEN 1251 AND 1677, VALUES BETWEEN 1678 AND 1700) REDUNDANCY 1");
        Date since = new Date(System.currentTimeMillis());
        Connection conn = TestUtil.jdbcConn;
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        for (int i2 = 0; i2 < 500; ++i2) {
            psInsertCust.setInt(1, i2);
            psInsertCust.setString(2, "XXXX" + i2);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i2);
            psInsertCust.setInt(5, i2);
            DMLsWithRedundancyDUnit.assertEquals((String)"Should insert one row", (int)1, (int)psInsertCust.executeUpdate());
        }
        this.clientSQLExecute(1, "create  index index_tid on trade.customers ( TID )");
        PreparedStatement psUpdate = conn.prepareStatement("update trade.customers set tid  = tid+500 where tid = ?");
        for (int i3 = 0; i3 < 500; ++i3) {
            psUpdate.setInt(1, i3);
            DMLsWithRedundancyDUnit.assertEquals((String)"Should update one row", (int)1, (int)psUpdate.executeUpdate());
        }
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select tid from trade.customers where tid >= 0");
        for (i = 0; i < 500; ++i) {
            DMLsWithRedundancyDUnit.assertTrue((String)("ResultSet should have more rows" + i), (boolean)rs.next());
            DMLsWithRedundancyDUnit.assertEquals((String)"Unexpected result", (int)(i + 500), (int)rs.getInt(1));
        }
        DMLsWithRedundancyDUnit.assertFalse((String)("ResultSet should have only" + i + " rows"), (boolean)rs.next());
    }
}

