/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.gii;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.TestCase;

public class DeltaGIIDUnit
extends DistributedSQLTestBase {
    private static final String DISKSTORE = "DeltaGIIDUnit";

    public DeltaGIIDUnit(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DeltaGIIDUnit.invokeInEveryVM(InitialImageOperation.class, (String)"resetAllGIITestHooks");
    }

    public String getSuffix() throws Exception {
        String suffix = " PERSISTENT 'DeltaGIIDUnit'";
        return suffix;
    }

    public void createDiskStore(boolean useClient, int vmNum) throws Exception {
        SerializableRunnable csr = DeltaGIIDUnit.getDiskStoreCreator(DISKSTORE);
        if (useClient) {
            if (vmNum == 1) {
                csr.run();
            } else {
                this.clientExecute(vmNum, (Runnable)csr);
            }
        } else {
            this.serverExecute(vmNum, (Runnable)csr);
        }
    }

    @Override
    protected String[] testSpecificDirectoriesForDeletion() {
        return new String[]{"test_dir"};
    }

    public void testGFXDDeltaWithDeltaGII() throws Exception {
        this.startVMs(0, 2);
        this.startVMs(1, 0);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        HashMap<Integer, String> expected = new HashMap<Integer, String>();
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) ENABLE CONCURRENCY CHECKS replicate " + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (int i = 1; i < 5; ++i) {
            psInsert.setInt(1, i);
            psInsert.setString(2, "unmodified");
            psInsert.setInt(3, i);
            psInsert.executeUpdate();
            expected.put(i, "unmodified");
        }
        this.stopVMNums(-2);
        PreparedStatement psUpdate = conn.prepareStatement("update trade.customers set cust_name=? where cid=?");
        psUpdate.setString(1, "BeforeRestart");
        psUpdate.setInt(2, 2);
        psUpdate.execute();
        expected.put(2, "BeforeRestart");
        this.blockGII(-2, InitialImageOperation.GIITestHookType.BeforeRequestRVV);
        this.blockGII(-2, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        DistributedSQLTestBase.AsyncVM async2 = this.restartServerVMAsync(2, 0, null, null);
        this.waitForGIICallbackStarted(-2, InitialImageOperation.GIITestHookType.BeforeRequestRVV);
        psUpdate.setString(1, "BeforeRequestRVV");
        psUpdate.setInt(2, 3);
        psUpdate.execute();
        expected.put(3, "BeforeRequestRVV");
        this.unblockGII(-2, InitialImageOperation.GIITestHookType.BeforeRequestRVV);
        this.waitForGIICallbackStarted(-2, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        psUpdate.setString(1, "AfterReceivedImageReply");
        psUpdate.setInt(2, 4);
        psUpdate.execute();
        expected.put(4, "AfterReceivedImageReply");
        this.unblockGII(-2, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        this.joinVM(false, async2);
        RegionVersionVector rvv1 = this.getRVV(-1);
        RegionVersionVector rvv2 = this.getRVV(-2);
        if (!rvv1.logicallySameAs(rvv2)) {
            DeltaGIIDUnit.fail((String)("RVVS don't match. provider=" + rvv1.fullToString() + ", recipient=" + rvv2.fullToString()));
        }
        Statement s = conn.createStatement();
        s.execute("select * from trade.customers");
        ResultSet rs = s.getResultSet();
        HashMap<Integer, String> received = new HashMap<Integer, String>();
        while (rs.next()) {
            received.put(rs.getInt("cid"), rs.getString("cust_name"));
        }
        DeltaGIIDUnit.assertEquals(expected, received);
        this.stopVMNums(-1);
        s = conn.createStatement();
        s.execute("select * from trade.customers");
        rs = s.getResultSet();
        received = new HashMap();
        while (rs.next()) {
            received.put(rs.getInt("cid"), rs.getString("cust_name"));
        }
        DeltaGIIDUnit.assertEquals(expected, received);
    }

    public void testGFXDDeltaWithDeltaGII_serverExecute() throws Exception {
        this.startVMs(0, 2);
        this.startVMs(1, 0);
        this.createDiskStore(true, 1);
        this.clientSQLExecute(1, "create schema trade");
        HashMap<Integer, String> expected = new HashMap<Integer, String>();
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid)) ENABLE CONCURRENCY CHECKS replicate " + this.getSuffix());
        Connection conn = TestUtil.getConnection();
        for (int i = 1; i < 5; ++i) {
            this.serverSQLExecute(1, "insert into trade.customers values (" + i + ", 'unmodified', " + i + ")");
            expected.put(i, "unmodified");
        }
        this.stopVMNums(-2);
        this.serverSQLExecute(1, "update trade.customers set cust_name='BeforeRestart' where cid=2");
        expected.put(2, "BeforeRestart");
        this.blockGII(-2, InitialImageOperation.GIITestHookType.BeforeRequestRVV);
        this.blockGII(-2, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        DistributedSQLTestBase.AsyncVM async2 = this.restartServerVMAsync(2, 0, null, null);
        this.waitForGIICallbackStarted(-2, InitialImageOperation.GIITestHookType.BeforeRequestRVV);
        this.serverSQLExecute(1, "update trade.customers set cust_name='BeforeRequestRVV' where cid=3");
        expected.put(3, "BeforeRequestRVV");
        this.unblockGII(-2, InitialImageOperation.GIITestHookType.BeforeRequestRVV);
        this.waitForGIICallbackStarted(-2, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        this.serverSQLExecute(1, "update trade.customers set cust_name='AfterReceivedImageReply' where cid=4");
        expected.put(4, "AfterReceivedImageReply");
        this.unblockGII(-2, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        this.joinVM(false, async2);
        RegionVersionVector rvv1 = this.getRVV(-1);
        RegionVersionVector rvv2 = this.getRVV(-2);
        if (!rvv1.logicallySameAs(rvv2)) {
            DeltaGIIDUnit.fail((String)("RVVS don't match. provider=" + rvv1.fullToString() + ", recipient=" + rvv2.fullToString()));
        }
        Statement s = conn.createStatement();
        s.execute("select * from trade.customers");
        ResultSet rs = s.getResultSet();
        HashMap<Integer, String> received = new HashMap<Integer, String>();
        while (rs.next()) {
            received.put(rs.getInt("cid"), rs.getString("cust_name"));
        }
        DeltaGIIDUnit.assertEquals(expected, received);
        this.stopVMNums(-1);
        s = conn.createStatement();
        s.execute("select * from trade.customers");
        rs = s.getResultSet();
        received = new HashMap();
        while (rs.next()) {
            received.put(rs.getInt("cid"), rs.getString("cust_name"));
        }
        DeltaGIIDUnit.assertEquals(expected, received);
    }

    public void blockGII(int vmNum, InitialImageOperation.GIITestHookType type) throws Exception {
        this.serverExecute(-vmNum, new BlockGII(type));
    }

    public void unblockGII(int vmNum, InitialImageOperation.GIITestHookType type) throws Exception {
        this.serverExecute(-vmNum, (Runnable)((Object)new ReleaseGII(type)));
    }

    public void waitForGIICallbackStarted(int vmNum, InitialImageOperation.GIITestHookType type) throws Exception {
        this.serverExecute(-vmNum, (Runnable)((Object)new WaitForGIICallbackStarted(type)));
    }

    protected RegionVersionVector getRVV(int vmNum) throws Exception {
        SerializableCallable getRVV = new SerializableCallable("getRVV"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                String path = Misc.getRegionPath((String)"TRADE.CUSTOMERS");
                System.out.println("DAN DEBUG - Trying to get " + path + " regions=" + cache.rootRegions() + " TRADE subregions=" + cache.getRegion("TRADE").subregions(true));
                LocalRegion region = (LocalRegion)cache.getRegion(Misc.getRegionPath((String)"TRADE.CUSTOMERS"));
                System.out.println("DAN DEBUG - Region is a " + region.getConcurrencyChecksEnabled());
                RegionVersionVector rvv = region.getVersionVector();
                rvv = rvv.getCloneForTransmission();
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)rvv, (DataOutput)hdos);
                return hdos.toByteArray();
            }
        };
        byte[] result = (byte[])this.serverExecute(-vmNum, (Callable<?>)getRVV);
        ByteArrayInputStream bais = new ByteArrayInputStream(result);
        return (RegionVersionVector)DataSerializer.readObject((DataInput)new DataInputStream(bais));
    }

    private static class Mycallback
    extends InitialImageOperation.GIITestHook {
        private Object lockObject = new Object();

        public Mycallback(InitialImageOperation.GIITestHookType type, String region_name) {
            super(type, region_name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.lockObject;
            synchronized (object) {
                this.lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lockObject;
            synchronized (object) {
                try {
                    this.isRunning = true;
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static class ReleaseGII
    extends SerializableRunnable {
        private InitialImageOperation.GIITestHookType type;

        public ReleaseGII(InitialImageOperation.GIITestHookType type) {
            this.type = type;
        }

        public void run() {
            InitialImageOperation.resetGIITestHook((InitialImageOperation.GIITestHookType)this.type, (boolean)true);
        }
    }

    private static class WaitForGIICallbackStarted
    extends SerializableRunnable {
        private InitialImageOperation.GIITestHookType type;

        public WaitForGIICallbackStarted(InitialImageOperation.GIITestHookType type) {
            this.type = type;
        }

        public void run() {
            final InitialImageOperation.GIITestHook callback = InitialImageOperation.getGIITestHookForCheckingPurpose((InitialImageOperation.GIITestHookType)this.type);
            DistributedTestBase.WaitCriterion ev = new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    return callback != null && callback.isRunning;
                }

                public String description() {
                    return null;
                }
            };
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)ev, (long)30000L, (long)200L, (boolean)true);
            if (callback == null || !callback.isRunning) {
                TestCase.fail((String)"GII tesk hook is not started yet");
            }
        }
    }

    private static class BlockGII
    implements Runnable,
    Serializable {
        private InitialImageOperation.GIITestHookType type;

        public BlockGII(InitialImageOperation.GIITestHookType type) {
            this.type = type;
        }

        @Override
        public void run() {
            InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)new Mycallback(this.type, "CUSTOMERS"));
        }
    }
}

