/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.functions;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class FunctionsDUnit
extends DistributedSQLTestBase {
    public FunctionsDUnit(String name) {
        super(name);
    }

    public void testFunctionCoalesceNvl_defect46017() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table tAggr (i int, j int) partition by column(j)");
        s.execute("create table tCoAggr (i int, j int) partition by column(j) colocate with (tAggr)");
        s.execute("create table tRepAggr (i int, j int) replicate");
        PreparedStatement ps = conn.prepareStatement("insert into tAggr(i,j) values (?,?)");
        PreparedStatement psCo = conn.prepareStatement("insert into tCoAggr(i,j) values (?,?)");
        PreparedStatement psRep = conn.prepareStatement("insert into tRepAggr(i,j) values (?,?)");
        for (int i = 0; i < 3; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
            psCo.setInt(1, i);
            psCo.setInt(2, i);
            psCo.executeUpdate();
            psRep.setInt(1, i);
            psRep.setInt(2, i);
            psRep.executeUpdate();
        }
        ps.setNull(1, 4);
        ps.setInt(2, 3);
        ps.executeUpdate();
        psRep.setNull(1, 4);
        psRep.setInt(2, 3);
        psRep.executeUpdate();
        conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet r = st.executeQuery("select coalesce(55, max(i)) from tRepAggr");
        int count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)55, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select coalesce(55, max(i)) from tAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)55, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(avg(i), 55, max(i)) from tRepAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select coalesce(avg(i), 55, max(i)) from tAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select count(j) from tRepAggr where coalesce(i, j) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select count(j) from tAggr where coalesce(i, j) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select count(j) from tRepAggr group by i, j having coalesce(max(j), 0) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select count(j) from tAggr group by i, j having coalesce(max(j), 0) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select count(j) from tRepAggr group by i having coalesce(max(j), 0) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select count(j) from tAggr group by i having coalesce(max(j), 0) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(count(j), 0) from tRepAggr group by i having coalesce(max(j), 0) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select coalesce(count(j), 0) from tAggr group by i having coalesce(max(j), 0) > 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(max(A.i), count(*), 55) from tAggr A inner join tCoAggr B on A.j = B.j");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)2, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select count(A.j) from tAggr A inner join tCoAggr B on A.j = B.j group by A.i having coalesce(max(A.j), 0) = 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)1, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        s = conn.createStatement();
        s.executeUpdate("delete from tAggr");
        s.executeUpdate("delete from tCoAggr");
        s.executeUpdate("delete from tRepAggr");
        ps = conn.prepareStatement("insert into tAggr(i,j) values (?,?)");
        ps.setNull(1, 4);
        ps.setNull(2, 4);
        ps.executeUpdate();
        PreparedStatement psCo2 = conn.prepareStatement("insert into tCoAggr(i,j) values (?,?)");
        psCo2.setNull(1, 4);
        psCo2.setNull(2, 4);
        psCo2.executeUpdate();
        PreparedStatement psRep2 = conn.prepareStatement("insert into tRepAggr(i,j) values (?,?)");
        psRep2.setNull(1, 4);
        psRep2.setNull(2, 4);
        psRep2.executeUpdate();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(55, i) from tRepAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)55, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select coalesce(55, i) from tAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)55, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(i, 55, j) from tRepAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)55, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select coalesce(i, 55, j) from tAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)55, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(max(i), count(i), 55) from tRepAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select coalesce(max(i), count(i), 55) from tAggr");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(max(j), count(j), 55) from tRepAggr group by i having coalesce(max(j), 2) = 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        r = st.executeQuery("select coalesce(max(j), count(j), 55) from tAggr group by i having coalesce(max(j), 2) = 2");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        r = st.executeQuery("select coalesce(max(A.i), count(*), 55) from tAggr A inner join tCoAggr B on A.j = B.j");
        count = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)0, (int)r.getInt(1));
            ++count;
        }
        FunctionsDUnit.assertEquals((int)1, (int)count);
    }

    public void testFunctionNvl_defect45979() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE D3764A (A0 INTEGER, A1 INTEGER, A2 INTEGER) replicate");
        st.execute("CREATE TABLE D3764B (A0 INTEGER, A1 INTEGER, A2 INTEGER) partition by column(a1)");
        st.execute("INSERT INTO D3764A (A0, A1) VALUES (1, 1), (1, 1)");
        st.execute("INSERT INTO D3764B (A0, A1) VALUES (1, 1), (1, 1)");
        int expected = 3;
        boolean expectedCount = true;
        ResultSet r = st.executeQuery("select SUM(a0) + nvl(a2, 1) from D3764A Group By a2");
        int r1 = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)3, (int)r.getInt(1));
            ++r1;
        }
        FunctionsDUnit.assertEquals((int)1, (int)r1);
        r = st.executeQuery("select SUM(a0) + nvl(a2, 1) from D3764B Group By a2");
        r1 = 0;
        while (r.next()) {
            FunctionsDUnit.assertEquals((int)3, (int)r.getInt(1));
            ++r1;
        }
        FunctionsDUnit.assertEquals((int)1, (int)r1);
    }

    public void testFunctionCreate() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table ORDERS (ID int primary key, VOL int NOT NULL unique, SECURITY_ID varchar(10)) partition by Primary Key redundancy 1");
        for (int i = 0; i < 100; ++i) {
            String statement = "insert into ORDERS values (" + i + "," + i + ",'char" + i + "')";
            this.clientSQLExecute(1, statement);
        }
        String createFunction = "CREATE FUNCTION times (value INTEGER) RETURNS INTEGER LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.functions.TestFunctions.times' PARAMETER STYLE JAVA NO SQL RETURNS NULL ON NULL INPUT ";
        this.clientSQLExecute(1, createFunction);
        this.sqlExecuteVerify(new int[]{1}, null, "SELECT times(ID) FROM ORDERS WHERE ID>10 and ID<15", TestUtil.getResourcesDir() + "/lib/checkFunctions.xml", "q_1");
        String createFunction1 = "CREATE FUNCTION subsetRows (tableName VARCHAR(20), low INTEGER, high INTEGER) RETURNS Table (ID INT, SECURITY_ID VARCHAR(10)) LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.functions.TestFunctions.subset' PARAMETER STYLE DERBY_JDBC_RESULT_SET READS SQL DATA RETURNS NULL ON NULL INPUT ";
        this.clientSQLExecute(1, createFunction1);
        this.sqlExecuteVerify(new int[]{1}, null, "SELECT s.* FROM Table (subsetRows('ORDERS',10, 15)) s", TestUtil.getResourcesDir() + "/lib/checkFunctions.xml", "q_2");
        this.clientSQLExecute(1, "DROP FUNCTION times");
        this.clientSQLExecute(1, "DROP FUNCTION subsetRows");
    }

    public void _testFunctionExecutionTimes() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table ORDERS (ID int primary key, VOL int NOT NULL unique, SECURITY_ID varchar(10)) partition by Primary Key redundancy 1");
        for (int i = 0; i < 100; ++i) {
            String statement = "insert into ORDERS values (" + i + "," + i + ",'char" + i + "')";
            this.clientSQLExecute(1, statement);
        }
        this.clientSQLExecute(1, "create table LOG (ThreadID bigint primary key)");
        String createFunction = "CREATE FUNCTION times (value INTEGER) RETURNS INTEGER LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.functions.TestFunctions.timesWithLog' PARAMETER STYLE JAVA NO SQL RETURNS NULL ON NULL INPUT ";
        this.clientSQLExecute(1, createFunction);
        this.sqlExecuteVerify(new int[]{1}, null, "SELECT times(ID) FROM ORDERS WHERE ID=10", TestUtil.getResourcesDir() + "/lib/checkFunctions.xml", "q_3");
        this.sqlExecuteVerify(new int[]{1}, null, "SELECT * FROM LOG", TestUtil.getResourcesDir() + "/lib/checkFunctions.xml", "q_4");
    }
}

