/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.distributed;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LockTimeoutException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.query.QueryChecksTest;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatterTest;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.JDBC;

public class DistributedQueryDUnit
extends DistributedSQLTestBase {
    public DistributedQueryDUnit(String name) {
        super(name);
    }

    public void testDistributedQuery() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First')");
        this.clientSQLExecute(1, "create synonym synForEmpTestTable for EMP.TESTTABLE");
        this.sqlExecuteVerify(new int[]{1}, null, "select ID, DESCRIPTION from synForEmpTestTable", null, null, false, false);
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
    }

    public void testBasicDistributedQueryUsingPreparedStatement() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create table TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into TESTTABLE values (1, 'First')");
        this.clientSQLExecute(1, "insert into TESTTABLE values (2, 'Second')");
        this.clientSQLExecute(1, "create synonym synForTestTable for TESTTABLE");
        this.sqlExecuteVerify(new int[]{1}, null, "select ID, DESCRIPTION from synForTestTable", TestUtil.getResourcesDir() + "/lib/distributedQuery.xml", "q_1", true, false);
        this.clientSQLExecute(1, "Drop table TESTTABLE ");
    }

    public void testBasicDistributedQueryUsingPreparedStatementWithParamterization() throws Exception {
        this.startServerVMs(2, 0, "SG1");
        this.startClientVMs(1, 0, null);
        this.clientSQLExecute(1, "create schema EMP default server groups (SG1)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (1, 'First')");
        this.clientSQLExecute(1, "insert into EMP.TESTTABLE values (2, 'Second')");
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("select ID, DESCRIPTION from EMP.TESTTABLE where id > ? ");
        ps.setInt(1, 0);
        ps.execute();
        TestUtil.verifyResults(true, ps, false, TestUtil.getResourcesDir() + "/lib/distributedQuery.xml", "q_1");
        this.clientSQLExecute(1, "Drop table EMP.TESTTABLE ");
    }

    public void testDDLDML() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid))");
        this.clientSQLExecute(1, "create index tid_idx on trade.customers (TID)");
        this.clientSQLExecute(1, "drop index trade.tid_idx");
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{RegionDestroyedException.class, LockTimeoutException.class});
        this.clientSQLExecute(1, "drop table trade.customers");
        this.createTablesAndPopulateData(0);
        this.serverSQLExecute(1, "update trade.customers set tid = 10 where cid = 1");
        SerializableRunnable multiIter = new SerializableRunnable("iterate multiple open ResultSets"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    PreparedStatement pstmt1 = conn.prepareStatement("select * from trade.customers");
                    PreparedStatement pstmt2 = conn.prepareStatement("select * from trade.portfolio");
                    ResultSet rs1 = pstmt1.executeQuery();
                    ResultSet rs2 = pstmt2.executeQuery();
                    int numResults1 = 0;
                    int numResults2 = 0;
                    for (int cnt = 1; cnt <= 10; ++cnt) {
                        rs1.next();
                        ++numResults1;
                        rs2.next();
                        ++numResults2;
                    }
                    while (rs1.next()) {
                        ++numResults1;
                    }
                    while (rs2.next()) {
                        ++numResults2;
                    }
                    TestCase.assertEquals((int)100, (int)numResults1);
                    TestCase.assertEquals((int)45, (int)numResults2);
                }
                catch (SQLException ex) {
                    throw new CacheException(ex){};
                }
            }
        };
        this.serverExecute(1, (Runnable)multiIter);
        this.serverExecute(2, (Runnable)multiIter);
        this.serverExecute(3, (Runnable)multiIter);
        multiIter.run();
        PreparedStatement prepStmt = TestUtil.jdbcConn.prepareStatement("select * from trade.customers");
        this.clientSQLExecute(1, "delete from trade.customers where cid=2");
        this.clientSQLExecute(1, "drop table trade.portfolio");
        prepStmt.execute();
        ResultSet rs = prepStmt.getResultSet();
        for (i = 0; i < 20 && rs.next(); ++i) {
            this.getLogWriter().info((Object)("Got CID: " + rs.getObject(1) + ", TID: " + rs.getObject(4)));
        }
        while (rs.next()) {
            this.getLogWriter().info((Object)("Got CID: " + rs.getObject(1) + ", TID: " + rs.getObject(4)));
        }
        this.serverSQLExecute(2, "drop table trade.customers");
        this.createTablesAndPopulateData(0);
        this.serverSQLExecute(1, "create synonym synForTradeCustomers for trade.customers");
        this.serverSQLExecute(3, "delete from synForTradeCustomers where cid=2");
        this.serverSQLExecute(2, "drop table trade.portfolio");
        prepStmt = TestUtil.jdbcConn.prepareStatement("select * from trade.customers");
        prepStmt.execute();
        rs = prepStmt.getResultSet();
        for (i = 0; i < 20 && rs.next(); ++i) {
            this.getLogWriter().info((Object)("Got CID: " + rs.getObject(1) + ", TID: " + rs.getObject(4)));
        }
        rs.close();
        this.serverSQLExecute(1, "drop table trade.customers");
        this.createTablesAndPopulateData(0);
        this.serverSQLExecute(1, "drop table trade.portfolio");
        this.serverSQLExecute(2, "drop table trade.customers");
        this.createTablesAndPopulateData(0);
        this.checkKeyViolation(-2, "update trade.portfolio set qty=qty-100 where cid>=0", "23513", "check constraint violation");
        this.serverSQLExecute(2, "drop table trade.portfolio");
        this.serverSQLExecute(3, "drop table trade.customers");
        this.createTablesAndPopulateData(0);
        this.serverSQLExecute(1, "delete from trade.customers where cid=2");
        this.serverSQLExecute(3, "drop table trade.portfolio");
        prepStmt = TestUtil.jdbcConn.prepareStatement("select * from trade.customers");
        prepStmt.execute();
        rs = prepStmt.getResultSet();
        int numResults = 0;
        while (rs.next()) {
            this.getLogWriter().info((Object)("Got CID: " + rs.getObject(1) + ", TID: " + rs.getObject(4)));
            ++numResults;
        }
        DistributedQueryDUnit.assertEquals((int)99, (int)numResults);
        this.serverSQLExecute(2, "drop table trade.customers");
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, new Object[]{RegionDestroyedException.class, LockTimeoutException.class});
    }

    public void testBug43359() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid)) redundancy 1");
        this.clientSQLExecute(1, "create index tid_idx on trade.customers (TID)");
        this.clientSQLExecute(1, "insert into trade.customers values(1,'name_1','addr_1',1)");
        SerializableRunnable dbShutter = new SerializableRunnable("attach observer on server1"){

            public void run() throws CacheException {
                GemFireXDQueryObserverAdapter sqo = new GemFireXDQueryObserverAdapter(){

                    public void beforeIndexUpdatesAtRegionLevel(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
                        Thread th = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                Misc.getGemFireCache().close("no reason", null, false, true);
                            }
                        });
                        th.start();
                        try {
                            th.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)sqo);
            }
        };
        this.startServerVMs(1, 0, null);
        Thread.sleep(5000L);
        this.serverExecute(1, (Runnable)dbShutter);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("insert into trade.customers values(114,'name_114','addr_114',1)");
        ResultSet rs = stmt.executeQuery("select * from trade.customers where cid >= 0");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        DistributedQueryDUnit.assertEquals((int)2, (int)numRows);
    }

    public void test40595() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create schema trade");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid))");
        PreparedStatement prepStmt = TestUtil.jdbcConn.prepareStatement("select * from trade.customers");
        prepStmt.execute();
        prepStmt.getResultSet().close();
        this.clientSQLExecute(1, "drop table trade.customers");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid))");
        prepStmt.execute();
        prepStmt.getResultSet().close();
        this.clientSQLExecute(1, "drop table trade.customers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test41179_1() throws Exception {
        this.startVMs(1, 2);
        VM vm0 = (VM)this.serverVMs.get(0);
        VM vm1 = (VM)this.serverVMs.get(1);
        try {
            SerializableCompactLong compactVal;
            vm0.invoke(DistributedQueryDUnit.class, "createRegionForTest", new Object[]{Boolean.FALSE});
            vm1.invoke(DistributedQueryDUnit.class, "createRegionForTest", new Object[]{Boolean.FALSE});
            Cache cache = CacheFactory.getAnyInstance();
            String regionName = DistributedQueryDUnit.createRegionForTest(Boolean.TRUE);
            Region region = cache.getRegion(regionName);
            long[] valuesToTest = new long[]{0L, 127L, -128L, 32767L, -32768L, Integer.MAX_VALUE, Integer.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE};
            long[] offsets = new long[]{0L, 1L, 4L, 9L, 14L, 15L, 16L, -1L, -4L, -9L, -14L, -15L, -16L};
            for (long valueToTest : valuesToTest) {
                for (long offset : offsets) {
                    if (valueToTest == Long.MAX_VALUE && offset > 0L || valueToTest == Long.MIN_VALUE && offset < 0L) continue;
                    long val = valueToTest + offset;
                    compactVal = new SerializableCompactLong(val);
                    region.put((Object)compactVal, (Object)compactVal);
                }
            }
            for (long valueToTest : valuesToTest) {
                for (long offset : offsets) {
                    if (valueToTest == Long.MAX_VALUE && offset > 0L || valueToTest == Long.MIN_VALUE && offset < 0L) continue;
                    long expectedVal = valueToTest + offset;
                    compactVal = new SerializableCompactLong(expectedVal);
                    SerializableCompactLong val = (SerializableCompactLong)region.get((Object)compactVal);
                    DistributedQueryDUnit.assertEquals((long)expectedVal, (long)val.val);
                }
            }
        }
        finally {
            this.stopAllVMs();
        }
    }

    public void test41179_2() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table TestLong (id bigint primary key, tid int)");
        this.serverSQLExecute(1, "create table TestInt (id int primary key, tid bigint)");
        long[] longValuesToTest = new long[]{0L, 127L, -128L, 32767L, -32768L, Integer.MAX_VALUE, Integer.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE};
        int[] intValuesToTest = new int[]{0, 127, -128, Short.MAX_VALUE, Short.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] offsets = new int[]{0, 1, 4, 9, 14, 15, 16, -1, -4, -9, -14, -15, -16};
        for (long longValueToTest : longValuesToTest) {
            for (int offset : offsets) {
                if (longValueToTest == Long.MAX_VALUE && offset > 0 || longValueToTest == Long.MIN_VALUE && offset < 0) continue;
                long val = longValueToTest + (long)offset;
                int intVal = (int)val;
                this.clientSQLExecute(1, "insert into TestLong values (" + val + ", " + intVal + ")");
            }
        }
        PreparedStatement pstmt = TestUtil.jdbcConn.prepareStatement("select tid from TestLong where id=?");
        for (long longValueToTest : longValuesToTest) {
            for (int offset : offsets) {
                if (longValueToTest == Long.MAX_VALUE && offset > 0 || longValueToTest == Long.MIN_VALUE && offset < 0) continue;
                long val = longValueToTest + (long)offset;
                int expectedVal = (int)val;
                this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tid from TestLong where id=" + val, null, String.valueOf(expectedVal));
                if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                    pstmt.setInt(1, (int)val);
                } else {
                    pstmt.setLong(1, val);
                }
                ResultSet rs = pstmt.executeQuery();
                DistributedQueryDUnit.assertTrue((boolean)rs.next());
                DistributedQueryDUnit.assertEquals((int)expectedVal, (int)rs.getInt(1));
                DistributedQueryDUnit.assertFalse((boolean)rs.next());
            }
        }
        for (int intValueToTest : intValuesToTest) {
            for (int offset : offsets) {
                if (intValueToTest == Integer.MAX_VALUE && offset > 0 || intValueToTest == Integer.MIN_VALUE && offset < 0) continue;
                int val = intValueToTest + offset;
                long longVal = val;
                this.clientSQLExecute(1, "insert into TestInt values (" + val + ", " + longVal + ")");
            }
        }
        pstmt = TestUtil.jdbcConn.prepareStatement("select tid from TestInt where id=?");
        for (int intValueToTest : intValuesToTest) {
            for (int offset : offsets) {
                if (intValueToTest == Integer.MAX_VALUE && offset > 0 || intValueToTest == Integer.MIN_VALUE && offset < 0) continue;
                int val = intValueToTest + offset;
                long expectedVal = val;
                this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select tid from TestInt where id=" + val, null, String.valueOf(expectedVal));
                pstmt.setInt(1, val);
                ResultSet rs = pstmt.executeQuery();
                DistributedQueryDUnit.assertTrue((boolean)rs.next());
                DistributedQueryDUnit.assertEquals((long)expectedVal, (long)rs.getInt(1));
                DistributedQueryDUnit.assertFalse((boolean)rs.next());
            }
        }
    }

    public void testBug41262() throws Exception {
        this.startVMs(1, 3);
        final boolean[] failed = new boolean[]{false};
        final Statement stmt = TestUtil.jdbcConn.createStatement();
        try {
            stmt.execute("create table TestInt (id int primary key, tid int)");
            stmt.execute("insert into TestInt values(1,1)");
            stmt.execute("update table TestInt set tid =2");
            stmt.execute("create table TestLong (id bigint primary key, tid int, id int)");
            DistributedQueryDUnit.fail((String)"Table creation should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ResultSet rs = stmt.executeQuery("select  * from TestInt");
                    TestCase.assertTrue((boolean)rs.next());
                    TestCase.assertFalse((boolean)rs.next());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    failed[0] = true;
                }
            }
        });
        th.start();
        th.join();
        DistributedQueryDUnit.assertFalse((boolean)failed[0]);
    }

    public void testRSNextHA_41471_41661() throws Exception {
        ResultSet rs;
        this.startVMs(1, 4);
        this.createTablesAndPopulateData(2);
        this.addExpectedException(new int[]{1}, new int[]{1, 2, 3, 4}, new Object[]{CacheClosedException.class, "No current connection", "Failed to start database 'gemfirexd'"});
        this.serverExecute(3, (Runnable)new SerializableRunnable("attach observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new ResultHolderIterationObserver());
            }
        });
        Properties props = new Properties();
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STREAMING);
        props.setProperty("disable-streaming", "false");
        Connection conn = TestUtil.getConnection(props);
        PreparedStatement prepStmt = conn.prepareStatement("select * from trade.customers");
        int numResults = 0;
        int numIters = 0;
        while (true) {
            this.getLogWriter().info((Object)("Into iteration " + ++numIters));
            rs = prepStmt.executeQuery();
            numResults = 0;
            try {
                while (rs.next()) {
                    this.getLogWriter().info((Object)("Got CID: " + rs.getObject(1) + ", TID: " + rs.getObject(4)));
                    ++numResults;
                }
                if (numIters != 1) break;
                DistributedQueryDUnit.fail((String)"expected an SQLException due to node going down during first ResultSet iteration");
            }
            catch (SQLException ex) {
                if (!"X0Z01".equals(ex.getSQLState())) {
                    throw ex;
                }
                this.getLogWriter().info((Object)"Got expected exception", (Throwable)ex);
                Thread.sleep(500L);
                continue;
            }
            break;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)numResults);
        this.serverExecute(2, (Runnable)new SerializableRunnable("attach observer"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new ResultHolderIterationObserver());
            }
        });
        props.setProperty("disable-streaming", "true");
        conn = TestUtil.getConnection(props);
        prepStmt = conn.prepareStatement("select * from trade.customers");
        rs = prepStmt.executeQuery();
        numResults = 0;
        while (rs.next()) {
            this.getLogWriter().info((Object)("Got CID: " + rs.getObject(1) + ", TID: " + rs.getObject(4)));
            ++numResults;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)numResults);
        DistributedQueryDUnit.assertFalse((boolean)conn.createStatement().executeQuery("select * from trade.customers where cid=1000 and tid>100").next());
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3, 4}, new Object[]{CacheClosedException.class, "No current connection", "Failed to start database 'gemfirexd'"});
    }

    public void testDateTimeTypes_and_42478_DEFAULT() throws Exception {
        int id;
        this.startVMs(1, 1);
        int netPort = this.startNetworkServer(1, null, null);
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = netConn.createStatement();
        this.clientSQLExecute(1, "create table s.timetest(id int primary key, ts timestamp not null, t time not null, dt date not null, price decimal(30,20), qty int)");
        this.clientSQLExecute(1, "create table s.defaulttest(id int primary key,  price decimal(30,20) default null, qty int default 0, name varchar(10) default 'none')");
        String insertStr = "insert into s.defaulttest (id, price, qty, name) values(?, ?, DEFAULT, DEFAULT)";
        PreparedStatement insertStmt = netConn.prepareStatement(insertStr);
        for (id = 1; id < 5; ++id) {
            insertStmt.setInt(1, id);
            insertStmt.setBigDecimal(2, new BigDecimal("20." + id));
            DistributedQueryDUnit.assertEquals((int)1, (int)insertStmt.executeUpdate());
        }
        for (id = 5; id < 10; ++id) {
            DistributedQueryDUnit.assertEquals((int)1, (int)stmt.executeUpdate("insert into s.defaulttest (id, price, qty, name) values(" + id + ", " + new BigDecimal("20." + id) + ", DEFAULT, DEFAULT)"));
        }
        insertStmt = netConn.prepareStatement("insert into s.defaulttest values(?, DEFAULT, DEFAULT, ?)");
        for (id = 10; id < 15; ++id) {
            insertStmt.setInt(1, id);
            insertStmt.setString(2, "name_" + id);
            DistributedQueryDUnit.assertEquals((int)1, (int)insertStmt.executeUpdate());
        }
        for (id = 15; id < 20; ++id) {
            DistributedQueryDUnit.assertEquals((int)1, (int)stmt.executeUpdate("insert into s.defaulttest values(" + id + ", DEFAULT, DEFAULT, 'name_" + id + "')"));
        }
        ResultSet rs = stmt.executeQuery("select * from s.defaulttest order by id");
        for (int id2 = 1; id2 < 20; ++id2) {
            DistributedQueryDUnit.assertTrue((boolean)rs.next());
            DistributedQueryDUnit.assertEquals((int)id2, (int)rs.getInt(1));
            if (id2 < 10) {
                DistributedQueryDUnit.assertEquals((Object)new BigDecimal("20." + id2).setScale(20), (Object)rs.getBigDecimal(2));
                DistributedQueryDUnit.assertEquals((String)"none", (String)rs.getString(4));
            } else {
                DistributedQueryDUnit.assertNull((Object)rs.getBigDecimal(2));
                DistributedQueryDUnit.assertNull((Object)rs.getString(2));
                DistributedQueryDUnit.assertEquals((String)("name_" + id2), (String)rs.getString(4));
            }
            DistributedQueryDUnit.assertEquals((int)0, (int)rs.getInt(3));
        }
        DistributedQueryDUnit.assertFalse((boolean)rs.next());
        this.clientSQLExecute(1, "create synonym synForsTimetest for s.timetest");
        insertStr = "insert into synForsTimetest values(?, ?, ?, ?, ?, ?)";
        String updateStr = "update synForsTimetest set price = ? * qty where id=?";
        String selectStr = "select * from synForsTimetest";
        String select2Str = "select price from synForsTimetest where id=?";
        insertStmt = netConn.prepareStatement(insertStr);
        PreparedStatement updateStmt = netConn.prepareStatement("update synForsTimetest set price = ? * qty where id=?");
        PreparedStatement selectStmt = TestUtil.jdbcConn.prepareStatement("select * from synForsTimetest");
        PreparedStatement select2Stmt = TestUtil.jdbcConn.prepareStatement("select price from synForsTimetest where id=?");
        for (int cnt = 1; cnt <= 2; ++cnt) {
            insertStmt.setInt(1, 1);
            insertStmt.setTimestamp(2, Timestamp.valueOf("2005-01-01 01:01:01"));
            insertStmt.setTime(3, Time.valueOf("12:12:12"));
            insertStmt.setDate(4, Date.valueOf("2005-01-01"));
            insertStmt.setBigDecimal(5, new BigDecimal("20.22"));
            insertStmt.setInt(6, 20);
            insertStmt.execute();
            long currentTime = System.currentTimeMillis();
            insertStmt.setInt(1, 2);
            insertStmt.setTimestamp(2, new Timestamp(currentTime));
            insertStmt.setTime(3, new Time(currentTime));
            insertStmt.setDate(4, new Date(currentTime));
            insertStmt.setBigDecimal(5, new BigDecimal("30.33"));
            insertStmt.setInt(6, 30);
            insertStmt.execute();
            insertStmt.setInt(1, 3);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(2005, 0, 1, 14, 14, 14);
            long utcMillis = cal.getTimeInMillis();
            insertStmt.setTimestamp(2, new Timestamp(utcMillis), cal);
            insertStmt.setTime(3, new Time(utcMillis), cal);
            insertStmt.setDate(4, new Date(utcMillis), cal);
            insertStmt.setBigDecimal(5, new BigDecimal("40.44"));
            insertStmt.setInt(6, 40);
            insertStmt.execute();
            rs = selectStmt.executeQuery();
            for (int index = 1; index <= 3; ++index) {
                DistributedQueryDUnit.assertTrue((boolean)rs.next());
                int id3 = rs.getInt(1);
                if (id3 == 1) {
                    DistributedQueryDUnit.assertEquals((String)"2005-01-01 01:01:01.0", (String)rs.getTimestamp("TS").toString());
                    DistributedQueryDUnit.assertEquals((String)"12:12:12", (String)rs.getTime(3).toString());
                    DistributedQueryDUnit.assertEquals((String)"2005-01-01", (String)rs.getDate(4).toString());
                    cal.clear();
                    cal.setTimeInMillis(Timestamp.valueOf("2005-01-01 01:01:01").getTime());
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 1, 2, cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), 0});
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 1, 3, -1, -1, -1, 12, 12, 12, 0});
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 1, 4, 2005, 1, 1, -1, -1, -1, -1});
                    continue;
                }
                if (id3 == 2) {
                    DistributedQueryDUnit.assertEquals((Object)new Timestamp(currentTime), (Object)rs.getTimestamp(2));
                    DistributedQueryDUnit.assertEquals((String)new Time(currentTime).toString(), (String)rs.getTime("T").toString());
                    DistributedQueryDUnit.assertEquals((String)new Date(currentTime).toString(), (String)rs.getDate("DT").toString());
                    cal.clear();
                    cal.setTimeInMillis(currentTime);
                    cal.clear();
                    cal.setTimeInMillis(currentTime);
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 2, 2, cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14)});
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 2, 3, -1, -1, -1, cal.get(11), cal.get(12), cal.get(13), 0});
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 2, 4, cal.get(1), cal.get(2) + 1, cal.get(5), -1, -1, -1, -1});
                    continue;
                }
                if (id3 == 3) {
                    DistributedQueryDUnit.assertEquals((Object)new Timestamp(utcMillis), (Object)rs.getTimestamp(2));
                    DistributedQueryDUnit.assertEquals((String)"14:14:14", (String)rs.getTime(3).toString());
                    DistributedQueryDUnit.assertEquals((String)"2005-01-01", (String)rs.getDate(4).toString());
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 3, 2, 2005, 1, 1, 14, 14, 14, 0});
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 3, 3, -1, -1, -1, 14, 14, 14, 0});
                    ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "checkDateTimeFields", new Object[]{"s.timetest", 3, 4, 2005, 1, 1, -1, -1, -1, -1});
                    continue;
                }
                DistributedQueryDUnit.fail((String)("unexpected id " + id3));
            }
            DistributedQueryDUnit.assertFalse((boolean)rs.next());
            updateStmt.setBigDecimal(1, new BigDecimal("1.17"));
            updateStmt.setInt(2, 2);
            updateStmt.execute();
            select2Stmt.setInt(1, 2);
            rs = select2Stmt.executeQuery();
            DistributedQueryDUnit.assertTrue((boolean)rs.next());
            DistributedQueryDUnit.assertEquals((Object)new BigDecimal("30.00000000000000000000"), (Object)rs.getBigDecimal(1));
            DistributedQueryDUnit.assertFalse((boolean)rs.next());
            netConn.createStatement().execute("delete from synForsTimetest");
            insertStmt = TestUtil.jdbcConn.prepareStatement(insertStr);
            updateStmt = TestUtil.jdbcConn.prepareStatement("update synForsTimetest set price = ? * qty where id=?");
            selectStmt = netConn.prepareStatement("select * from synForsTimetest");
            select2Stmt = netConn.prepareStatement("select price from synForsTimetest where id=?");
        }
    }

    public void testConnectionSevereExceptionPropagation() throws Exception {
        this.startVMs(0, 2);
        SerializableRunnable r = new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    ResultSet rs = conn.getMetaData().getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
                    boolean found = rs.next();
                    rs.close();
                    if (found) {
                        st.execute("drop table course ");
                    }
                    st.execute("create table course (course_id int, i int, j int, course_name varchar(2048),  primary key(course_id)) partition by column (i) ");
                    String sql = "insert into course values( ";
                    StringBuilder ins = new StringBuilder(sql);
                    for (int i = 0; i < 100; ++i) {
                        ins.append(i).append(",");
                        ins.append(i + PartitionedRegion.rand.nextInt(1000)).append(",");
                        ins.append(1).append(", '");
                        ins.append(TestUtil.numstr(i)).append("' )");
                        if (i % 2 == 0) {
                            st.execute(ins.toString());
                            ins = new StringBuilder(sql);
                            continue;
                        }
                        ins.append(", ( ");
                    }
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                            private boolean raiseException = false;

                            public void beforeQueryExecution(EmbedStatement stmt, Activation activation) throws SQLException {
                                this.raiseException = true;
                            }

                            public void scanControllerOpened(Object sc, Conglomerate conglom) {
                                if (!this.raiseException) {
                                    return;
                                }
                                if (!(sc instanceof MemScanController) || !(conglom instanceof MemConglomerate)) {
                                    return;
                                }
                                MemConglomerate c = (MemConglomerate)conglom;
                                if (c.getGemFireContainer().getTableName().equalsIgnoreCase("course")) {
                                    DistributedQueryDUnit.this.getLogWriter().info((Object)"Raising fake ClassCastException connection severe exception");
                                    throw new ClassCastException("Expected this exception to propagate out to query node");
                                }
                            }
                        });
                        ResultSet results = st.executeQuery("select * from course");
                        while (results.next()) {
                        }
                        TestCase.fail((String)"must have received an exception");
                    }
                    catch (SQLException expected) {
                        if (!"XJ001".equals(expected.getSQLState()) || !expected.getMessage().contains("ClassCastException")) {
                            throw new GemFireXDRuntimeException((Throwable)expected);
                        }
                    }
                    finally {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    }
                }
                catch (SQLException unexpected) {
                    throw new GemFireXDRuntimeException((Throwable)unexpected);
                }
            }
        };
        this.serverExecute(1, (Runnable)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCorrelatedSubQueryOnPR_PR_UNSUPPORTED() throws Exception {
        block30: {
            this.startVMs(1, 4);
            int clientPort = this.startNetworkServer(1, null, null);
            int derbyPort = AvailablePort.getRandomAvailablePort((int)0);
            Connection conn = TestUtil.getNetConnection(clientPort, null, null);
            Connection conn2 = TestUtil.jdbcConn;
            String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + derbyPort + "/newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            final String derbyUrl = derbyDbUrl;
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            NetworkServerControl server = DBSynchronizerTestBase.startNetworkServer(derbyPort);
            Connection derbyConn = DriverManager.getConnection(derbyUrl);
            Statement stmt = conn.createStatement();
            Statement stmt2 = conn2.createStatement();
            Statement derbyStmt = derbyConn.createStatement();
            stmt.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 clob not null, DATA1 blob not null, primary key (ID1)) PARTITION BY COLUMN ( ID1 )");
            stmt.execute("create table TESTTABLE2 (ID2 int not null, DESCRIPTION2 varchar(1024) not null, ADDRESS2 clob not null, primary key (ID2))");
            derbyStmt.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 clob not null, DATA1 blob not null, primary key (ID1))");
            derbyStmt.execute("create table TESTTABLE2 (ID2 int not null, DESCRIPTION2 varchar(1024) not null, ADDRESS2 clob not null, primary key (ID2))");
            String query = "select ID1, DESCRIPTION1, ADDRESS1, DATA1 from TESTTABLE1 where ID1 IN ( Select AVG(ID2) from Testtable2   where description2 > description1)";
            stmt.execute("insert into TESTTABLE1 values (1, 'ONE', 'ADDR1', X'1234567890ABCDEF')");
            stmt.execute("insert into TESTTABLE1 values (2, 'TWO', 'ADDR2', X'234567890ABCDEF1')");
            stmt.execute("insert into TESTTABLE1 values (3, 'THREE', 'ADDR3', cast (X'34567890ABCDEF12' as blob))");
            stmt.execute("insert into TESTTABLE2 values (1, 'ZONE', 'ADDR1')");
            stmt.execute("insert into TESTTABLE2 values (2, 'ATWO', 'ADDR2')");
            stmt.execute("insert into TESTTABLE2 values (3, 'ATHREE', 'ADDR3')");
            conn.commit();
            try {
                int ch;
                try {
                    stmt.execute(query);
                    DistributedQueryDUnit.fail((String)"The query should not get executed");
                }
                catch (SQLException snse) {
                    DistributedQueryDUnit.assertEquals((String)"0A000", (String)snse.getSQLState());
                }
                catch (Exception e) {
                    System.out.println(e);
                    DistributedQueryDUnit.fail(e.getMessage(), e);
                }
                try {
                    stmt2.execute(query);
                    DistributedQueryDUnit.fail((String)"The query should not get executed");
                }
                catch (SQLException snse) {
                    DistributedQueryDUnit.assertEquals((String)"0A000", (String)snse.getSQLState());
                }
                catch (Exception e) {
                    System.out.println(e);
                    DistributedQueryDUnit.fail(e.getMessage(), e);
                }
                try {
                    conn.prepareStatement(query);
                    DistributedQueryDUnit.fail((String)"The query should not get executed");
                }
                catch (SQLException snse) {
                    DistributedQueryDUnit.assertEquals((String)"0A000", (String)snse.getSQLState());
                }
                catch (Exception e) {
                    System.out.println(e);
                    DistributedQueryDUnit.fail(e.getMessage(), e);
                }
                try {
                    conn2.prepareStatement(query);
                    DistributedQueryDUnit.fail((String)"The query should not get executed");
                }
                catch (SQLException snse) {
                    DistributedQueryDUnit.assertEquals((String)"0A000", (String)snse.getSQLState());
                }
                catch (Exception e) {
                    System.out.println(e);
                    DistributedQueryDUnit.fail(e.getMessage(), e);
                }
                GemFireXDQueryObserverAdapter delegate = new GemFireXDQueryObserverAdapter(){
                    private final ConcurrentHashMap<Connection, Connection> dbConnMap = new ConcurrentHashMap();

                    public PreparedStatement afterQueryPrepareFailure(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, SQLException sqle) throws SQLException {
                        if (sqle != null && "0A000".equals(sqle.getSQLState())) {
                            return this.getDBConnection(conn).prepareStatement(sql);
                        }
                        return null;
                    }

                    public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) throws SQLException {
                        if (sqle != null && "0A000".equals(sqle.getSQLState())) {
                            stmt.setResultSet(this.getDBConnection(stmt.getConnection()).createStatement().executeQuery(stmt.getSQLText()));
                            return true;
                        }
                        return false;
                    }

                    public void afterCommit(Connection conn) {
                        Connection dbConn = this.dbConnMap.get(conn);
                        if (dbConn != null) {
                            try {
                                dbConn.commit();
                            }
                            catch (SQLException sqle) {
                                Logger.getLogger("com.pivotal.gemfirexd").warning("Ignored exception in commit: " + sqle);
                            }
                        }
                    }

                    public void afterRollback(Connection conn) {
                        Connection dbConn = this.dbConnMap.get(conn);
                        if (dbConn != null) {
                            try {
                                dbConn.rollback();
                            }
                            catch (SQLException sqle) {
                                Logger.getLogger("com.pivotal.gemfirexd").warning("Ignored exception in rollback: " + sqle);
                            }
                        }
                    }

                    public void afterConnectionClose(Connection conn) {
                        Connection dbConn = this.dbConnMap.get(conn);
                        if (dbConn != null) {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException sqle) {
                                Logger.getLogger("com.pivotal.gemfirexd").warning("Ignored exception in close: " + sqle);
                            }
                        }
                    }

                    private Connection getDBConnection(Connection conn) throws SQLException {
                        Connection oldConn;
                        Connection dbConn = this.dbConnMap.get(conn);
                        if (dbConn != null) {
                            return dbConn;
                        }
                        dbConn = DriverManager.getConnection(derbyUrl);
                        dbConn.setAutoCommit(conn.getAutoCommit());
                        int isolationLevel = conn.getTransactionIsolation();
                        if (dbConn.getMetaData().supportsTransactionIsolationLevel(isolationLevel)) {
                            dbConn.setTransactionIsolation(isolationLevel);
                        }
                        return (oldConn = this.dbConnMap.putIfAbsent(conn, dbConn)) == null ? dbConn : oldConn;
                    }
                };
                this.getServerVM(1).invoke((Runnable)new SerializableRunnable((GemFireXDQueryObserver)delegate){
                    final /* synthetic */ GemFireXDQueryObserver val$delegate;
                    {
                        this.val$delegate = gemFireXDQueryObserver;
                    }

                    public void run() {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.val$delegate);
                    }
                });
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)delegate);
                derbyStmt.execute("insert into TESTTABLE1 values (1, 'ONE', 'ADDR1', cast (X'1234567890ABCDEF' as blob))");
                derbyStmt.execute("insert into TESTTABLE1 values (2, 'TWO', 'ADDR2', cast (X'234567890ABCDEF1' as blob))");
                derbyStmt.execute("insert into TESTTABLE1 values (3, 'THREE', 'ADDR3', cast (X'34567890ABCDEF12' as blob))");
                derbyStmt.execute("insert into TESTTABLE2 values (1, 'ZONE', 'ADDR1')");
                derbyStmt.execute("insert into TESTTABLE2 values (2, 'ATWO', 'ADDR2')");
                derbyStmt.execute("insert into TESTTABLE2 values (3, 'ATHREE', 'ADDR3')");
                derbyConn.commit();
                ResultSet rs = stmt.executeQuery(query);
                DistributedQueryDUnit.assertTrue((boolean)rs.next());
                DistributedQueryDUnit.assertEquals((int)1, (int)rs.getInt(1));
                DistributedQueryDUnit.assertEquals((String)"ONE", (String)rs.getString(2));
                Clob clob = rs.getClob(3);
                StringBuilder sb = new StringBuilder();
                Reader rdr = clob.getCharacterStream();
                while ((ch = rdr.read()) != -1) {
                    sb.append((char)ch);
                }
                DistributedQueryDUnit.assertEquals((String)"ADDR1", (String)sb.toString());
                DistributedQueryDUnit.assertFalse((boolean)rs.next());
                rs.close();
                rs = stmt2.executeQuery(query);
                DistributedQueryDUnit.assertTrue((boolean)rs.next());
                DistributedQueryDUnit.assertEquals((int)1, (int)rs.getInt(1));
                DistributedQueryDUnit.assertEquals((String)"ONE", (String)rs.getString(2));
                clob = rs.getClob(3);
                sb = new StringBuilder();
                rdr = clob.getCharacterStream();
                while ((ch = rdr.read()) != -1) {
                    sb.append((char)ch);
                }
                DistributedQueryDUnit.assertEquals((String)"ADDR1", (String)sb.toString());
                DistributedQueryDUnit.assertFalse((boolean)rs.next());
                rs.close();
                PreparedStatement ps = conn.prepareStatement(query);
                rs = ps.executeQuery();
                DistributedQueryDUnit.assertTrue((boolean)rs.next());
                DistributedQueryDUnit.assertEquals((int)1, (int)rs.getInt(1));
                DistributedQueryDUnit.assertEquals((String)"ONE", (String)rs.getString(2));
                clob = rs.getClob(3);
                sb = new StringBuilder();
                rdr = clob.getCharacterStream();
                while ((ch = rdr.read()) != -1) {
                    sb.append((char)ch);
                }
                DistributedQueryDUnit.assertEquals((String)"ADDR1", (String)sb.toString());
                DistributedQueryDUnit.assertFalse((boolean)rs.next());
                rs.close();
                ps.close();
                ps = conn2.prepareStatement(query);
                rs = ps.executeQuery();
                DistributedQueryDUnit.assertTrue((boolean)rs.next());
                DistributedQueryDUnit.assertEquals((int)1, (int)rs.getInt(1));
                DistributedQueryDUnit.assertEquals((String)"ONE", (String)rs.getString(2));
                clob = rs.getClob(3);
                sb = new StringBuilder();
                rdr = clob.getCharacterStream();
                while ((ch = rdr.read()) != -1) {
                    sb.append((char)ch);
                }
                DistributedQueryDUnit.assertEquals((String)"ADDR1", (String)sb.toString());
                DistributedQueryDUnit.assertFalse((boolean)rs.next());
                rs.close();
                ps.close();
            }
            catch (Throwable throwable) {
                block29: {
                    if (!conn.isClosed()) {
                        conn.commit();
                    }
                    if (!conn2.isClosed()) {
                        conn2.commit();
                    }
                    if (!derbyConn.isClosed()) {
                        derbyConn.commit();
                    }
                    derbyStmt.execute("drop table TESTTABLE1");
                    derbyStmt.execute("drop table TESTTABLE2");
                    server.shutdown();
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getMessage().indexOf("shutdown") != -1) break block29;
                        sqle.printStackTrace();
                        throw sqle;
                    }
                }
                GemFireXDQueryObserverHolder.clearInstance();
                this.getServerVM(1).invoke((Runnable)new SerializableRunnable(){

                    public void run() {
                        GemFireXDQueryObserverHolder.clearInstance();
                    }
                });
                throw throwable;
            }
            if (!conn.isClosed()) {
                conn.commit();
            }
            if (!conn2.isClosed()) {
                conn2.commit();
            }
            if (!derbyConn.isClosed()) {
                derbyConn.commit();
            }
            derbyStmt.execute("drop table TESTTABLE1");
            derbyStmt.execute("drop table TESTTABLE2");
            server.shutdown();
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().indexOf("shutdown") != -1) break block30;
                sqle.printStackTrace();
                throw sqle;
            }
        }
        GemFireXDQueryObserverHolder.clearInstance();
        this.getServerVM(1).invoke((Runnable)new /* invalid duplicate definition of identical inner class */);
    }

    public void _testOrList_45041() throws Exception {
        Properties props = new Properties();
        props.setProperty("host-data", "true");
        this.startVMs(1, 2, 0, null, props);
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table test1 (id int primary key, name varchar(100) not null)");
        stmt.execute("create index idx1 on test1(name)");
        for (int id = 1; id < 100; ++id) {
            stmt.execute("insert into test1 values (" + id + ", 'name" + id + "')");
        }
        TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        ResultSet rs = stmt.executeQuery("select * from test1 where name < 'name5' or name > 'name90' order by id");
        int i = 1;
        while (rs.next()) {
            if (i == 5) {
                i = 10;
            } else if (i == 50) {
                i = 91;
            }
            DistributedQueryDUnit.assertEquals((int)i, (int)rs.getInt(1));
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(2));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select id from test1 where name < 'name5' or name > 'name90' order by name");
        i = 1;
        while (rs.next()) {
            if (i > 1) {
                if (i <= 5) {
                    i = (i - 1) * 10;
                } else if (i % 10 == 0 && i < 50) {
                    i /= 10;
                } else if (i == 50) {
                    i = 91;
                }
            }
            DistributedQueryDUnit.assertEquals((int)i, (int)rs.getInt(1));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where name < 'name5' or name > 'name90' order by name");
        i = 1;
        while (rs.next()) {
            if (i > 1) {
                if (i <= 5) {
                    i = (i - 1) * 10;
                } else if (i % 10 == 0 && i < 50) {
                    i /= 10;
                } else if (i == 50) {
                    i = 91;
                }
            }
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where name < 'name5' or name > 'name90' order by name");
        i = 1;
        while (rs.next()) {
            if (i > 1) {
                if (i <= 5) {
                    i = (i - 1) * 10;
                } else if (i % 10 == 0 && i < 50) {
                    i /= 10;
                } else if (i == 50) {
                    i = 91;
                }
            }
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            DistributedQueryDUnit.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where name < 'name5' or name > 'name90' order by id");
        i = 1;
        while (rs.next()) {
            if (i == 5) {
                i = 10;
            } else if (i == 50) {
                i = 91;
            }
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where name < 'name5' or name > 'name90' order by id");
        i = 1;
        while (rs.next()) {
            if (i == 5) {
                i = 10;
            } else if (i == 50) {
                i = 91;
            }
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            DistributedQueryDUnit.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        Object[][] expectedRows = new Object[][]{{7, "name7"}, {8, "name8"}, {9, "name9"}, {61, "name61"}, {62, "name62"}, {63, "name63"}, {64, "name64"}, {65, "name65"}, {66, "name66"}, {67, "name67"}, {68, "name68"}, {69, "name69"}, {70, "name70"}, {71, "name71"}, {72, "name72"}, {73, "name73"}, {74, "name74"}, {75, "name75"}, {76, "name76"}, {77, "name77"}, {78, "name78"}, {79, "name79"}, {80, "name80"}, {81, "name81"}, {82, "name82"}, {83, "name83"}, {84, "name84"}, {85, "name85"}, {86, "name86"}, {87, "name87"}, {88, "name88"}, {89, "name89"}};
        rs = stmt.executeQuery("select id from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90') order by id");
        i = 7;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            DistributedQueryDUnit.assertEquals((int)i, (int)rs.getInt(1));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90') order by id");
        i = 7;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90') order by id");
        i = 7;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            DistributedQueryDUnit.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select id, name from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90')");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select * from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90')");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where (name < 'name80' and id > 60) or (name > 'name70' and id < 90) order by id");
        i = 8;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.TABLE);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where (name < 'name80' and id > 60) or (id > 70 and name < 'name90') order by id");
        i = 61;
        while (rs.next()) {
            DistributedQueryDUnit.assertEquals((String)("name" + i), (String)rs.getString(1));
            DistributedQueryDUnit.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        DistributedQueryDUnit.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(DistributedQueryDUnit.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.TABLE);
        observer.checkAndClear();
    }

    public void testUseCase1CaseInsensitiveSearch() throws Exception {
        this.reduceLogLevelForTest("config");
        this.startVMs(1, 3);
        QueryChecksTest.checkCaseInsensitiveSearch(TestUtil.jdbcConn, false, true);
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    QueryChecksTest.checkCaseInsensitiveSearch(TestUtil.jdbcConn, true, false);
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("failure in running queries", e);
                }
            }
        });
        this.stopVMNums(-1, -2, -3);
        this.restartVMNums(-1, -2, -3);
        SerializableRunnable checkData = new SerializableRunnable(){

            public void run() {
                try {
                    QueryChecksTest.caseInsensitiveQueries(TestUtil.jdbcConn, true);
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("failure in running queries", e);
                }
            }
        };
        this.serverExecute(1, (Runnable)checkData);
        this.serverExecute(2, (Runnable)checkData);
        this.serverExecute(3, (Runnable)checkData);
    }

    public static void checkDateTimeFields(String tableName, int id, int columnIndex, int year, int month, int date, int hour, int minute, int second, int millisecond) throws Exception {
        Connection conn = TestUtil.jdbcConn;
        EmbedResultSet ers = (EmbedResultSet)conn.createStatement().executeQuery("select * from " + tableName);
        boolean foundId = false;
        RowFormatterTest.NullHolder wasNull = new RowFormatterTest.NullHolder();
        while (!foundId && ers.next()) {
            int[] ints;
            ExecRow row = ers.getCurrentRow();
            DistributedQueryDUnit.assertTrue((String)("Expected CompactExecRow but got " + row.getClass().getName()), (boolean)(row instanceof AbstractCompactExecRow));
            AbstractCompactExecRow compactRow = (AbstractCompactExecRow)row;
            if (compactRow.getAsInt(1, (ResultWasNull)wasNull) != id) continue;
            DistributedQueryDUnit.assertFalse((boolean)wasNull.wasNull());
            if (year >= 0) {
                if (hour >= 0) {
                    ints = compactRow.getRowFormatter().readAsIntArray(columnIndex, compactRow, 3);
                    DistributedQueryDUnit.assertEquals((int)SQLDate.computeEncodedDate((int)year, (int)month, (int)date), (int)ints[0]);
                    DistributedQueryDUnit.assertEquals((int)SQLTime.computeEncodedTime((int)hour, (int)minute, (int)second), (int)ints[1]);
                    DistributedQueryDUnit.assertEquals((int)(millisecond * 1000000), (int)ints[2]);
                } else {
                    ints = compactRow.getRowFormatter().readAsIntArray(columnIndex, compactRow, 1);
                    DistributedQueryDUnit.assertEquals((int)SQLDate.computeEncodedDate((int)year, (int)month, (int)date), (int)ints[0]);
                }
            } else {
                ints = compactRow.getRowFormatter().readAsIntArray(columnIndex, compactRow, 2);
                DistributedQueryDUnit.assertEquals((int)SQLTime.computeEncodedTime((int)hour, (int)minute, (int)second), (int)ints[0]);
                DistributedQueryDUnit.assertEquals((int)0, (int)ints[1]);
            }
            foundId = true;
        }
        DistributedQueryDUnit.assertTrue((String)("failed to find ID: " + id), (boolean)foundId);
    }

    public static String createRegionForTest(Boolean accessor) {
        Instantiator.register((Instantiator)new Instantiator(SerializableCompactLong.class, 79){

            public DataSerializable newInstance() {
                return new SerializableCompactLong();
            }
        });
        AttributesFactory attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PARTITION);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        if (accessor.booleanValue()) {
            paf.setLocalMaxMemory(0);
        }
        PartitionAttributes prAttr = paf.create();
        attr.setPartitionAttributes(prAttr);
        Cache cache = CacheFactory.getAnyInstance();
        Region reg = cache.createRegion("TESTLONG", attr.create());
        return reg.getFullPath();
    }

    private void createTablesAndPopulateData(int redundancy) throws Exception {
        String insertStmt;
        int i;
        String redundancyStr = "";
        if (redundancy > 0) {
            redundancyStr = " redundancy " + redundancy;
        }
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid))" + redundancyStr);
        for (i = 0; i < 100; ++i) {
            insertStmt = "insert into trade.customers values (" + i + ", '" + "CUST" + i + "', '" + "ADDR" + i + "', " + (i + 1) + ")";
            if (i % 2 == 0) {
                this.clientSQLExecute(1, insertStmt);
                continue;
            }
            this.serverSQLExecute((i % 4 + 1) / 2, insertStmt);
        }
        this.serverSQLExecute(2, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty >= 0), constraint avail_ch check (availQty >= 0 and availQty <= qty))" + redundancyStr);
        for (i = 5; i < 50; ++i) {
            insertStmt = "insert into trade.portfolio values (" + i + ", " + (i + 2) + ", " + i * 10 + ", " + i * 9 + ", " + (i + 1) + ")";
            if (i % 2 == 0) {
                this.clientSQLExecute(1, insertStmt);
                continue;
            }
            this.serverSQLExecute((i % 4 + 1) / 2, insertStmt);
        }
    }

    private static class ResultHolderIterationObserver
    extends GemFireXDQueryObserverAdapter {
        private int numIterations;
        private Thread stopperThread;

        private ResultHolderIterationObserver() {
        }

        public void afterResultHolderIteration(GfxdConnectionWrapper wrapper, EmbedStatement es) {
            try {
                if (++this.numIterations == 5) {
                    Thread.sleep(2000L);
                    this.stopperThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TestUtil.shutDown();
                                DistributedTestBase.getGlobalLogger().info((Object)"completed shutdown");
                            }
                            catch (SQLException ex) {
                                throw new TestException("failed in shutdown", (Throwable)ex);
                            }
                        }
                    });
                    this.stopperThread.start();
                    throw new CacheClosedException("forcing cache closed exception");
                }
            }
            catch (InterruptedException ie) {
                throw new CacheClosedException("got thread interrupt", (Throwable)ie);
            }
        }

        public void afterResultHolderExecution(GfxdConnectionWrapper wrapper, EmbedStatement es, String query) {
            this.numIterations = 0;
        }
    }

    public static class SerializableCompactLong
    implements DataSerializable {
        private long val;

        public SerializableCompactLong() {
        }

        public SerializableCompactLong(long val) {
            this.val = val;
        }

        public void toData(DataOutput out) throws IOException {
            InternalDataSerializer.writeSignedVL((long)this.val, (DataOutput)out);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.val = InternalDataSerializer.readSignedVL((DataInput)in);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SerializableCompactLong) {
                return this.val == ((SerializableCompactLong)obj).val;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.val ^ this.val >>> 32);
        }

        public String toString() {
            return String.valueOf(this.val);
        }
    }
}

