/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.distributed;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.sql.SQLException;

public class DistributedDeleteDUnit
extends DistributedSQLTestBase {
    public DistributedDeleteDUnit(String name) {
        super(name);
    }

    public void testDeleteOnTableWithoutReferencedKey() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid))");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid>10");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_1", true, false);
    }

    public void testDeleteOnTableWithoutReferencedKeyAndDifferentPartitionStrategy() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid)) REPLICATE");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint availloan_ck check (loanlimit>=availloan and availloan >=0)) PARTITION BY PRIMARY KEY");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid>10");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_1", true, false);
    }

    public void testDeleteOnTableWithReferencedPrimaryKey() throws Exception {
        block5: {
            block4: {
                this.startVMs(1, 2);
                this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid))");
                this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete RESTRICT, constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.addExpectedException(new int[]{1}, null, StandardException.class);
                try {
                    this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid>10");
                    DistributedDeleteDUnit.fail((String)"Exception is expected!");
                }
                catch (SQLException sqle) {
                    if ("23503".equals(sqle.getSQLState())) break block4;
                    throw sqle;
                }
            }
            try {
                this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid = 20");
                DistributedDeleteDUnit.fail((String)"Exception is expected!");
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) break block5;
                throw sqle;
            }
        }
        this.removeExpectedException(new int[]{1}, null, StandardException.class);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_2", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid=60");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
    }

    public void testDeleteOnTableWithReferencedPrimaryKeyAndDifferentStrategy() throws Exception {
        block5: {
            block4: {
                this.startVMs(1, 2);
                this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid)) REPLICATE ");
                this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete RESTRICT, constraint availloan_ck check (loanlimit>=availloan and availloan >=0)) PARTITION BY PRIMARY KEY");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.addExpectedException(new int[]{1}, null, StandardException.class);
                try {
                    this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid>10");
                    DistributedDeleteDUnit.fail((String)"Exception is expected!");
                }
                catch (SQLException sqle) {
                    if ("23503".equals(sqle.getSQLState())) break block4;
                    throw sqle;
                }
            }
            try {
                this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid = 20");
                DistributedDeleteDUnit.fail((String)"Exception is expected!");
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) break block5;
                throw sqle;
            }
        }
        this.removeExpectedException(new int[]{1}, null, StandardException.class);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_2", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid=60");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
    }

    public void _testDeleteOnTableWithReferencedUniqueKey() throws Exception {
        block5: {
            block4: {
                this.startVMs(1, 2);
                this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100),tid int not null, primary key (cid), unique (tid))");
                this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint cust_newt_fk foreign key (cid) references trade.customers (tid) on delete RESTRICT, constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
                this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
                this.addExpectedException(new int[]{1}, null, StandardException.class);
                try {
                    this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid>10");
                    DistributedDeleteDUnit.fail((String)"Exception is expected!");
                }
                catch (SQLException sqle) {
                    if ("23503".equals(sqle.getSQLState())) break block4;
                    throw sqle;
                }
            }
            try {
                this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid = 30");
                DistributedDeleteDUnit.fail((String)"Exception is expected!");
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) break block5;
                throw sqle;
            }
        }
        this.removeExpectedException(new int[]{1}, null, StandardException.class);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_2", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid=60");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
    }

    public void testDeleteOnTableWithReferencedPrimaryKeyAndRedundancy() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid)) PARTITION BY PRIMARY KEY REDUNDANCY 2");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete RESTRICT, constraint availloan_ck check (loanlimit>=availloan and availloan >=0)) PARTITION BY PRIMARY KEY REDUNDANCY 2");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid=60");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.clientSQLExecute(1, "drop table trade.networth");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.clientSQLExecute(1, "create table trade.customers (cid smallint not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid)) PARTITION BY PRIMARY KEY REDUNDANCY 2");
        this.clientSQLExecute(1, "create table trade.networth (cid smallint not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete RESTRICT, constraint availloan_ck check (loanlimit>=availloan and availloan >=0)) PARTITION BY PRIMARY KEY REDUNDANCY 2");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid=60");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.clientSQLExecute(1, "drop table trade.networth");
        this.clientSQLExecute(1, "drop table trade.customers");
        this.clientSQLExecute(1, "create table trade.customers (cid bigint not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid)) PARTITION BY PRIMARY KEY REDUNDANCY 2");
        this.clientSQLExecute(1, "create table trade.networth (cid bigint not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete RESTRICT, constraint availloan_ck check (loanlimit>=availloan and availloan >=0)) PARTITION BY PRIMARY KEY REDUNDANCY 2");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
        this.clientSQLExecute(1, "INSERT INTO trade.customers VALUES (60, 'name60', CURRENT_DATE, 'address60',60)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "DELETE FROM trade.customers WHERE cid=60");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.customers", TestUtil.getResourcesDir() + "/lib/deleteOperation.xml", "q_3", true, false);
    }

    public void testDeleteOnTableWithReferencedFKAndNonPKPartitioning() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid)) partition by range (cid) ( VALUES BETWEEN 0 AND 999, VALUES BETWEEN 1009 AND 1102, VALUES BETWEEN 1193 AND 1251, VALUES BETWEEN 1291 AND 1677, VALUES BETWEEN 1678 AND 10000)");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20), tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit >= availloan and availloan >=0)) partition by column(loanLimit, availloan)");
        this.clientSQLExecute(1, "insert into trade.customers values (1000, 'CUST_ONE', 'ADDR_ONE', 1), (1100, 'CUST_TWO', 'ADDR_TWO', 2), (1200, 'CUST_THREE', 'ADDR_THREE', 3), (1300, 'CUST_FOUR', 'ADDR_FOUR', 4), (1400, 'CUST_FIVE', 'ADDR_FIVE', 5)");
        this.serverSQLExecute(2, "insert into trade.networth values (1000, 10.2, 100.3, 10000, 5000.5, 1), (1100, 11.2, 111.3, 11111, 5111.5, 2), (1200, 12.2, 112.3, 12222, 5222.5, 3), (1300, 13.2, 113.3, 13333, 5333.5, 4)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select cid, addr, tid from trade.customers", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "dd_cust_insert");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select cid, securities, loanlimit, tid from trade.networth", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "dd_netw_insert");
        this.checkFKViolation(1, "delete from trade.customers where cid = 1000");
        this.checkFKViolation(-2, "delete from trade.customers where cid = 1100");
        this.checkFKViolation(-3, "delete from trade.customers where cid = 1300");
        this.clientSQLExecute(1, "delete from trade.networth where cid = 1300");
        this.serverSQLExecute(2, "delete from trade.networth where cid = 1000");
        this.serverSQLExecute(3, "delete from trade.customers where cid = 1000");
        this.serverSQLExecute(1, "delete from trade.customers where cid = 1300");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select cid, addr, tid from trade.customers", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "dd_cust_delete");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "select cid, securities, loanlimit, tid from trade.networth", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "dd_netw_delete");
    }

    public void test40050() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint availloan_ck check (loanlimit>=availloan and availloan >=0)) PARTITION BY PRIMARY KEY REDUNDANCY 2");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (60, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (70, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (80, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (90, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (100, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (110, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (120, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (130, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (140, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (150, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (160, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (170, 2310.00, 1234.00, 3456, 1245.00, 10)");
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (180, 2310.00, 1234.00, 3456, 1245.00, 20)");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/selectWithRedundancy2.xml", "q_1", true, false);
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (190, 2310.00, 1234.00, 3456, 1245.00, 20)");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/selectWithRedundancy2.xml", "q_2", true, false);
        this.clientSQLExecute(1, "DELETE FROM trade.networth where cid>180");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/selectWithRedundancy2.xml", "q_3", true, false);
        this.clientSQLExecute(1, "DELETE FROM trade.networth where cid>10");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/selectWithRedundancy2.xml", "q_4", true, false);
        this.clientSQLExecute(1, "INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 3456, 1245.00, 20)");
        this.sqlExecuteVerify(new int[]{1}, null, "select cid From trade.networth", TestUtil.getResourcesDir() + "/lib/selectWithRedundancy2.xml", "q_5", true, false);
    }
}

