/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.distributed;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultColocatedTablesEquiJoinDUnit
extends DistributedSQLTestBase {
    public DefaultColocatedTablesEquiJoinDUnit(String name) {
        super(name);
    }

    void checkColocation(int[] clientNums, int[] serverNums, String table1, String table2, String dumpEntries) {
        ArrayList<VM> vmlist = this.getVMs(clientNums, serverNums);
        DefaultColocatedTablesEquiJoinDUnit.assertNotNull(vmlist);
        DefaultColocatedTablesEquiJoinDUnit.assertTrue((vmlist.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < vmlist.size(); ++i) {
            VM executeVM = vmlist.get(i);
            if (executeVM == null) continue;
            executeVM.invoke(DefaultColocatedTablesEquiJoinDUnit.class, "verifyTablesColocated", new Object[]{table1, table2, new Boolean(dumpEntries)});
        }
    }

    public static void verifyTablesColocated(String table1AsRegionPath, String table2AsRegionPath, Boolean dumpEntries) {
        Region colocatedTableForSecondTable = Misc.getGemFireCache().getRegion(table2AsRegionPath);
        DefaultColocatedTablesEquiJoinDUnit.assertNotNull((Object)colocatedTableForSecondTable);
        PartitionAttributes pattrs = colocatedTableForSecondTable.getAttributes().getPartitionAttributes();
        DefaultColocatedTablesEquiJoinDUnit.assertNotNull((Object)pattrs);
        DefaultColocatedTablesEquiJoinDUnit.assertEquals((String)table1AsRegionPath, (String)pattrs.getColocatedWith());
        DefaultColocatedTablesEquiJoinDUnit.getGlobalLogger().info((Object)("table 2: " + table2AsRegionPath + " getColocatedwith returned: " + pattrs.getColocatedWith()));
        if (dumpEntries.booleanValue()) {
            DefaultColocatedTablesEquiJoinDUnit.getGlobalLogger().info((Object)("Dumping all entries in table1: " + table1AsRegionPath));
            DefaultColocatedTablesEquiJoinDUnit.dumpRegionEntries(table1AsRegionPath);
            DefaultColocatedTablesEquiJoinDUnit.dumpRegionEntries(table2AsRegionPath);
        }
    }

    public static void dumpRegionEntries(String regionPath) {
        PartitionedRegion reg = (PartitionedRegion)Misc.getGemFireCache().getRegion(regionPath);
        DefaultColocatedTablesEquiJoinDUnit.assertNotNull((Object)reg);
        Iterator irl = reg.getSharedDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)reg);
        DefaultColocatedTablesEquiJoinDUnit.getGlobalLogger().info((Object)("Dumping all local entries in table1: " + regionPath));
        int i = 0;
        while (irl.hasNext()) {
            RowLocation rl = (RowLocation)irl.next();
            DefaultColocatedTablesEquiJoinDUnit.getGlobalLogger().info((Object)("entry" + i++ + " = " + rl));
        }
    }

    public void testDistributedQueryPKFKExists() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID_2 int not null, THIRDID_2 int not null, foreign key (ID_FK) references EMP.PARTITIONTESTTABLE(ID))");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE values (1, 1, 1), (2, 2, 2), (3, 3, 3) ");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_FK values (1, 1, 1), (2, 2, 2), (3, 3, 3) ");
        this.checkColocation(new int[]{1}, new int[]{1, 2}, "/EMP/PARTITIONTESTTABLE", "/EMP/PARTITIONTESTTABLE_FK", "true");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.PARTITIONTESTTABLE, EMP.PARTITIONTESTTABLE_FK where ID = ID_FK", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "defaultquery_test1", false, false);
    }

    public void testDistributedQueryPKFKExists_pkOn2ndtablealso() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID_2 int not null, THIRDID_2 int not null, primary key (SECONDID_2), foreign key (ID_FK) references EMP.PARTITIONTESTTABLE(ID))");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE values (1, 1, 1), (2, 2, 2), (3, 3, 3) ");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE_FK values (1, 5, 1), (2, 7, 2), (3, 9, 3) ");
        this.checkColocation(new int[]{1}, new int[]{1, 2}, "/EMP/PARTITIONTESTTABLE", "/EMP/PARTITIONTESTTABLE_FK", "true");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.PARTITIONTESTTABLE, EMP.PARTITIONTESTTABLE_FK where ID = ID_FK", TestUtil.getResourcesDir() + "/lib/checkEquiJoinQuery.xml", "defaultquery_test2", false, false);
    }

    public void testDistributedQueryNoPKFKExists_explicitPartitionByPrimary() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION BY PRIMARY KEY");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID int not null, THIRDID int not null)");
        boolean gotException = false;
        try {
            this.clientSQLExecute(1, "select * from EMP.PARTITIONTESTTABLE, EMP.PARTITIONTESTTABLE_FK where ID = ID_FK");
        }
        catch (SQLException ex) {
            gotException = true;
        }
        DefaultColocatedTablesEquiJoinDUnit.assertTrue((boolean)gotException);
    }

    public void testDistributedQueryNoPKFKExists_implicitPartitionByPrimary_failAsNoPKFK() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID int not null, THIRDID int not null)");
        boolean gotException = false;
        try {
            this.clientSQLExecute(1, "select * from EMP.PARTITIONTESTTABLE, EMP.PARTITIONTESTTABLE_FK where ID = ID_FK");
        }
        catch (SQLException ex) {
            gotException = true;
        }
        DefaultColocatedTablesEquiJoinDUnit.assertTrue((boolean)gotException);
    }

    public void testDistributedQueryNoPKFKExists_singleSystemNoException() throws Exception {
        this.startServerVMs(1, 0, null);
        this.serverSQLExecute(1, "create schema EMP");
        this.serverSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION BY PRIMARY KEY");
        this.serverSQLExecute(1, "create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null constraint fk references EMP.PARTITIONTESTTABLE (ID),  SECONDID int not null, THIRDID int not null)");
        boolean gotException = false;
        try {
            this.serverSQLExecute(1, "select * from EMP.PARTITIONTESTTABLE, EMP.PARTITIONTESTTABLE_FK where ID = ID_FK");
        }
        catch (SQLException ex) {
            gotException = true;
        }
        DefaultColocatedTablesEquiJoinDUnit.assertFalse((boolean)gotException);
    }

    public void testBug46953() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema TRADE");
        this.clientSQLExecute(1, "create table trade.custrep (c_balance int not null, c_first int not null, c_middle varchar(10), c_id int primary key ) replicate");
        this.clientSQLExecute(1, "create table trade.custpart (c_balance int not null, c_first int not null, c_middle varchar(10), c_id int primary key ) partition by column (c_first)");
        Connection conn = TestUtil.getConnection();
        String[] securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.custrep values (?, ?, ?, ?)");
        for (i = 0; i < 3; ++i) {
            psInsert.setInt(1, 1);
            psInsert.setInt(2, i * 2);
            psInsert.setString(3, securities[i % 9]);
            psInsert.setInt(4, i * 4);
            psInsert.executeUpdate();
        }
        conn = TestUtil.getConnection();
        securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        psInsert = conn.prepareStatement("insert into trade.custpart values (?, ?, ?, ?)");
        for (i = 0; i < 3; ++i) {
            psInsert.setInt(1, 1);
            psInsert.setInt(2, i * 2);
            psInsert.setString(3, securities[i % 9]);
            psInsert.setInt(4, i * 4);
            psInsert.executeUpdate();
        }
        boolean gotException = false;
        try {
            this.clientSQLExecute(1, "SELECT * FROM trade.custpart, (select max(c_balance) from trade.custpart) as mytab(c1)");
        }
        catch (SQLException ex) {
            DefaultColocatedTablesEquiJoinDUnit.assertEquals((String)"0A000", (String)ex.getSQLState());
            gotException = true;
        }
        DefaultColocatedTablesEquiJoinDUnit.assertTrue((boolean)gotException);
        Connection conn2 = TestUtil.getConnection();
        PreparedStatement ps = conn2.prepareStatement("SELECT * FROM trade.custrep, (select max(c_balance) from trade.custrep) as mytab(c1)");
        ResultSet r = ps.executeQuery();
        int count = 0;
        while (r.next()) {
            DefaultColocatedTablesEquiJoinDUnit.assertEquals((int)1, (int)r.getInt(1));
            DefaultColocatedTablesEquiJoinDUnit.assertEquals((int)1, (int)r.getInt(5));
            ++count;
        }
        DefaultColocatedTablesEquiJoinDUnit.assertEquals((int)3, (int)count);
        r.close();
    }
}

