/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.diag;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.RMIException;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class GfxdDiagsDUnit
extends DistributedSQLTestBase {
    public GfxdDiagsDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = true;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = false;
    }

    public void testSingleMember() throws Exception {
        this.startClientVMs(1, 0, null);
        Statement stmt = TestUtil.getStatement();
        ResultSet rs = stmt.executeQuery("select * from SYS.MEMBERS");
        this.checkSingleMemberResult(rs);
        PreparedStatement pstmt = TestUtil.getPreparedStatement("select * from SYS.MEMBERS order by KIND");
        rs = pstmt.executeQuery();
        this.checkSingleMemberResult(rs);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS where ID = DSID() AND ISELDER = 0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where KIND <> 'locator(normal)'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and ISELDER = 0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and KIND <> 'locator(normal)'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and DSID() = ID and ISELDER=0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and KIND <> 'locator(normal)' and ISELDER = 1", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
    }

    public void testSingleMemberWithServerGroups() throws Exception {
        Properties props = new Properties();
        props.setProperty("gemfire.roles", "role1,role2");
        props.setProperty("host-data", "true");
        this.startServerVMs(1, 0, " SG1, Sg2,sg3", props);
        this.serverExecute(1, (Runnable)GfxdDiagsDUnit.checkSingleServerResultForServerGroups());
        this.serverSQLExecute(1, "CREATE TABLE TESTTAB (ID int not null primary key, NAME varchar(64)) SERVER GROUPS ( SG2, sG1,sg3, Sg2 )");
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_sgs", true, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_sgs", false, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS where GROUPS() = SERVERGROUPS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_sgs", true, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where KIND <> 'locator(normal)'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_only_sgs", true, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where ISELDER = 0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_only_sgs", false, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and ISELDER = 0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_only_sgs", false, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and m.KIND <> 'locator(normal)'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_only_sgs", false, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and m.SERVERGROUPS = GROUPS() and ISELDER=0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_server_only_sgs", true, false);
        this.sqlExecuteVerify(null, new int[]{1}, "select KIND, ROLES, HOSTDATA, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and ISELDER = 0 and t.TABLENAME not like 'TEST%'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
    }

    public static SerializableRunnable checkSingleServerResultForServerGroups() throws Exception {
        SerializableRunnable checkSingleMemberResultForServerGroups = new SerializableRunnable("checkSingleMemberResultForServerGroups"){

            public void run() throws CacheException {
                try {
                    Statement stmt = TestUtil.getStatement();
                    ResultSet rs = stmt.executeQuery("select * from SYS.MEMBERS");
                    this.checkSingleServerResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3", true);
                    PreparedStatement pstmt = TestUtil.getPreparedStatement("select * from SYS.MEMBERS");
                    rs = pstmt.executeQuery();
                    this.checkSingleServerResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3", true);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }

            private void checkSingleServerResultForServerGroups(ResultSet rs, String roles, String sgs, boolean isServer) throws Exception {
                boolean isElder = false;
                for (int num = 1; num <= 2; ++num) {
                    block10: {
                        block9: {
                            OrObject currLocators;
                            String currSgs;
                            String currRoles;
                            String currType;
                            String currKind;
                            TestCase.assertTrue((String)("num=" + num), (boolean)rs.next());
                            TestCase.assertTrue((!isElder || !rs.getBoolean("ISELDER") ? 1 : 0) != 0);
                            TestCase.assertTrue((!isElder || (Boolean)rs.getObject("ISELDER") == false ? 1 : 0) != 0);
                            isElder = rs.getBoolean("ISELDER");
                            if (isElder) {
                                currKind = "locator(normal)";
                                currType = "false";
                                currRoles = "";
                                currSgs = "";
                                currLocators = GfxdDiagsDUnit.getLocatorObj();
                            } else {
                                currKind = isServer ? "datastore(normal)" : "accessor(normal)";
                                currType = String.valueOf(isServer);
                                currRoles = roles;
                                currSgs = sgs;
                                currLocators = null;
                            }
                            TestCase.assertEquals((String)currKind, (String)rs.getString("KIND"));
                            TestCase.assertEquals((Object)currKind, (Object)rs.getObject("KIND"));
                            TestCase.assertEquals((String)currType, (String)rs.getString("HOSTDATA"));
                            TestCase.assertEquals((String)currRoles, (String)rs.getString("ROLES"));
                            TestCase.assertEquals((Object)currRoles, (Object)rs.getObject("ROLES"));
                            TestCase.assertEquals((String)currSgs, (String)rs.getString("SERVERGROUPS"));
                            TestCase.assertEquals((Object)currSgs, (Object)rs.getObject("SERVERGROUPS"));
                            TestCase.assertEquals((Object)currLocators, (Object)OrObject.create(rs.getString("LOCATOR")));
                            TestCase.assertEquals((Object)currLocators, (Object)OrObject.create(rs.getObject("LOCATOR")));
                            Logger logger = DistributedTestBase.getGlobalLogger();
                            logger.info((Object)("Got ID as " + rs.getString("ID")));
                            logger.info((Object)("Got ID as " + rs.getObject("ID")));
                            logger.info((Object)("Got IPADDRESS as " + rs.getString("IPADDRESS")));
                            logger.info((Object)("Got IPADDRESS as " + rs.getObject("IPADDRESS")));
                            logger.info((Object)("Got HOST as " + rs.getString("HOST")));
                            logger.info((Object)("Got HOST as " + rs.getObject("HOST")));
                            logger.info((Object)("Got PID as " + rs.getObject("PID")));
                            logger.info((Object)("Got PID as " + rs.getInt("PID")));
                            logger.info((Object)("Got PORT as " + rs.getObject("PORT")));
                            logger.info((Object)("Got PORT as " + rs.getInt("PORT")));
                            logger.info((Object)("Got NETSERVERS as " + rs.getObject("NETSERVERS")));
                            logger.info((Object)("Got NETSERVERS as " + rs.getString("NETSERVERS")));
                            logger.info((Object)("Got SYSTEMPROPS as " + rs.getObject("SYSTEMPROPS")));
                            logger.info((Object)("Got SYSTEMPROPS as " + rs.getString("SYSTEMPROPS")));
                            logger.info((Object)("Got GEMFIREPROPS as " + rs.getObject("GEMFIREPROPS")));
                            logger.info((Object)("Got GEMFIREPROPS as " + rs.getString("GEMFIREPROPS")));
                            logger.info((Object)("Got BOOTPROPS as " + rs.getObject("BOOTPROPS")));
                            logger.info((Object)("Got BOOTPROPS as " + rs.getString("BOOTPROPS")));
                            try {
                                rs.getObject("VMID");
                                TestCase.fail((String)"expected unknown column get to fail");
                            }
                            catch (SQLException ex) {
                                if ("S0022".equals(ex.getSQLState())) break block9;
                                throw ex;
                            }
                        }
                        try {
                            rs.getDate("PID");
                            TestCase.fail((String)"expected type conversion error");
                        }
                        catch (SQLException ex) {
                            if ("22005".equals(ex.getSQLState())) break block10;
                            throw ex;
                        }
                    }
                    try {
                        rs.getTime("PORT");
                        TestCase.fail((String)"expected type conversion error");
                        continue;
                    }
                    catch (SQLException ex) {
                        if ("22005".equals(ex.getSQLState())) continue;
                        throw ex;
                    }
                }
                TestCase.assertFalse((boolean)rs.next());
            }
        };
        return checkSingleMemberResultForServerGroups;
    }

    public void testMultipleMembersChange() throws Exception {
        this.startClientVMs(2, 0, null);
        this.startServerVMs(3, 0, null);
        this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "multiple_members", true, false);
        this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "multiple_members", false, false);
        this.runQueriesAndCheckResults(3, 2, "", "");
        this.stopVMNums(2, -3);
        this.runQueriesAndCheckResults(2, 1, "", "");
        int netPort = this.startNetworkServer(2, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        ResultSet rs = conn.createStatement().executeQuery("select KIND, LOCATOR, NETSERVERS from SYS.MEMBERS order by KIND, NETSERVERS");
        int numResults = 0;
        GfxdDiagsDUnit.assertTrue((String)("expected 4 results but failed on " + ++numResults), (boolean)rs.next());
        GfxdDiagsDUnit.assertEquals((String)"accessor(normal)", (String)rs.getString(1));
        GfxdDiagsDUnit.assertEquals(null, (String)rs.getString(2));
        GfxdDiagsDUnit.assertEquals((String)"", (String)rs.getString(3));
        GfxdDiagsDUnit.assertTrue((String)("expected 4 results but failed on " + ++numResults), (boolean)rs.next());
        GfxdDiagsDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(1));
        GfxdDiagsDUnit.assertEquals(null, (String)rs.getString(2));
        GfxdDiagsDUnit.assertEquals((String)"", (String)rs.getString(3));
        GfxdDiagsDUnit.assertTrue((String)("expected 4 results but failed on " + ++numResults), (boolean)rs.next());
        GfxdDiagsDUnit.assertEquals((String)"datastore(normal)", (String)rs.getString(1));
        GfxdDiagsDUnit.assertEquals(null, (String)rs.getString(2));
        GfxdDiagsDUnit.assertEquals((String)(GfxdDiagsDUnit.getQualifiedInetAddress(SocketCreator.getLocalHost()) + '[' + netPort + ']'), (String)rs.getString(3));
        GfxdDiagsDUnit.assertTrue((String)("expected 4 results but failed on " + ++numResults), (boolean)rs.next());
        GfxdDiagsDUnit.assertEquals((String)"locator(normal)", (String)rs.getString(1));
        GfxdDiagsDUnit.assertEquals((Object)GfxdDiagsDUnit.getLocatorObj(), (Object)OrObject.create(rs.getString(2)));
        GfxdDiagsDUnit.assertEquals((String)"", (String)rs.getString(3));
        GfxdDiagsDUnit.assertFalse((String)"expected 4 results but got more", (boolean)rs.next());
        conn.close();
        this.restartVMNums(-3);
        this.runQueriesAndCheckResults(3, 1, "", "");
        this.stopVMNums(-2, -3);
        this.runQueriesAndCheckResults(1, 1, "", "");
    }

    public void testMultipleMembersChangeWithServerGroups() throws Exception {
        Properties props = new Properties();
        props.setProperty("gemfire.roles", "role2, role1");
        this.startClientVMs(1, 0, " SG2, Sg3, sG1", props);
        this.startClientVMs(1, 0, "Sg1,SG3, Sg2 ", props);
        this.startServerVMs(3, 0, "sg3, Sg2,SG1 ", props);
        GfxdDiagsDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                try {
                    GfxdDiagsDUnit.this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "multiple_members_sgs", true, false);
                    return true;
                }
                catch (RMIException rmiex) {
                    if (rmiex.getCause() instanceof AssertionFailedError) {
                        return false;
                    }
                    throw rmiex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            public String description() {
                return "waiting for members to register in profiles";
            }
        }, (long)60000L, (long)500L, (boolean)true);
        this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "multiple_members_sgs", false, false);
        VM v = this.getClientVM(1);
        SerializableCallable dsC = new SerializableCallable("Get local DSID() "){

            public Object call() throws Exception {
                Connection conn = TestUtil.getConnection();
                ResultSet r = conn.createStatement().executeQuery("values DSID()");
                TestCase.assertTrue((boolean)r.next());
                return r.getString(1);
            }
        };
        String dsid = v != null ? (String)v.invoke((Callable)dsC) : (String)dsC.call();
        GfxdDiagsDUnit.assertTrue((String)dsid, (dsid != null && dsid.length() > 0 ? 1 : 0) != 0);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS where ID = '" + dsid + "'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only_sgs", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS where GROUPS() = SERVERGROUPS and ID = '" + dsid + "'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only_sgs", true, false);
        String roles = "role1,role2";
        String sgs = "SG1,SG2,SG3";
        this.runQueriesAndCheckResults(3, 2, "role1,role2", "SG1,SG2,SG3");
        this.stopVMNums(2, -3);
        this.runQueriesAndCheckResults(2, 1, "role1,role2", "SG1,SG2,SG3");
        this.restartServerVMNums(new int[]{3}, 0, "SG1,SG2,SG3", props);
        this.runQueriesAndCheckResults(3, 1, "role1,role2", "SG1,SG2,SG3");
        this.stopVMNums(-2, -3);
        this.runQueriesAndCheckResults(1, 1, "role1,role2", "SG1,SG2,SG3");
    }

    public void sb__testSingleMemberWithServerGroupsUpdate() throws Exception {
        Statement updStmt;
        PreparedStatement updPstmt;
        PreparedStatement pstmt;
        ResultSet rs;
        block20: {
            block19: {
                block18: {
                    int numResults;
                    Properties props = new Properties();
                    props.setProperty("gemfire.roles", "role2, role1");
                    this.startClientVMs(1, 0, " SG1,sg2, Sg3", props);
                    Statement stmt = TestUtil.getStatement();
                    rs = stmt.executeQuery("select * from SYS.MEMBERS");
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3");
                    pstmt = TestUtil.getPreparedStatement("select * from SYS.MEMBERS");
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3");
                    updPstmt = TestUtil.jdbcConn.prepareStatement("select * from SYS.MEMBERS where KIND <> 'locator(normal)'", 1003, 1008);
                    updStmt = TestUtil.jdbcConn.createStatement(1003, 1008);
                    boolean updateDone = false;
                    boolean exCheckDone = false;
                    block10: while (!updateDone || !exCheckDone) {
                        rs = updStmt.executeQuery("select * from SYS.MEMBERS");
                        for (numResults = 1; numResults <= 2; ++numResults) {
                            GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                            rs.updateString("SERVERGROUPS", "sg1, Sg3");
                            if ("locator(normal)".equals(rs.getString("KIND"))) {
                                block16: {
                                    if (exCheckDone) continue;
                                    this.addExpectedException(new int[]{1}, null, GemFireXDRuntimeException.class);
                                    try {
                                        rs.updateRow();
                                        GfxdDiagsDUnit.fail((String)"expected an exception in updating admin");
                                    }
                                    catch (SQLException ex) {
                                        if ("XJ124".equals(ex.getSQLState())) break block16;
                                        throw ex;
                                    }
                                }
                                this.removeExpectedException(new int[]{1}, null, GemFireXDRuntimeException.class);
                                exCheckDone = true;
                                continue block10;
                            }
                            rs.updateRow();
                            updateDone = true;
                        }
                    }
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG3");
                    rs = updPstmt.executeQuery();
                    GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                    rs.updateObject("SERVERGROUPS", (Object)"Sg2, SG1 ");
                    rs.updateRow();
                    GfxdDiagsDUnit.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2");
                    updateDone = false;
                    exCheckDone = false;
                    block12: while (!updateDone || !exCheckDone) {
                        rs = updStmt.executeQuery("select * from SYS.MEMBERS");
                        for (numResults = 1; numResults <= 2; ++numResults) {
                            GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                            rs.updateBoolean("HOSTDATA", true);
                            if ("locator(normal)".equals(rs.getString("KIND"))) {
                                block17: {
                                    if (exCheckDone) continue;
                                    this.addExpectedException(new int[]{1}, null, GemFireXDRuntimeException.class);
                                    try {
                                        rs.updateRow();
                                        GfxdDiagsDUnit.fail((String)"expected an exception in updating admin");
                                    }
                                    catch (SQLException ex) {
                                        if ("XJ124".equals(ex.getSQLState())) break block17;
                                        throw ex;
                                    }
                                }
                                this.removeExpectedException(new int[]{1}, null, GemFireXDRuntimeException.class);
                                exCheckDone = true;
                                continue block12;
                            }
                            rs.updateRow();
                            updateDone = true;
                        }
                    }
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2", true);
                    rs = updPstmt.executeQuery();
                    GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                    rs.updateObject("HOSTDATA", (Object)Boolean.FALSE);
                    rs.updateRow();
                    GfxdDiagsDUnit.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2", false);
                    rs = updStmt.executeQuery("select KIND, HOSTDATA, SERVERGROUPS, ID from SYS.MEMBERS where KIND <> 'locator(normal)'");
                    GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                    rs.updateString("SERVERGROUPS", "sg2, Sg3");
                    rs.updateRow();
                    GfxdDiagsDUnit.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG2,SG3");
                    rs = updStmt.executeQuery("select KIND, HOSTDATA, SERVERGROUPS, ID from SYS.MEMBERS where ISELDER = 0");
                    GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                    rs.updateString("HOSTDATA", "true");
                    rs.updateRow();
                    GfxdDiagsDUnit.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG2,SG3", true);
                    rs = updStmt.executeQuery("select HOSTDATA, SERVERGROUPS, ID from SYS.MEMBERS where KIND <> 'locator(normal)'");
                    GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                    rs.updateObject("HOSTDATA", (Object)Boolean.FALSE);
                    rs.updateRow();
                    GfxdDiagsDUnit.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG2,SG3", false);
                    try {
                        this.clientSQLExecute(1, "update SYS.MEMBERS set SERVERGROUPS='sg2, SG1 ' where KIND <> 'locator(normal)'");
                        GfxdDiagsDUnit.fail((String)"expected update statement to fail");
                    }
                    catch (SQLException ex) {
                        if ("42Y25".equals(ex.getSQLState())) break block18;
                        throw ex;
                    }
                }
                rs = updStmt.executeQuery("select SERVERGROUPS, ID from SYS.MEMBERS where ISELDER = 0");
                GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                rs.updateString("SERVERGROUPS", "tsg2, tSg4");
                rs.updateRow();
                GfxdDiagsDUnit.assertFalse((boolean)rs.next());
                rs = pstmt.executeQuery();
                this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "TSG2,TSG4");
                rs = updStmt.executeQuery("select ROLES, ID from SYS.MEMBERS where ISELDER = 0");
                GfxdDiagsDUnit.assertTrue((boolean)rs.next());
                rs.updateObject("ID", (Object)"newId");
                try {
                    rs.updateRow();
                    GfxdDiagsDUnit.fail((String)"expected an exception in updating a read-only column");
                }
                catch (SQLException ex) {
                    if ("42X31".equals(ex.getSQLState())) break block19;
                    throw ex;
                }
            }
            rs = updStmt.executeQuery("select ROLES, ID from SYS.MEMBERS where KIND <> 'locator(normal)'");
            GfxdDiagsDUnit.assertTrue((boolean)rs.next());
            rs.updateObject("ROLES", (Object)"newrole");
            try {
                rs.updateRow();
                GfxdDiagsDUnit.fail((String)"expected an exception in updating a read-only column");
            }
            catch (SQLException ex) {
                if ("42X31".equals(ex.getSQLState())) break block20;
                throw ex;
            }
        }
        this.clientSQLExecute(1, "CREATE TABLE TESTTAB (ID int not null primary key, NAME varchar(64)) SERVER GROUPS (SG1, SG3,sg2)");
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and ISELDER = 0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and t.TABLENAME = 'TESTTAB' and KIND <> 'locator(normal)'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", true, false);
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        PartitionAttributes pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        this.clientVerifyRegionProperties(1, null, "TESTTAB", (RegionAttributes<?, ?>)expectedAttrs);
        rs = updPstmt.executeQuery();
        GfxdDiagsDUnit.assertTrue((boolean)rs.next());
        rs.updateString("SERVERGROUPS", "  sg2, Sg3 , SG1 ");
        rs.updateRow();
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_sgs", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_sgs", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where KIND <> 'locator(normal)'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only_sgs", true, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where ISELDER = 0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only_sgs", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and ISELDER = 0", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only_sgs", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and m.KIND <> 'locator(normal)'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "single_client_only_sgs", false, false);
        this.sqlExecuteVerify(new int[]{1}, null, "select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and ISELDER = 0 and t.TABLENAME not like 'TEST%'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
        this.clientSQLExecute(1, "CREATE TABLE TESTTAB1 (ID int not null primary key, NAME varchar(64)) SERVER GROUPS (SG1, SG3,sg2)");
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        this.clientVerifyRegionProperties(1, null, "TESTTAB1", (RegionAttributes<?, ?>)expectedAttrs);
        rs = updStmt.executeQuery("select KIND, HOSTDATA, ID from SYS.MEMBERS where KIND <> 'locator(normal)'");
        GfxdDiagsDUnit.assertTrue((boolean)rs.next());
        rs.updateObject("HOSTDATA", (Object)Boolean.TRUE);
        rs.updateRow();
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        rs = pstmt.executeQuery();
        this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3", true);
        this.clientSQLExecute(1, "CREATE TABLE TESTTAB2 (ID int not null primary key, NAME varchar(64)) SERVER GROUPS (SG1, SG3,sg2)");
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        this.clientVerifyRegionProperties(1, null, "TESTTAB2", (RegionAttributes<?, ?>)expectedAttrs);
    }

    public void sb__testMultipleMembersChangeWithServerGroupsUpdate() throws Exception {
        int numResults;
        Properties props = new Properties();
        props.setProperty("gemfire.roles", "role1, role2");
        this.startClientVMs(2, 0, " SG2, Sg3, sG1", props);
        this.startServerVMs(3, 0, "sg3, Sg2,SG1 ", props);
        this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "multiple_members_sgs", true, false);
        this.sqlExecuteVerify(new int[]{1, 2}, new int[]{1, 2, 3}, "select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "multiple_members_sgs", false, false);
        String roles = "role1,role2";
        String sgs = "SG1,SG2,SG3";
        this.runQueriesAndCheckResults(3, 2, "role1,role2", sgs);
        PreparedStatement updPstmt = TestUtil.jdbcConn.prepareStatement("select * from SYS.MEMBERS where KIND <> 'locator(normal)'", 1003, 1008);
        Statement updStmt = TestUtil.jdbcConn.createStatement(1003, 1008);
        ResultSet rs = updPstmt.executeQuery();
        for (int numResults2 = 1; numResults2 <= 5; ++numResults2) {
            GfxdDiagsDUnit.assertTrue((boolean)rs.next());
            boolean isDataStore = rs.getBoolean("HOSTDATA");
            if (isDataStore) {
                rs.updateString("SERVERGROUPS", " sg2 , SG1 ");
            } else {
                rs.updateString("SERVERGROUPS", "SG1,SG3");
            }
            rs.updateBoolean("HOSTDATA", !isDataStore);
            rs.updateRow();
        }
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        sgs = "SG1,SG3";
        String clientSGs = "SG1,SG2";
        this.runQueriesAndCheckResults(2, 3, "role1,role2", clientSGs, sgs, true);
        this.stopVMNums(2, -3);
        this.runQueriesAndCheckResults(1, 2, "role1,role2", clientSGs, sgs, true);
        this.joinVM(false, this.restartServerVMAsync(3, 0, clientSGs, props));
        DistributedMember member = this.getMemberForVM((VM)this.serverVMs.get(2));
        this.getLogWriter().info((Object)("waiting for member [" + member.getId() + ']'));
        do {
            Thread.sleep(1000L);
        } while (!(rs = updStmt.executeQuery("select * from SYS.MEMBERS where PID=" + member.getProcessId())).next());
        rs.updateObject("HOSTDATA", (Object)Boolean.FALSE);
        rs.updateRow();
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        this.runQueriesAndCheckResults(1, 3, "role1,role2", clientSGs, sgs, true);
        rs = updStmt.executeQuery("select * from SYS.MEMBERS where ISELDER = 0");
        for (numResults = 1; numResults <= 4; ++numResults) {
            GfxdDiagsDUnit.assertTrue((boolean)rs.next());
            rs.updateString("SERVERGROUPS", " tsg3 , TSG1 ");
            rs.updateRow();
        }
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        sgs = "TSG1,TSG3";
        this.runQueriesAndCheckResults(1, 3, "role1,role2", sgs, sgs, true);
        rs = updPstmt.executeQuery();
        for (numResults = 1; numResults <= 4; ++numResults) {
            GfxdDiagsDUnit.assertTrue((boolean)rs.next());
            boolean isDataStore = rs.getBoolean("HOSTDATA");
            if (isDataStore) {
                rs.updateString("SERVERGROUPS", " sg3 , SG1 ");
            } else {
                rs.updateString("SERVERGROUPS", "SG1,SG2");
            }
            rs.updateString("HOSTDATA", String.valueOf(!isDataStore));
            rs.updateRow();
        }
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        sgs = "SG1,SG2";
        clientSGs = "SG1,SG3";
        this.runQueriesAndCheckResults(3, 1, "role1,role2", clientSGs, sgs, false);
        this.restartClientVMNums(new int[]{2}, 0, clientSGs, props);
        member = this.getMemberForVM((VM)this.clientVMs.get(1));
        this.getLogWriter().info((Object)("waiting for member [" + member.getId() + ']'));
        do {
            Thread.sleep(1000L);
        } while (!(rs = updStmt.executeQuery("select * from SYS.MEMBERS where PID=" + member.getProcessId())).next());
        this.runQueriesAndCheckResults(3, 2, "role1,role2", clientSGs, sgs, false);
        rs = updStmt.executeQuery("select * from SYS.MEMBERS where ISELDER = 0");
        for (numResults = 1; numResults <= 5; ++numResults) {
            GfxdDiagsDUnit.assertTrue((boolean)rs.next());
            rs.updateString("SERVERGROUPS", " sg3, sg1,SG2 ");
            rs.updateRow();
        }
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        sgs = "SG1,SG2,SG3";
        this.runQueriesAndCheckResults(3, 2, "role1,role2", sgs);
        this.stopVMNums(-1, -2, -3, 2);
        this.runQueriesAndCheckResults(0, 1, "role1,role2", sgs);
    }

    public void testBug43219_VTITablesRouting() throws Exception {
        this.startVMs(1, 3);
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        if (GemFireXDUtils.hasTable((Connection)conn, (String)"countries")) {
            st.execute("drop table countries");
        }
        st.execute("CREATE TABLE COUNTRIES (COUNTRY VARCHAR(26) NOT NULL, COUNTRY_ISO_CODE CHAR(2) NOT NULL, REGION VARCHAR(26)) REPLICATE");
        ResultSet rs = st.executeQuery("select t.tablename, t.datapolicy, m.hostdata, m.id from sys.systables t , sys.members m where t.tablename = 'COUNTRIES'");
        ArrayList<String> dataPolicyNonEmpty = new ArrayList<String>();
        ArrayList<String> dataPolicyEmpty = new ArrayList<String>();
        while (rs.next()) {
            if (rs.getString(2).equalsIgnoreCase("REPLICATE")) {
                this.getLogWriter().info((Object)("Got hostdata = " + rs.getString(3) + " datapolicy = " + rs.getString(2) + " id = " + rs.getString(4)));
                GfxdDiagsDUnit.assertTrue((boolean)rs.getString(3).equalsIgnoreCase("true"));
                dataPolicyNonEmpty.add(rs.getString(4));
                continue;
            }
            if (!rs.getString(2).equalsIgnoreCase("EMPTY")) continue;
            this.getLogWriter().info((Object)("Got hostdata = " + rs.getString(3) + " datapolicy = " + rs.getString(2) + " id = " + rs.getString(4)));
            GfxdDiagsDUnit.assertTrue((boolean)rs.getString(3).equalsIgnoreCase("false"));
            dataPolicyEmpty.add(rs.getString(4));
        }
        GfxdDiagsDUnit.assertEquals((int)3, (int)dataPolicyNonEmpty.size());
        GfxdDiagsDUnit.assertEquals((int)1, (int)dataPolicyEmpty.size());
    }

    private void runQueriesAndCheckResults(int numServers, int numClients, String roles, String sgs) throws Exception {
        this.runQueriesAndCheckResults(numServers, numClients, roles, sgs, sgs, false);
    }

    private void runQueriesAndCheckResults(int numServers, int numClients, String roles, String clientSGs, String serverSGs, boolean swapServerClient) throws Exception {
        String tableSGs;
        Statement stmt = TestUtil.getStatement();
        ResultSet rs = stmt.executeQuery("select * from SYS.MEMBERS");
        this.checkMembersResultForServerGroups(false, numServers, numClients, 1, rs, roles, clientSGs, serverSGs);
        PreparedStatement pstmt = TestUtil.getPreparedStatement("select * from SYS.MEMBERS");
        rs = pstmt.executeQuery();
        this.checkMembersResultForServerGroups(false, numServers, numClients, 1, rs, roles, clientSGs, serverSGs);
        if (clientSGs.length() > 0 || serverSGs.length() > 0) {
            tableSGs = "SG2, sG1,sg3 , Sg2";
            stmt.execute("CREATE TABLE TESTTAB (ID int not null primary key, NAME varchar(64)) SERVER GROUPS ( " + tableSGs + " )");
        } else {
            tableSGs = "";
            stmt.execute("CREATE TABLE TESTTAB (ID int not null primary key, NAME varchar(64))");
        }
        SortedSet tableSGSet = SharedUtils.toSortedSet((String)tableSGs, (boolean)false);
        SortedSet clntSGSet = SharedUtils.toSortedSet((String)clientSGs, (boolean)false);
        SortedSet srvSGSet = SharedUtils.toSortedSet((String)serverSGs, (boolean)false);
        boolean serversAreStores = true;
        if (tableSGs.length() > 0) {
            serversAreStores = GemFireXDUtils.setIntersect((Set)tableSGSet, (Set)srvSGSet, null);
        }
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        PartitionAttributes pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        for (int clientNum = 1; clientNum <= numClients; ++clientNum) {
            if (swapServerClient) {
                this.serverVerifyRegionProperties(clientNum, null, "TESTTAB", (RegionAttributes<?, ?>)expectedAttrs);
                continue;
            }
            this.clientVerifyRegionProperties(clientNum, null, "TESTTAB", (RegionAttributes<?, ?>)expectedAttrs);
        }
        if (serversAreStores) {
            pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
            expectedAttrs.setPartitionAttributes(pattrs);
        }
        for (int serverNum = 1; serverNum <= numServers; ++serverNum) {
            if (swapServerClient) {
                this.clientVerifyRegionProperties(serverNum, null, "TESTTAB", (RegionAttributes<?, ?>)expectedAttrs);
                continue;
            }
            this.serverVerifyRegionProperties(serverNum, null, "TESTTAB", (RegionAttributes<?, ?>)expectedAttrs);
        }
        rs = stmt.executeQuery("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where KIND <> 'locator(normal)'");
        this.checkMembersResultForServerGroups(true, numServers, numClients, 0, rs, roles, clientSGs, serverSGs);
        pstmt = TestUtil.getPreparedStatement("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where ISELDER = 0");
        rs = pstmt.executeQuery();
        this.checkMembersResultForServerGroups(true, numServers, numClients, 0, rs, roles, clientSGs, serverSGs);
        int numServersWithTable = 0;
        int numClientsWithTable = 0;
        if (GemFireXDUtils.setEquals((SortedSet)tableSGSet, (SortedSet)srvSGSet)) {
            numServersWithTable = numServers;
        }
        if (GemFireXDUtils.setEquals((SortedSet)tableSGSet, (SortedSet)clntSGSet)) {
            numClientsWithTable = numClients;
        }
        rs = stmt.executeQuery("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where groupsintersect(t.SERVERGROUPS, m.SERVERGROUPS) and ISELDER = 0 and t.TABLENAME = 'TESTTAB'");
        this.checkMembersResultForServerGroups(true, numServersWithTable, numClientsWithTable, 0, rs, roles, clientSGs, serverSGs);
        pstmt = TestUtil.getPreparedStatement("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where groupsintersect(t.SERVERGROUPS, m.SERVERGROUPS) and KIND <> 'locator(normal)' and t.TABLENAME = 'TESTTAB'");
        rs = pstmt.executeQuery();
        this.checkMembersResultForServerGroups(true, numServersWithTable, numClientsWithTable, 0, rs, roles, clientSGs, serverSGs);
        rs = stmt.executeQuery("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where groupsintersect(t.SERVERGROUPS, m.SERVERGROUPS) and KIND <> 'locator(normal)' and ISELDER = 1");
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
        stmt.execute("drop table TESTTAB");
    }

    private void checkSingleMemberResult(ResultSet rs) throws SQLException {
        this.checkSingleMemberResultForServerGroups(rs, "", "");
    }

    private void checkSingleMemberResultForServerGroups(ResultSet rs, String roles, String sgs) throws SQLException {
        this.checkSingleMemberResultForServerGroups(rs, roles, sgs, false);
    }

    private void checkSingleMemberResultForServerGroups(ResultSet rs, String roles, String sgs, boolean isServer) throws SQLException {
        boolean isElder = false;
        for (int num = 1; num <= 2; ++num) {
            block10: {
                block9: {
                    OrObject currLocators;
                    String currSgs;
                    String currRoles;
                    String currType;
                    String currKind;
                    GfxdDiagsDUnit.assertTrue((String)("num=" + num), (boolean)rs.next());
                    GfxdDiagsDUnit.assertTrue((!isElder || !rs.getBoolean("ISELDER") ? 1 : 0) != 0);
                    GfxdDiagsDUnit.assertTrue((!isElder || (Boolean)rs.getObject("ISELDER") == false ? 1 : 0) != 0);
                    isElder = rs.getBoolean("ISELDER");
                    if (isElder) {
                        currKind = "locator(normal)";
                        currType = "false";
                        currRoles = "";
                        currSgs = "";
                        currLocators = GfxdDiagsDUnit.getLocatorObj();
                    } else {
                        currKind = isServer ? "datastore(normal)" : "accessor(normal)";
                        currType = String.valueOf(isServer);
                        currRoles = roles;
                        currSgs = sgs;
                        currLocators = null;
                    }
                    GfxdDiagsDUnit.assertEquals((String)currKind, (String)rs.getString("KIND"));
                    GfxdDiagsDUnit.assertEquals((Object)currKind, (Object)rs.getObject("KIND"));
                    GfxdDiagsDUnit.assertEquals((String)currType, (String)rs.getString("HOSTDATA"));
                    GfxdDiagsDUnit.assertEquals((String)currRoles, (String)rs.getString("ROLES"));
                    GfxdDiagsDUnit.assertEquals((Object)currRoles, (Object)rs.getObject("ROLES"));
                    GfxdDiagsDUnit.assertEquals((String)currSgs, (String)rs.getString("SERVERGROUPS"));
                    GfxdDiagsDUnit.assertEquals((Object)currSgs, (Object)rs.getObject("SERVERGROUPS"));
                    GfxdDiagsDUnit.assertEquals((Object)currLocators, (Object)OrObject.create(rs.getString("LOCATOR")));
                    GfxdDiagsDUnit.assertEquals((Object)currLocators, (Object)OrObject.create(rs.getObject("LOCATOR")));
                    this.getLogWriter().info((Object)("Got ID as " + rs.getString("ID")));
                    this.getLogWriter().info((Object)("Got ID as " + rs.getObject("ID")));
                    this.getLogWriter().info((Object)("Got IPADDRESS as " + rs.getString("IPADDRESS")));
                    this.getLogWriter().info((Object)("Got IPADDRESS as " + rs.getObject("IPADDRESS")));
                    this.getLogWriter().info((Object)("Got HOST as " + rs.getString("HOST")));
                    this.getLogWriter().info((Object)("Got HOST as " + rs.getObject("HOST")));
                    this.getLogWriter().info((Object)("Got PID as " + rs.getObject("PID")));
                    this.getLogWriter().info((Object)("Got PID as " + rs.getInt("PID")));
                    this.getLogWriter().info((Object)("Got PORT as " + rs.getObject("PORT")));
                    this.getLogWriter().info((Object)("Got PORT as " + rs.getInt("PORT")));
                    this.getLogWriter().info((Object)("Got NETSERVERS as " + rs.getObject("NETSERVERS")));
                    this.getLogWriter().info((Object)("Got NETSERVERS as " + rs.getString("NETSERVERS")));
                    this.getLogWriter().info((Object)("Got SYSTEMPROPS as " + rs.getObject("SYSTEMPROPS")));
                    this.getLogWriter().info((Object)("Got SYSTEMPROPS as " + rs.getString("SYSTEMPROPS")));
                    this.getLogWriter().info((Object)("Got GEMFIREPROPS as " + rs.getObject("GEMFIREPROPS")));
                    this.getLogWriter().info((Object)("Got GEMFIREPROPS as " + rs.getString("GEMFIREPROPS")));
                    this.getLogWriter().info((Object)("Got BOOTPROPS as " + rs.getObject("BOOTPROPS")));
                    this.getLogWriter().info((Object)("Got BOOTPROPS as " + rs.getString("BOOTPROPS")));
                    try {
                        rs.getObject("VMID");
                        GfxdDiagsDUnit.fail((String)"expected unknown column get to fail");
                    }
                    catch (SQLException ex) {
                        if ("S0022".equals(ex.getSQLState())) break block9;
                        throw ex;
                    }
                }
                try {
                    rs.getDate("PID");
                    GfxdDiagsDUnit.fail((String)"expected type conversion error");
                }
                catch (SQLException ex) {
                    if ("22005".equals(ex.getSQLState())) break block10;
                    throw ex;
                }
            }
            try {
                rs.getTime("PORT");
                GfxdDiagsDUnit.fail((String)"expected type conversion error");
                continue;
            }
            catch (SQLException ex) {
                if ("22005".equals(ex.getSQLState())) continue;
                throw ex;
            }
        }
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
    }

    private static OrObject getLocatorObj() {
        return OrObject.create(GfxdDiagsDUnit.getDUnitLocatorString(), "127.0.0.1[" + GfxdDiagsDUnit.getDUnitLocatorPort() + ']');
    }

    private void checkMembersResultForServerGroups(boolean project, int numServers, int numClients, int numAdmins, ResultSet rs, String roles, String clientSGs, String serverSGs) throws SQLException {
        boolean isElder = false;
        String currKind = null;
        int totalNum = numServers + numClients + numAdmins;
        while (totalNum-- >= 1) {
            block19: {
                block18: {
                    block17: {
                        GfxdDiagsDUnit.assertTrue((String)("failed with totalNum=" + totalNum + " numServers=" + numServers + " numClients=" + numClients + " numAdmin=" + numAdmins), (boolean)rs.next());
                        GfxdDiagsDUnit.assertTrue((numServers >= 0 && numClients >= 0 && numAdmins >= 0 ? 1 : 0) != 0);
                        GfxdDiagsDUnit.assertTrue((!isElder || !rs.getBoolean("ISELDER") ? 1 : 0) != 0);
                        GfxdDiagsDUnit.assertTrue((!isElder || (Boolean)rs.getObject("ISELDER") == false ? 1 : 0) != 0);
                        isElder = rs.getBoolean("ISELDER");
                        String currType = rs.getString("HOSTDATA");
                        String currRoles = "";
                        String currServerGroups = "";
                        if (currType == null || isElder) {
                            --numAdmins;
                            currKind = "locator(normal)";
                        } else if ("true".equals(currType)) {
                            --numServers;
                            currKind = "datastore(normal)";
                            currRoles = roles;
                            currServerGroups = serverSGs;
                        } else if ("false".equals(currType)) {
                            --numClients;
                            currKind = "accessor(normal)";
                            currRoles = roles;
                            currServerGroups = clientSGs;
                        } else {
                            GfxdDiagsDUnit.fail((String)("unexpected HOSTDATA: " + currType));
                        }
                        GfxdDiagsDUnit.assertEquals((Object)currKind, (Object)rs.getObject("KIND"));
                        GfxdDiagsDUnit.assertEquals((String)currKind, (String)rs.getString("KIND"));
                        GfxdDiagsDUnit.assertEquals((String)currType, (String)rs.getString("HOSTDATA"));
                        GfxdDiagsDUnit.assertEquals((String)currRoles, (String)rs.getString("ROLES"));
                        GfxdDiagsDUnit.assertEquals((Object)currRoles, (Object)rs.getObject("ROLES"));
                        GfxdDiagsDUnit.assertEquals((String)currServerGroups, (String)rs.getString("SERVERGROUPS"));
                        GfxdDiagsDUnit.assertEquals((Object)currServerGroups, (Object)rs.getObject("SERVERGROUPS"));
                        if (!project) {
                            this.getLogWriter().info((Object)("Got ID as " + rs.getString("ID")));
                            this.getLogWriter().info((Object)("Got ID as " + rs.getObject("ID")));
                            this.getLogWriter().info((Object)("Got IPADDRESS as " + rs.getString("IPADDRESS")));
                            this.getLogWriter().info((Object)("Got IPADDRESS as " + rs.getObject("IPADDRESS")));
                            this.getLogWriter().info((Object)("Got HOST as " + rs.getString("HOST")));
                            this.getLogWriter().info((Object)("Got HOST as " + rs.getObject("HOST")));
                            this.getLogWriter().info((Object)("Got PID as " + rs.getObject("PID")));
                            this.getLogWriter().info((Object)("Got PID as " + rs.getInt("PID")));
                            this.getLogWriter().info((Object)("Got PORT as " + rs.getObject("PORT")));
                            this.getLogWriter().info((Object)("Got PORT as " + rs.getInt("PORT")));
                        } else {
                            try {
                                rs.getString("ID");
                                GfxdDiagsDUnit.fail((String)"expected unexpected column get to fail");
                            }
                            catch (SQLException ex) {
                                if ("S0022".equals(ex.getSQLState())) break block17;
                                throw ex;
                            }
                        }
                    }
                    try {
                        rs.getObject("VMID");
                        GfxdDiagsDUnit.fail((String)"expected unknown column get to fail");
                    }
                    catch (SQLException ex) {
                        if ("S0022".equals(ex.getSQLState())) break block18;
                        throw ex;
                    }
                }
                try {
                    rs.getTime("ISELDER");
                    GfxdDiagsDUnit.fail((String)"expected type conversion error");
                }
                catch (SQLException ex) {
                    if ("22005".equals(ex.getSQLState())) break block19;
                    throw ex;
                }
            }
            try {
                rs.getInt("KIND");
                GfxdDiagsDUnit.fail((String)"expected type conversion error");
            }
            catch (SQLException ex) {
                if ("22018".equals(ex.getSQLState())) continue;
                throw ex;
            }
        }
        GfxdDiagsDUnit.assertTrue((numServers == 0 && numClients == 0 && numAdmins == 0 ? 1 : 0) != 0);
        GfxdDiagsDUnit.assertFalse((boolean)rs.next());
    }

    public static final class OrObject {
        public final Object o1;
        public final Object o2;

        private OrObject(Object o1, Object o2) {
            this.o1 = o1;
            this.o2 = o2;
        }

        public static OrObject create(Object o1) {
            return o1 != null ? new OrObject(o1, null) : null;
        }

        public static OrObject create(Object o1, Object o2) {
            return o1 != null ? new OrObject(o1, o2) : null;
        }

        public boolean equals(Object o) {
            if (o instanceof OrObject) {
                OrObject obj = this;
                OrObject other = (OrObject)o;
                if (other.o2 == null) {
                    obj = other;
                    other = this;
                }
                if (obj.o2 == null) {
                    return ArrayUtils.objectEquals((Object)obj.o1, (Object)other.o1) || ArrayUtils.objectEquals((Object)obj.o1, (Object)other.o2);
                }
                return ArrayUtils.objectEquals((Object)obj.o1, (Object)other.o1) || ArrayUtils.objectEquals((Object)obj.o2, (Object)other.o2);
            }
            return false;
        }

        public String toString() {
            return this.o2 == null ? String.valueOf(this.o1) : String.valueOf(this.o1) + ',' + String.valueOf(this.o2);
        }
    }
}

