/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TriggerDUnit
extends DistributedSQLTestBase {
    private final String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
    private static List<String> historyEnties;

    public TriggerDUnit(String name) {
        super(name);
    }

    public void testTriggers_actionInsert() throws Exception {
        this.startVMs(1, 1);
        this.startServerVMs(2, 0, "sg1");
        this.startServerVMs(1, 0, "SG2");
        this.clientSQLExecute(1, "create schema dom");
        this.clientSQLExecute(1, "create table dom.flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null)");
        this.clientSQLExecute(1, "create table dom.flights_history(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        this.clientSQLExecute(1, "create table dom.flights_history_two(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        this.clientSQLExecute(1, "create table dom.flights_history_del(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        String triggerStmnt = "CREATE TRIGGER trig1 AFTER UPDATE ON dom.flights REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL INSERT INTO dom.flights_history VALUES (UPDATEDROW.FLIGHT_ID, UPDATEDROW.AIRCRAFT, 'INSERTED FROM trig1')";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig2 AFTER INSERT ON dom.flights REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL INSERT INTO dom.flights_history_two VALUES (NEWROW.FLIGHT_ID, NEWROW.AIRCRAFT, 'INSERTED FROM trig2')";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig3 AFTER DELETE ON dom.flights REFERENCING OLD AS OLDROW FOR EACH ROW MODE DB2SQL INSERT INTO dom.flights_history_del VALUES (OLDROW.FLIGHT_ID, OLDROW.AIRCRAFT, 'INSERTED FROM trig3')";
        this.clientSQLExecute(1, triggerStmnt);
        this.clientSQLExecute(1, "insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        this.clientSQLExecute(1, "update dom.flights set segment_number = 10 where segment_number = 20");
        this.clientSQLExecute(1, "delete from dom.flights");
        String jdbcSQL = "select * from dom.flights_history";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone");
        jdbcSQL = "select * from dom.flights_history_two";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone_2");
        jdbcSQL = "select * from dom.flights_history_del";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone_3");
        this.clientSQLExecute(1, "drop trigger trig1");
        this.clientSQLExecute(1, "drop trigger trig2");
        this.clientSQLExecute(1, "drop trigger trig3");
        this.clientSQLExecute(1, "truncate table dom.flights");
        this.clientSQLExecute(1, "truncate table dom.flights_history");
        this.clientSQLExecute(1, "truncate table dom.flights_history_two");
        this.clientSQLExecute(1, "truncate table dom.flights_history_del");
        this.clientSQLExecute(1, "insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        this.clientSQLExecute(1, "update dom.flights set segment_number = 10 where segment_number = 20");
        this.clientSQLExecute(1, "delete from dom.flights");
        jdbcSQL = "select * from dom.flights_history";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "empty");
        jdbcSQL = "select * from dom.flights_history_two";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "empty");
        jdbcSQL = "select * from dom.flights_history_del";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "empty");
    }

    public void testTriggers_Replicate_actionInsert() throws Exception {
        this.startVMs(1, 1);
        this.startServerVMs(2, 0, "sg1");
        this.startServerVMs(1, 0, "SG2");
        this.clientSQLExecute(1, "create schema dom");
        this.clientSQLExecute(1, "create table dom.flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null) replicate");
        this.clientSQLExecute(1, "create table dom.flights_history(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        this.clientSQLExecute(1, "create table dom.flights_history_two(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        this.clientSQLExecute(1, "create table dom.flights_history_del(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        String triggerStmnt = "CREATE TRIGGER trig1 AFTER UPDATE ON dom.flights REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL INSERT INTO dom.flights_history VALUES (UPDATEDROW.FLIGHT_ID, UPDATEDROW.AIRCRAFT, 'INSERTED FROM trig1')";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig2 AFTER INSERT ON dom.flights REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL INSERT INTO dom.flights_history_two VALUES (NEWROW.FLIGHT_ID, NEWROW.AIRCRAFT, 'INSERTED FROM trig2')";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig3 AFTER DELETE ON dom.flights REFERENCING OLD AS OLDROW FOR EACH ROW MODE DB2SQL INSERT INTO dom.flights_history_del VALUES (OLDROW.FLIGHT_ID, OLDROW.AIRCRAFT, 'INSERTED FROM trig3')";
        this.clientSQLExecute(1, triggerStmnt);
        this.clientSQLExecute(1, "insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        this.clientSQLExecute(1, "update dom.flights set segment_number = 10 where segment_number = 20");
        this.clientSQLExecute(1, "delete from dom.flights");
        String jdbcSQL = "select * from dom.flights_history";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone");
        jdbcSQL = "select * from dom.flights_history_two";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone_2");
        jdbcSQL = "select * from dom.flights_history_del";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone_3");
    }

    public void testTriggers_actionUpdate() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema dom");
        this.clientSQLExecute(1, "create table dom.flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null)");
        this.clientSQLExecute(1, "create table dom.flights_rep(flight_id int not null, segment_number int not null, aircraft varchar(20) not null) replicate");
        this.clientSQLExecute(1, "insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        this.clientSQLExecute(1, "insert into dom.flights_rep values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        this.clientSQLExecute(1, "create table dom.flights_history(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        this.clientSQLExecute(1, "create table dom.flights_history_rep(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        this.clientSQLExecute(1, "insert into dom.flights_history values (4, 'lalta', 'status1'), (3, 'delta', 'status2')");
        this.clientSQLExecute(1, "insert into dom.flights_history_rep values (4, 'lalta', 'status1'), (3, 'delta', 'status2')");
        String triggerStmnt = "CREATE TRIGGER trig1 AFTER UPDATE ON dom.flights REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL update dom.flights_history set status='INSERTED FROM trig1' where 1=1";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig2 AFTER UPDATE ON dom.flights_rep REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL update dom.flights_history_rep set status='INSERTED FROM trig1' where 1=1";
        this.clientSQLExecute(1, triggerStmnt);
        this.clientSQLExecute(1, "update dom.flights set segment_number = 10 where segment_number = 20");
        this.clientSQLExecute(1, "update dom.flights_rep set segment_number = 10 where segment_number = 20");
        String jdbcSQL = "select * from dom.flights_history";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone");
        jdbcSQL = "select * from dom.flights_history_rep";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone");
    }

    public void testTriggers_actionDelete() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema dom");
        this.clientSQLExecute(1, "create table dom.flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null)");
        this.clientSQLExecute(1, "create table dom.flights_rep(flight_id int not null, segment_number int not null, aircraft varchar(20) not null) replicate");
        this.clientSQLExecute(1, "insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        this.clientSQLExecute(1, "insert into dom.flights_rep values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        this.clientSQLExecute(1, "create table dom.flights_history(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null) partition by column(status)");
        this.clientSQLExecute(1, "create table dom.flights_history_rep(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null) replicate");
        this.clientSQLExecute(1, "insert into dom.flights_history values (4, 'lalta', 'status1'), (3, 'delta', 'status2')");
        this.clientSQLExecute(1, "insert into dom.flights_history_rep values (4, 'lalta', 'status1'), (3, 'delta', 'status2')");
        String triggerStmnt = "CREATE TRIGGER trig1 AFTER UPDATE ON dom.flights REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL delete from dom.flights_history where flight_id = 4";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig2 AFTER UPDATE ON dom.flights_rep REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL delete from dom.flights_history_rep where flight_id = 4";
        this.clientSQLExecute(1, triggerStmnt);
        this.clientSQLExecute(1, "update dom.flights set segment_number = 10 where segment_number = 20");
        this.clientSQLExecute(1, "update dom.flights_rep set segment_number = 10 where segment_number = 20");
        String jdbcSQL = "select * from dom.flights_history";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigtwo");
        jdbcSQL = "select * from dom.flights_history_rep";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigtwo");
    }

    public void testTriggers_Replicate_actionInsert_defaultSchema() throws Exception {
        this.startVMs(1, 1);
        this.startServerVMs(2, 0, "sg1");
        this.startServerVMs(1, 0, "SG2");
        this.clientSQLExecute(1, "create schema dom");
        this.clientSQLExecute(1, "create table dom.flights_history(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        this.clientSQLExecute(1, "create table dom.flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null) replicate");
        this.clientSQLExecute(1, "insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        String triggerStmnt = "CREATE TRIGGER trig1 AFTER UPDATE ON dom.flights REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL INSERT INTO dom.flights_history VALUES (UPDATEDROW.FLIGHT_ID, UPDATEDROW.AIRCRAFT, 'INSERTED FROM trig1')";
        this.clientSQLExecute(1, triggerStmnt);
        this.clientSQLExecute(1, "update dom.flights set segment_number = 10 where segment_number = 20");
        String jdbcSQL = "select * from dom.flights_history";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone");
    }

    public void testTriggersTX_actionUpdate() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("create schema dom");
        stmt.execute("create table dom.flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null)");
        stmt.execute("create table dom.flights_rep(flight_id int not null, segment_number int not null, aircraft varchar(20) not null) replicate");
        stmt.execute("insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        stmt.execute("insert into dom.flights_rep values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
        conn.commit();
        stmt.execute("create table dom.flights_history(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        stmt.execute("create table dom.flights_history_rep(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        stmt.execute("insert into dom.flights_history values (4, 'lalta', 'status1'), (3, 'delta', 'status2')");
        stmt.execute("insert into dom.flights_history_rep values (4, 'lalta', 'status1'), (3, 'delta', 'status2')");
        conn.commit();
        String triggerStmnt = "CREATE TRIGGER trig1 AFTER UPDATE ON dom.flights REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL update dom.flights_history set status='INSERTED FROM trig1' where 1=1";
        stmt.execute(triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig2 AFTER UPDATE ON dom.flights_rep REFERENCING OLD AS UPDATEDROW FOR EACH ROW MODE DB2SQL update dom.flights_history_rep set status='INSERTED FROM trig1' where 1=1";
        stmt.execute(triggerStmnt);
        stmt.execute("update dom.flights set segment_number = 10 where segment_number = 20");
        stmt.execute("update dom.flights_rep set segment_number = 10 where segment_number = 20");
        String jdbcSQL = "select * from dom.flights_history";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone");
        jdbcSQL = "select * from dom.flights_history_rep";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigone");
        Connection conn2 = TestUtil.getConnection();
        conn2.setTransactionIsolation(2);
        conn2.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        jdbcSQL = "select * from dom.flights_history";
        stmt2.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt2, false, this.goldenTextFile, "trigone_1");
        jdbcSQL = "select * from dom.flights_history_rep";
        stmt2 = conn2.createStatement();
        stmt2.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt2, false, this.goldenTextFile, "trigone_1");
        conn.commit();
        jdbcSQL = "select * from dom.flights_history";
        stmt2 = conn2.createStatement();
        stmt2.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt2, false, this.goldenTextFile, "trigone");
        stmt.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt, false, this.goldenTextFile, "trigone");
        jdbcSQL = "select * from dom.flights_history_rep";
        stmt2 = conn2.createStatement();
        stmt2.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt2, false, this.goldenTextFile, "trigone");
        stmt = conn.createStatement();
        stmt.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt, false, this.goldenTextFile, "trigone");
        conn2.commit();
        jdbcSQL = "select * from dom.flights_history";
        stmt2 = conn2.createStatement();
        stmt2.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt2, false, this.goldenTextFile, "trigone");
        jdbcSQL = "select * from dom.flights_history_rep";
        stmt2 = conn2.createStatement();
        stmt2.execute(jdbcSQL);
        TestUtil.verifyResults(true, stmt2, false, this.goldenTextFile, "trigone");
    }

    public static void fhmbip() {
        if (historyEnties == null) {
            historyEnties = new ArrayList<String>();
        }
        historyEnties.add("Before insert entry");
    }

    public static void fhmaip() {
        if (historyEnties == null) {
            historyEnties = new ArrayList<String>();
        }
        historyEnties.add("After insert entry");
    }

    public static void fhmbup() {
        if (historyEnties == null) {
            historyEnties = new ArrayList<String>();
        }
        historyEnties.add("Before update entry");
    }

    public static void fhmaup() {
        if (historyEnties == null) {
            historyEnties = new ArrayList<String>();
        }
        historyEnties.add("After update entry");
    }

    public static void fhmbdp() {
        if (historyEnties == null) {
            historyEnties = new ArrayList<String>();
        }
        historyEnties.add("Before delete entry");
    }

    public static void fhmadp() {
        if (historyEnties == null) {
            historyEnties = new ArrayList<String>();
        }
        historyEnties.add("After delete entry");
    }

    public void _testStmntTriggers_WithProcedures() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create procedure flightHistoryMaintainerBeforeInsertProc() LANGUAGE JAVA PARAMETER STYLE JAVA  EXTERNAL NAME 'com.pivotal.gemfirexd.ddl.TriggerDUnit.fhmbip'");
        this.clientSQLExecute(1, "create procedure flightHistoryMaintainerAfterInsertProc() LANGUAGE JAVA PARAMETER STYLE JAVA  EXTERNAL NAME 'com.pivotal.gemfirexd.ddl.TriggerDUnit.fhmaip'");
        this.clientSQLExecute(1, "create procedure flightHistoryMaintainerBeforeUpdateProc() LANGUAGE JAVA PARAMETER STYLE JAVA  EXTERNAL NAME 'com.pivotal.gemfirexd.ddl.TriggerDUnit.fhmbup'");
        this.clientSQLExecute(1, "create procedure flightHistoryMaintainerAfterUpdateProc() LANGUAGE JAVA PARAMETER STYLE JAVA  EXTERNAL NAME 'com.pivotal.gemfirexd.ddl.TriggerDUnit.fhmaup'");
        this.clientSQLExecute(1, "create procedure flightHistoryMaintainerBeforeDeleteProc() LANGUAGE JAVA PARAMETER STYLE JAVA  EXTERNAL NAME 'com.pivotal.gemfirexd.ddl.TriggerDUnit.fhmbdp'");
        this.clientSQLExecute(1, "create procedure flightHistoryMaintainerAfterDeleteProc() LANGUAGE JAVA PARAMETER STYLE JAVA  EXTERNAL NAME 'com.pivotal.gemfirexd.ddl.TriggerDUnit.fhmadp'");
        this.clientSQLExecute(1, "create table dom.flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null)");
        String triggerStmnt = "CREATE TRIGGER AFT_INS AFTER INSERT ON dom.flights FOR EACH STATEMENT MODE DB2SQL call flightHistoryMaintainerAfterInsertProc()";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER AFT_UPD AFTER UPDATE ON dom.flights FOR EACH STATEMENT MODE DB2SQL call flightHistoryMaintainerAfterUpdateProc()";
        this.clientSQLExecute(1, triggerStmnt);
        triggerStmnt = "CREATE TRIGGER AFT_DEL AFTER DELETE ON dom.flights FOR EACH STATEMENT MODE DB2SQL call flightHistoryMaintainerAfterDeleteProc()";
        this.clientSQLExecute(1, triggerStmnt);
        for (int i = 0; i < 2; ++i) {
            this.clientSQLExecute(1, "insert into dom.flights values (1, 10, 'delta'), (2, 10, 'palta'), (3, 20, 'delta'), (4, 20, 'lalta')");
            String jdbcSQL = "select * from dom.flights";
            this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigStmntBeforeUpdate");
            this.clientSQLExecute(1, "update dom.flights set segment_number = 1000");
            jdbcSQL = "select * from dom.flights";
            this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, this.goldenTextFile, "trigStmntAfterUpdate");
            this.clientSQLExecute(1, "delete from dom.flights");
            TriggerDUnit.verifyHistoryEntries();
        }
    }

    public static void verifyHistoryEntries() {
        TriggerDUnit.assertEquals((int)3, (int)historyEnties.size());
        TriggerDUnit.assertEquals((String)"After insert entry", (String)historyEnties.get(0));
        TriggerDUnit.assertEquals((String)"After update entry", (String)historyEnties.get(1));
        TriggerDUnit.assertEquals((String)"After delete entry", (String)historyEnties.get(2));
        historyEnties.clear();
    }
}

