/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Oplog;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTHashSet;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexPersistenceDUnit
extends DistributedSQLTestBase {
    public IndexPersistenceDUnit(String name) {
        super(name);
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
        GemFireStore.setTestNewIndexFlag((boolean)false);
    }

    public static void setSystemProperty(String key, String value) {
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("setting system property: " + key + " to " + value));
        System.setProperty(key, value);
        if (value != null && value.equals("false")) {
            System.clearProperty(key);
        }
    }

    public static void setTestNewIndexFlag() {
        GemFireStore.setTestNewIndexFlag((boolean)true);
    }

    public static void setTestIndexRecreateFlag() {
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public boolean testIndexRecreate() {
                return true;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
    }

    public static void checkIndexRecovery(boolean expected) {
        boolean actual = GemFireStore.getBootedInstance().didIndexRecovery();
        IndexPersistenceDUnit.assertEquals((boolean)expected, (boolean)actual);
    }

    public static void checkProperIndex(String tNamePath, String idxName, int indexSize) {
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("checkProperIndex called with tNamePath: " + tNamePath + ", index name: " + idxName));
        GfxdIndexManager im = (GfxdIndexManager)((LocalRegion)Misc.getRegion((String)tNamePath, (boolean)true, (boolean)false)).getIndexUpdater();
        ConcurrentSkipListMap indexMap = null;
        List indexContainers = im.getIndexContainers();
        for (GemFireContainer c : indexContainers) {
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("indexcontainer name: " + c.getName() + ", qualified table name: " + c.getQualifiedTableName()));
            if (c.getName().toString().contains(idxName)) {
                IndexPersistenceDUnit.getGlobalLogger().info((Object)("indexcontainer name: " + c.getName() + " matched with index name: " + idxName));
                Misc.getCacheLogWriter().info("indexcontainer name: " + c.getName() + " matched with index name: " + idxName);
                indexMap = c.getSkipListMap();
                break;
            }
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("indexcontainer name: " + c.getName() + " did not match with index name: " + idxName));
        }
        IndexPersistenceDUnit.assertNotNull(indexMap);
        Set s = indexMap.entrySet();
        int totCnt = 0;
        for (Map.Entry entry : s) {
            Object val = entry.getValue();
            if (val instanceof RowLocation) {
                ++totCnt;
                continue;
            }
            if (val instanceof RowLocation[]) {
                totCnt += ((RowLocation[])val).length;
                continue;
            }
            if (!(val instanceof ConcurrentTHashSet)) continue;
            totCnt += ((ConcurrentTHashSet)val).size();
        }
        IndexPersistenceDUnit.assertEquals((int)indexSize, (int)totCnt);
    }

    public static void forceCompaction() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache == null) {
            return;
        }
        Collection dsImpls = cache.listDiskStores();
        assert (dsImpls != null && dsImpls.size() > 0);
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("Disk Stores are: " + dsImpls));
        boolean compacted = false;
        for (DiskStoreImpl dsi : dsImpls) {
            if (dsi.getName().equals("GFXD-DD-DISKSTORE")) continue;
            compacted = dsi.forceCompaction();
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("compaction happened=" + compacted + " in some oplogs in disk store: " + dsi.getName()));
        }
    }

    public static void forceRolling() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache == null) {
            return;
        }
        Collection dsImpls = cache.listDiskStores();
        assert (dsImpls != null && dsImpls.size() > 0);
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("Disk Stores are: " + dsImpls));
        for (DiskStoreImpl dsi : dsImpls) {
            if (dsi.getName().equals("GFXD-DD-DISKSTORE")) continue;
            dsi.forceRoll(true);
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("force roll called on disk store: " + dsi.getName()));
        }
    }

    public static void setTestOplogToTestForCompaction() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache == null) {
            return;
        }
        Collection dsImpls = cache.listDiskStores();
        assert (dsImpls != null && dsImpls.size() > 0);
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("Disk Stores are: " + dsImpls));
        for (DiskStoreImpl dsi : dsImpls) {
            if (dsi.getName().equals("GFXD-DD-DISKSTORE")) continue;
            Oplog currOplog = dsi.getPersistentOplogSet(null).getChild();
            dsi.TEST_oplogCompact(currOplog);
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("force roll called on disk store: " + dsi.getName()));
        }
    }

    public static void unsetTestOplogToTestForCompaction() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache == null) {
            return;
        }
        Collection dsImpls = cache.listDiskStores();
        assert (dsImpls != null && dsImpls.size() > 0);
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("Disk Stores are: " + dsImpls));
        for (DiskStoreImpl dsi : dsImpls) {
            if (dsi.getName().equals("GFXD-DD-DISKSTORE")) continue;
            dsi.TEST_oplogCompact(null);
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("force roll called on disk store: " + dsi.getName()));
        }
    }

    public static Boolean testOplogCompacted() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache == null) {
            return Boolean.TRUE;
        }
        Collection dsImpls = cache.listDiskStores();
        assert (dsImpls != null && dsImpls.size() > 0);
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("testOplogCompacted::Disk Stores are: " + dsImpls));
        for (DiskStoreImpl dsi : dsImpls) {
            if (dsi.getName().equals("GFXD-DD-DISKSTORE")) continue;
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("testOplogCompacted::is test oplog compacted called on: " + dsi.getName()));
            return dsi.isTestOplogCompacted();
        }
        return false;
    }

    public static void runConstraintTest() throws Exception {
        int i;
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null unique, c3 int not null unique) replicate persistent";
        String ddl_dependent = "create table TMP.T2(c1 int not null primary key, c2 varchar(20) not null, c3 int not null, constraint pk_fk foreign key (c1) references TMP.T1 (c1), constraint uk_fk foreign key (c3) references TMP.T1 (c3)) replicate persistent";
        String ddlToExec = ddl;
        String ddl2ToExec = ddl_dependent;
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create schema TMP");
        stmt.execute(ddlToExec);
        stmt.execute(ddl2ToExec);
        PreparedStatement ps1 = conn.prepareStatement("insert into TMP.T1 values (?, ?, ?)");
        for (i = 0; i < 10; ++i) {
            ps1.setInt(1, i);
            ps1.setString(2, "str-" + i);
            ps1.setInt(3, i * 10);
        }
        ps1 = conn.prepareStatement("insert into TMP.T2 values (?, ?, ?)");
        for (i = 0; i < 10; ++i) {
            ps1.setInt(1, i);
            ps1.setString(2, "str-" + i);
            ps1.setInt(3, i * 10);
        }
    }

    public static void addAlterTableForC2() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("alter table TMP.T2 add constraint cust_fk foreign key (c2) references TMP.T1 (c2)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testConstraintIndexes() throws Exception {
        block3: {
            Statement stmt = null;
            boolean success = false;
            try {
                IndexPersistenceDUnit.deleteAllOplogFiles();
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "true"});
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"TracePersistIndex", "true"});
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"TracePersistIndexFinest", "true"});
                this.startVMs(1, 3);
                VM vm3 = (VM)this.serverVMs.get(1);
                vm3.invoke(IndexPersistenceDUnit.class, "runConstraintTest");
                this.stopVMNum(-3);
                VM vm4 = (VM)this.serverVMs.get(2);
                vm4.invoke(IndexPersistenceDUnit.class, "setTestNewIndexFlag");
                this.restartServerVMNums(new int[]{3}, 0, null, null);
                vm4.invoke(IndexPersistenceDUnit.class, "setTestNewIndexFlag", new Object[]{Boolean.FALSE, "/TMP/T2"});
                stmt = TestUtil.getConnection().createStatement();
                this.stopVMNum(-3);
                vm3.invoke(IndexPersistenceDUnit.class, "addAlterTableForC2");
                vm4 = (VM)this.serverVMs.get(2);
                vm4.invoke(IndexPersistenceDUnit.class, "setTestNewIndexFlag");
                this.restartServerVMNums(new int[]{3}, 0, null, null);
                vm4.invoke(IndexPersistenceDUnit.class, "setTestNewIndexFlag", new Object[]{Boolean.TRUE, "/TMP/T2"});
                stmt.execute("drop table TMP.T2");
                stmt.execute("drop table TMP.T1");
                success = true;
                IndexPersistenceDUnit.deleteAllOplogFiles();
                if (!success) break block3;
            }
            catch (Throwable throwable) {
                if (success) {
                    stmt.execute("drop schema TMP RESTRICT");
                }
                IndexPersistenceDUnit.deleteAllOplogFiles();
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"TracePersistIndex", "false"});
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"TracePersistIndexFinest", "false"});
                this.stopAllVMs();
                throw throwable;
            }
            stmt.execute("drop schema TMP RESTRICT");
        }
        IndexPersistenceDUnit.deleteAllOplogFiles();
        IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
        IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"TracePersistIndex", "false"});
        IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{"TracePersistIndexFinest", "false"});
        this.stopAllVMs();
    }

    public static void setTestNewIndexFlag(Boolean expected, String regionPath) {
        LocalRegion r = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)false, (boolean)false);
        GfxdIndexManager sqlim = (GfxdIndexManager)r.getIndexUpdater();
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("setTestNewIndexFlag called with args " + expected + " and " + regionPath + " and indexupdater = " + sqlim + " test flag: " + DiskStoreImpl.TEST_NEW_CONTAINER));
        List list = sqlim.getAllIndexes();
        IndexPersistenceDUnit.getGlobalLogger().info((Object)("list of index containers are: " + Arrays.toString(list.toArray())));
        if (expected.booleanValue()) {
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("new index list is: " + r.getDiskStore().TEST_NEW_CONTAINER_LIST));
            IndexPersistenceDUnit.assertNotNull((Object)r.getDiskStore().TEST_NEW_CONTAINER_LIST);
        } else {
            IndexPersistenceDUnit.assertNull((Object)r.getDiskStore().TEST_NEW_CONTAINER_LIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testNewIndexCreatedElseWhereWhenAMemberDown() throws Exception {
        block8: {
            Statement stmt = null;
            boolean success = false;
            try {
                IndexPersistenceDUnit.deleteAllOplogFiles();
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "true"});
                String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null)";
                File file1 = new File(IndexPersistenceDUnit.getClassName());
                file1.mkdirs();
                this.startVMs(1, 3);
                Connection conn = TestUtil.getConnection();
                stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                stmt.execute("create diskstore teststore ('" + file1.getPath() + "')");
                for (int j = 0; j < 2; ++j) {
                    String ddlToExec = ddl;
                    ddlToExec = j == 1 ? ddlToExec + " replicate persistent 'teststore'" : ddlToExec + " partition by list(c1) (values(1, 2, 3, 4, 5, 6, 7, 8)) redundancy 2 persistent 'teststore'";
                    stmt.execute(ddlToExec);
                    stmt.execute("create index TMP.IDX2 on TMP.T1(c2, c3)");
                    stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                    stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                    stmt.execute("insert into TMP.T1 values(5, 'one', 1), (6, 'two', 2), (7, 'three', 3), (8, 'four', 3)");
                    stmt.execute("select * from TMP.T1 where c3 = 3");
                    this.stopVMNum(-3);
                    stmt.execute("create index TMP.NEW_INDEX on TMP.T1(c2)");
                    this.restartServerVMNums(new int[]{3}, 0, null, null);
                    VM vm4 = (VM)this.serverVMs.get(2);
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "NEW_INDEX", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX2", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX1", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkIndexRecovery", new Object[]{true});
                    this.stopVMNum(-3);
                    this.restartServerVMNums(new int[]{3}, 0, null, null);
                    vm4 = (VM)this.serverVMs.get(2);
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "NEW_INDEX", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX2", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX1", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkIndexRecovery", new Object[]{true});
                    stmt.execute("drop table TMP.T1");
                    success = true;
                    IndexPersistenceDUnit.deleteAllOplogFiles();
                }
                if (!success) break block8;
            }
            catch (RuntimeException t) {
                block9: {
                    this.getLogWriter().info((Object)"got run time exception", (Throwable)t);
                    IndexPersistenceDUnit.fail("no exception expected", t);
                    if (!success) break block9;
                    stmt.execute("drop schema TMP RESTRICT");
                }
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
                this.stopAllVMs();
            }
            catch (Throwable t3) {
                block10: {
                    this.getLogWriter().info((Object)"got exception", t3);
                    IndexPersistenceDUnit.fail("no exception expected", t3);
                    if (!success) break block10;
                    {
                        catch (Throwable throwable) {
                            if (success) {
                                stmt.execute("drop schema TMP RESTRICT");
                            }
                            IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
                            this.stopAllVMs();
                            throw throwable;
                        }
                    }
                    stmt.execute("drop schema TMP RESTRICT");
                }
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
                this.stopAllVMs();
            }
            stmt.execute("drop schema TMP RESTRICT");
        }
        IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
        this.stopAllVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testIndexRe_Creation() throws Exception {
        block8: {
            Statement stmt = null;
            boolean success = false;
            try {
                IndexPersistenceDUnit.deleteAllOplogFiles();
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "true"});
                String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null)";
                File file1 = new File(IndexPersistenceDUnit.getClassName());
                file1.mkdirs();
                this.startVMs(1, 3);
                Connection conn = TestUtil.getConnection();
                stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                stmt.execute("create diskstore teststore_two ('" + file1.getPath() + "')");
                for (int j = 0; j < 2; ++j) {
                    String ddlToExec = ddl;
                    ddlToExec = j == 1 ? ddlToExec + " replicate persistent 'teststore_two'" : ddlToExec + " partition by list(c1) (values(1, 2, 3, 4, 5, 6, 7, 8)) redundancy 2 persistent 'teststore_two'";
                    stmt.execute(ddlToExec);
                    stmt.execute("create index TMP.IDX2 on TMP.T1(c2, c3)");
                    stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                    stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                    stmt.execute("insert into TMP.T1 values(5, 'one', 1), (6, 'two', 2), (7, 'three', 3), (8, 'four', 3)");
                    stmt.execute("select * from TMP.T1 where c3 = 3");
                    this.stopVMNum(-3);
                    stmt.execute("create index TMP.NEW_INDEX on TMP.T1(c2)");
                    VM vm4 = (VM)this.serverVMs.get(2);
                    vm4.invoke(IndexPersistenceDUnit.class, "setTestIndexRecreateFlag");
                    this.restartServerVMNums(new int[]{3}, 0, null, null);
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "NEW_INDEX", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX2", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX1", 8});
                    vm4.invoke(IndexPersistenceDUnit.class, "checkIndexRecovery", new Object[]{true});
                    stmt.execute("drop table TMP.T1");
                    success = true;
                    IndexPersistenceDUnit.deleteAllOplogFiles();
                }
                if (!success) break block8;
            }
            catch (RuntimeException t) {
                block9: {
                    this.getLogWriter().info((Object)"got run time exception", (Throwable)t);
                    IndexPersistenceDUnit.fail("no exception expected", t);
                    if (!success) break block9;
                    stmt.execute("drop schema TMP RESTRICT");
                }
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
                this.stopAllVMs();
            }
            catch (Throwable t3) {
                block10: {
                    this.getLogWriter().info((Object)"got exception", t3);
                    IndexPersistenceDUnit.fail("no exception expected", t3);
                    if (!success) break block10;
                    {
                        catch (Throwable throwable) {
                            if (success) {
                                stmt.execute("drop schema TMP RESTRICT");
                            }
                            IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
                            this.stopAllVMs();
                            throw throwable;
                        }
                    }
                    stmt.execute("drop schema TMP RESTRICT");
                }
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
                this.stopAllVMs();
            }
            stmt.execute("drop schema TMP RESTRICT");
        }
        IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
        this.stopAllVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testCompaction() throws Exception {
        try {
            IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "true"});
            String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null)";
            this.startVMs(1, 3);
            Connection conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute("create schema TMP");
            for (int j = 0; j < 2; ++j) {
                String ddlToExec = ddl;
                ddlToExec = j == 1 ? ddlToExec + " replicate persistent" : ddlToExec + " partition by list(c1) (values(1, 2, 3, 4, 5, 6, 7, 8)) redundancy 2 persistent";
                stmt.execute(ddlToExec);
                stmt.execute("create index TMP.IDX2 on TMP.T1(c2, c3)");
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                stmt.execute("insert into TMP.T1 values(5, 'one', 1), (6, 'two', 2), (7, 'three', 3), (8, 'four', 3)");
                stmt.execute("select * from TMP.T1 where c3 = 3");
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setTestOplogToTestForCompaction");
                stmt.execute("delete from TMP.T1");
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"forceRolling");
                IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"forceCompaction");
                IndexPersistenceDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                    public boolean done() {
                        VM serverVM;
                        while (!(Boolean.TRUE.equals((serverVM = IndexPersistenceDUnit.this.getServerVM(1)).invoke(IndexPersistenceDUnit.class, "testOplogCompacted")) && Boolean.TRUE.equals((serverVM = IndexPersistenceDUnit.this.getServerVM(2)).invoke(IndexPersistenceDUnit.class, "testOplogCompacted")) && Boolean.TRUE.equals((serverVM = IndexPersistenceDUnit.this.getServerVM(3)).invoke(IndexPersistenceDUnit.class, "testOplogCompacted")))) {
                        }
                        return Boolean.TRUE;
                    }

                    public String description() {
                        return "waiting for GII to start";
                    }
                }, (long)30000L, (long)500L, (boolean)true);
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                stmt.execute("insert into TMP.T1 values(5, 'one', 1), (6, 'two', 2), (7, 'three', 3), (8, 'four', 3)");
                this.stopVMNum(-3);
                stmt.execute("create index TMP.NEW_INDEX on TMP.T1(c2)");
                this.restartServerVMNums(new int[]{3}, 0, null, null);
                VM vm4 = (VM)this.serverVMs.get(2);
                vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "NEW_INDEX", 8});
                vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX2", 8});
                vm4.invoke(IndexPersistenceDUnit.class, "checkProperIndex", new Object[]{"/TMP/T1", "IDX1", 8});
                stmt.execute("drop table TMP.T1");
            }
        }
        catch (Throwable throwable) {
            IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
            IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"unsetTestOplogToTestForCompaction");
            this.stopAllVMs();
            throw throwable;
        }
        IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"setSystemProperty", (Object[])new Object[]{GfxdConstants.GFXD_PERSIST_INDEXES, "false"});
        IndexPersistenceDUnit.invokeInEveryVM(IndexPersistenceDUnit.class, (String)"unsetTestOplogToTestForCompaction");
        this.stopAllVMs();
    }

    public static void deleteAllOplogFiles() throws IOException {
        try {
            File[] newFiles;
            File newDir;
            File currDir = new File(".");
            File[] files = currDir.listFiles();
            IndexPersistenceDUnit.getGlobalLogger().info((Object)("current dir is: " + currDir.getCanonicalPath()));
            for (File f : files) {
                if (f.getAbsolutePath().contains("BACKUPGFXD-DEFAULT-DISKSTORE")) {
                    IndexPersistenceDUnit.getGlobalLogger().info((Object)("deleting file: " + f + " from dir: " + currDir));
                    f.delete();
                }
                if (!f.isDirectory()) continue;
                newDir = new File(f.getCanonicalPath());
                for (File nf : newFiles = newDir.listFiles()) {
                    if (!nf.getAbsolutePath().contains("BACKUPGFXD-DEFAULT-DISKSTORE")) continue;
                    IndexPersistenceDUnit.getGlobalLogger().info((Object)("deleting file: " + nf + " from dir: " + newDir));
                    nf.delete();
                }
            }
            for (File f : files) {
                if (f.getAbsolutePath().contains("GFXD-DD-DISKSTORE")) {
                    IndexPersistenceDUnit.getGlobalLogger().info((Object)("deleting file: " + f + " from dir: " + currDir));
                    f.delete();
                }
                if (!f.isDirectory()) continue;
                newDir = new File(f.getCanonicalPath());
                for (File nf : newFiles = newDir.listFiles()) {
                    if (!nf.getAbsolutePath().contains("GFXD-DD-DISKSTORE")) continue;
                    IndexPersistenceDUnit.getGlobalLogger().info((Object)("deleting file: " + nf + " from dir: " + newDir));
                    nf.delete();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

