/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class GlobalHashIndexDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 3615764749940350805L;

    public GlobalHashIndexDUnit(String name) {
        super(name);
    }

    public void testGlobalHashIndexCreate() throws Exception {
        this.startVMs(1, 2);
        String schemaName = GlobalHashIndexDUnit.getCurrentDefaultSchemaName();
        this.clientSQLExecute(1, "create table " + schemaName + ".ORDERS (ID int primary key, VOL int NOT NULL unique, " + "SECURITY_ID varchar(10)) partition by Primary Key redundancy 1");
        for (int i = 0; i < 100; ++i) {
            String statement = "insert into ORDERS values (" + i + "," + i + ",'char" + i + "')";
            this.clientSQLExecute(1, statement);
        }
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('" + schemaName + "','ORDERS')", null, "1");
        String updateQuery = "update " + schemaName + ".ORDERS set vol=vol+101";
        TestUtil.setupConnection();
        EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
        es.execute();
        this.sqlExecuteVerify(null, new int[]{1, 2}, "VALUES SYSCS_UTIL.CHECK_TABLE('" + schemaName + "','ORDERS')", null, "1");
    }

    public void testGlobalHashIndexDuplicateWithMultiColumns() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create table ORDERS (ID int primary key, VOL int NOT NULL, NAME varchar(10) NOT NULL, SECURITY_ID varchar(10), UNIQUE (VOL, NAME))");
        this.clientSQLExecute(1, "insert into ORDERS values (1, 2, 'GEMSTONE', 'GEMSTONE')");
        this.clientSQLExecute(1, "insert into ORDERS values (2, 2, 'GEMSTONE1', 'GEMSTONE')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug39692() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table APP.SECURITIES (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int,constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))");
        this.clientSQLExecute(1, "create table APP.CUSTOMERS (cid int not null, cust_name varchar(100),since date, addr varchar(100), tid int, primary key (cid))");
        this.clientSQLExecute(1, "create table APP.BUYORDERS (oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal(30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references app.customers (cid) on delete RESTRICT, constraint bo_sec_fk foreign key (sid) references app.securities (sec_id), constraint bo_qty_ck check (qty>=0))");
        this.clientSQLExecute(1, "insert into APP.SECURITIES VALUES(1, 'abc', 12.23, 'nasdaq', 20)");
        this.clientSQLExecute(1, "insert into APP.SECURITIES VALUES(2, 'bbc', 13.23, 'nye', 30)");
        this.clientSQLExecute(1, "insert into APP.SECURITIES VALUES(3, 'cbc', 14.23, 'amex', 40)");
        this.clientSQLExecute(1, "insert into APP.SECURITIES VALUES(4, 'dbc', 15.23, 'lse', 50)");
        this.clientSQLExecute(1, "insert into APP.SECURITIES VALUES(5, 'ebc', 16.23, 'fse', 60)");
        this.clientSQLExecute(1, "insert into APP.CUSTOMERS VALUES(6, 'andy', '2008-11-03','gemstone AVE',70)");
        this.clientSQLExecute(1, "insert into APP.CUSTOMERS VALUES(7, 'andy', '2008-11-03','gemstone AVE',80)");
        this.clientSQLExecute(1, "insert into APP.CUSTOMERS VALUES(8, 'andy', '2008-11-03','gemstone AVE',90)");
        this.clientSQLExecute(1, "insert into APP.CUSTOMERS VALUES(9, 'andy', '2008-11-03','gemstone AVE',100)");
        this.clientSQLExecute(1, "insert into APP.CUSTOMERS VALUES(10, 'andy', '2008-11-03','gemstone AVE',110)");
        this.clientSQLExecute(1, "insert into APP.CUSTOMERS VALUES(11, 'andy', '2008-11-03','gemstone AVE',120)");
        this.clientSQLExecute(1, "insert into APP.CUSTOMERS VALUES(12, 'andy', '2008-11-03','gemstone AVE',130)");
        this.clientSQLExecute(1, "insert into APP.BUYORDERS VALUES(13, 6, 1,100,12.34,'2008-11-03 12:34:56','F',10)");
        this.clientSQLExecute(1, "insert into APP.BUYORDERS VALUES(14, 7, 2,100,12.34,'2008-11-03 12:34:56','F',10)");
        this.clientSQLExecute(1, "insert into APP.BUYORDERS VALUES(15, 8, 3,100,12.34,'2008-11-03 12:34:56','F',10)");
        this.clientSQLExecute(1, "insert into APP.BUYORDERS VALUES(16, 9, 4,100,12.34,'2008-11-03 12:34:56','F',10)");
        this.clientSQLExecute(1, "insert into APP.BUYORDERS VALUES(17, 10, 5,100,12.34,'2008-11-03 12:34:56','F',10)");
        this.clientSQLExecute(1, "insert into APP.BUYORDERS VALUES(18, 11, 1,100,12.34,'2008-11-03 12:34:56','F',10)");
        this.clientSQLExecute(1, "insert into APP.BUYORDERS VALUES(19, 12, 2,100,12.34,'2008-11-03 12:34:56','F',10)");
        this.addExpectedException(new int[]{1}, new int[]{1}, new Object[]{ReplyException.class, SQLException.class, FunctionException.class});
        try {
            this.clientSQLExecute(1, "UPDATE APP.BUYORDERS SET sid = 0 where cid =6 and sid=1 ");
        }
        catch (SQLException ex) {
            block4: {
                try {
                    if ("23503".equals(ex.getSQLState())) break block4;
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{ReplyException.class, SQLException.class, FunctionException.class});
                    throw throwable;
                }
            }
            this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{ReplyException.class, SQLException.class, FunctionException.class});
        }
        this.removeExpectedException(new int[]{1}, new int[]{1}, new Object[]{ReplyException.class, SQLException.class, FunctionException.class});
    }

    public void testBug_40826() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid),constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))");
        this.clientSQLExecute(1, "INSERT INTO TRADE.PORTFOLIO VALUES(2, 3, 10, 10, 1.0, 1)");
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("update trade.portfolio set subTotal=(?*qty) where cid=? and sid=? and tid=?");
        ps.setBigDecimal(1, new BigDecimal(1.1));
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        ps.setInt(4, 4);
        ps.execute();
        conn.close();
    }

    public void testGlobalUniqueIndexWithRedundancy() throws Exception {
        this.startVMs(1, 2);
        String schemaName = GlobalHashIndexDUnit.getCurrentDefaultSchemaName();
        this.clientSQLExecute(1, "create table " + schemaName + ".ORDERS (ID int primary key, VOL int NOT NULL unique, " + "SECURITY_ID varchar(10)) partition by Primary Key redundancy 1");
        this.clientSQLExecute(1, "INSERT INTO " + schemaName + ".ORDERS VALUES(2, 3, 'ABC')");
        this.clientSQLExecute(1, "create global hash index i1 on " + schemaName + ".orders(VOL)");
    }
}

