/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.internal.cache.control.OffHeapMemoryMonitor;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import io.snappydata.test.dunit.VM;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class GfxdOffHeapLRUDUnit
extends DistributedSQLTestBase {
    public GfxdOffHeapLRUDUnit(String name) {
        super(name);
    }

    public void _testPRLRUOffHeapPercDestroy() throws Exception {
        Properties extra = new Properties();
        extra.put("gemfire.off-heap-memory-size", "500m");
        this.startVMs(1, 1, 0, null, extra);
        this.clientSQLExecute(1, "create table trade.bigcustomers (cid int not null, cust_addr clob) offheap EVICTION BY LRUHEAPPERCENT EVICTACTION destroy");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_critical_offheap_percentage_sg(?, ?)");
        cs.setInt(1, 90);
        cs.setNull(2, 12);
        cs.execute();
        cs = conn.prepareCall("call sys.set_eviction_offheap_percentage_sg(?, ?)");
        cs.setInt(1, 25);
        cs.setNull(2, 12);
        cs.execute();
        float evictionOffHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionOffHeapPercentage();
        GfxdOffHeapLRUDUnit.assertEquals((Object)Float.valueOf(25.0f), (Object)Float.valueOf(evictionOffHeapPercentage));
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdOffHeapLRUDUnit.class, "assertOffHeapPercentage", new Object[]{Float.valueOf(evictionOffHeapPercentage)});
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?)");
        this.insertNBigElements2(200, ps, 0);
        Statement s = conn.createStatement();
        Thread.sleep(10000L);
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdOffHeapLRUDUnit.assertTrue((cnt < 200 ? 1 : 0) != 0);
    }

    public void testPRLRUOffHeapPercDestroy_1() throws Exception {
        Properties extra = new Properties();
        extra.put("gemfire.off-heap-memory-size", "500m");
        this.startVMs(1, 1, 0, null, extra);
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000)) offheap EVICTION BY LRUHEAPPERCENT EVICTACTION destroy");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_eviction_offheap_percentage(?)");
        cs.setInt(1, 25);
        cs.execute();
        float evictionOffHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionOffHeapPercentage();
        GfxdOffHeapLRUDUnit.assertEquals((Object)Float.valueOf(25.0f), (Object)Float.valueOf(evictionOffHeapPercentage));
        TestUtil.getLogger().info((Object)("evictionOffHeapPercentage: " + evictionOffHeapPercentage));
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(1000, ps, 0);
        Statement s = conn.createStatement();
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdOffHeapLRUDUnit.class, "raiseFakeOffHeapEvictorOnEvent");
        this.insertNBigElements(1000, ps, 1000);
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdOffHeapLRUDUnit.assertTrue((cnt < 2000 ? 1 : 0) != 0);
    }

    public void testPRLRUOffHeapPercOverflow() throws Exception {
        Properties extra = new Properties();
        extra.put("gemfire.off-heap-memory-size", "500m");
        this.startVMs(1, 1, 0, null, extra);
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))  offheap EVICTION BY LRUHEAPPERCENT EVICTACTION overflow synchronous");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_eviction_offheap_percentage(?)");
        cs.setInt(1, 25);
        cs.execute();
        float evictionOffHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionOffHeapPercentage();
        GfxdOffHeapLRUDUnit.assertEquals((Object)Float.valueOf(25.0f), (Object)Float.valueOf(evictionOffHeapPercentage));
        TestUtil.getLogger().info((Object)("evictionOffHeapPercentage: " + evictionOffHeapPercentage));
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(1000, ps, 0);
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdOffHeapLRUDUnit.class, "raiseFakeOffHeapEvictorOnEvent");
        Statement s = conn.createStatement();
        this.insertNBigElements(1000, ps, 1000);
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdOffHeapLRUDUnit.assertEquals((String)("expected 2000 elements but found " + cnt), (int)2000, (int)cnt);
    }

    public void testReplicatedRegionLRUOffHeapPercOverflow() throws Exception {
        Properties extra = new Properties();
        extra.put("gemfire.off-heap-memory-size", "500m");
        this.startVMs(1, 1, 0, null, extra);
        this.clientSQLExecute(1, " create diskstore teststore 'temp' ");
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))  replicate offheap EVICTION BY LRUHEAPPERCENT EVICTACTION overflow synchronous 'teststore' ");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_eviction_offheap_percentage(?)");
        cs.setInt(1, 25);
        cs.execute();
        float evictionOffHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionOffHeapPercentage();
        GfxdOffHeapLRUDUnit.assertEquals((Object)Float.valueOf(25.0f), (Object)Float.valueOf(evictionOffHeapPercentage));
        TestUtil.getLogger().info((Object)("evictionOffHeapPercentage: " + evictionOffHeapPercentage));
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(1000, ps, 0);
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdOffHeapLRUDUnit.class, "raiseFakeOffHeapEvictorOnEvent");
        Statement s = conn.createStatement();
        this.insertNBigElements(1000, ps, 1000);
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdOffHeapLRUDUnit.assertEquals((String)("expected 2000 elements but found " + cnt), (int)2000, (int)cnt);
    }

    private void insertNBigElements(int n, PreparedStatement ps, int baseCnt) throws SQLException {
        int i;
        String dummyPrefix = "";
        for (i = 0; i < 100; ++i) {
            dummyPrefix = dummyPrefix + "jjjjjjjjjj";
        }
        for (i = baseCnt; i < n + baseCnt; ++i) {
            String name = dummyPrefix + "_name" + i;
            String addr = dummyPrefix + "_addr" + (i + baseCnt);
            String addr2 = dummyPrefix + "_addr2" + (i + baseCnt);
            ps.setInt(1, i + baseCnt);
            ps.setString(2, name);
            ps.setString(3, addr);
            ps.setString(4, addr2);
            ps.executeUpdate();
        }
    }

    private void insertNBigElements2(int n, PreparedStatement ps, int baseCnt) throws SQLException {
        int i;
        StringBuilder sb = new StringBuilder(1000000);
        for (i = 0; i < 100000; ++i) {
            sb.append("jjjjjjjjjj");
        }
        for (i = baseCnt; i < n + baseCnt; ++i) {
            String addr = sb.toString() + "_addr" + (i + baseCnt);
            ps.setInt(1, i + baseCnt);
            ps.setString(2, addr);
            ps.executeUpdate();
        }
    }

    public static void assertOffHeapPercentage(Float perc) {
        float evictionOffHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionOffHeapPercentage();
        GfxdOffHeapLRUDUnit.assertEquals((Object)Float.valueOf(perc.floatValue()), (Object)Float.valueOf(evictionOffHeapPercentage));
    }

    public static void raiseFakeOffHeapEvictorOnEvent() {
        Misc.getGemFireCache().getOffHeapEvictor().testAbortAfterLoopCount = 1;
        Misc.getGemFireCache().getResourceManager().setEvictionOffHeapPercentage(85.0f);
        OffHeapMemoryMonitor ohmm = Misc.getGemFireCache().getResourceManager().getOffHeapMonitor();
        ohmm.stopMonitoring();
        ohmm.updateStateAndSendEvent(0x1C1FFFFFL);
    }
}

