/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.TreeSet;

public class GfxdLoaderDUnit
extends DistributedSQLTestBase {
    public GfxdLoaderDUnit(String name) {
        super(name);
    }

    public void testLoaderWhenPkIsNotPartition() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION By Column(SECONDID)");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdTestRowLoader", null);
        this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get1");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get2");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get3");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        CacheLoader ldr = rattr.getCacheLoader();
        GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
        GfxdLoaderDUnit.assertNull((Object)gfxdldr);
        GfxdLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)regtwo.size(), (int)3);
    }

    public void testLoaderWhenPkIsNotPartition_multipleConcGets() throws Exception {
        this.startVMs(2, 2);
        this.clientSQLExecute(1, "create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION By Column(SECONDID)");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdTestRowLoader", null);
        this.doConcurrently();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        GfxdLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)3, (int)regtwo.size());
    }

    public void testLoaderWhenPkIsPartition() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdTestRowLoader", null);
        this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get1");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get2");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get3");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        CacheLoader ldr = rattr.getCacheLoader();
        GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
        GfxdLoaderDUnit.assertNull((Object)gfxdldr);
        GfxdLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)regtwo.size(), (int)3);
    }

    public void testLoaderWhenPkIsPartition_multipleConcGets() throws Exception {
        this.startVMs(2, 2);
        this.clientSQLExecute(1, "create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION By Column(ID)");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdTestRowLoader", null);
        this.doConcurrently();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        CacheLoader ldr = rattr.getCacheLoader();
        GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
        GfxdLoaderDUnit.assertNull((Object)gfxdldr);
        GfxdLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)3, (int)regtwo.size());
    }

    private void doConcurrently() {
        Runnable task1 = new Runnable(){

            @Override
            public void run() {
                try {
                    GfxdLoaderDUnit.this.sqlExecuteVerify(null, new int[]{1, 2}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get1");
                    GfxdLoaderDUnit.this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get2");
                    GfxdLoaderDUnit.this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get3");
                    GfxdLoaderDUnit.this.sqlExecuteVerify(null, new int[]{1, 2}, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get");
                }
                catch (Exception ex) {
                    DistributedSQLTestBase.fail("failed while doing concurrent verification", ex);
                }
            }
        };
        Runnable task2 = new Runnable(){

            @Override
            public void run() {
                try {
                    GfxdLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get1");
                    GfxdLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get2");
                    GfxdLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get3");
                    GfxdLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "loader_get");
                }
                catch (Exception ex) {
                    DistributedSQLTestBase.fail("failed while doing concurrent verification", ex);
                }
            }
        };
        Thread td1 = new Thread(task1);
        Thread td2 = new Thread(task2);
        td1.start();
        td2.start();
        try {
            td1.join(10000L);
            td2.join(10000L);
        }
        catch (InterruptedException ex) {
            GfxdLoaderDUnit.fail((String)"failed while waiting to join");
        }
    }

    public void testTransactionalBehaviourOfCacheLoaderOnReplicate_Bug42914() throws Exception {
        this.runTransactionalBehaviourOfCacheLoader_Bug42914(true);
    }

    public void testTransactionalBehaviourOfCacheLoaderOnPartitionedTable_Bug42914() throws Exception {
        this.runTransactionalBehaviourOfCacheLoader_Bug42914(false);
    }

    private void runTransactionalBehaviourOfCacheLoader_Bug42914(boolean isReplicated) throws Exception {
        int i;
        ResultSet rs;
        int i2;
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        String suffix = isReplicated ? "replicate" : "redundancy 1";
        String createTable = "create table EMP.TESTTABLE (ID int primary key, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), ID1 int) " + suffix;
        this.clientSQLExecute(1, createTable);
        GfxdCallbacksTest.addLoader("EMP", "TESTTABLE", "com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase$GfxdTestRowLoader", "");
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        String query = "select * from emp.testtable where ID = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        Statement stmt = conn.createStatement();
        for (i2 = 0; i2 < 20; ++i2) {
            ps.setInt(1, i2);
            rs = ps.executeQuery();
            rs.next();
            GfxdLoaderDUnit.assertEquals((int)rs.getInt(1), (int)i2);
            GfxdLoaderDUnit.assertFalse((boolean)rs.next());
        }
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select count(*) from emp.testtable", null, "0");
        conn.rollback();
        rs = stmt.executeQuery("select * from emp.testtable");
        GfxdLoaderDUnit.assertFalse((boolean)rs.next());
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select count(*) from emp.testtable", null, "0");
        for (i2 = 0; i2 < 20; ++i2) {
            ps.setInt(1, i2);
            rs = ps.executeQuery();
            rs.next();
            GfxdLoaderDUnit.assertEquals((int)rs.getInt(1), (int)i2);
            GfxdLoaderDUnit.assertFalse((boolean)rs.next());
        }
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select count(*) from emp.testtable", null, "0");
        rs = stmt.executeQuery("select count(*) from emp.testtable");
        GfxdLoaderDUnit.assertTrue((boolean)rs.next());
        GfxdLoaderDUnit.assertEquals((int)20, (int)rs.getInt(1));
        GfxdLoaderDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        conn.close();
        conn = TestUtil.getConnection();
        stmt = conn.createStatement();
        ps = conn.prepareStatement(query);
        rs = stmt.executeQuery("select id from emp.testtable");
        TreeSet<Integer> ids = new TreeSet<Integer>();
        for (i = 0; i < 20; ++i) {
            GfxdLoaderDUnit.assertTrue((String)("failed next for i=" + i), (boolean)rs.next());
            ids.add(rs.getInt(1));
        }
        GfxdLoaderDUnit.assertFalse((boolean)rs.next());
        GfxdLoaderDUnit.assertEquals((int)20, (int)ids.size());
        GfxdLoaderDUnit.assertEquals((int)0, (int)((Integer)ids.first()));
        GfxdLoaderDUnit.assertEquals((int)19, (int)((Integer)ids.last()));
        for (i = 0; i < 20; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            GfxdLoaderDUnit.assertTrue((boolean)rs.next());
            GfxdLoaderDUnit.assertEquals((int)i, (int)rs.getInt(1));
            GfxdLoaderDUnit.assertFalse((boolean)rs.next());
        }
        rs = stmt.executeQuery("select count(*) from emp.testtable");
        GfxdLoaderDUnit.assertTrue((boolean)rs.next());
        GfxdLoaderDUnit.assertEquals((int)20, (int)rs.getInt(1));
        GfxdLoaderDUnit.assertFalse((boolean)rs.next());
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select count(*) from emp.testtable", null, "20");
    }
}

