/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;

public class GfxdListenerWriterDUnit
extends DistributedSQLTestBase {
    public GfxdListenerWriterDUnit(String name) {
        super(name);
    }

    public void testListenerCallback() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", "");
        this.clientSQLExecute(1, "insert into emp.testtable values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable values(3,4,5)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.removeListener("ID1", "emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        this.clientSQLExecute(1, "insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test2");
    }

    public void testListenerCallback_replicate() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) replicate");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", "");
        this.clientSQLExecute(1, "insert into emp.testtable values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable values(3,4,5)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.removeListener("ID1", "emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        this.clientSQLExecute(1, "insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test2");
    }

    public void testWriterCallback() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", null);
        this.clientSQLExecute(1, "insert into emp.testtable values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable values(3,4,5)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.removeWriter("emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        this.clientSQLExecute(1, "insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test2");
    }

    public void testWriterCallback_replicate() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) replicate");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", null);
        this.clientSQLExecute(1, "insert into emp.testtable values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable values(3,4,5)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.removeWriter("emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test1");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        this.clientSQLExecute(1, "insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "listenerWriter_Test2");
    }

    public void testListenerCallbackSupressionForSkipListener() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", "");
        Properties props = new Properties();
        props.put("skip-listeners", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        stmt.execute("insert into emp.testtable values(1,2,3)");
        stmt.execute("insert into emp.testtable values(2,3,4)");
        stmt.execute("insert into emp.testtable values(3,4,5)");
        stmt.execute("update emp.testtable set secondid =7");
        stmt.execute("delete from  emp.testtable where ID = 1");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.removeListener("ID1", "emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        stmt.execute("insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
    }

    public void testListenerCallbackSuppression_replicateForSkipListeners() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) replicate");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", "");
        Properties props = new Properties();
        props.put("skip-listeners", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        stmt.execute("insert into emp.testtable values(1,2,3)");
        stmt.execute("insert into emp.testtable values(2,3,4)");
        stmt.execute("insert into emp.testtable values(3,4,5)");
        stmt.execute("update emp.testtable set secondid =7");
        stmt.execute("delete from  emp.testtable where ID = 1");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.removeListener("ID1", "emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.addListener("ID1", "emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        stmt.execute("insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
    }

    public void testWriterCallbackSuppressionForSkipListeners() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", null);
        Properties props = new Properties();
        props.put("skip-listeners", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        stmt.execute("insert into emp.testtable values(1,2,3)");
        stmt.execute("insert into emp.testtable values(2,3,4)");
        stmt.execute("insert into emp.testtable values(3,4,5)");
        stmt.execute("update emp.testtable set secondid =7");
        stmt.execute("delete from  emp.testtable where ID = 1");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.removeWriter("emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        stmt.execute("insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
    }

    public void testWriterCallbackSuppressionForSkipListener_replicate() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) replicate");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:2", null);
        Properties props = new Properties();
        props.put("skip-listeners", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        stmt.execute("insert into emp.testtable values(1,2,3)");
        stmt.execute("insert into emp.testtable values(2,3,4)");
        stmt.execute("insert into emp.testtable values(3,4,5)");
        stmt.execute("update emp.testtable set secondid =7");
        stmt.execute("delete from  emp.testtable where ID = 1");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.removeWriter("emp", "testtable");
        this.clientSQLExecute(1, "insert into emp.testtable values(4,5,6)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
        GfxdCallbacksTest.addWriter("emp", "testtable", "com.pivotal.gemfirexd.ddl.EventCallBackFactorImpl", "emp.testtable_one:3", "");
        stmt.execute("insert into emp.testtable values(5,6,7)");
        this.sqlExecuteVerify(new int[]{1}, null, "select * from EMP.TESTTABLE_ONE", TestUtil.getResourcesDir() + "/lib/checkCreateTable.xml", "empty");
    }
}

