/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.VM;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class GfxdLRUDUnit
extends DistributedSQLTestBase {
    public GfxdLRUDUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    private void insertNElements(int n, Statement s) throws SQLException {
        for (int i = 0; i < n; ++i) {
            String insertStr = "insert into trade.customers values (" + i + ", 'name" + i + "')";
            s.execute(insertStr);
        }
    }

    private void insertNBigElements(int n, PreparedStatement ps, int baseCnt) throws SQLException {
        int i;
        String dummyPrefix = "";
        for (i = 0; i < 100; ++i) {
            dummyPrefix = dummyPrefix + "jjjjjjjjjj";
        }
        for (i = baseCnt; i < n + baseCnt; ++i) {
            String name = dummyPrefix + "_name" + i;
            String addr = dummyPrefix + "_addr" + (i + baseCnt);
            String addr2 = dummyPrefix + "_addr2" + (i + baseCnt);
            ps.setInt(1, i + baseCnt);
            ps.setString(2, name);
            ps.setString(3, addr);
            ps.setString(4, addr2);
            ps.executeUpdate();
        }
    }

    private void insertNBigElements2(int n, PreparedStatement ps, int baseCnt) throws SQLException {
        int i;
        StringBuilder sb = new StringBuilder(1000000);
        for (i = 0; i < 100000; ++i) {
            sb.append("jjjjjjjjjj");
        }
        for (i = baseCnt; i < n + baseCnt; ++i) {
            String addr = sb.toString() + "_addr" + (i + baseCnt);
            ps.setInt(1, i + baseCnt);
            ps.setString(2, addr);
            ps.executeUpdate();
        }
    }

    public void testPRLRUCountDestroy() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.customers (cid int not null, cust_name varchar(100))  EVICTION BY LRUCOUNT 100 EVICTACTION DESTROY");
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        this.insertNElements(200, s);
        s.execute("select count(*) from trade.customers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        GfxdLRUDUnit.assertEquals((String)("expected 100 elements but found " + cnt), (int)100, (int)cnt);
    }

    public void testPRLRUCountOverflow() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.customers (cid int not null, cust_name varchar(100))  EVICTION BY LRUCOUNT 100 EVICTACTION overflow synchronous");
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        this.insertNElements(200, s);
        s.execute("select count(*) from trade.customers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        GfxdLRUDUnit.assertEquals((String)("expected 200 elements but found " + cnt), (int)200, (int)cnt);
    }

    public void testReplicatedRegionLRUCountOverflow() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.customers (cid int not null, cust_name varchar(100))  replicate EVICTION BY LRUCOUNT 100 EVICTACTION overflow synchronous");
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        this.insertNElements(200, s);
        s.execute("select count(*) from trade.customers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        GfxdLRUDUnit.assertEquals((String)("expected 200 elements but found " + cnt), (int)200, (int)cnt);
    }

    public void testReplicatedRegionLRUCountOverflowAsync() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.customers (cid int not null, cust_name varchar(100))  replicate EVICTION BY LRUCOUNT 100 EVICTACTION overflow asynchronous");
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        this.insertNElements(200, s);
        Thread.sleep(5000L);
        s.execute("select count(*) from trade.customers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        GfxdLRUDUnit.assertEquals((String)("expected 200 elements but found " + cnt), (int)200, (int)cnt);
    }

    public void testPRLRUMemDestroy() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))  MAXPARTSIZE 1 EVICTION BY LRUMEMSIZE 1 EVICTACTION DESTROY");
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(2000, ps, 0);
        Statement s = conn.createStatement();
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdLRUDUnit.assertTrue((cnt < 2000 ? 1 : 0) != 0);
    }

    public void testPRLRUMemOverflow() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))  MAXPARTSIZE 1 EVICTION BY LRUMEMSIZE 1 EVICTACTION overflow synchronous");
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(2000, ps, 0);
        Statement s = conn.createStatement();
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdLRUDUnit.assertEquals((String)("expected 2000 elements but found " + cnt), (int)2000, (int)cnt);
    }

    public void testReplicatedRegionLRUMemOverflow() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))  replicate EVICTION BY LRUMEMSIZE 1 EVICTACTION overflow synchronous");
        Connection conn = TestUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(2000, ps, 0);
        Statement s = conn.createStatement();
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdLRUDUnit.assertEquals((String)("expected 2000 elements but found " + cnt), (int)2000, (int)cnt);
    }

    public void testPartitionedRegionEvictionLRUMemSize() throws Exception {
        this.startVMs(0, 1);
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute(" create table trade.test3 (OrderId INT NOT NULL,ItemId INT) PARTITION BY COLUMN (OrderId) MAXPARTSIZE 200 EVICTION BY LRUMEMSIZE 431 EVICTACTION DESTROY ");
        Statement s1 = conn.createStatement();
        s1.execute("select EVICTIONATTRS from sys.systables where tablename = 'TEST3'");
        ResultSet rs = s1.getResultSet();
        String evictAttributesAfterCreateTable = null;
        if (rs.next()) {
            evictAttributesAfterCreateTable = rs.getString(1);
        }
        GfxdLRUDUnit.assertNotNull(evictAttributesAfterCreateTable);
        TestUtil.getLogger().info((Object)("Eviction attributes after create table: " + evictAttributesAfterCreateTable));
        GfxdLRUDUnit.assertFalse((boolean)evictAttributesAfterCreateTable.contains("431"));
        GfxdLRUDUnit.assertTrue((boolean)evictAttributesAfterCreateTable.contains("200"));
        s.execute("ALTER TABLE trade.test3 SET EVICTION MAXSIZE 876");
        s.execute("select EVICTIONATTRS from sys.systables where tablename = 'TEST3'");
        rs = s.getResultSet();
        String evictAttributesAfterAlterTable = null;
        while (rs.next()) {
            evictAttributesAfterAlterTable = rs.getString(1);
        }
        GfxdLRUDUnit.assertNotNull(evictAttributesAfterAlterTable);
        GfxdLRUDUnit.assertFalse((boolean)evictAttributesAfterAlterTable.contains("876"));
        GfxdLRUDUnit.assertTrue((boolean)evictAttributesAfterAlterTable.contains("200"));
        GfxdLRUDUnit.assertTrue((String)"Eviction attributes after create table and alter table should match..both should be equal to localMaxMemory", (boolean)evictAttributesAfterCreateTable.equals(evictAttributesAfterAlterTable));
    }

    public static void assertHeapPercentage(Float perc) {
        float evictionHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionHeapPercentage();
        GfxdLRUDUnit.assertEquals((Object)Float.valueOf(perc.floatValue()), (Object)Float.valueOf(evictionHeapPercentage));
    }

    public static void logVMHeapSizeAndCurrentHeapSize() {
        Runtime rt = Runtime.getRuntime();
        long totmem = rt.totalMemory();
        long freemem = rt.freeMemory();
        Misc.getCacheLogWriter().info("logVMHeapSizeAndCurrentHeapSize tot mem in bytes: " + totmem + " and free mem: " + freemem + " so used mem: " + (totmem - freemem) + " and heap max size: " + rt.maxMemory());
    }

    public void testPRLRUHeapPercDestroy() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, "create table trade.bigcustomers (cid int not null, cust_addr clob) EVICTION BY LRUHEAPPERCENT EVICTACTION destroy");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_critical_heap_percentage_sg(?, ?)");
        cs.setInt(1, 90);
        cs.setNull(2, 12);
        cs.execute();
        cs = conn.prepareCall("call sys.set_eviction_heap_percentage_sg(?, ?)");
        cs.setInt(1, 25);
        cs.setNull(2, 12);
        cs.execute();
        float evictionHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionHeapPercentage();
        GfxdLRUDUnit.assertEquals((Object)Float.valueOf(25.0f), (Object)Float.valueOf(evictionHeapPercentage));
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdLRUDUnit.class, "assertHeapPercentage", new Object[]{Float.valueOf(evictionHeapPercentage)});
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?)");
        this.insertNBigElements2(300, ps, 0);
        final Statement s = conn.createStatement();
        servervm.invoke(GfxdLRUDUnit.class, "logVMHeapSizeAndCurrentHeapSize");
        DistributedTestBase.WaitCriterion waitCond = new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                try {
                    s.execute("select count(*) from trade.bigcustomers");
                    ResultSet rs = s.getResultSet();
                    int cnt = 0;
                    if (rs.next()) {
                        cnt = rs.getInt(1);
                    }
                    TestUtil.getLogger().info((Object)("cnt: " + cnt));
                    return cnt < 300;
                }
                catch (SQLException sqle) {
                    DistributedSQLTestBase.fail("unexpected exception " + sqle, sqle);
                    return false;
                }
            }

            public String description() {
                return "waiting for LRU destroy";
            }
        };
        GfxdLRUDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)waitCond, (long)120000L, (long)500L, (boolean)true);
    }

    public void testPRLRUHeapPercDestroy_1() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))   EVICTION BY LRUHEAPPERCENT EVICTACTION destroy");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_eviction_heap_percentage(?)");
        cs.setInt(1, 25);
        cs.execute();
        float evictionHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionHeapPercentage();
        TestUtil.getLogger().info((Object)("evictionHeapPercentage: " + evictionHeapPercentage));
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(1000, ps, 0);
        final Statement s = conn.createStatement();
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdLRUDUnit.class, "raiseFakeHeapEvictorOnEvent");
        this.insertNBigElements(1000, ps, 1000);
        DistributedTestBase.WaitCriterion waitCond = new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                try {
                    s.execute("select count(*) from trade.bigcustomers");
                    ResultSet rs = s.getResultSet();
                    int cnt = 0;
                    if (rs.next()) {
                        cnt = rs.getInt(1);
                    }
                    TestUtil.getLogger().info((Object)("cnt: " + cnt));
                    return cnt < 2000;
                }
                catch (SQLException sqle) {
                    DistributedSQLTestBase.fail("unexpected exception " + sqle, sqle);
                    return false;
                }
            }

            public String description() {
                return "waiting for LRU destroy";
            }
        };
        GfxdLRUDUnit.waitForCriterion((DistributedTestBase.WaitCriterion)waitCond, (long)120000L, (long)500L, (boolean)true);
    }

    public void testPRLRUHeapPercOverflow() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))  EVICTION BY LRUHEAPPERCENT EVICTACTION overflow synchronous");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_eviction_heap_percentage(?)");
        cs.setInt(1, 25);
        cs.execute();
        float evictionHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionHeapPercentage();
        TestUtil.getLogger().info((Object)("evictionHeapPercentage: " + evictionHeapPercentage));
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(1000, ps, 0);
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdLRUDUnit.class, "raiseFakeHeapEvictorOnEvent");
        Statement s = conn.createStatement();
        this.insertNBigElements(1000, ps, 1000);
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdLRUDUnit.assertEquals((String)("expected 2000 elements but found " + cnt), (int)2000, (int)cnt);
    }

    public void testReplicatedRegionLRUHeapPercOverflow() throws Exception {
        this.startVMs(1, 1);
        this.clientSQLExecute(1, " create diskstore teststore 'temp' ");
        this.clientSQLExecute(1, " create table trade.bigcustomers (cid int not null, cust_name varchar(2000), cust_addr varchar(2000), cust_addr2 varchar(2000))  replicate EVICTION BY LRUHEAPPERCENT EVICTACTION overflow synchronous 'teststore' ");
        Connection conn = TestUtil.getConnection();
        CallableStatement cs = conn.prepareCall("call sys.set_eviction_heap_percentage(?)");
        cs.setInt(1, 25);
        cs.execute();
        float evictionHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionHeapPercentage();
        TestUtil.getLogger().info((Object)("evictionHeapPercentage: " + evictionHeapPercentage));
        PreparedStatement ps = conn.prepareStatement("insert into trade.bigcustomers values(?, ?, ?, ?)");
        this.insertNBigElements(1000, ps, 0);
        VM servervm = (VM)this.serverVMs.get(0);
        servervm.invoke(GfxdLRUDUnit.class, "raiseFakeHeapEvictorOnEvent");
        Statement s = conn.createStatement();
        this.insertNBigElements(1000, ps, 1000);
        s.execute("select count(*) from trade.bigcustomers");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        if (rs.next()) {
            cnt = rs.getInt(1);
        }
        TestUtil.getLogger().info((Object)("cnt: " + cnt));
        GfxdLRUDUnit.assertEquals((String)("expected 2000 elements but found " + cnt), (int)2000, (int)cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void raiseFakeHeapEvictorOnEvent() {
        Misc.getGemFireCache().getHeapEvictor().testAbortAfterLoopCount = 1;
        HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
        try {
            System.setProperty("gemfire.memoryEventTolerance", "0");
            Misc.getGemFireCache().getResourceManager().setEvictionHeapPercentage(85.0f);
            HeapMemoryMonitor hmm = Misc.getGemFireCache().getResourceManager().getHeapMonitor();
            hmm.setTestMaxMemoryBytes(100L);
            hmm.updateStateAndSendEvent(90L);
        }
        finally {
            System.clearProperty("gemfire.memoryEventTolerance");
            HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)false);
        }
    }
}

