/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdGatewayEventListener;
import com.pivotal.gemfirexd.jdbc.GfxdJarInstallationTest;
import com.pivotal.gemfirexd.tools.internal.JarTools;
import io.snappydata.test.dunit.VM;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.CyclicBarrier;
import org.apache.derbyTesting.junit.JDBC;

public class GfxdJarInstallationDUnit
extends DistributedSQLTestBase {
    private final String myjar = TestUtil.getResourcesDir() + "/lib/myjar.jar";
    private final String myfalsejar = TestUtil.getResourcesDir() + "/lib/myfalsejar.jar";
    private final String callbackjar = TestUtil.getResourcesDir() + "/lib/callback.jar";
    private final String udtjar = TestUtil.getResourcesDir() + "/lib/udt.jar";
    private final String dbsyncjar = TestUtil.getResourcesDir() + "/lib/sectdbsync.jar";
    private final String myAsyncJar = TestUtil.getResourcesDir() + "/lib/myAsyncJar.jar";
    private final String myNewAsyncJar = TestUtil.getResourcesDir() + "/lib/myNewAsyncJar.jar";

    public GfxdJarInstallationDUnit(String name) {
        super(name);
    }

    public void testBug44223() throws Exception {
        Properties locatorProps = new Properties();
        this.setMasterCommonProperties(locatorProps);
        String locatorBindAddress = SocketCreator.getLocalHost().getHostName();
        int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        GfxdJarInstallationDUnit._startNewLocator(((Object)((Object)this)).getClass().getName(), this.getName(), locatorBindAddress, locatorPort, null, locatorProps);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        TestUtil.startNetServer(netPort, null);
        Properties serverProps = new Properties();
        serverProps.setProperty("locators", locatorBindAddress + '[' + locatorPort + ']');
        this.startVMs(0, 1, 0, null, serverProps);
        this.startNetworkServer(1, null, null);
        String url = TestUtil.getNetProtocol(locatorBindAddress, netPort);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        st.execute("call sqlj.install_jar('" + this.udtjar + "', 'app.udtjar', 0)");
    }

    public void testBug44224() throws Exception {
        this.startVMs(1, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort1);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        st.execute("call sqlj.install_jar('" + this.udtjar + "', 'app.udtjar', 0)");
        st.execute("create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        st.execute("create table orders( orderID int generated always as identity, customerID int, totalPrice price)");
        st.execute("create function makePrice( currencyCode char( 3 ), amount decimal( 31, 5 ), timeInstant Timestamp ) returns Price language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'");
        st.execute("create function getCurrencyCode( price Price ) returns char( 3 ) language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getCurrencyCode'");
        st.execute("create function getTimeInstant( price Price ) returns timestamp language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getTimeInstant'");
        st.execute("create function getAmount( price Price ) returns decimal( 31, 5 ) language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getAmount'");
        st.execute("insert into orders( customerID, totalPrice ) values ( 12345, makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') ) )");
        st.execute("select getCurrencyCode( totalPrice ) from orders");
        st.execute("select getCurrencyCode( totalPrice ), getAmount(totalPrice) from orders");
        st.execute("select getTimeInstant( totalPrice ) from orders");
        st.execute("select getAmount(totalPrice) from orders");
    }

    public void testBug44517() throws Exception {
        this.startVMs(1, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort1);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        st.execute("call sqlj.install_jar('" + this.callbackjar + "', 'app.rowloaderjar', 0)");
        st.execute("create table APP.CallbackTest (data varchar(40))");
        st.execute("call sys.ATTACH_LOADER('APP','CallbackTest','gemfirexd.callbacktests.GfxdTestRowLoader','RowLoader Init')");
    }

    public void testBug44501() throws Exception {
        this.startVMs(1, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort1);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        st.execute("call sqlj.install_jar('" + this.callbackjar + "', 'app.writerjar', 0)");
        st.execute("create table APP.WriterTest (data varchar(40))");
        st.execute("call sys.attach_writer('APP','WriterTest','gemfirexd.callbacktests.GfxdTestWriter', 'in-writer', null)");
    }

    public void testBug44492() throws Exception {
        this.startVMs(1, 2, 0, null, null);
        int netPort1 = this.startNetworkServer(1, null, null);
        this.startNetworkServer(2, null, null);
        TestUtil.loadNetDriver();
        InetAddress localHost = SocketCreator.getLocalHost();
        String url = TestUtil.getNetProtocol(localHost.getHostName(), netPort1);
        Connection conn = DriverManager.getConnection(url);
        Statement st = conn.createStatement();
        st.execute("call sqlj.install_jar('" + this.callbackjar + "', 'app.listenerjar', 0)");
        st.execute("create table APP.CBTEST (data varchar(40))");
        st.execute("call SYS.ADD_LISTENER('callbacktest', 'APP', 'CBTEST', 'gemfirexd.callbacktests.GfxdTestListener', 'initialtest', null)");
    }

    public void testJarInstallRemoveReplace_novti() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(1, 0, null);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("call sqlj.install_jar('" + this.myjar + "', 'app.sample2', 0)");
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
        stmt.execute(ddl);
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4')");
        stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
        stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
        String sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1";
        CallableStatement cs = conn.prepareCall(sql);
        cs.execute();
        cs.getResultSet();
        this.startServerVMs(1, 0, null);
        this.stopVMNum(-1);
        cs = conn.prepareCall(sql);
        cs.execute();
    }

    public void testJarRemove() throws Exception {
        block2: {
            this.startClientVMs(1, 0, null);
            this.startServerVMs(2, 0, null);
            Connection conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute("call sqlj.install_jar('" + this.myjar + "', 'app.sample2', 0)");
            String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
            stmt.execute(ddl);
            stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3')");
            stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3')");
            stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4')");
            stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
            stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
            String sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1";
            CallableStatement cs = conn.prepareCall(sql);
            cs.execute();
            cs.getResultSet();
            stmt.execute("call sqlj.remove_jar('app.sample2', 0)");
            try {
                stmt.execute("call sqlj.remove_jar('app.sample3', 0)");
                GfxdJarInstallationDUnit.fail((String)"expected an exception for non-existent jar 'app.sample3'");
            }
            catch (SQLException sqle) {
                if ("X0X13".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
    }

    public void test52526() throws Exception {
        Statement stmt;
        int netPort;
        String localHostName;
        block2: {
            this.startVMs(1, 2);
            localHostName = SocketCreator.getLocalHost().getHostName();
            netPort = this.startNetworkServer(1, null, null);
            Connection conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute("create schema fees");
            JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=fees.testjar", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
            try {
                stmt.execute("drop schema fees restrict");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0Y54")) break block2;
                throw se;
            }
        }
        JarTools.main((String[])new String[]{"remove-jar", "-name=fees.testjar", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
        stmt.execute("drop schema fees restrict");
        stmt.execute("create schema fees");
        JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=fees.testjar", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
    }

    public void testJarInstallRemoveReplace_vti() throws Exception {
        String sql;
        this.startVMs(1, 2);
        String localHostName = SocketCreator.getLocalHost().getHostName();
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        CallableStatement mergeCS = null;
        for (int i = 1; i <= 4; ++i) {
            block11: {
                CallableStatement cs;
                if (i == 1) {
                    sql = "call SQLJ.INSTALL_JAR_BYTES(?, ?)";
                    cs = conn.prepareCall(sql);
                    cs.setBinaryStream(1, (InputStream)new FileInputStream(this.myjar));
                    cs.setString(2, "app.sample1");
                    cs.executeUpdate();
                } else if (i == 2) {
                    JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=app.sample1", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
                } else if (i == 3) {
                    sql = "call SQLJ.REPLACE_JAR_BYTES(?, ?)";
                    cs = conn.prepareCall(sql);
                    cs.setBytes(1, GfxdJarInstallationTest.getJarBytes(this.myfalsejar));
                    cs.setString(2, "app.sample1");
                    cs.executeUpdate();
                } else {
                    JarTools.main((String[])new String[]{"replace-jar", "-file=" + this.myjar, "-name=app.sample1", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
                }
                String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
                stmt.execute(ddl);
                stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3')");
                stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3')");
                stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4')");
                stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
                stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
                sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1";
                try {
                    if (mergeCS == null) {
                        mergeCS = conn.prepareCall(sql);
                    }
                    mergeCS.execute();
                    this.checkMergeResults(mergeCS);
                    if (i == 3) {
                        GfxdJarInstallationDUnit.fail((String)"expected exception with incorrect jar");
                    }
                }
                catch (SQLException sqle) {
                    if (i == 3 && "42X51".equals(sqle.getSQLState())) break block11;
                    throw sqle;
                }
            }
            if (i == 4) continue;
            stmt.execute("drop alias MergeSortProcessor");
            stmt.execute("drop procedure MergeSort");
            stmt.execute("drop table EMP.PARTITIONTESTTABLE");
            if (i == 2 || i == 3) continue;
            JarTools.main((String[])new String[]{"remove-jar", "-name=APP.sample1", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
        }
        String ddl = "create table EMP.REPLICATETESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) REPLICATE";
        stmt.execute(ddl);
        stmt.execute("INSERT INTO EMP.REPLICATETESTTABLE VALUES (2, 2, '3')");
        stmt.execute("INSERT INTO EMP.REPLICATETESTTABLE VALUES (3, 3, '3')");
        stmt.execute("INSERT INTO EMP.REPLICATETESTTABLE VALUES (2, 2, '4')");
        this.startServerVMs(1, 0, null);
        this.stopVMNums(-1, -2);
        sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.REPLICATETESTTABLE WHERE 1=1";
        mergeCS = conn.prepareCall(sql);
        mergeCS.execute();
        this.checkMergeResults(mergeCS);
    }

    private void checkMergeResults(CallableStatement cs) throws SQLException {
        ResultSet rs = cs.getResultSet();
        GfxdJarInstallationDUnit.assertTrue((boolean)rs.next());
        GfxdJarInstallationDUnit.assertEquals((int)2, (int)rs.getInt(1));
        GfxdJarInstallationDUnit.assertEquals((int)2, (int)rs.getInt(2));
        GfxdJarInstallationDUnit.assertTrue((boolean)rs.next());
        GfxdJarInstallationDUnit.assertEquals((int)2, (int)rs.getInt(1));
        GfxdJarInstallationDUnit.assertEquals((int)2, (int)rs.getInt(2));
        GfxdJarInstallationDUnit.assertTrue((boolean)rs.next());
        GfxdJarInstallationDUnit.assertEquals((int)3, (int)rs.getInt(1));
        GfxdJarInstallationDUnit.assertEquals((int)3, (int)rs.getInt(2));
        GfxdJarInstallationDUnit.assertFalse((boolean)rs.next());
    }

    public void testUDTINJarFromClient() throws Exception {
        this.startVMs(1, 3);
        int port = this.startNetworkServer(1, null, null);
        Connection netConn = TestUtil.getNetConnection(port, null, null);
        GfxdJarInstallationTest.udtTypeTest(netConn, true, false, true, true, false);
        GfxdJarInstallationTest.udtTypeTest(netConn, false, false, true, true, false);
        Connection conn = TestUtil.getConnection();
        GfxdJarInstallationTest.udtTypeTest(conn, false, false, true, true, false);
        GfxdJarInstallationTest.udtTypeTest(conn, true, false, true, true, false);
    }

    public void testUDTINJarFromClientWithLocator() throws Exception {
        InetAddress localHost = SocketCreator.getLocalHost();
        FabricLocator fabapi = FabricServiceManager.getFabricLocatorInstance();
        Properties locProps = new Properties();
        this.setCommonProperties(locProps, 0, null, null);
        locProps.remove("locators");
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        int locPort = TestUtil.startLocator(localHost.getHostAddress(), netPort, locProps);
        Properties serverProps = new Properties();
        serverProps.setProperty("locators", localHost.getHostName() + '[' + locPort + ']');
        this.startServerVMs(3, 0, null, serverProps);
        this.startNetworkServer(2, null, null);
        this.startNetworkServer(1, null, null);
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        GfxdJarInstallationTest.udtTypeTest(netConn, false, false, true, false, true);
        this.stopVMNums(-1, -2, -3);
        fabapi.stop(null);
        locPort = TestUtil.startLocator(localHost.getHostAddress(), netPort, locProps);
        serverProps.clear();
        serverProps.setProperty("locators", localHost.getHostName() + '[' + locPort + ']');
        this.restartServerVMNums(new int[]{1, 2, 3}, 0, null, serverProps);
        this.startNetworkServer(1, null, null);
        this.startNetworkServer(3, null, null);
        GfxdJarInstallationTest.udtTypeTest(netConn, false, false, false, true, true);
        GfxdJarInstallationTest.udtTypeTest(netConn, true, false, true, true, false);
        GfxdJarInstallationTest.udtTypeTest(netConn, false, true, true, true, false);
        this.stopVMNums(-1, -2, -3);
        fabapi.stop(null);
    }

    public void testBug47783_47824() throws Exception {
        Properties props = new Properties();
        props.setProperty("SKIP_SPS_PRECOMPILE", "false");
        this.startClientVMs(1, 0, null, props);
        this.startServerVMs(2, 0, "DBSYNC", props);
        final int netPort1 = this.startNetworkServer(2, null, props);
        props.setProperty("mcast-port", "0");
        this.startServerVMs(1, 0, null, props);
        int netPort = this.startNetworkServer(3, null, props);
        String netAddress = SocketCreator.getLocalHost().getHostName();
        Connection conn = TestUtil.getConnection();
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        Statement netStmt = netConn.createStatement();
        stmt.execute("call sqlj.install_jar('" + this.dbsyncjar + "', 'app.dbsync', 0)");
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, CB CLOB, DT BLOB, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
        netStmt.execute(ddl);
        stmt.execute("create asynceventlistener SECTSYNC(listenerclass 'com.jpmorgan.tss.securitas.strategic.logsynctable.db.gemfirexd.callbacks.SectDBSynchronizer' initparams 'com.pivotal.gemfirexd.jdbc.ClientDriver,jdbc:gemfirexd://" + netAddress + ':' + netPort + "' ENABLEPERSISTENCE true MANUALSTART false " + "ALERTTHRESHOLD 5000) SERVER GROUPS(DBSYNC)");
        stmt.execute("ALTER TABLE EMP.PARTITIONTESTTABLE SET ASYNCEVENTLISTENER(SECTSYNC)");
        stmt.execute("call sqlj.install_jar('" + this.myjar + "', 'app.sample2', 0)");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3', 'CLOB1', X'0a0a0a')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3', 'CLOB2', X'0b0b0b')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4', 'CLOB3', X'0c0c0c')");
        final Object[][] expectedOutput = new Object[][]{{2, 2, "4", "CLOB3", "0c0c0c"}, {3, 3, "3", "CLOB2", "0b0b0b"}, {2, 2, "3", "CLOB1", "0a0a0a"}};
        int numThreads = 20;
        Thread[] threads = new Thread[20];
        final Exception[] ex = new Exception[1];
        final CyclicBarrier barrier = new CyclicBarrier(20);
        for (int i = 0; i < 20; ++i) {
            threads[i] = new Thread(new Runnable(){
                final Connection netConn;
                final PreparedStatement pstmt;
                {
                    this.netConn = TestUtil.getNetConnection(netPort1, null, null);
                    this.pstmt = this.netConn.prepareStatement("select * from EMP.PARTITIONTESTTABLE");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ResultSet rs = this.pstmt.executeQuery();
                        barrier.await();
                        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
                        rs.close();
                    }
                    catch (Exception e) {
                        ex[0] = e;
                    }
                    finally {
                        try {
                            this.pstmt.close();
                        }
                        catch (Exception exception) {}
                        try {
                            this.netConn.commit();
                            this.netConn.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        for (Thread thr : threads) {
            thr.start();
        }
        for (Thread thr : threads) {
            thr.join();
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
        stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
        String sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1";
        CallableStatement cs = conn.prepareCall(sql);
        cs.execute();
        cs.getResultSet();
        stmt.execute("call sys.WAIT_FOR_SENDER_QUEUE_FLUSH('SECTSYNC', 1, 0)");
        ResultSet rs = netStmt.executeQuery("select * from EMP.PARTITIONTESTTABLE");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs.close();
        stmt.execute("ALTER TABLE EMP.PARTITIONTESTTABLE SET ASYNCEVENTLISTENER()");
        stmt.execute("drop ASYNCEVENTLISTENER sectsync");
        stmt.execute("call sqlj.remove_jar('app.sample2', 0)");
        stmt.execute("call sqlj.remove_jar('app.dbsync', 0)");
    }

    public void testBug47863() throws Exception {
        this.startClientVMs(1, 0, null, null);
        this.startServerVMs(2, 0, "DBSYNC", null);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        this.startServerVMs(1, 0, null, props);
        int netPort = this.startNetworkServer(3, null, props);
        String netAddress = SocketCreator.getLocalHost().getHostName();
        props.setProperty("user", "testuser");
        props.setProperty("password", "testpass");
        Connection conn = TestUtil.getConnection(props);
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = conn.createStatement();
        Statement netStmt = netConn.createStatement();
        stmt.execute("create schema testsch");
        stmt.execute("call sqlj.install_jar('" + this.dbsyncjar + "', 'testsch.dbsync', 0)");
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, CB CLOB, DT BLOB, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID) PERSISTENT";
        stmt.execute(ddl);
        stmt.execute("create asynceventlistener SECTSYNC(listenerclass 'com.jpmorgan.tss.securitas.strategic.logsynctable.db.gemfirexd.callbacks.SectDBSynchronizer' initparams 'com.pivotal.gemfirexd.jdbc.ClientDriver,jdbc:gemfirexd://" + netAddress + ':' + netPort + "' ENABLEPERSISTENCE true MANUALSTART false " + "ALERTTHRESHOLD 5000) SERVER GROUPS(DBSYNC)");
        stmt.execute("ALTER TABLE EMP.PARTITIONTESTTABLE SET ASYNCEVENTLISTENER(SECTSYNC)");
        stmt.execute("call sqlj.install_jar('" + this.myjar + "', 'sample2', 0)");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3', 'CLOB1', X'0a0a0a')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3', 'CLOB2', X'0b0b0b')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4', 'CLOB3', X'0c0c0c')");
        Object[][] expectedOutput = new Object[][]{{2, 2, "4", "CLOB3", "0c0c0c"}, {3, 3, "3", "CLOB2", "0b0b0b"}, {2, 2, "3", "CLOB1", "0a0a0a"}};
        stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
        stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
        String sortSQL = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1";
        CallableStatement cs = conn.prepareCall(sortSQL);
        cs.execute();
        cs.getResultSet();
        stmt.execute("call sys.WAIT_FOR_SENDER_QUEUE_FLUSH('SECTSYNC', 1, 0)");
        ResultSet rs = netStmt.executeQuery("select * from EMP.PARTITIONTESTTABLE");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs.close();
        this.stopVMNums(-1, -2);
        this.restartServerVMNums(new int[]{1, 2}, 0, "DBSYNC", null);
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (4, 4, '5', 'CLOB4', X'0d0d0d')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (5, 3, '5', 'CLOB5', X'0e0e0e')");
        expectedOutput = new Object[][]{{4, 4, "5", "CLOB4", "0d0d0d"}, {3, 3, "3", "CLOB2", "0b0b0b"}, {2, 2, "3", "CLOB1", "0a0a0a"}, {5, 3, "5", "CLOB5", "0e0e0e"}, {2, 2, "4", "CLOB3", "0c0c0c"}};
        cs = conn.prepareCall(sortSQL);
        cs.execute();
        cs.getResultSet();
        stmt.execute("call sys.WAIT_FOR_SENDER_QUEUE_FLUSH('SECTSYNC', 1, 0)");
        rs = netStmt.executeQuery("select * from EMP.PARTITIONTESTTABLE");
        JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
        rs.close();
        stmt.execute("ALTER TABLE EMP.PARTITIONTESTTABLE SET ASYNCEVENTLISTENER()");
        stmt.execute("drop ASYNCEVENTLISTENER sectsync");
        stmt.execute("call sqlj.remove_jar('testuser.sample2', 0)");
        stmt.execute("call sqlj.remove_jar('testsch.dbsync', 0)");
    }

    public void testAsyncListenerInvalidationOnJarReplaceRemove() throws Exception {
        this.startClientVMs(1, 0, null, null);
        this.startServerVMs(2, 0, "ASYNC", null);
        this.startServerVMs(1, 0, null, null);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create schema EMP");
        stmt.execute("call sqlj.install_jar('" + this.myAsyncJar + "', 'EMP.ASYNC', 0)");
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID) ";
        stmt.execute(ddl);
        stmt.execute("create asynceventlistener ASYNCLIS(listenerclass 'jarSource.AsyncListener' initparams '' ENABLEPERSISTENCE true MANUALSTART false ALERTTHRESHOLD 5000) SERVER GROUPS(ASYNC)");
        stmt.execute("ALTER TABLE EMP.PARTITIONTESTTABLE SET ASYNCEVENTLISTENER(ASYNCLIS)");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (4, 2, '4')");
        VM firstvm = this.getServerVM(1);
        VM secondvm = this.getServerVM(2);
        Boolean ret = (Boolean)firstvm.invoke(GfxdJarInstallationDUnit.class, "verifyOldEventsProcessed");
        if (!ret.booleanValue()) {
            ret = (Boolean)secondvm.invoke(GfxdJarInstallationDUnit.class, "verifyOldEventsProcessed");
            GfxdJarInstallationDUnit.assertTrue((boolean)ret);
        }
        stmt.execute("call sqlj.replace_jar('" + this.myNewAsyncJar + "', 'EMP.ASYNC')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (10, 2, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (11, 3, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (12, 2, '4')");
        ret = (Boolean)firstvm.invoke(GfxdJarInstallationDUnit.class, "verifyNewEventsProcessed");
        if (!ret.booleanValue()) {
            ret = (Boolean)secondvm.invoke(GfxdJarInstallationDUnit.class, "verifyNewEventsProcessed");
            GfxdJarInstallationDUnit.assertTrue((boolean)ret);
        }
        try {
            stmt.execute("call sqlj.remove_jar('EMP.ASYNC', 0)");
        }
        catch (SQLException ex) {
            GfxdJarInstallationDUnit.assertTrue((boolean)ex.getSQLState().equalsIgnoreCase("X0Y25"));
        }
    }

    public static Boolean verifyOldEventsProcessed() {
        GfxdGatewayEventListener lis = (GfxdGatewayEventListener)Misc.getGemFireCache().getAsyncEventQueue("ASYNCLIS").getAsyncEventListener();
        AsyncEventListener alis = lis.getAsyncEventListenerForTest();
        Class<?> c = alis.getClass();
        try {
            Method exceptionGetter = c.getMethod("getThrowable", new Class[0]);
            Object exc = exceptionGetter.invoke((Object)alis, new Object[0]);
            GfxdJarInstallationDUnit.assertNull((Object)exc);
            Misc.getCacheLogWriter().info("listener is " + alis);
            GfxdJarInstallationDUnit.assertTrue((boolean)alis.toString().equals("OLD"));
            return true;
        }
        catch (Throwable t) {
            Misc.getCacheLogWriter().info("got exception 0", t);
            return false;
        }
    }

    public static Boolean verifyNewEventsProcessed() {
        GfxdGatewayEventListener lis = (GfxdGatewayEventListener)Misc.getGemFireCache().getAsyncEventQueue("ASYNCLIS").getAsyncEventListener();
        AsyncEventListener alis = lis.getAsyncEventListenerForTest();
        Class<?> c = alis.getClass();
        try {
            Method exceptionGetter = c.getMethod("getThrowable", new Class[0]);
            Object exc = exceptionGetter.invoke((Object)alis, new Object[0]);
            GfxdJarInstallationDUnit.assertNull((Object)exc);
            Misc.getCacheLogWriter().info("listener is " + alis);
            GfxdJarInstallationDUnit.assertTrue((boolean)alis.toString().equals("NEW"));
            return true;
        }
        catch (Throwable t) {
            Misc.getCacheLogWriter().info("got exception 1", t);
            return false;
        }
    }

    public static Boolean verifyNoListenerAttachedToTable() {
        GfxdGatewayEventListener lis = (GfxdGatewayEventListener)Misc.getGemFireCache().getAsyncEventQueue("ASYNCLIS").getAsyncEventListener();
        AsyncEventListener alis = lis.getAsyncEventListenerForTest();
        try {
            GfxdJarInstallationDUnit.assertNull((Object)alis);
            return true;
        }
        catch (Throwable t) {
            Misc.getCacheLogWriter().info("got exception 2", t);
            return false;
        }
    }
}

