/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;

public class GfxdJDBCRowLoaderDUnit
extends DistributedSQLTestBase {
    public GfxdJDBCRowLoaderDUnit(String name) {
        super(name);
    }

    public void testJDBCLoaderWhenPkIsNotPartition() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION By Column(SECONDID)");
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(3,4,5)");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdJDBCRowLoader", "|url=jdbc|query-string=SELECT * FROM EMP.TESTTABLE_ONE WHERE ID=?");
        this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_1");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_2");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_3");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        CacheLoader ldr = rattr.getCacheLoader();
        GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
        GfxdJDBCRowLoaderDUnit.assertNull((Object)gfxdldr);
        GfxdJDBCRowLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)regtwo.size(), (int)3);
    }

    private void doJDBCRowLoaderConcurrently() {
        Runnable task1 = new Runnable(){

            @Override
            public void run() {
                try {
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(null, new int[]{1, 2}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_1");
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_2");
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_3");
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(null, new int[]{1, 2}, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get");
                }
                catch (Exception ex) {
                    DistributedSQLTestBase.fail("failed while doing concurrent verification", ex);
                }
            }
        };
        Runnable task2 = new Runnable(){

            @Override
            public void run() {
                try {
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_1");
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_2");
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_3");
                    GfxdJDBCRowLoaderDUnit.this.sqlExecuteVerify(new int[]{2}, null, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get");
                }
                catch (Exception ex) {
                    DistributedSQLTestBase.fail("failed while doing concurrent verification", ex);
                }
            }
        };
        Thread td1 = new Thread(task1);
        Thread td2 = new Thread(task2);
        td1.start();
        td2.start();
        try {
            td1.join(10000L);
            td2.join(10000L);
        }
        catch (InterruptedException ex) {
            GfxdJDBCRowLoaderDUnit.fail((String)"failed while waiting to join");
        }
    }

    public void testJDBCLoaderWhenPkIsNotPartition_multipleConcGets() throws Exception {
        this.startVMs(2, 2);
        this.clientSQLExecute(1, "create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(3,4,5)");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION By Column(SECONDID)");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdJDBCRowLoader", "|url=jdbc|max-connections=10|query-string=SELECT * FROM EMP.TESTTABLE_ONE WHERE ID=?");
        this.doJDBCRowLoaderConcurrently();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        GfxdJDBCRowLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)3, (int)regtwo.size());
    }

    public void testJDBCRowLoaderWhenPkIsPartition() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create schema EMP");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(3,4,5)");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdJDBCRowLoader", "|url=jdbc|query-string=SELECT * FROM EMP.TESTTABLE_ONE WHERE ID=?");
        this.sqlExecuteVerify(new int[]{1}, null, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 1", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_1");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 2", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_2");
        this.sqlExecuteVerify(null, new int[]{1, 2, 3}, "select THIRDID from EMP.PARTITIONTESTTABLE where ID = 3", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get_3");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "select * from emp.partitiontesttable", TestUtil.getResourcesDir() + "/lib/checkEventCallback.xml", "loader_get");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        CacheLoader ldr = rattr.getCacheLoader();
        GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
        GfxdJDBCRowLoaderDUnit.assertNull((Object)gfxdldr);
        GfxdJDBCRowLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)regtwo.size(), (int)3);
    }

    public void testLoaderWhenPkIsPartition_multipleConcGets() throws Exception {
        this.startVMs(2, 2);
        this.clientSQLExecute(1, "create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        this.clientSQLExecute(1, "create table EMP.TESTTABLE_ONE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(1,2,3)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(2,3,4)");
        this.clientSQLExecute(1, "insert into emp.testtable_one values(3,4,5)");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION By Column(ID)");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdJDBCRowLoader", "|url=jdbc|max-connections=10|query-string=SELECT * FROM EMP.TESTTABLE_ONE WHERE ID=?");
        this.doJDBCRowLoaderConcurrently();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        CacheLoader ldr = rattr.getCacheLoader();
        GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
        GfxdJDBCRowLoaderDUnit.assertNull((Object)gfxdldr);
        GfxdJDBCRowLoaderDUnit.assertEquals((String)"Number of entries expected to be 3", (int)3, (int)regtwo.size());
    }
}

