/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.RowLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GfxdJDBCRowLoader
implements RowLoader {
    private static final int VENDOR_CODE_ARCHIVE_ERROR = 0;
    private static final int VENDOR_CODE_TIMEOUT = 1;
    private static final String QUERY_SELECT_STRING = "SELECT *";
    private static final String QUERY_FROM_STRING = " FROM ";
    private static final String QUERY_WHERE_STRING = " WHERE ";
    private static final String QUERY_AND_STRING = " AND ";
    private final Queue<PreparedStatement[]> waitingQueries = new LinkedList<PreparedStatement[]>();
    private final Queue<PreparedStatement> availableStatements = new LinkedList<PreparedStatement>();
    private final ExecutorService backgroundExecutor = Executors.newCachedThreadPool();
    private final Logger logger = Logger.getLogger("com.pivotal.gemfirexd");
    protected Properties props = new Properties();
    protected String url = "";
    protected String queryString = "";
    protected String queryColumns = "";
    protected int minConnections;
    protected int maxConnections;
    protected long connectionTimeout;
    private Integer connectionCount = 0;

    public Object getRow(String schemaName, String tableName, Object[] primarykey) throws SQLException {
        this.logGetRowEntering(schemaName, tableName, primarykey);
        if (this.connectionCount < this.minConnections) {
            this.initPreparedStatements(schemaName, tableName);
        }
        PreparedStatement pstmt = this.getPreparedStatement(schemaName, tableName);
        this.populatePreparedStatement(pstmt, schemaName, tableName, primarykey);
        return this.executePreparedStatement(pstmt);
    }

    public void init(String initStr) throws SQLException {
        this.logger.entering("JDBCRowLoader", "init()");
        this.loadParametersFromInitString(initStr);
    }

    public static GfxdJDBCRowLoader create() {
        return new GfxdJDBCRowLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPreparedStatements(String schema, String table) {
        for (int i = 0; i < this.minConnections; ++i) {
            Integer n = this.connectionCount;
            synchronized (n) {
                this.connectionCount = this.connectionCount + 1;
            }
            StatementCreator creator = new StatementCreator(schema, table);
            this.backgroundExecutor.execute(creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedStatement(String schema, String table) throws SQLException {
        PreparedStatement[] holder;
        PreparedStatement[] preparedStatementArray = holder = new PreparedStatement[1];
        synchronized (holder) {
            this.getPooledStatement(holder, schema, table);
            if (holder[0] == null) {
                try {
                    holder.wait(this.connectionTimeout);
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.WARNING, "JDBCRowLoader interrupted while waiting for an available pooled statement.", e);
                    Thread.currentThread().interrupt();
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            PreparedStatement pstmt = holder[0];
            if (pstmt == null) {
                throw new SQLException("Timeout waiting for pooled connection to archive database", "08001", 1);
            }
            return pstmt;
        }
    }

    private void populatePreparedStatement(PreparedStatement pstmt, String schema, String table, Object[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            pstmt.setObject(i + 1, params[i]);
        }
    }

    private Object executePreparedStatement(PreparedStatement pstmt) throws SQLException {
        try {
            this.logger.info("Executing query " + pstmt.toString());
            ResultSet result = pstmt.executeQuery();
            this.logger.info("Query succeeded");
            this.recyclePooledStatement(pstmt);
            return result;
        }
        catch (SQLException e) {
            this.releasePooledStatement(pstmt);
            this.logGetRowError(e);
            throw new SQLException("Error executing query from archive database", e.getSQLState(), 0, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getPooledStatement(PreparedStatement[] holder, String schema, String table) {
        holder[0] = this.availableStatements.poll();
        if (holder[0] == null) {
            this.waitingQueries.add(holder);
            Integer n = this.connectionCount;
            synchronized (n) {
                if (this.connectionCount < this.maxConnections) {
                    this.connectionCount = this.connectionCount + 1;
                    StatementCreator creator = new StatementCreator(schema, table);
                    this.backgroundExecutor.execute(creator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void returnPooledStatement(PreparedStatement pstmt) {
        PreparedStatement[] holder = this.waitingQueries.poll();
        if (holder == null) {
            this.availableStatements.offer(pstmt);
            return;
        }
        PreparedStatement[] preparedStatementArray = holder;
        synchronized (holder) {
            holder[0] = pstmt;
            holder.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void recyclePooledStatement(PreparedStatement pstmt) {
        StatementRecycler recycler = new StatementRecycler(pstmt);
        this.backgroundExecutor.execute(recycler);
    }

    private void releasePooledStatement(PreparedStatement pstmt) {
        StatementReleaser releaser = new StatementReleaser(pstmt);
        this.backgroundExecutor.execute(releaser);
    }

    protected Connection getDatabaseConnection() throws SQLException {
        return TestUtil.getConnection();
    }

    private void loadParametersFromInitString(String initStr) {
        this.parsePropertiesFromString(initStr);
        this.logInitParameters();
        this.url = this.getProperty("url", "");
        this.queryString = this.getProperty("query-string", "");
        this.queryColumns = this.getProperty("query-columns", "");
        this.minConnections = Integer.parseInt(this.getProperty("min-connections", "1"));
        this.maxConnections = Integer.parseInt(this.getProperty("max-connections", "1"));
        this.connectionTimeout = Long.parseLong(this.getProperty("connection-timeout", "3000"));
    }

    private void parsePropertiesFromString(String initStr) {
        if (initStr.length() > 1) {
            String[] params;
            String delimiter = initStr.substring(0, 1);
            for (String parameter : params = initStr.substring(1).split("\\" + delimiter)) {
                int equalsIndex = parameter.indexOf(61);
                if (!(equalsIndex > 0 & parameter.length() > equalsIndex + 1)) continue;
                String key = parameter.substring(0, equalsIndex).trim();
                String value = parameter.substring(equalsIndex + 1).trim();
                this.props.put(key, value);
            }
        }
    }

    private String buildQueryString(String schema, String table) {
        String[] cols;
        if (!this.queryString.isEmpty()) {
            return this.queryString;
        }
        if (this.queryColumns.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder(QUERY_SELECT_STRING);
        if (!schema.isEmpty() || !table.isEmpty()) {
            query.append(QUERY_FROM_STRING);
            if (!schema.isEmpty()) {
                query.append(schema).append(".");
            }
            if (!table.isEmpty()) {
                query.append(table);
            }
        }
        if ((cols = this.queryColumns.split(",")).length > 0) {
            query.append(QUERY_WHERE_STRING);
            for (int i = 0; i < cols.length; ++i) {
                String column = cols[i];
                query.append(column).append("=?");
                if (i >= cols.length - 1) continue;
                query.append(QUERY_AND_STRING);
            }
        }
        return query.toString();
    }

    private String getProperty(String key, String defaultValue) {
        Object value = this.props.remove(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    private void logGetRowEntering(String schema, String table, Object[] params) {
        this.logger.entering("JDBCRowLoader", "getRow(String schema, String table, Object[] params)");
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JDBCRowLoader invoked to fetch from schema <" + schema + "> on table <" + table + ">.");
            for (int i = 0; i < params.length; ++i) {
                this.logger.info(" primary key element " + i + ": " + params[i]);
            }
        }
    }

    private void logGetRowError(SQLException e) {
        this.logger.log(Level.SEVERE, "Error executing prepared statement in JDBCRowLoader", e);
    }

    private void logInitParameters() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JDBCRowLoader initialized.");
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                String entryKey = (String)entry.getKey();
                if ("password".equalsIgnoreCase(entryKey) || "passwd".equalsIgnoreCase(entryKey)) {
                    this.logger.info("   " + entryKey + ": " + this.maskString((String)entry.getValue()));
                    continue;
                }
                this.logger.info("   " + entryKey + ": " + entry.getValue());
            }
        }
    }

    private String maskString(String str) {
        if (str != null) {
            char[] masked = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                masked[i] = 120;
            }
            return String.copyValueOf(masked);
        }
        return "";
    }

    private class StatementReleaser
    implements Runnable {
        private final PreparedStatement pstmt;

        StatementReleaser(PreparedStatement target) {
            this.pstmt = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Integer n = GfxdJDBCRowLoader.this.connectionCount;
                synchronized (n) {
                    GfxdJDBCRowLoader.this.connectionCount = GfxdJDBCRowLoader.this.connectionCount - 1;
                }
                this.pstmt.getConnection().close();
            }
            catch (SQLException e) {
                GfxdJDBCRowLoader.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private class StatementRecycler
    implements Runnable {
        private final PreparedStatement pstmt;

        StatementRecycler(PreparedStatement target) {
            this.pstmt = target;
        }

        @Override
        public void run() {
            try {
                this.pstmt.clearParameters();
                GfxdJDBCRowLoader.this.returnPooledStatement(this.pstmt);
            }
            catch (SQLException e) {
                GfxdJDBCRowLoader.this.releasePooledStatement(this.pstmt);
                GfxdJDBCRowLoader.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private class StatementCreator
    implements Runnable {
        private final String schema;
        private final String table;

        public StatementCreator(String schema, String table) {
            this.schema = schema;
            this.table = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (GfxdJDBCRowLoader.this.url.isEmpty()) {
                GfxdJDBCRowLoader.this.logger.severe("Connection url not provided for JDBCRowLoader");
                return;
            }
            try {
                Connection con = GfxdJDBCRowLoader.this.getDatabaseConnection();
                GfxdJDBCRowLoader.this.logger.info(" Successful connection to target database: " + GfxdJDBCRowLoader.this.url);
                con.setReadOnly(true);
                PreparedStatement pstmt = con.prepareStatement(GfxdJDBCRowLoader.this.buildQueryString(this.schema, this.table));
                GfxdJDBCRowLoader.this.recyclePooledStatement(pstmt);
            }
            catch (SQLException e) {
                Integer n = GfxdJDBCRowLoader.this.connectionCount;
                synchronized (n) {
                    GfxdJDBCRowLoader.this.connectionCount = GfxdJDBCRowLoader.this.connectionCount - 1;
                }
                GfxdJDBCRowLoader.this.logger.log(Level.SEVERE, "Error connecting to target database", e);
            }
        }
    }
}

