/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.ddl;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdListPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class GfxdAllPartitionResolversAPIDUnit
extends DistributedSQLTestBase {
    public GfxdAllPartitionResolversAPIDUnit(String name) {
        super(name);
    }

    void checkResolver(int[] clientNums, int[] serverNums, String verifyFucntion) {
        ArrayList<VM> vmlist = this.getVMs(clientNums, serverNums);
        GfxdAllPartitionResolversAPIDUnit.assertNotNull(vmlist);
        GfxdAllPartitionResolversAPIDUnit.assertTrue((vmlist.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < vmlist.size(); ++i) {
            VM executeVM = vmlist.get(i);
            if (executeVM == null) continue;
            executeVM.invoke(GfxdAllPartitionResolversAPIDUnit.class, verifyFucntion);
        }
    }

    public static void verifyRangeResolver() {
        Cache cache = CacheFactory.getAnyInstance();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
        GfxdAllPartitionResolversAPIDUnit.assertNotNull((Object)rpr);
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(200));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)200, (int)robj);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(20));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)robj);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(60));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)3, (int)robj);
        GfxdAllPartitionResolversAPIDUnit.assertNull((Object)rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(10), true, (DataValueDescriptor)new SQLInteger(20), true));
        Object[] robjs1 = rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(25), true, (DataValueDescriptor)new SQLInteger(75), true);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)3, (int)robjs1.length);
        Object[] robjs2 = rpr.getRoutingObjectsForList(new DataValueDescriptor[]{new SQLInteger(25), new SQLInteger(75)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)2, (int)robjs2.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)robjs2[0].hashCode());
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)3, (int)robjs2[1].hashCode());
        robjs2 = rpr.getRoutingObjectsForList(new DataValueDescriptor[]{new SQLInteger(15), new SQLInteger(75)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)2, (int)robjs2.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)15, (int)robjs2[0].hashCode());
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)3, (int)robjs2[1].hashCode());
        robj = (Integer)rpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(0)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)robj.hashCode());
        String[] arr = rpr.getColumnNames();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)arr.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"ID", (String)arr[0]);
        String tbname = rpr.getTableName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"PARTITIONTESTTABLE", (String)tbname);
        String scname = rpr.getSchemaName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"EMP", (String)scname);
        String master = rpr.getMasterTable(false);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)master);
        GfxdAllPartitionResolversAPIDUnit.assertTrue((boolean)rpr.isUsedInPartitioning("ID"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("ID"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
    }

    public void testRangePartitionResolver() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  ID2 int not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE values (1, 1), (2, 2), (3, 3) ");
        this.checkResolver(new int[]{1}, new int[]{1, 2}, "verifyRangeResolver");
    }

    public static void verifyListResolver() {
        Cache cache = CacheFactory.getAnyInstance();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdListPartitionResolver rpr = (GfxdListPartitionResolver)pr;
        GfxdAllPartitionResolversAPIDUnit.assertNotNull((Object)rpr);
        SQLInteger notInList = new SQLInteger(200);
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)4);
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)notInList);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)notInList.computeHashCode(dtd.getMaximumWidth(), 0), (int)robj);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(20));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)robj);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(60));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)robj);
        GfxdAllPartitionResolversAPIDUnit.assertNull((Object)rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(10), true, (DataValueDescriptor)new SQLInteger(20), true));
        GfxdAllPartitionResolversAPIDUnit.assertNull((Object)rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(25), true, (DataValueDescriptor)new SQLInteger(75), true));
        Object[] onerobj = rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(25), true, (DataValueDescriptor)new SQLInteger(25), true);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)onerobj.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)25, (int)onerobj[0].hashCode());
        onerobj = rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(20), true, (DataValueDescriptor)new SQLInteger(20), true);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)onerobj.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)onerobj[0].hashCode());
        Object[] robjs2 = rpr.getRoutingObjectsForList(new DataValueDescriptor[]{new SQLInteger(25), new SQLInteger(20)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)2, (int)robjs2.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)25, (int)robjs2[0].hashCode());
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)robjs2[1].hashCode());
        robj = (Integer)rpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(0)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)robj.hashCode());
        robj = (Integer)rpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(40)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)robj.hashCode());
        String[] arr = rpr.getColumnNames();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)arr.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"ID", (String)arr[0]);
        String tbname = rpr.getTableName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"PARTITIONTESTTABLE", (String)tbname);
        String scname = rpr.getSchemaName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"EMP", (String)scname);
        String master = rpr.getMasterTable(false);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)master);
        GfxdAllPartitionResolversAPIDUnit.assertTrue((boolean)rpr.isUsedInPartitioning("ID"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("ID"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
    }

    public void testListPartitionResolver() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  ID2 int not null, primary key (ID))PARTITION BY LIST ( ID ) ( VALUES (20, 40), VALUES (50, 60) , VALUES (70, 80), VALUES (90, 100 ))");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE values (1, 1), (2, 2), (3, 3) ");
        this.checkResolver(new int[]{1}, new int[]{1, 2}, "verifyListResolver");
    }

    public static void verifyPartitionByColumnResolver() {
        Cache cache = CacheFactory.getAnyInstance();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdPartitionByExpressionResolver rpr = (GfxdPartitionByExpressionResolver)pr;
        GfxdAllPartitionResolversAPIDUnit.assertNotNull((Object)rpr);
        SQLInteger dvd = new SQLInteger(200);
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)dvd);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0), (int)robj);
        dvd = new SQLInteger(20);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)dvd);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0), (int)robj);
        dvd = new SQLInteger(60);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(60));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0), (int)robj);
        GfxdAllPartitionResolversAPIDUnit.assertNull((Object)rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(10), true, (DataValueDescriptor)new SQLInteger(20), true));
        GfxdAllPartitionResolversAPIDUnit.assertNull((Object)rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(25), true, (DataValueDescriptor)new SQLInteger(75), true));
        dvd = new SQLInteger(25);
        Object[] onerobj = rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(25), true, (DataValueDescriptor)dvd, true);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)onerobj.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0), (int)onerobj[0].hashCode());
        dvd = new SQLInteger(20);
        Object[] robjs2 = rpr.getRoutingObjectsForList(new DataValueDescriptor[]{new SQLInteger(25), dvd});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)2, (int)robjs2.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)new SQLInteger(25), null, (int)0), (int)robjs2[0].hashCode());
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0), (int)robjs2[1].hashCode());
        robj = (Integer)rpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(0)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)new SQLInteger(0), null, (int)0), (int)robj.hashCode());
        dvd = new SQLInteger(40);
        robj = (Integer)rpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(40)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0), (int)robj.hashCode());
        String[] arr = rpr.getColumnNames();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)arr.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"ID2", (String)arr[0]);
        String tbname = rpr.getTableName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"PARTITIONTESTTABLE", (String)tbname);
        String scname = rpr.getSchemaName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"EMP", (String)scname);
        String master = rpr.getMasterTable(false);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)master);
        GfxdAllPartitionResolversAPIDUnit.assertFalse((boolean)rpr.isUsedInPartitioning("ID"));
        GfxdAllPartitionResolversAPIDUnit.assertTrue((boolean)rpr.isUsedInPartitioning("ID2"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("ID2"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
        GfxdAllPartitionResolversAPIDUnit.assertFalse((boolean)rpr.isPartitioningKeyThePrimaryKey());
    }

    public void testPartitionByColumnPartitionResolver() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  ID2 int not null, ID3 int not null, primary key (ID))PARTITION BY COLUMN (ID2)");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE values (1, 1, 1), (2, 2, 2 ), (3, 3, 3) ");
        this.checkResolver(new int[]{1}, new int[]{1, 2}, "verifyPartitionByColumnResolver");
    }

    public static void verifyPartitionByPrimaryResolver() {
        Cache cache = CacheFactory.getAnyInstance();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdPartitionByExpressionResolver rpr = (GfxdPartitionByExpressionResolver)pr;
        GfxdAllPartitionResolversAPIDUnit.assertNotNull((Object)rpr);
        SQLInteger dvd = new SQLInteger(200);
        int maxWidth = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)4).getMaximumWidth();
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)dvd);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd.computeHashCode(maxWidth, 0), (int)robj);
        dvd = new SQLInteger(20);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)dvd);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd.computeHashCode(maxWidth, 0), (int)robj);
        dvd = new SQLInteger(60);
        robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)dvd);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd.computeHashCode(maxWidth, 0), (int)robj);
        GfxdAllPartitionResolversAPIDUnit.assertNull((Object)rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(10), true, (DataValueDescriptor)new SQLInteger(20), true));
        GfxdAllPartitionResolversAPIDUnit.assertNull((Object)rpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(25), true, (DataValueDescriptor)new SQLInteger(75), true));
        dvd = new SQLInteger(25);
        Object[] onerobj = rpr.getRoutingObjectsForRange((DataValueDescriptor)dvd, true, (DataValueDescriptor)new SQLInteger(25), true);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)onerobj.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd.computeHashCode(maxWidth, 0), (int)onerobj[0].hashCode());
        SQLInteger dvd2 = new SQLInteger(20);
        Object[] robjs2 = rpr.getRoutingObjectsForList(new DataValueDescriptor[]{dvd, dvd2});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)2, (int)robjs2.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd.computeHashCode(maxWidth, 0), (int)robjs2[0].hashCode());
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd2.computeHashCode(maxWidth, 0), (int)robjs2[1].hashCode());
        dvd = new SQLInteger(0);
        robj = (Integer)rpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{dvd});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd.computeHashCode(maxWidth, 0), (int)robj.hashCode());
        dvd = new SQLInteger(40);
        robj = (Integer)rpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(40)});
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)dvd.computeHashCode(maxWidth, 0), (int)robj.hashCode());
        String[] arr = rpr.getColumnNames();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)arr.length);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"ID", (String)arr[0]);
        String tbname = rpr.getTableName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"PARTITIONTESTTABLE", (String)tbname);
        String scname = rpr.getSchemaName();
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"EMP", (String)scname);
        String master = rpr.getMasterTable(false);
        GfxdAllPartitionResolversAPIDUnit.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)master);
        GfxdAllPartitionResolversAPIDUnit.assertTrue((boolean)rpr.isUsedInPartitioning("ID"));
        GfxdAllPartitionResolversAPIDUnit.assertFalse((boolean)rpr.isUsedInPartitioning("ID2"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("ID"));
        GfxdAllPartitionResolversAPIDUnit.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
        GfxdAllPartitionResolversAPIDUnit.assertTrue((boolean)rpr.isPartitioningKeyThePrimaryKey());
    }

    public void testPartitionByPrimaryPartitionResolver() throws Exception {
        this.startVMs(1, 2);
        this.clientSQLExecute(1, "create schema EMP");
        this.clientSQLExecute(1, "create table EMP.PARTITIONTESTTABLE (ID int not null,  ID2 int not null, ID3 int not null, primary key (ID))PARTITION BY PRIMARY KEY");
        this.clientSQLExecute(1, "insert into EMP.PARTITIONTESTTABLE values (1, 1, 1), (2, 2, 2 ), (3, 3, 3) ");
        this.checkResolver(new int[]{1}, new int[]{1, 2}, "verifyPartitionByPrimaryResolver");
    }

    public void testDefaultPartitionResolver_40101() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table trade.txhistory (cid int, sid int, qty int, price decimal (30, 20), type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))");
        String query1 = "select cid, sid, type, tid from trade.txhistory where cid > 4 and sid < 200 and qty > 100 and tid < 40";
        String query2 = "select count(*) from trade.txhistory  where cid > 3 and sid < 100 and tid > 20";
        String query3 = "select max(price) from trade.txhistory where tid = 5";
        String query4 = "select sum(qty * price) as amount from trade.txhistory where sid < 100 and tid > 20";
        this.clientSQLExecute(1, "insert into trade.txhistory values (4, 50, 150, 30.0, 'buy', 20), (5, 160, 120, 40.0, 'sell', 30), (3, 80, 80, 70.0, 'sell', 40), (3, 20, 120, 45.0, 'buy', 5), (6, 80, 200, 80.0, 'buy', 30), (5, 10, 60, 75.0, 'sell', 200), (8, 70, 180, 30.0, 'sell', 5)");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query1, TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "hist_query1");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query2, null, "2");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query3, null, "45.00000000000000000000");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query4, null, "26100.00000000000000000000");
    }

    public void testDefaultPartitionResolverRange_40290() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1, SG2", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2, SG3, SG4", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, null, null);
        this.startClientVMs(1, 0, null);
        this.joinVMs(true, async1, async2, async3);
        this.clientSQLExecute(1, "create schema trade DEFAULT SERVER GROUPS (SG2,SG3,SG4)");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), ctid int, primary key (cid))  partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 10000)");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash int not null, securities int not null, loanlimit int, availloan int not null, tid int not null, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
        this.clientSQLExecute(1, "insert into trade.customers values(52, 'NAME52', 'ADDRESS IS NAME52', 4 ), (51, 'NAME51', 'ADDRESS IS NAME51', 4), (415, 'NAME415', 'ADDRESS IS NAME415', 12), (408, 'NAME408', 'ADDRESS IS NAME408', 12), (383, 'NAME383', 'ADDRESS IS NAME383', 16), (380, 'NAME380', 'ADDRESS IS NAME380', 16)");
        this.clientSQLExecute(1, "insert into trade.networth values(51, 51, 0, 51000, 10000, 2 ), (415, 415, 0, 41500, 10000, 2), (408, 408, 0, 40800, 10000, 2), (383, 383, 0, 38300, 10000, 2), (380, 380, 0, 38000, 10000, 2)");
        String query1 = "select * from trade.customers c, trade.networth n where n.cid = c.cid and n.tid = 2";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query1, TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "test_40290");
    }

    public void testDefaultPartitionResolverList_40290() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1, SG2", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2, SG3, SG4", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, null, null);
        this.startClientVMs(1, 0, null);
        this.joinVMs(true, async1, async2, async3);
        this.clientSQLExecute(1, "create schema trade DEFAULT SERVER GROUPS (SG2,SG3,SG4)");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), ctid int, primary key (cid))  partition by list (cid) ( VALUES (0, 10, 100, 200), VALUES (51, 415, 408, 383, 380), VALUES (1500, 2000))");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash int not null, securities int not null, loanlimit int, availloan int not null, tid int not null, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
        this.clientSQLExecute(1, "insert into trade.customers values(52, 'NAME52', 'ADDRESS IS NAME52', 4 ), (51, 'NAME51', 'ADDRESS IS NAME51', 4), (415, 'NAME415', 'ADDRESS IS NAME415', 12), (408, 'NAME408', 'ADDRESS IS NAME408', 12), (383, 'NAME383', 'ADDRESS IS NAME383', 16), (380, 'NAME380', 'ADDRESS IS NAME380', 16)");
        this.clientSQLExecute(1, "insert into trade.networth values(51, 51, 0, 51000, 10000, 2 ), (415, 415, 0, 41500, 10000, 2), (408, 408, 0, 40800, 10000, 2), (383, 383, 0, 38300, 10000, 2), (380, 380, 0, 38000, 10000, 2)");
        String query1 = "select * from trade.customers c, trade.networth n where n.cid = c.cid and n.tid = 2";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query1, TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "test_40290");
    }

    public void testDefaultPartitionResolverColumn_40290() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1, SG2", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2, SG3, SG4", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, null, null);
        this.startClientVMs(1, 0, null);
        this.joinVMs(true, async1, async2, async3);
        this.clientSQLExecute(1, "create schema trade DEFAULT SERVER GROUPS (SG2,SG3,SG4)");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), ctid int, primary key (cid))  partition by column (cid)");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash int not null, securities int not null, loanlimit int, availloan int not null, tid int not null, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
        this.clientSQLExecute(1, "insert into trade.customers values(52, 'NAME52', 'ADDRESS IS NAME52', 4 ), (51, 'NAME51', 'ADDRESS IS NAME51', 4), (415, 'NAME415', 'ADDRESS IS NAME415', 12), (408, 'NAME408', 'ADDRESS IS NAME408', 12), (383, 'NAME383', 'ADDRESS IS NAME383', 16), (380, 'NAME380', 'ADDRESS IS NAME380', 16)");
        this.clientSQLExecute(1, "insert into trade.networth values(51, 51, 0, 51000, 10000, 2 ), (415, 415, 0, 41500, 10000, 2), (408, 408, 0, 40800, 10000, 2), (383, 383, 0, 38300, 10000, 2), (380, 380, 0, 38000, 10000, 2)");
        String query1 = "select * from trade.customers c, trade.networth n where n.cid = c.cid and n.tid = 2";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query1, TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "test_40290");
    }

    public void testDefaultPartitionResolverColumnPK_40290() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1, SG2", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2, SG3, SG4", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, null, null);
        this.startClientVMs(1, 0, null);
        this.joinVMs(true, async1, async2, async3);
        this.clientSQLExecute(1, "create schema trade DEFAULT SERVER GROUPS (SG2,SG3,SG4)");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), ctid int, primary key (cid))  partition by primary key");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash int not null, securities int not null, loanlimit int, availloan int not null, tid int not null, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
        this.clientSQLExecute(1, "insert into trade.customers values(52, 'NAME52', 'ADDRESS IS NAME52', 4 ), (51, 'NAME51', 'ADDRESS IS NAME51', 4), (415, 'NAME415', 'ADDRESS IS NAME415', 12), (408, 'NAME408', 'ADDRESS IS NAME408', 12), (383, 'NAME383', 'ADDRESS IS NAME383', 16), (380, 'NAME380', 'ADDRESS IS NAME380', 16)");
        this.clientSQLExecute(1, "insert into trade.networth values(51, 51, 0, 51000, 10000, 2 ), (415, 415, 0, 41500, 10000, 2), (408, 408, 0, 40800, 10000, 2), (383, 383, 0, 38300, 10000, 2), (380, 380, 0, 38000, 10000, 2)");
        String query1 = "select * from trade.customers c, trade.networth n where n.cid = c.cid and n.tid = 2";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query1, TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "test_40290");
    }

    public void testDefaultPartitionResolverDefaultRslvr_40290() throws Exception {
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "SG1, SG2", null);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "SG2, SG3, SG4", null);
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, null, null);
        this.startClientVMs(1, 0, null);
        this.joinVMs(true, async1, async2, async3);
        this.clientSQLExecute(1, "create schema trade DEFAULT SERVER GROUPS (SG2,SG3,SG4)");
        this.clientSQLExecute(1, "create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), ctid int, primary key (cid))");
        this.clientSQLExecute(1, "create table trade.networth (cid int not null, cash int not null, securities int not null, loanlimit int, availloan int not null, tid int not null, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
        this.clientSQLExecute(1, "insert into trade.customers values(52, 'NAME52', 'ADDRESS IS NAME52', 4 ), (51, 'NAME51', 'ADDRESS IS NAME51', 4), (415, 'NAME415', 'ADDRESS IS NAME415', 12), (408, 'NAME408', 'ADDRESS IS NAME408', 12), (383, 'NAME383', 'ADDRESS IS NAME383', 16), (380, 'NAME380', 'ADDRESS IS NAME380', 16)");
        this.clientSQLExecute(1, "insert into trade.networth values(51, 51, 0, 51000, 10000, 2 ), (415, 415, 0, 41500, 10000, 2), (408, 408, 0, 40800, 10000, 2), (383, 383, 0, 38300, 10000, 2), (380, 380, 0, 38000, 10000, 2)");
        String query1 = "select * from trade.customers c, trade.networth n where n.cid = c.cid and n.tid = 2";
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, query1, TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "test_40290");
    }

    public void testExpression_bug41002() throws Exception {
        block5: {
            block4: {
                this.startVMs(1, 2);
                this.clientSQLExecute(1, "CREATE TABLE COFFEES (COF_NAME VARCHAR(32) CONSTRAINT COF_PK PRIMARY KEY, SUP_ID INTEGER, PRICE FLOAT, SALES INTEGER, TOTAL INTEGER) PARTITION BY (COF_NAME)");
                try {
                    this.clientSQLExecute(1, "CREATE TABLE SUPPLIERS (SUP_ID INTEGER CONSTRAINT SUP_PK PRIMARY KEY, SUP_NAME VARCHAR(40), STREET VARCHAR(40), CITY VARCHAR(20), STATE VARCHAR(2), ZIP CHAR(5)) PARTITION BY SUP_ID COLOCATE WITH (COFFEES)");
                }
                catch (SQLException ex) {
                    if ("42X01".equals(ex.getSQLState())) break block4;
                    throw ex;
                }
            }
            this.clientSQLExecute(1, "CREATE TABLE SUPPLIERS (SUP_ID INTEGER CONSTRAINT SUP_PK PRIMARY KEY, SUP_NAME VARCHAR(40), STREET VARCHAR(40), CITY VARCHAR(20), STATE VARCHAR(2), ZIP CHAR(5)) PARTITION BY (SUP_ID) COLOCATE WITH (COFFEES)");
            this.serverSQLExecute(1, "INSERT INTO COFFEES VALUES('French Roast', 49, 8.99, 0, 0)");
            this.serverSQLExecute(2, "INSERT INTO SUPPLIERS VALUES(49, 'Nestle', 'Street1', 'City1', 'OR', '40000')");
            this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "SELECT * FROM COFFEES", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "bug41002_coffees");
            this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2}, "SELECT * FROM SUPPLIERS", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "bug41002_suppliers");
            this.addExpectedException(new int[]{1}, null, UnsupportedOperationException.class);
            try {
                this.clientSQLExecute(1, "drop table COFFEES");
            }
            catch (SQLException ex) {
                if ("X0Y98".equals(ex.getSQLState())) break block5;
                throw ex;
            }
        }
        this.removeExpectedException(new int[]{1}, null, UnsupportedOperationException.class);
        this.clientSQLExecute(1, "drop table SUPPLIERS");
        this.clientSQLExecute(1, "drop table COFFEES");
    }

    public void testExpressionNetworkClient_bug41002() throws Exception {
        Statement stmt;
        Connection conn;
        VM serverVM;
        block5: {
            block4: {
                int netPort = this.startNetworkServer(1, null, null);
                serverVM = (VM)this.serverVMs.get(0);
                conn = TestUtil.getNetConnection(netPort, null, null);
                stmt = conn.createStatement();
                stmt.execute("CREATE TABLE COFFEES (COF_NAME VARCHAR(32) CONSTRAINT COF_PK PRIMARY KEY, SUP_ID INTEGER, PRICE FLOAT, SALES INTEGER, TOTAL INTEGER) PARTITION BY (COF_NAME)");
                try {
                    stmt.execute("CREATE TABLE SUPPLIERS (SUP_ID INTEGER CONSTRAINT SUP_PK PRIMARY KEY, SUP_NAME VARCHAR(40), STREET VARCHAR(40), CITY VARCHAR(20), STATE VARCHAR(2), ZIP CHAR(5)) PARTITION BY SUP_ID COLOCATE WITH (COFFEES)");
                }
                catch (SQLException ex) {
                    if ("42X01".equals(ex.getSQLState())) break block4;
                    throw ex;
                }
            }
            stmt.execute("CREATE TABLE SUPPLIERS (SUP_ID INTEGER CONSTRAINT SUP_PK PRIMARY KEY, SUP_NAME VARCHAR(40), STREET VARCHAR(40), CITY VARCHAR(20), STATE VARCHAR(2), ZIP CHAR(5)) PARTITION BY (SUP_ID) COLOCATE WITH (COFFEES)");
            stmt.execute("INSERT INTO COFFEES VALUES('French Roast', 49, 8.99, 0, 0)");
            stmt.execute("INSERT INTO SUPPLIERS VALUES(49, 'Nestle', 'Street1', 'City1', 'OR', '40000')");
            TestUtil.jdbcConn = conn;
            TestUtil.sqlExecuteVerifyText("SELECT * FROM COFFEES", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "bug41002_coffees", true, false);
            TestUtil.sqlExecuteVerifyText("SELECT * FROM SUPPLIERS", TestUtil.getResourcesDir() + "/lib/checkQuery.xml", "bug41002_suppliers", false, false);
            this.addExpectedException(serverVM, new Object[]{UnsupportedOperationException.class});
            try {
                stmt.execute("drop table COFFEES");
            }
            catch (SQLException ex) {
                if ("X0Y98".equals(ex.getSQLState())) break block5;
                throw ex;
            }
        }
        this.removeExpectedException(serverVM, new Object[]{UnsupportedOperationException.class});
        stmt.execute("drop table SUPPLIERS");
        stmt.execute("drop table COFFEES");
        stmt.close();
        conn.close();
    }

    public void testDataLoss_44547() throws Exception {
        block4: {
            int i;
            this.startVMs(1, 3);
            this.clientSQLExecute(1, "create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int) partition by column (sid)");
            this.serverExecute(1, (Runnable)new SerializableRunnable(){

                public void run() {
                    Region globalIndexRegion = Misc.getRegion((String)"/TRADE/2__SELLORDERS__OID", (boolean)true, (boolean)false);
                    for (int i = 1; i <= 100; ++i) {
                        globalIndexRegion.put((Object)new SQLInteger(10000 + i), (Object)"dummy");
                    }
                }
            });
            this.serverExecute(2, (Runnable)new SerializableRunnable(){

                public void run() {
                    try {
                        Connection conn = TestUtil.getConnection();
                        PreparedStatement pstmt = conn.prepareStatement("insert into trade.sellorders values (?, ?, ?)");
                        for (int i = 1; i <= 100; ++i) {
                            pstmt.setInt(1, i);
                            pstmt.setInt(2, i);
                            pstmt.setInt(3, i * 3);
                            pstmt.execute();
                        }
                    }
                    catch (Exception ex) {
                        throw new TestException("failed in inserts", (Throwable)ex);
                    }
                }
            });
            Connection conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            for (i = 1; i <= 50; ++i) {
                stmt.execute("delete from trade.sellorders where cid = " + i);
            }
            this.stopVMNum(-1);
            try {
                for (i = 51; i <= 100; ++i) {
                    stmt.execute("delete from trade.sellorders where cid = " + i);
                }
                GfxdAllPartitionResolversAPIDUnit.fail((String)"expected an assertion failure during deletes");
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().contains("Delete did not happen on index: TRADE.2__SELLORDERS__OID")) break block4;
                throw sqle;
            }
        }
    }
}

